/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gogs;

import com.google.common.base.Preconditions;
import hudson.Extension;
import hudson.model.Job;
import hudson.model.UnprotectedRootAction;
import hudson.security.ACL;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.plugins.gogs.GogsPayloadProcessor;
import org.jenkinsci.plugins.gogs.GogsProjectProperty;
import org.jenkinsci.plugins.gogs.GogsResults;
import org.jenkinsci.plugins.gogs.GogsUtils;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

@Extension
public class GogsWebHook
implements UnprotectedRootAction {
    private static final Logger LOGGER = Logger.getLogger(GogsWebHook.class.getName());
    static final String URLNAME = "gogs-webhook";
    private static final String DEFAULT_CHARSET = "UTF-8";

    public String getDisplayName() {
        return null;
    }

    public String getIconFileName() {
        return null;
    }

    public String getUrlName() {
        return URLNAME;
    }

    private static String encode(String data, String key) throws Exception {
        Charset asciiCs = Charset.forName(DEFAULT_CHARSET);
        Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
        SecretKeySpec secret_key = new SecretKeySpec(asciiCs.encode(key).array(), "HmacSHA256");
        sha256_HMAC.init(secret_key);
        return Hex.encodeHexString((byte[])sha256_HMAC.doFinal(data.getBytes(DEFAULT_CHARSET)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doIndex(StaplerRequest req, StaplerResponse rsp) throws IOException {
        String queryString;
        Map queryStringMap;
        GogsResults result = new GogsResults();
        GogsPayloadProcessor payloadProcessor = new GogsPayloadProcessor();
        Preconditions.checkNotNull((Object)req, (Object)"Null request submitted to doIndex method");
        Preconditions.checkNotNull((Object)rsp, (Object)"Null reply submitted to doIndex method");
        String event = req.getHeader("X-Gogs-Event");
        if (!"push".equals(event)) {
            result.setStatus(403, "Only push event can be accepted.");
            this.exitWebHook(result, rsp);
            return;
        }
        String gogsDelivery = req.getHeader("X-Gogs-Delivery");
        gogsDelivery = gogsDelivery == null || gogsDelivery.isEmpty() ? "Triggered by Jenkins-Gogs-Plugin. Delivery ID unknown." : "Gogs-ID: " + gogsDelivery;
        String gogsSignature = req.getHeader("X-Gogs-Signature");
        if (gogsSignature == null || gogsSignature.isEmpty()) {
            gogsSignature = null;
        }
        if (!(queryStringMap = (Map)Preconditions.checkNotNull(GogsWebHook.splitQuery(queryString = (String)Preconditions.checkNotNull((Object)req.getQueryString(), (Object)"The queryString in the request is null")), (Object)"Null queryStringMap")).containsKey("job")) {
            result.setStatus(404, "Parameter 'job' is missing.");
            this.exitWebHook(result, rsp);
            return;
        }
        Object jobObject = queryStringMap.get("job");
        if (jobObject == null) {
            result.setStatus(404, "No value assigned to parameter 'job'");
            this.exitWebHook(result, rsp);
            return;
        }
        String jobName = jobObject.toString();
        String body = IOUtils.toString((InputStream)req.getInputStream(), (String)DEFAULT_CHARSET);
        if (!body.isEmpty() && req.getRequestURI().contains("/gogs-webhook/")) {
            JSONObject jsonObject = JSONObject.fromObject((Object)body);
            JSONObject commits = (JSONObject)jsonObject.getJSONArray("commits").get(0);
            String message = (String)commits.get("message");
            if (message.startsWith("[IGNORE]")) {
                result.setStatus(200, "Ignoring push");
                this.exitWebHook(result, rsp);
                return;
            }
            String contentType = req.getContentType();
            if (contentType != null && contentType.startsWith("application/x-www-form-urlencoded")) {
                body = URLDecoder.decode(body, DEFAULT_CHARSET);
            }
            if (body.startsWith("payload=")) {
                body = body.substring(8);
            }
            String jSecret = null;
            boolean foundJob = false;
            payloadProcessor.setPayload("ref", jsonObject.getString("ref"));
            payloadProcessor.setPayload("before", jsonObject.getString("before"));
            SecurityContext saveCtx = ACL.impersonate((Authentication)ACL.SYSTEM);
            try {
                Job job = GogsUtils.find(jobName, Job.class);
                if (job != null) {
                    foundJob = true;
                    GogsProjectProperty property = (GogsProjectProperty)job.getProperty(GogsProjectProperty.class);
                    if (property != null) {
                        jSecret = property.getGogsSecret();
                    }
                } else {
                    String ref = (String)jsonObject.get("ref");
                    String[] components = ref.split("/");
                    ref = components[components.length - 1];
                    job = GogsUtils.find(jobName + "/" + ref, Job.class);
                    if (job != null) {
                        foundJob = true;
                        GogsProjectProperty property = (GogsProjectProperty)job.getProperty(GogsProjectProperty.class);
                        if (property != null) {
                            jSecret = property.getGogsSecret();
                        }
                    }
                }
            }
            finally {
                SecurityContextHolder.setContext((SecurityContext)saveCtx);
            }
            String gSecret = null;
            if (gogsSignature == null) {
                gSecret = jsonObject.optString("secret", null);
            } else {
                try {
                    if (gogsSignature.equals(GogsWebHook.encode(body, jSecret))) {
                        gSecret = jSecret;
                    }
                }
                catch (Exception e) {
                    LOGGER.warning(e.getMessage());
                }
            }
            if (!foundJob) {
                String msg = String.format("Job '%s' is not defined in Jenkins", jobName);
                result.setStatus(404, msg);
                LOGGER.warning(msg);
            } else if (this.isNullOrEmpty(jSecret) && this.isNullOrEmpty(gSecret)) {
                result = payloadProcessor.triggerJobs(jobName, gogsDelivery);
            } else if (!this.isNullOrEmpty(jSecret) && jSecret.equals(gSecret)) {
                result = payloadProcessor.triggerJobs(jobName, gogsDelivery);
            } else {
                result.setStatus(403, "Incorrect secret");
            }
        } else {
            result.setStatus(404, "No payload or URI contains invalid entries.");
        }
        this.exitWebHook(result, rsp);
    }

    private void exitWebHook(GogsResults result, StaplerResponse resp) throws IOException {
        if (result.getStatus() != 200) {
            LOGGER.warning(result.getMessage());
        }
        JSONObject json = new JSONObject();
        json.element("result", (Object)(result.getStatus() == 200 ? "OK" : "ERROR"));
        json.element("message", (Object)result.getMessage());
        resp.setStatus(result.getStatus());
        resp.addHeader("Content-Type", "application/json");
        PrintWriter printer = resp.getWriter();
        printer.print(json.toString());
    }

    private static Map<String, String> splitQuery(String qs) throws UnsupportedEncodingException {
        String[] pairs;
        LinkedHashMap<String, String> query_pairs = new LinkedHashMap<String, String>();
        for (String pair : pairs = qs.split("&")) {
            int idx = pair.indexOf("=");
            String key = idx > 0 ? URLDecoder.decode(pair.substring(0, idx), DEFAULT_CHARSET) : pair;
            String value = idx > 0 && pair.length() > idx + 1 ? URLDecoder.decode(pair.substring(idx + 1), DEFAULT_CHARSET) : null;
            query_pairs.put(key, value);
        }
        return query_pairs;
    }

    private boolean isNullOrEmpty(String s) {
        return s == null || s.trim().isEmpty();
    }
}

