/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gogs;

import hudson.Extension;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.gogs.GogsWebHook;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class GogsProjectProperty
extends JobProperty<Job<?, ?>> {
    private final String gogsSecret;
    private final boolean gogsUsePayload;
    private static final Logger LOGGER = Logger.getLogger(GogsWebHook.class.getName());

    @DataBoundConstructor
    public GogsProjectProperty(String gogsSecret, boolean gogsUsePayload) {
        this.gogsSecret = gogsSecret;
        this.gogsUsePayload = gogsUsePayload;
    }

    public String getGogsSecret() {
        return this.gogsSecret;
    }

    public boolean getGogsUsePayload() {
        return this.gogsUsePayload;
    }

    @Extension
    public static final class DescriptorImpl
    extends JobPropertyDescriptor {
        public static final String GOGS_PROJECT_BLOCK_NAME = "gogsProject";
        private String gogsSecret;
        private boolean gogsUsePayload;

        public String getGogsSecret() {
            return this.gogsSecret;
        }

        public boolean getGogsUsePayload() {
            return this.gogsUsePayload;
        }

        public JobProperty<?> newInstance(StaplerRequest req, JSONObject formData) {
            GogsProjectProperty tpp = (GogsProjectProperty)((Object)req.bindJSON(GogsProjectProperty.class, formData.getJSONObject(GOGS_PROJECT_BLOCK_NAME)));
            if (tpp != null) {
                LOGGER.finest(formData.toString());
                LOGGER.finest(tpp.gogsSecret);
                this.gogsSecret = tpp.gogsSecret;
            }
            return tpp;
        }

        public String getDisplayName() {
            return "Gogs Secret";
        }
    }
}

