/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gogs;

import hudson.model.Action;
import hudson.model.BuildableItem;
import hudson.model.Cause;
import hudson.model.Item;
import hudson.security.ACL;
import hudson.triggers.Trigger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import jenkins.triggers.SCMTriggerItem;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.jenkinsci.plugins.gogs.GogsCause;
import org.jenkinsci.plugins.gogs.GogsPayload;
import org.jenkinsci.plugins.gogs.GogsResults;
import org.jenkinsci.plugins.gogs.GogsTrigger;

class GogsPayloadProcessor {
    private static final Logger LOGGER = Logger.getLogger(GogsPayloadProcessor.class.getName());
    private final Map<String, String> payload = new HashMap<String, String>();

    GogsPayloadProcessor() {
    }

    public Map<String, String> getPayload() {
        return this.payload;
    }

    public void setPayload(String k, String v) {
        this.payload.put(k, v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GogsResults triggerJobs(String jobName, String deliveryID) {
        SecurityContext saveCtx = ACL.impersonate((Authentication)ACL.SYSTEM);
        Boolean didJob = false;
        GogsResults result = new GogsResults();
        try {
            Jenkins instance = Jenkins.getInstance();
            if (instance != null) {
                for (BuildableItem project : instance.getAllItems(BuildableItem.class)) {
                    if (!project.getName().equals(jobName)) continue;
                    GogsTrigger gTrigger = null;
                    GogsCause cause = new GogsCause(deliveryID);
                    if (project instanceof ParameterizedJobMixIn.ParameterizedJob) {
                        ParameterizedJobMixIn.ParameterizedJob pJob = (ParameterizedJobMixIn.ParameterizedJob)project;
                        for (Trigger trigger : pJob.getTriggers().values()) {
                            if (!(trigger instanceof GogsTrigger)) continue;
                            gTrigger = (GogsTrigger)trigger;
                            break;
                        }
                    }
                    if (gTrigger != null) {
                        SCMTriggerItem item = SCMTriggerItem.SCMTriggerItems.asSCMTriggerItem((Item)project);
                        GogsPayload gogsPayload = new GogsPayload(this.payload);
                        if (item != null) {
                            item.scheduleBuild2(0, new Action[]{gogsPayload});
                        }
                    } else {
                        project.scheduleBuild(0, (Cause)cause);
                    }
                    didJob = true;
                    result.setMessage(String.format("Job '%s' is executed", jobName));
                }
                if (!didJob.booleanValue()) {
                    String msg = String.format("Job '%s' is not defined in Jenkins", jobName);
                    result.setStatus(404, msg);
                    LOGGER.warning(msg);
                }
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            LOGGER.severe(sw.toString());
        }
        finally {
            SecurityContextHolder.setContext((SecurityContext)saveCtx);
        }
        return result;
    }
}

