/*
 * Decompiled with CFR 0.152.
 */
package com.orctom.jenkins.plugin.globalpostscript.runner;

import com.orctom.jenkins.plugin.globalpostscript.GlobalPostScript;
import com.orctom.jenkins.plugin.globalpostscript.ScriptContentLoader;
import com.orctom.jenkins.plugin.globalpostscript.model.ScriptContent;
import com.orctom.jenkins.plugin.globalpostscript.runner.ScriptRunner;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyShell;
import groovy.lang.MissingPropertyException;
import hudson.model.TaskListener;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Map;
import jenkins.model.Jenkins;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyScriptRunner
extends ScriptRunner {
    @Override
    public void run(File scriptFile, Map<String, String> variables, GlobalPostScript.BadgeManager manager, TaskListener listener) {
        GroovyShell shell = new GroovyShell(this.getGroovyClassloader());
        try {
            for (Map.Entry<String, String> entry : variables.entrySet()) {
                shell.setVariable(entry.getKey(), (Object)entry.getValue());
            }
            shell.setVariable("out", (Object)listener.getLogger());
            shell.setVariable("manager", (Object)manager);
            ScriptContent sc = ScriptContentLoader.getScriptContent(scriptFile, variables);
            shell.parse(sc.getContent()).run();
        }
        catch (MissingPropertyException e) {
            this.println(listener, "[ERROR] Failed to execute: " + scriptFile.getName() + ", " + e.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.println(listener, "[ERROR] Failed to execute: " + scriptFile.getName() + ", " + e.getMessage());
        }
    }

    protected ClassLoader getGroovyClassloader() {
        if (null == Jenkins.getInstance()) {
            return this.getParentClassloader();
        }
        File libFolder = new File(Jenkins.getInstance().getRootDir().getAbsolutePath() + GlobalPostScript.SCRIPT_FOLDER, "lib");
        return this.getGroovyClassloader(libFolder);
    }

    protected ClassLoader getGroovyClassloader(File libFolder) {
        GroovyClassLoader cl = new GroovyClassLoader(this.getParentClassloader());
        if (!libFolder.exists() || !libFolder.isDirectory()) {
            return cl;
        }
        File[] files = libFolder.listFiles(new JarFilter());
        if (null == files || 0 == files.length) {
            return cl;
        }
        for (File file : files) {
            cl.addClasspath(file.getPath());
            System.out.println("[global-post-script] extra classpath: " + file.getPath());
        }
        return cl;
    }

    protected static class JarFilter
    implements FilenameFilter {
        private static final String JAR_FILE_SUFFIX = ".jar";

        protected JarFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.toLowerCase().endsWith(JAR_FILE_SUFFIX);
        }
    }
}

