/*
 * Decompiled with CFR 0.152.
 */
package com.orctom.jenkins.plugin.globalpostscript.model;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URL {
    public static final Pattern PATTERN = Pattern.compile("^(https?://)?((?:[\\w-]+\\.)+[\\w-]*(?::\\d+)?)(/[\\w\\/]*)*(?:\\?(.*))?(?:#([-a-z\\d_]+))?");
    private String protocol;
    private String host;
    private String uri;
    private Map<String, String> parameters = new LinkedHashMap<String, String>();

    public URL(String url) {
        String[] params;
        Matcher matcher = PATTERN.matcher(url);
        String queryString = null;
        while (matcher.find()) {
            this.protocol = matcher.group(1);
            this.host = matcher.group(2);
            this.uri = matcher.group(3);
            queryString = matcher.group(4);
        }
        if (StringUtils.isNotEmpty(queryString) && (params = StringUtils.split(queryString, (char)'&')) != null) {
            for (String param : params) {
                String[] entry = StringUtils.split((String)param, (char)'=');
                this.parameters.put(entry[0], entry[1]);
            }
        }
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public String getUri() {
        return this.uri;
    }

    public Map<String, String> getParams() {
        return this.parameters;
    }

    public String removeParam(String param) {
        return this.parameters.remove(param);
    }

    public String getParamValue(String param) {
        return this.parameters.get(param);
    }

    public void updateParamValue(String param, String value) {
        this.parameters.put(param, value);
    }

    public void appendToParamValue(String param, String append) {
        String oldValue = this.getParamValue(param);
        String newValue = null == oldValue ? append : oldValue + append;
        this.updateParamValue(param, newValue);
    }

    public void prependToParamValue(String param, String prepend) {
        String oldValue = this.getParamValue(param);
        String newValue = null == oldValue ? prepend : prepend + oldValue;
        this.updateParamValue(param, newValue);
    }

    public String getQueryString() {
        StringBuilder queryString = new StringBuilder(100);
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            queryString.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
        }
        queryString.deleteCharAt(queryString.length() - 1);
        return queryString.toString();
    }

    public String getURL() {
        return this.protocol + this.host + this.uri + "?" + this.getQueryString();
    }
}

