/*
 * Decompiled with CFR 0.152.
 */
package com.orctom.jenkins.plugin.globalpostscript;

import com.google.common.collect.Lists;
import com.orctom.jenkins.plugin.globalpostscript.GlobalPostScriptAction;
import com.orctom.jenkins.plugin.globalpostscript.ScriptExecutor;
import com.orctom.jenkins.plugin.globalpostscript.model.URL;
import hudson.EnvVars;
import hudson.Extension;
import hudson.console.ModelHyperlinkNote;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ParametersAction;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.StringParameterValue;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.tasks.Messages;
import hudson.util.ComboBoxModel;
import hudson.util.FormValidation;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class GlobalPostScript
extends RunListener<Run<?, ?>>
implements Describable<GlobalPostScript> {
    public static final String SCRIPT_FOLDER = File.separator + "global-post-script" + File.separator;

    public static String getRemoteJobUrl(String jobUrl) {
        if (jobUrl.contains("buildByToken")) {
            return jobUrl.substring(0, jobUrl.indexOf("buildByToken")) + "job/" + jobUrl.replaceFirst(".*job=(\\w+)&.*", "$1");
        }
        return jobUrl.substring(0, jobUrl.lastIndexOf("/") + 1);
    }

    public void onCompleted(Run run, TaskListener listener) {
        EnvVars envVars = this.getEnvVars(run, listener);
        if (run.getResult().isWorseThan(this.getDescriptorImpl().getResultCondition())) {
            return;
        }
        String script = this.getDescriptorImpl().getScript();
        File file = new File(Jenkins.getInstance().getRootDir().getAbsolutePath() + SCRIPT_FOLDER, script);
        if (file.exists()) {
            try {
                BadgeManager manager = new BadgeManager(run, listener);
                ScriptExecutor executor = new ScriptExecutor(listener, manager);
                executor.execute(file, (Map<String, String>)envVars);
            }
            catch (Throwable e) {
                e.printStackTrace(listener.getLogger());
            }
        }
    }

    private EnvVars getEnvVars(Run run, TaskListener listener) {
        try {
            EnvVars envVars = run.getEnvironment(listener);
            envVars.put("BUILD_RESULT", run.getResult().toString());
            return envVars;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public Descriptor<GlobalPostScript> getDescriptor() {
        return this.getDescriptorImpl();
    }

    public DescriptorImpl getDescriptorImpl() {
        return (DescriptorImpl)Jenkins.getInstance().getDescriptorOrDie(GlobalPostScript.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends Descriptor<GlobalPostScript> {
        private String script = "downstream_job_trigger.groovy";
        private Result runCondition = Result.UNSTABLE;

        public DescriptorImpl() {
            this.load();
        }

        public FormValidation doCheckScript(@QueryParameter(value="script") String name) throws IOException, ServletException {
            if (StringUtils.isEmpty((String)name)) {
                return FormValidation.error((String)"Please set the script name");
            }
            if (!name.matches("[a-zA-Z0-9_\\-]+\\.\\w+")) {
                return FormValidation.error((String)"Please make sure it's a valid file name with extension");
            }
            return FormValidation.ok();
        }

        public ComboBoxModel doFillScriptItems() {
            ComboBoxModel items = new ComboBoxModel();
            File scriptFolder = new File(Jenkins.getInstance().getRootDir().getAbsolutePath() + SCRIPT_FOLDER);
            FilenameFilter filter = new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    String fileName = name.toLowerCase();
                    return new File(dir, name).isFile() && (fileName.endsWith(".groovy") || fileName.endsWith(".gvy") || fileName.endsWith(".gy") || fileName.endsWith(".gsh") || fileName.endsWith(".bat") || fileName.endsWith(".sh"));
                }
            };
            Collections.addAll(items, scriptFolder.list(filter));
            return items;
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Global Post Script";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.script = formData.getString("script");
            this.runCondition = Result.fromString((String)formData.getString("runCondition"));
            this.save();
            return super.configure(req, formData);
        }

        public String getScript() {
            return this.script;
        }

        public Result getResultCondition() {
            return this.runCondition;
        }

        public String getRunCondition() {
            return this.runCondition.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BadgeManager {
        private Run run;
        private TaskListener listener;
        private EnvVars envVars;

        public BadgeManager(Run run, TaskListener listener) {
            this.run = run;
            this.listener = listener;
            if (null != run) {
                try {
                    this.envVars = run.getEnvironment(listener);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        public boolean isVar(String name) {
            if (null == this.envVars || StringUtils.isBlank((String)name)) {
                return false;
            }
            return this.envVars.containsKey((Object)name);
        }

        public boolean isNotBlankVar(String name) {
            if (null == this.envVars || StringUtils.isBlank((String)name)) {
                return false;
            }
            return StringUtils.isNotBlank((String)((String)this.envVars.get((Object)name)));
        }

        public void addBadge(String icon, String text) {
            this.run.addAction((Action)GlobalPostScriptAction.createBadge(icon, text));
        }

        public void addShortText(String text) {
            this.run.addAction((Action)GlobalPostScriptAction.addShortText(text));
        }

        public void triggerJob(String jobName) {
            this.triggerJob(jobName, Collections.<String, String>emptyMap());
        }

        public void triggerJob(String jobName, Map<String, String> params) {
            ArrayList newParams = Lists.newArrayList();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                newParams.add(new StringParameterValue(entry.getKey(), entry.getValue()));
            }
            AbstractProject job = (AbstractProject)Jenkins.getInstance().getItem(jobName, this.run.getParent().getParent(), AbstractProject.class);
            if (null != job) {
                Cause.UpstreamCause cause = new Cause.UpstreamCause(this.run);
                boolean scheduled = job.scheduleBuild(job.getQuietPeriod(), (Cause)cause, new Action[]{new ParametersAction((List)newParams)});
                if (Jenkins.getInstance().getItemByFullName(job.getFullName()) == job) {
                    String name = ModelHyperlinkNote.encodeTo((Item)job) + "  " + ModelHyperlinkNote.encodeTo((String)(job.getAbsoluteUrl() + job.getNextBuildNumber() + "/"), (String)("#" + job.getNextBuildNumber()));
                    if (scheduled) {
                        this.println(Messages.BuildTrigger_Triggering((Object)name));
                    } else {
                        this.println(Messages.BuildTrigger_InQueue((Object)name));
                    }
                }
            } else {
                this.println("[ERROR] Downstream job not found: " + jobName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void triggerRemoteJob(String jobTriggerUrl) {
            String url = jobTriggerUrl;
            String jobUrl = GlobalPostScript.getRemoteJobUrl(jobTriggerUrl);
            try {
                URL jobURL = new URL(jobTriggerUrl);
                jobURL.appendToParamValue("cause", new URLCodec().encode(this.getCause(), "UTF-8"));
                url = jobURL.getURL();
            }
            catch (Exception jobURL) {
                // empty catch block
            }
            HttpClient client = new HttpClient();
            GetMethod method = new GetMethod(url);
            try {
                client.executeMethod((HttpMethod)method);
                int statusCode = method.getStatusCode();
                if (statusCode < 400) {
                    this.println(Messages.BuildTrigger_Triggering((Object)jobUrl));
                } else {
                    this.println("[ERROR] Failed to trigger: " + jobUrl + " | " + statusCode);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.println("[ERROR] Failed to trigger: " + jobUrl + " | " + e.getMessage());
            }
            finally {
                method.releaseConnection();
            }
        }

        public String getCause() {
            List causes = this.run.getCauses();
            StringBuilder cause = new StringBuilder(50);
            for (Cause c : causes) {
                String desc = c.getShortDescription();
                if (!StringUtils.isNotEmpty((String)desc)) continue;
                cause.append(c.getShortDescription()).append(" ");
            }
            String rootUrl = Jenkins.getInstance().getRootUrl();
            if (StringUtils.isNotEmpty((String)rootUrl)) {
                cause.append("on ").append(rootUrl).append(" ");
            }
            cause.append("[").append(this.run.getParent().getName()).append("]");
            return cause.toString();
        }

        private void println(String message) {
            this.listener.getLogger().println(message);
        }
    }
}

