/*
 * Decompiled with CFR 0.152.
 */
package com.dabsquared.gitlabjenkins.service;

import com.dabsquared.gitlabjenkins.gitlab.api.GitLabClient;
import com.dabsquared.gitlabjenkins.gitlab.api.model.Label;
import com.dabsquared.gitlabjenkins.util.LoggerUtil;
import com.dabsquared.gitlabjenkins.util.ProjectIdUtil;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GitLabProjectLabelsService {
    private static final Logger LOGGER = Logger.getLogger(GitLabProjectLabelsService.class.getName());
    private static transient GitLabProjectLabelsService instance;
    private final Cache<String, List<String>> projectLabelsCache = Caffeine.newBuilder().maximumSize(1000L).expireAfterWrite(5L, TimeUnit.SECONDS).build();

    GitLabProjectLabelsService() {
    }

    public static GitLabProjectLabelsService instance() {
        if (instance == null) {
            instance = new GitLabProjectLabelsService();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getLabels(GitLabClient client, String sourceRepositoryString) {
        Cache<String, List<String>> cache = this.projectLabelsCache;
        synchronized (cache) {
            return (List)this.projectLabelsCache.get((Object)sourceRepositoryString, (Function)new LabelNamesLoader(client));
        }
    }

    private static class LabelNamesLoader
    implements Function<String, List<String>> {
        private final GitLabClient client;

        private LabelNamesLoader(GitLabClient client) {
            this.client = client;
        }

        @Override
        public List<String> apply(String sourceRepository) {
            String projectId;
            ArrayList<String> result = new ArrayList<String>();
            try {
                projectId = ProjectIdUtil.retrieveProjectId(this.client, sourceRepository);
            }
            catch (ProjectIdUtil.ProjectIdResolutionException e) {
                throw new LabelLoadingException(e);
            }
            for (Label label : this.client.getLabels(projectId)) {
                result.add(label.getName());
            }
            LOGGER.log(Level.FINEST, "found these labels for repo {0} : {1}", LoggerUtil.toArray(sourceRepository, result));
            return result;
        }
    }

    public static class LabelLoadingException
    extends RuntimeException {
        LabelLoadingException(Throwable cause) {
            super(cause);
        }
    }
}

