/*
 * Decompiled with CFR 0.152.
 */
package com.dabsquared.gitlabjenkins.gitlab.api;

import com.dabsquared.gitlabjenkins.gitlab.api.GitLabClient;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionPoint;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public abstract class GitLabClientBuilder
implements Comparable<GitLabClientBuilder>,
ExtensionPoint,
Serializable {
    private final String id;
    private final int ordinal;

    public static GitLabClientBuilder getGitLabClientBuilderById(String id) {
        for (GitLabClientBuilder provider : GitLabClientBuilder.getAllGitLabClientBuilders()) {
            if (!provider.id().equals(id)) continue;
            return provider;
        }
        throw new NoSuchElementException("unknown client-builder-id: " + id);
    }

    public static List<GitLabClientBuilder> getAllGitLabClientBuilders() {
        ArrayList<GitLabClientBuilder> builders = new ArrayList<GitLabClientBuilder>((Collection<GitLabClientBuilder>)Jenkins.getInstance().getExtensionList(GitLabClientBuilder.class));
        Collections.sort(builders);
        return builders;
    }

    protected GitLabClientBuilder(String id, int ordinal) {
        this.id = id;
        this.ordinal = ordinal;
    }

    @NonNull
    public final String id() {
        return this.id;
    }

    @NonNull
    public abstract GitLabClient buildClient(String var1, String var2, boolean var3, int var4, int var5);

    @Override
    public final int compareTo(@NonNull GitLabClientBuilder other) {
        int o = this.ordinal - other.ordinal;
        return o != 0 ? o : this.id().compareTo(other.id());
    }
}

