/*
 * Decompiled with CFR 0.152.
 */
package com.dabsquared.gitlabjenkins.cause;

import com.dabsquared.gitlabjenkins.cause.Messages;
import com.dabsquared.gitlabjenkins.gitlab.api.model.MergeRequest;
import hudson.markup.EscapedMarkupFormatter;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import jenkins.model.Jenkins;
import net.karneim.pojobuilder.GeneratePojoBuilder;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public final class CauseData {
    private final ActionType actionType;
    private final Integer sourceProjectId;
    private final Integer targetProjectId;
    private final String branch;
    private final String sourceBranch;
    private final String userName;
    private final String userUsername;
    private final String userEmail;
    private final String sourceRepoHomepage;
    private final String sourceRepoName;
    private final String sourceNamespace;
    private final String sourceRepoUrl;
    private final String sourceRepoSshUrl;
    private final String sourceRepoHttpUrl;
    private final String mergeRequestTitle;
    private final String mergeRequestDescription;
    private final Integer mergeRequestId;
    private final Integer mergeRequestIid;
    private final String mergeRequestState;
    private final String mergedByUser;
    private final String mergeRequestAssignee;
    private final Integer mergeRequestTargetProjectId;
    private final String targetBranch;
    private final String targetRepoName;
    private final String targetNamespace;
    private final String targetRepoSshUrl;
    private final String targetRepoHttpUrl;
    private final String triggeredByUser;
    private final String before;
    private final String after;
    private final String lastCommit;
    private final String targetProjectUrl;
    private final String triggerPhrase;
    private final String ref;
    private final String beforeSha;
    private final String isTag;
    private final String sha;
    private final String status;
    private final String stages;
    private final String createdAt;
    private final String finishedAt;
    private final String buildDuration;

    @GeneratePojoBuilder(withFactoryMethod="*")
    CauseData(ActionType actionType, Integer sourceProjectId, Integer targetProjectId, String branch, String sourceBranch, String userName, String userUsername, String userEmail, String sourceRepoHomepage, String sourceRepoName, String sourceNamespace, String sourceRepoUrl, String sourceRepoSshUrl, String sourceRepoHttpUrl, String mergeRequestTitle, String mergeRequestDescription, Integer mergeRequestId, Integer mergeRequestIid, Integer mergeRequestTargetProjectId, String targetBranch, String targetRepoName, String targetNamespace, String targetRepoSshUrl, String targetRepoHttpUrl, String triggeredByUser, String before, String after, String lastCommit, String targetProjectUrl, String triggerPhrase, String mergeRequestState, String mergedByUser, String mergeRequestAssignee, String ref, String isTag, String sha, String beforeSha, String status, String stages, String createdAt, String finishedAt, String buildDuration) {
        this.actionType = Objects.requireNonNull(actionType, "actionType must not be null.");
        this.sourceProjectId = Objects.requireNonNull(sourceProjectId, "sourceProjectId must not be null.");
        this.targetProjectId = Objects.requireNonNull(targetProjectId, "targetProjectId must not be null.");
        this.branch = Objects.requireNonNull(branch, "branch must not be null.");
        this.sourceBranch = Objects.requireNonNull(sourceBranch, "sourceBranch must not be null.");
        this.userName = Objects.requireNonNull(userName, "userName must not be null.");
        this.userUsername = userUsername == null ? "" : userUsername;
        this.userEmail = userEmail == null ? "" : userEmail;
        this.sourceRepoHomepage = sourceRepoHomepage == null ? "" : sourceRepoHomepage;
        this.sourceRepoName = Objects.requireNonNull(sourceRepoName, "sourceRepoName must not be null.");
        this.sourceNamespace = Objects.requireNonNull(sourceNamespace, "sourceNamespace must not be null.");
        this.sourceRepoUrl = sourceRepoUrl == null ? sourceRepoSshUrl : sourceRepoUrl;
        this.sourceRepoSshUrl = Objects.requireNonNull(sourceRepoSshUrl, "sourceRepoSshUrl must not be null.");
        this.sourceRepoHttpUrl = Objects.requireNonNull(sourceRepoHttpUrl, "sourceRepoHttpUrl must not be null.");
        this.mergeRequestTitle = Objects.requireNonNull(mergeRequestTitle, "mergeRequestTitle must not be null.");
        this.mergeRequestDescription = mergeRequestDescription == null ? "" : mergeRequestDescription;
        this.mergeRequestId = mergeRequestId;
        this.mergeRequestIid = mergeRequestIid;
        this.mergeRequestState = mergeRequestState == null ? "" : mergeRequestState;
        this.mergedByUser = mergedByUser == null ? "" : mergedByUser;
        this.mergeRequestAssignee = mergeRequestAssignee == null ? "" : mergeRequestAssignee;
        this.mergeRequestTargetProjectId = mergeRequestTargetProjectId;
        this.targetBranch = Objects.requireNonNull(targetBranch, "targetBranch must not be null.");
        this.targetRepoName = Objects.requireNonNull(targetRepoName, "targetRepoName must not be null.");
        this.targetNamespace = Objects.requireNonNull(targetNamespace, "targetNamespace must not be null.");
        this.targetRepoSshUrl = Objects.requireNonNull(targetRepoSshUrl, "targetRepoSshUrl must not be null.");
        this.targetRepoHttpUrl = Objects.requireNonNull(targetRepoHttpUrl, "targetRepoHttpUrl must not be null.");
        this.triggeredByUser = Objects.requireNonNull(triggeredByUser, "triggeredByUser must not be null.");
        this.before = before == null ? "" : before;
        this.after = after == null ? "" : after;
        this.lastCommit = Objects.requireNonNull(lastCommit, "lastCommit must not be null");
        this.targetProjectUrl = targetProjectUrl;
        this.triggerPhrase = triggerPhrase;
        this.ref = ref;
        this.isTag = isTag;
        this.sha = sha;
        this.beforeSha = beforeSha;
        this.status = status;
        this.stages = stages;
        this.createdAt = createdAt;
        this.finishedAt = finishedAt;
        this.buildDuration = buildDuration;
    }

    @Exported
    public Map<String, String> getBuildVariables() {
        MapWrapper<String, String> variables = new MapWrapper<String, String>(new HashMap());
        variables.put("gitlabBranch", this.branch);
        variables.put("gitlabSourceBranch", this.sourceBranch);
        variables.put("gitlabActionType", this.actionType.name());
        variables.put("gitlabUserName", this.userName);
        variables.put("gitlabUserUsername", this.userUsername == null ? "" : this.userUsername);
        variables.put("gitlabUserEmail", this.userEmail);
        variables.put("gitlabSourceRepoHomepage", this.sourceRepoHomepage);
        variables.put("gitlabSourceRepoName", this.sourceRepoName);
        variables.put("gitlabSourceNamespace", this.sourceNamespace);
        variables.put("gitlabSourceRepoURL", this.sourceRepoUrl);
        variables.put("gitlabSourceRepoSshUrl", this.sourceRepoSshUrl);
        variables.put("gitlabSourceRepoHttpUrl", this.sourceRepoHttpUrl);
        variables.put("gitlabMergeRequestTitle", this.mergeRequestTitle);
        variables.put("gitlabMergeRequestDescription", this.mergeRequestDescription);
        variables.put("gitlabMergeRequestId", this.mergeRequestId == null ? "" : this.mergeRequestId.toString());
        variables.put("gitlabMergeRequestIid", this.mergeRequestIid == null ? "" : this.mergeRequestIid.toString());
        variables.put("gitlabMergeRequestTargetProjectId", this.mergeRequestTargetProjectId == null ? "" : this.mergeRequestTargetProjectId.toString());
        variables.put("gitlabMergeRequestLastCommit", this.lastCommit);
        variables.putIfNotNull("gitlabMergeRequestState", this.mergeRequestState);
        variables.putIfNotNull("gitlabMergedByUser", this.mergedByUser);
        variables.putIfNotNull("gitlabMergeRequestAssignee", this.mergeRequestAssignee);
        variables.put("gitlabTargetBranch", this.targetBranch);
        variables.put("gitlabTargetRepoName", this.targetRepoName);
        variables.put("gitlabTargetNamespace", this.targetNamespace);
        variables.put("gitlabTargetRepoSshUrl", this.targetRepoSshUrl);
        variables.put("gitlabTargetRepoHttpUrl", this.targetRepoHttpUrl);
        variables.put("gitlabBefore", this.before);
        variables.put("gitlabAfter", this.after);
        variables.put("ref", this.ref);
        variables.put("beforeSha", this.beforeSha);
        variables.put("isTag", this.isTag);
        variables.put("sha", this.sha);
        variables.put("status", this.status);
        variables.put("stages", this.stages);
        variables.put("createdAt", this.createdAt);
        variables.put("finishedAt", this.finishedAt);
        variables.put("duration", this.buildDuration);
        variables.putIfNotNull("gitlabTriggerPhrase", this.triggerPhrase);
        return variables;
    }

    @Exported
    public Integer getSourceProjectId() {
        return this.sourceProjectId;
    }

    @Exported
    public Integer getTargetProjectId() {
        return this.targetProjectId;
    }

    @Exported
    public String getBranch() {
        return this.branch;
    }

    @Exported
    public String getSourceBranch() {
        return this.sourceBranch;
    }

    @Exported
    public ActionType getActionType() {
        return this.actionType;
    }

    @Exported
    public String getUserName() {
        return this.userName;
    }

    @Exported
    public String getUserUsername() {
        return this.userUsername;
    }

    @Exported
    public String getUserEmail() {
        return this.userEmail;
    }

    @Exported
    public String getSourceRepoHomepage() {
        return this.sourceRepoHomepage;
    }

    @Exported
    public String getSourceRepoName() {
        return this.sourceRepoName;
    }

    @Exported
    public String getSourceNamespace() {
        return this.sourceNamespace;
    }

    @Exported
    public String getSourceRepoUrl() {
        return this.sourceRepoUrl;
    }

    @Exported
    public String getSourceRepoSshUrl() {
        return this.sourceRepoSshUrl;
    }

    @Exported
    public String getSourceRepoHttpUrl() {
        return this.sourceRepoHttpUrl;
    }

    @Exported
    public String getMergeRequestTitle() {
        return this.mergeRequestTitle;
    }

    @Exported
    public String getMergeRequestDescription() {
        return this.mergeRequestDescription;
    }

    @Exported
    public Integer getMergeRequestId() {
        return this.mergeRequestId;
    }

    @Exported
    public Integer getMergeRequestIid() {
        return this.mergeRequestIid;
    }

    @Exported
    public Integer getMergeRequestTargetProjectId() {
        return this.mergeRequestTargetProjectId;
    }

    @Exported
    public String getTargetBranch() {
        return this.targetBranch;
    }

    @Exported
    public String getTargetRepoName() {
        return this.targetRepoName;
    }

    @Exported
    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    @Exported
    public String getTargetRepoSshUrl() {
        return this.targetRepoSshUrl;
    }

    @Exported
    public String getTargetRepoHttpUrl() {
        return this.targetRepoHttpUrl;
    }

    @Exported
    public String getTriggeredByUser() {
        return this.triggeredByUser;
    }

    @Exported
    public String getBefore() {
        return this.before;
    }

    @Exported
    public String getAfter() {
        return this.after;
    }

    @Exported
    public String getLastCommit() {
        return this.lastCommit;
    }

    @Exported
    public String getTargetProjectUrl() {
        return this.targetProjectUrl;
    }

    @Exported
    public String getRef() {
        return this.ref;
    }

    @Exported
    public String getIsTag() {
        return this.isTag;
    }

    @Exported
    public String getSha() {
        return this.sha;
    }

    @Exported
    public String getBeforeSha() {
        return this.beforeSha;
    }

    @Exported
    public String getStatus() {
        return this.status;
    }

    @Exported
    public String getStages() {
        return this.stages;
    }

    @Exported
    public String getCreatedAt() {
        return this.createdAt;
    }

    @Exported
    public String getFinishedAt() {
        return this.finishedAt;
    }

    @Exported
    public String getBuildDuration() {
        return this.buildDuration;
    }

    String getShortDescription() {
        return this.actionType.getShortDescription(this);
    }

    @Exported
    public String getMergeRequestState() {
        return this.mergeRequestState;
    }

    @Exported
    public String getMergedByUser() {
        return this.mergedByUser;
    }

    @Exported
    public String getMergeRequestAssignee() {
        return this.mergeRequestAssignee;
    }

    @Exported
    public MergeRequest getMergeRequest() {
        if (this.mergeRequestId == null) {
            return null;
        }
        return new MergeRequest(this.mergeRequestId, this.mergeRequestIid, this.sourceBranch, this.targetBranch, this.mergeRequestTitle, this.sourceProjectId, this.targetProjectId, this.mergeRequestDescription, this.mergeRequestState);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CauseData causeData = (CauseData)o;
        return new EqualsBuilder().append((Object)this.actionType, (Object)causeData.actionType).append((Object)this.sourceProjectId, (Object)causeData.sourceProjectId).append((Object)this.targetProjectId, (Object)causeData.targetProjectId).append((Object)this.branch, (Object)causeData.branch).append((Object)this.sourceBranch, (Object)causeData.sourceBranch).append((Object)this.userName, (Object)causeData.userName).append((Object)this.userUsername, (Object)causeData.userUsername).append((Object)this.userEmail, (Object)causeData.userEmail).append((Object)this.sourceRepoHomepage, (Object)causeData.sourceRepoHomepage).append((Object)this.sourceRepoName, (Object)causeData.sourceRepoName).append((Object)this.sourceNamespace, (Object)causeData.sourceNamespace).append((Object)this.sourceRepoUrl, (Object)causeData.sourceRepoUrl).append((Object)this.sourceRepoSshUrl, (Object)causeData.sourceRepoSshUrl).append((Object)this.sourceRepoHttpUrl, (Object)causeData.sourceRepoHttpUrl).append((Object)this.mergeRequestTitle, (Object)causeData.mergeRequestTitle).append((Object)this.mergeRequestDescription, (Object)causeData.mergeRequestDescription).append((Object)this.mergeRequestId, (Object)causeData.mergeRequestId).append((Object)this.mergeRequestIid, (Object)causeData.mergeRequestIid).append((Object)this.mergeRequestState, (Object)causeData.mergeRequestState).append((Object)this.mergedByUser, (Object)causeData.mergedByUser).append((Object)this.mergeRequestAssignee, (Object)causeData.mergeRequestAssignee).append((Object)this.mergeRequestTargetProjectId, (Object)causeData.mergeRequestTargetProjectId).append((Object)this.targetBranch, (Object)causeData.targetBranch).append((Object)this.targetRepoName, (Object)causeData.targetRepoName).append((Object)this.targetNamespace, (Object)causeData.targetNamespace).append((Object)this.targetRepoSshUrl, (Object)causeData.targetRepoSshUrl).append((Object)this.targetRepoHttpUrl, (Object)causeData.targetRepoHttpUrl).append((Object)this.triggeredByUser, (Object)causeData.triggeredByUser).append((Object)this.before, (Object)causeData.before).append((Object)this.after, (Object)causeData.after).append((Object)this.lastCommit, (Object)causeData.lastCommit).append((Object)this.targetProjectUrl, (Object)causeData.targetProjectUrl).append((Object)this.ref, (Object)causeData.getRef()).append((Object)this.isTag, (Object)causeData.getIsTag()).append((Object)this.sha, (Object)causeData.getSha()).append((Object)this.beforeSha, (Object)causeData.getBeforeSha()).append((Object)this.status, (Object)causeData.getStatus()).append((Object)this.stages, (Object)causeData.getStages()).append((Object)this.createdAt, (Object)causeData.getCreatedAt()).append((Object)this.finishedAt, (Object)causeData.getFinishedAt()).append((Object)this.buildDuration, (Object)causeData.getBuildDuration()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.actionType).append((Object)this.sourceProjectId).append((Object)this.targetProjectId).append((Object)this.branch).append((Object)this.sourceBranch).append((Object)this.userName).append((Object)this.userUsername).append((Object)this.userEmail).append((Object)this.sourceRepoHomepage).append((Object)this.sourceRepoName).append((Object)this.sourceNamespace).append((Object)this.sourceRepoUrl).append((Object)this.sourceRepoSshUrl).append((Object)this.sourceRepoHttpUrl).append((Object)this.mergeRequestTitle).append((Object)this.mergeRequestDescription).append((Object)this.mergeRequestId).append((Object)this.mergeRequestIid).append((Object)this.mergeRequestState).append((Object)this.mergedByUser).append((Object)this.mergeRequestAssignee).append((Object)this.mergeRequestTargetProjectId).append((Object)this.targetBranch).append((Object)this.targetRepoName).append((Object)this.targetNamespace).append((Object)this.targetRepoSshUrl).append((Object)this.targetRepoHttpUrl).append((Object)this.triggeredByUser).append((Object)this.before).append((Object)this.after).append((Object)this.lastCommit).append((Object)this.targetProjectUrl).append((Object)this.ref).append((Object)this.isTag).append((Object)this.sha).append((Object)this.beforeSha).append((Object)this.status).append((Object)this.stages).append((Object)this.createdAt).append((Object)this.finishedAt).append((Object)this.buildDuration).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("actionType", (Object)this.actionType).append("sourceProjectId", (Object)this.sourceProjectId).append("targetProjectId", (Object)this.targetProjectId).append("branch", (Object)this.branch).append("sourceBranch", (Object)this.sourceBranch).append("userName", (Object)this.userName).append("userUsername", (Object)this.userUsername).append("userEmail", (Object)this.userEmail).append("sourceRepoHomepage", (Object)this.sourceRepoHomepage).append("sourceRepoName", (Object)this.sourceRepoName).append("sourceNamespace", (Object)this.sourceNamespace).append("sourceRepoUrl", (Object)this.sourceRepoUrl).append("sourceRepoSshUrl", (Object)this.sourceRepoSshUrl).append("sourceRepoHttpUrl", (Object)this.sourceRepoHttpUrl).append("mergeRequestTitle", (Object)this.mergeRequestTitle).append("mergeRequestDescription", (Object)this.mergeRequestDescription).append("mergeRequestId", (Object)this.mergeRequestId).append("mergeRequestIid", (Object)this.mergeRequestIid).append("mergeRequestState", (Object)this.mergeRequestState).append("mergedByUser", (Object)this.mergedByUser).append("mergeRequestAssignee", (Object)this.mergeRequestAssignee).append("mergeRequestTargetProjectId", (Object)this.mergeRequestTargetProjectId).append("targetBranch", (Object)this.targetBranch).append("targetRepoName", (Object)this.targetRepoName).append("targetNamespace", (Object)this.targetNamespace).append("targetRepoSshUrl", (Object)this.targetRepoSshUrl).append("targetRepoHttpUrl", (Object)this.targetRepoHttpUrl).append("triggeredByUser", (Object)this.triggeredByUser).append("before", (Object)this.before).append("after", (Object)this.after).append("lastCommit", (Object)this.lastCommit).append("targetProjectUrl", (Object)this.targetProjectUrl).append("ref", (Object)this.ref).append("isTag", (Object)this.isTag).append("sha", (Object)this.sha).append("beforeSha", (Object)this.beforeSha).append("status", (Object)this.status).append("stages", (Object)this.stages).append("createdAt", (Object)this.createdAt).append("finishedAt", (Object)this.finishedAt).append("duration", (Object)this.buildDuration).toString();
    }

    private static class MapWrapper<K, V>
    extends AbstractMap<K, V> {
        private final Map<K, V> map;

        MapWrapper(Map<K, V> map) {
            this.map = map;
        }

        @Override
        public V put(K key, V value) {
            return this.map.put(key, value);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return this.map.entrySet();
        }

        void putIfNotNull(K key, V value) {
            if (value != null) {
                this.map.put(key, value);
            }
        }
    }

    public static enum ActionType {
        PUSH{

            @Override
            String getShortDescription(CauseData data) {
                return ActionType.getShortDescriptionPush(data);
            }
        }
        ,
        TAG_PUSH{

            @Override
            String getShortDescription(CauseData data) {
                return ActionType.getShortDescriptionPush(data);
            }
        }
        ,
        MERGE{

            @Override
            String getShortDescription(CauseData data) {
                String forkNamespace;
                String string = forkNamespace = StringUtils.equals((String)data.getSourceNamespace(), (String)data.getTargetBranch()) ? "" : data.getSourceNamespace() + "/";
                if (Jenkins.getActiveInstance().getMarkupFormatter() instanceof EscapedMarkupFormatter || data.getTargetProjectUrl() == null) {
                    return Messages.GitLabWebHookCause_ShortDescription_MergeRequestHook_plain(String.valueOf(data.getMergeRequestIid()), forkNamespace + data.getSourceBranch(), data.getTargetBranch());
                }
                return Messages.GitLabWebHookCause_ShortDescription_MergeRequestHook_html(String.valueOf(data.getMergeRequestIid()), forkNamespace + data.getSourceBranch(), data.getTargetBranch(), data.getTargetProjectUrl());
            }
        }
        ,
        NOTE{

            @Override
            String getShortDescription(CauseData data) {
                String forkNamespace;
                String triggeredBy = data.getTriggeredByUser();
                String string = forkNamespace = StringUtils.equals((String)data.getSourceNamespace(), (String)data.getTargetBranch()) ? "" : data.getSourceNamespace() + "/";
                if (Jenkins.getActiveInstance().getMarkupFormatter() instanceof EscapedMarkupFormatter || data.getTargetProjectUrl() == null) {
                    return Messages.GitLabWebHookCause_ShortDescription_NoteHook_plain(triggeredBy, String.valueOf(data.getMergeRequestIid()), forkNamespace + data.getSourceBranch(), data.getTargetBranch());
                }
                return Messages.GitLabWebHookCause_ShortDescription_NoteHook_html(triggeredBy, String.valueOf(data.getMergeRequestIid()), forkNamespace + data.getSourceBranch(), data.getTargetBranch(), data.getTargetProjectUrl());
            }
        }
        ,
        PIPELINE{

            @Override
            String getShortDescription(CauseData data) {
                String getStatus = data.getStatus();
                if (getStatus == null) {
                    return Messages.GitLabWebHookCause_ShortDescription_PipelineHook_noStatus();
                }
                return Messages.GitLabWebHookCause_ShortDescription_PipelineHook(getStatus);
            }
        };


        private static String getShortDescriptionPush(CauseData data) {
            String pushedBy = data.getTriggeredByUser();
            if (pushedBy == null) {
                return Messages.GitLabWebHookCause_ShortDescription_PushHook_noUser();
            }
            return Messages.GitLabWebHookCause_ShortDescription_PushHook(pushedBy);
        }

        abstract String getShortDescription(CauseData var1);
    }
}

