/*
 * Decompiled with CFR 0.152.
 */
package com.dabsquared.gitlabjenkins.webhook.build;

import com.dabsquared.gitlabjenkins.GitLabPushTrigger;
import com.dabsquared.gitlabjenkins.connection.GitLabConnectionConfig;
import com.dabsquared.gitlabjenkins.webhook.WebHookAction;
import hudson.model.Item;
import hudson.model.Job;
import hudson.security.Permission;
import hudson.util.HttpResponses;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.StaplerResponse;

abstract class BuildWebHookAction
implements WebHookAction {
    private static final Logger LOGGER = Logger.getLogger(BuildWebHookAction.class.getName());

    BuildWebHookAction() {
    }

    abstract void processForCompatibility();

    abstract void execute();

    @Override
    public final void execute(StaplerResponse response) {
        this.processForCompatibility();
        this.execute();
    }

    protected static abstract class TriggerNotifier
    implements Runnable {
        private final Item project;
        private final String secretToken;
        private final Authentication authentication;

        public TriggerNotifier(Item project, String secretToken, Authentication authentication) {
            this.project = project;
            this.secretToken = secretToken;
            this.authentication = authentication;
        }

        @Override
        public void run() {
            GitLabPushTrigger trigger = GitLabPushTrigger.getFromJob((Job)this.project);
            if (trigger != null) {
                if (StringUtils.isEmpty((String)trigger.getSecretToken())) {
                    this.checkPermission(Item.BUILD, this.project);
                } else if (!StringUtils.equals((String)trigger.getSecretToken(), (String)this.secretToken)) {
                    throw HttpResponses.errorWithoutStack((int)401, (String)"Invalid token");
                }
                this.performOnPost(trigger);
            }
        }

        private void checkPermission(Permission permission, Item project) {
            if (((GitLabConnectionConfig)Jenkins.get().getDescriptor(GitLabConnectionConfig.class)).isUseAuthenticatedEndpoint() && !project.getACL().hasPermission(this.authentication, permission)) {
                String message = String.format("%s is missing the %s/%s permission", this.authentication.getName(), permission.group.title, permission.name);
                LOGGER.finest("Unauthorized (Did you forget to add API Token to the web hook ?)");
                throw HttpResponses.errorWithoutStack((int)403, (String)message);
            }
        }

        protected abstract void performOnPost(GitLabPushTrigger var1);
    }
}

