/*
 * Decompiled with CFR 0.152.
 */
package com.dabsquared.gitlabjenkins.connection;

import com.dabsquared.gitlabjenkins.connection.GitLabConnection;
import com.dabsquared.gitlabjenkins.gitlab.api.GitLabClient;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Item;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jenkins.model.GlobalConfiguration;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

@Extension
public class GitLabConnectionConfig
extends GlobalConfiguration {
    private Boolean useAuthenticatedEndpoint = true;
    private List<GitLabConnection> connections = new ArrayList<GitLabConnection>();
    private transient Map<String, GitLabConnection> connectionMap = new HashMap<String, GitLabConnection>();

    @DataBoundConstructor
    public GitLabConnectionConfig() {
        this.load();
        this.refreshConnectionMap();
    }

    public boolean isUseAuthenticatedEndpoint() {
        return this.useAuthenticatedEndpoint;
    }

    @DataBoundSetter
    public void setUseAuthenticatedEndpoint(boolean useAuthenticatedEndpoint) {
        this.useAuthenticatedEndpoint = useAuthenticatedEndpoint;
        this.save();
    }

    public List<GitLabConnection> getConnections() {
        return this.connections;
    }

    public void addConnection(GitLabConnection connection) {
        this.connections.add(connection);
        this.connectionMap.put(connection.getName(), connection);
    }

    @DataBoundSetter
    public void setConnections(List<GitLabConnection> newConnections) {
        this.connections = new ArrayList<GitLabConnection>();
        this.connectionMap = new HashMap<String, GitLabConnection>();
        for (GitLabConnection connection : newConnections) {
            this.addConnection(connection);
        }
        this.save();
    }

    public GitLabClient getClient(String connectionName, Item item, String jobCredentialId) {
        if (!this.connectionMap.containsKey(connectionName)) {
            return null;
        }
        return this.connectionMap.get(connectionName).getClient(item, jobCredentialId);
    }

    private void refreshConnectionMap() {
        this.connectionMap.clear();
        for (GitLabConnection connection : this.connections) {
            this.connectionMap.put(connection.getName(), connection);
        }
    }

    protected GitLabConnectionConfig readResolve() {
        if (this.useAuthenticatedEndpoint == null) {
            this.setUseAuthenticatedEndpoint(false);
        }
        return this;
    }

    public static GitLabConnectionConfig get() {
        return (GitLabConnectionConfig)((Object)ExtensionList.lookupSingleton(GitLabConnectionConfig.class));
    }
}

