/*
 * Decompiled with CFR 0.152.
 */
package com.dabsquared.gitlabjenkins.workflow;

import com.dabsquared.gitlabjenkins.connection.GitLabConnectionProperty;
import com.dabsquared.gitlabjenkins.gitlab.api.model.BuildState;
import com.dabsquared.gitlabjenkins.util.CommitStatusUpdater;
import com.dabsquared.gitlabjenkins.workflow.GitLabBranchBuild;
import com.dabsquared.gitlabjenkins.workflow.PendingBuildsAction;
import com.google.common.collect.ImmutableSet;
import hudson.Extension;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.BodyExecution;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.FlowInterruptedException;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class GitLabCommitStatusStep
extends Step {
    private String name;
    private List<GitLabBranchBuild> builds = new ArrayList<GitLabBranchBuild>();
    private GitLabConnectionProperty connection;

    @DataBoundConstructor
    public GitLabCommitStatusStep(String name) {
        this.name = StringUtils.isEmpty((String)name) ? null : name;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new GitLabCommitStatusStepExecution(context, this);
    }

    public String getName() {
        return this.name;
    }

    public List<GitLabBranchBuild> getBuilds() {
        return this.builds;
    }

    @DataBoundSetter
    public void setBuilds(List<GitLabBranchBuild> builds) {
        this.builds = builds;
    }

    public GitLabConnectionProperty getConnection() {
        return this.connection;
    }

    @DataBoundSetter
    public void setConnection(GitLabConnectionProperty connection) {
        this.connection = connection;
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public String getDisplayName() {
            return "Update the commit status in GitLab depending on the build status";
        }

        public String getFunctionName() {
            return "gitlabCommitStatus";
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public Set<Class<?>> getRequiredContext() {
            return ImmutableSet.of(TaskListener.class, Run.class);
        }
    }

    public static class GitLabCommitStatusStepExecution
    extends StepExecution {
        private static final long serialVersionUID = 1L;
        private final transient Run<?, ?> run;
        private final transient GitLabCommitStatusStep step;
        private BodyExecution body;

        GitLabCommitStatusStepExecution(StepContext context, GitLabCommitStatusStep step) throws Exception {
            super(context);
            this.step = step;
            this.run = (Run)context.get(Run.class);
        }

        public boolean start() throws Exception {
            final String name = StringUtils.isEmpty((String)this.step.name) ? "jenkins" : this.step.name;
            this.body = this.getContext().newBodyInvoker().withCallback(new BodyExecutionCallback(){

                public void onStart(StepContext context) {
                    CommitStatusUpdater.updateCommitStatus(run, this.getTaskListener(context), BuildState.running, name, step.builds, step.connection);
                    PendingBuildsAction action = (PendingBuildsAction)run.getAction(PendingBuildsAction.class);
                    if (action != null) {
                        action.startBuild(name);
                    }
                }

                public void onSuccess(StepContext context, Object result) {
                    CommitStatusUpdater.updateCommitStatus(run, this.getTaskListener(context), BuildState.success, name, step.builds, step.connection);
                    context.onSuccess(result);
                }

                public void onFailure(StepContext context, Throwable t) {
                    BuildState state = t instanceof FlowInterruptedException ? BuildState.canceled : BuildState.failed;
                    CommitStatusUpdater.updateCommitStatus(run, this.getTaskListener(context), state, name, step.builds, step.connection);
                    context.onFailure(t);
                }
            }).start();
            return false;
        }

        public void stop(@Nonnull Throwable cause) throws Exception {
            if (this.body != null) {
                String name = StringUtils.isEmpty((String)this.step.name) ? "jenkins" : this.step.name;
                CommitStatusUpdater.updateCommitStatus(this.run, null, BuildState.canceled, name, this.step.builds, this.step.connection);
                this.body.cancel(cause);
            }
        }

        private TaskListener getTaskListener(StepContext context) {
            if (!context.isReady()) {
                return null;
            }
            try {
                return (TaskListener)context.get(TaskListener.class);
            }
            catch (Exception x) {
                return null;
            }
        }
    }
}

