/*
 * Decompiled with CFR 0.152.
 */
package com.dabsquared.gitlabjenkins.webhook.build;

import com.dabsquared.gitlabjenkins.GitLabPushTrigger;
import com.dabsquared.gitlabjenkins.gitlab.hook.model.Project;
import com.dabsquared.gitlabjenkins.gitlab.hook.model.PushHook;
import com.dabsquared.gitlabjenkins.util.JsonUtil;
import com.dabsquared.gitlabjenkins.util.LoggerUtil;
import com.dabsquared.gitlabjenkins.webhook.build.BuildWebHookAction;
import com.fasterxml.jackson.databind.JsonNode;
import hudson.model.Item;
import hudson.model.Job;
import hudson.security.ACL;
import hudson.util.HttpResponses;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.plugins.git.GitSCMSource;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceOwner;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.transport.URIish;

public class PushBuildAction
extends BuildWebHookAction {
    private static final Logger LOGGER = Logger.getLogger(PushBuildAction.class.getName());
    private final Item project;
    private PushHook pushHook;
    private final String secretToken;

    public PushBuildAction(Item project, String json, String secretToken) {
        LOGGER.log(Level.FINE, "Push: {0}", JsonUtil.toPrettyPrint(json));
        this.project = project;
        this.pushHook = JsonUtil.read(json, PushHook.class);
        this.secretToken = secretToken;
    }

    public PushBuildAction(Item project, JsonNode json, String secretToken) {
        LOGGER.log(Level.FINE, "Push: {0}", JsonUtil.toPrettyPrint(json));
        this.project = project;
        this.pushHook = JsonUtil.read(json, PushHook.class);
        this.secretToken = secretToken;
    }

    @Override
    void processForCompatibility() {
        if (this.pushHook.getProject() == null && this.pushHook.getRepository() != null) {
            try {
                String path = new URL(this.pushHook.getRepository().getGitHttpUrl()).getPath();
                if (StringUtils.isNotBlank((String)path)) {
                    Project project = new Project();
                    project.setNamespace(path.replaceFirst("/", "").substring(0, path.lastIndexOf("/")));
                    this.pushHook.setProject(project);
                } else {
                    LOGGER.log(Level.WARNING, "Could not find suitable namespace.");
                }
            }
            catch (MalformedURLException ignored) {
                LOGGER.log(Level.WARNING, "Invalid repository url found while building namespace.");
            }
        }
    }

    @Override
    public void execute() {
        if (this.pushHook.getRepository() != null && this.pushHook.getRepository().getUrl() == null) {
            LOGGER.log(Level.WARNING, "No repository url found.");
            return;
        }
        if (this.project instanceof Job) {
            ACL.impersonate((Authentication)ACL.SYSTEM, (Runnable)new BuildWebHookAction.TriggerNotifier(this.project, this.secretToken, Jenkins.getAuthentication()){

                @Override
                protected void performOnPost(GitLabPushTrigger trigger) {
                    trigger.onPost(PushBuildAction.this.pushHook);
                }
            });
            throw HttpResponses.ok();
        }
        if (this.project instanceof SCMSourceOwner) {
            ACL.impersonate((Authentication)ACL.SYSTEM, (Runnable)new SCMSourceOwnerNotifier());
            throw HttpResponses.ok();
        }
        throw HttpResponses.errorWithoutStack((int)409, (String)"Push Hook is not supported for this project");
    }

    private class SCMSourceOwnerNotifier
    implements Runnable {
        private SCMSourceOwnerNotifier() {
        }

        @Override
        public void run() {
            for (SCMSource scmSource : ((SCMSourceOwner)PushBuildAction.this.project).getSCMSources()) {
                if (!(scmSource instanceof GitSCMSource)) continue;
                GitSCMSource gitSCMSource = (GitSCMSource)scmSource;
                try {
                    if (!new URIish(gitSCMSource.getRemote()).equals((Object)new URIish(gitSCMSource.getRemote()))) continue;
                    if (!gitSCMSource.isIgnoreOnPushNotifications()) {
                        LOGGER.log(Level.FINE, "Notify scmSourceOwner {0} about changes for {1}", LoggerUtil.toArray(PushBuildAction.this.project.getName(), gitSCMSource.getRemote()));
                        ((SCMSourceOwner)PushBuildAction.this.project).onSCMSourceUpdated(scmSource);
                        continue;
                    }
                    LOGGER.log(Level.FINE, "Ignore on push notification for scmSourceOwner {0} about changes for {1}", LoggerUtil.toArray(PushBuildAction.this.project.getName(), gitSCMSource.getRemote()));
                }
                catch (URISyntaxException uRISyntaxException) {}
            }
        }
    }
}

