/*
 * Decompiled with CFR 0.152.
 */
package com.dabsquared.gitlabjenkins.gitlab.api.impl;

import com.dabsquared.gitlabjenkins.gitlab.api.GitLabClient;
import com.dabsquared.gitlabjenkins.gitlab.api.impl.GitLabApiProxy;
import com.dabsquared.gitlabjenkins.gitlab.api.model.Awardable;
import com.dabsquared.gitlabjenkins.gitlab.api.model.Branch;
import com.dabsquared.gitlabjenkins.gitlab.api.model.BuildState;
import com.dabsquared.gitlabjenkins.gitlab.api.model.Label;
import com.dabsquared.gitlabjenkins.gitlab.api.model.MergeRequest;
import com.dabsquared.gitlabjenkins.gitlab.api.model.Pipeline;
import com.dabsquared.gitlabjenkins.gitlab.api.model.Project;
import com.dabsquared.gitlabjenkins.gitlab.api.model.User;
import com.dabsquared.gitlabjenkins.gitlab.hook.model.State;
import com.google.common.base.Function;
import java.util.List;

final class ResteasyGitLabClient
implements GitLabClient {
    private final String hostUrl;
    private final GitLabApiProxy api;
    private final Function<MergeRequest, Integer> mergeRequestIdProvider;

    ResteasyGitLabClient(String hostUrl, GitLabApiProxy api, Function<MergeRequest, Integer> mergeRequestIdProvider) {
        this.hostUrl = hostUrl;
        this.api = api;
        this.mergeRequestIdProvider = mergeRequestIdProvider;
    }

    @Override
    public final String getHostUrl() {
        return this.hostUrl;
    }

    @Override
    public Project createProject(String projectName) {
        return this.api.createProject(projectName);
    }

    @Override
    public MergeRequest createMergeRequest(Integer projectId, String sourceBranch, String targetBranch, String title) {
        return this.api.createMergeRequest(projectId, sourceBranch, targetBranch, title);
    }

    @Override
    public Project getProject(String projectName) {
        return this.api.getProject(projectName);
    }

    @Override
    public Project updateProject(String projectId, String name, String path) {
        return this.api.updateProject(projectId, name, path);
    }

    @Override
    public void deleteProject(String projectId) {
        this.api.deleteProject(projectId);
    }

    @Override
    public void addProjectHook(String projectId, String url, Boolean pushEvents, Boolean mergeRequestEvents, Boolean noteEvents) {
        this.api.addProjectHook(projectId, url, pushEvents, mergeRequestEvents, noteEvents);
    }

    @Override
    public void changeBuildStatus(String projectId, String sha, BuildState state, String ref, String context, String targetUrl, String description) {
        this.api.changeBuildStatus(projectId, sha, state, ref, context, targetUrl, description);
    }

    @Override
    public void changeBuildStatus(Integer projectId, String sha, BuildState state, String ref, String context, String targetUrl, String description) {
        this.api.changeBuildStatus(projectId, sha, state, ref, context, targetUrl, description);
    }

    @Override
    public void getCommit(String projectId, String sha) {
        this.api.getCommit(projectId, sha);
    }

    @Override
    public void acceptMergeRequest(MergeRequest mr, String mergeCommitMessage, boolean shouldRemoveSourceBranch) {
        this.api.acceptMergeRequest(mr.getProjectId(), (Integer)this.mergeRequestIdProvider.apply((Object)mr), mergeCommitMessage, shouldRemoveSourceBranch);
    }

    @Override
    public void createMergeRequestNote(MergeRequest mr, String body) {
        this.api.createMergeRequestNote(mr.getProjectId(), (Integer)this.mergeRequestIdProvider.apply((Object)mr), body);
    }

    @Override
    public List<Awardable> getMergeRequestEmoji(MergeRequest mr) {
        return this.api.getMergeRequestEmoji(mr.getProjectId(), (Integer)this.mergeRequestIdProvider.apply((Object)mr));
    }

    @Override
    public void awardMergeRequestEmoji(MergeRequest mr, String name) {
        this.api.awardMergeRequestEmoji(mr.getProjectId(), (Integer)this.mergeRequestIdProvider.apply((Object)mr), name);
    }

    @Override
    public void deleteMergeRequestEmoji(MergeRequest mr, Integer awardId) {
        this.api.deleteMergeRequestEmoji(mr.getProjectId(), (Integer)this.mergeRequestIdProvider.apply((Object)mr), awardId);
    }

    @Override
    public List<MergeRequest> getMergeRequests(String projectId, State state, int page, int perPage) {
        return this.api.getMergeRequests(projectId, state, page, perPage);
    }

    @Override
    public List<Branch> getBranches(String projectId) {
        return this.api.getBranches(projectId);
    }

    @Override
    public Branch getBranch(String projectId, String branch) {
        return this.api.getBranch(projectId, branch);
    }

    @Override
    public User getCurrentUser() {
        return this.api.getCurrentUser();
    }

    @Override
    public User addUser(String email, String username, String name, String password) {
        return this.api.addUser(email, username, name, password);
    }

    @Override
    public User updateUser(String userId, String email, String username, String name, String password) {
        return this.api.updateUser(userId, email, username, name, password);
    }

    @Override
    public List<Label> getLabels(String projectId) {
        return this.api.getLabels(projectId);
    }

    @Override
    public List<Pipeline> getPipelines(String projectName) {
        return this.api.getPipelines(projectName);
    }
}

