/*
 * Decompiled with CFR 0.152.
 */
package com.dabsquared.gitlabjenkins.gitlab.api.impl;

import com.dabsquared.gitlabjenkins.gitlab.api.GitLabClient;
import com.dabsquared.gitlabjenkins.gitlab.api.GitLabClientBuilder;
import com.dabsquared.gitlabjenkins.gitlab.api.model.Awardable;
import com.dabsquared.gitlabjenkins.gitlab.api.model.Branch;
import com.dabsquared.gitlabjenkins.gitlab.api.model.BuildState;
import com.dabsquared.gitlabjenkins.gitlab.api.model.Label;
import com.dabsquared.gitlabjenkins.gitlab.api.model.MergeRequest;
import com.dabsquared.gitlabjenkins.gitlab.api.model.Pipeline;
import com.dabsquared.gitlabjenkins.gitlab.api.model.Project;
import com.dabsquared.gitlabjenkins.gitlab.api.model.User;
import com.dabsquared.gitlabjenkins.gitlab.hook.model.State;
import java.util.List;
import java.util.NoSuchElementException;
import javax.ws.rs.NotFoundException;

final class AutodetectingGitLabClient
implements GitLabClient {
    private final Iterable<GitLabClientBuilder> builders;
    private final String url;
    private final String token;
    private final boolean ignoreCertificateErrors;
    private final int connectionTimeout;
    private final int readTimeout;
    private GitLabClient delegate;

    AutodetectingGitLabClient(Iterable<GitLabClientBuilder> builders, String url, String token, boolean ignoreCertificateErrors, int connectionTimeout, int readTimeout) {
        this.builders = builders;
        this.url = url;
        this.token = token;
        this.ignoreCertificateErrors = ignoreCertificateErrors;
        this.connectionTimeout = connectionTimeout;
        this.readTimeout = readTimeout;
    }

    @Override
    public String getHostUrl() {
        return this.url;
    }

    @Override
    public Project createProject(final String projectName) {
        return this.execute(new GitLabOperation<Project>(){

            @Override
            Project execute(GitLabClient client) {
                return client.createProject(projectName);
            }
        });
    }

    @Override
    public MergeRequest createMergeRequest(final Integer projectId, final String sourceBranch, final String targetBranch, final String title) {
        return this.execute(new GitLabOperation<MergeRequest>(){

            @Override
            MergeRequest execute(GitLabClient client) {
                return client.createMergeRequest(projectId, sourceBranch, targetBranch, title);
            }
        });
    }

    @Override
    public Project getProject(final String projectName) {
        return this.execute(new GitLabOperation<Project>(){

            @Override
            Project execute(GitLabClient client) {
                return client.getProject(projectName);
            }
        });
    }

    @Override
    public Project updateProject(final String projectId, final String name, final String path) {
        return this.execute(new GitLabOperation<Project>(){

            @Override
            Project execute(GitLabClient client) {
                return client.updateProject(projectId, name, path);
            }
        });
    }

    @Override
    public void deleteProject(final String projectId) {
        this.execute(new GitLabOperation<Void>(){

            @Override
            Void execute(GitLabClient client) {
                client.deleteProject(projectId);
                return null;
            }
        });
    }

    @Override
    public void addProjectHook(final String projectId, final String url, final Boolean pushEvents, final Boolean mergeRequestEvents, final Boolean noteEvents) {
        this.execute(new GitLabOperation<Void>(){

            @Override
            Void execute(GitLabClient client) {
                client.addProjectHook(projectId, url, pushEvents, mergeRequestEvents, noteEvents);
                return null;
            }
        });
    }

    @Override
    public void changeBuildStatus(final String projectId, final String sha, final BuildState state, final String ref, final String context, final String targetUrl, final String description) {
        this.execute(new GitLabOperation<Void>(){

            @Override
            Void execute(GitLabClient client) {
                client.changeBuildStatus(projectId, sha, state, ref, context, targetUrl, description);
                return null;
            }
        });
    }

    @Override
    public void changeBuildStatus(final Integer projectId, final String sha, final BuildState state, final String ref, final String context, final String targetUrl, final String description) {
        this.execute(new GitLabOperation<Void>(){

            @Override
            Void execute(GitLabClient client) {
                client.changeBuildStatus(projectId, sha, state, ref, context, targetUrl, description);
                return null;
            }
        });
    }

    @Override
    public void getCommit(final String projectId, final String sha) {
        this.execute(new GitLabOperation<Void>(){

            @Override
            Void execute(GitLabClient client) {
                client.getCommit(projectId, sha);
                return null;
            }
        });
    }

    @Override
    public void acceptMergeRequest(final MergeRequest mr, final String mergeCommitMessage, final boolean shouldRemoveSourceBranch) {
        this.execute(new GitLabOperation<Void>(){

            @Override
            Void execute(GitLabClient client) {
                client.acceptMergeRequest(mr, mergeCommitMessage, shouldRemoveSourceBranch);
                return null;
            }
        });
    }

    @Override
    public void createMergeRequestNote(final MergeRequest mr, final String body) {
        this.execute(new GitLabOperation<Void>(){

            @Override
            Void execute(GitLabClient client) {
                client.createMergeRequestNote(mr, body);
                return null;
            }
        });
    }

    @Override
    public List<Awardable> getMergeRequestEmoji(final MergeRequest mr) {
        return this.execute(new GitLabOperation<List<Awardable>>(){

            @Override
            List<Awardable> execute(GitLabClient client) {
                return client.getMergeRequestEmoji(mr);
            }
        });
    }

    @Override
    public void awardMergeRequestEmoji(final MergeRequest mr, final String body) {
        this.execute(new GitLabOperation<Void>(){

            @Override
            Void execute(GitLabClient client) {
                client.awardMergeRequestEmoji(mr, body);
                return null;
            }
        });
    }

    @Override
    public void deleteMergeRequestEmoji(final MergeRequest mr, final Integer awardId) {
        this.execute(new GitLabOperation<Void>(){

            @Override
            Void execute(GitLabClient client) {
                client.deleteMergeRequestEmoji(mr, awardId);
                return null;
            }
        });
    }

    @Override
    public List<MergeRequest> getMergeRequests(final String projectId, final State state, final int page, final int perPage) {
        return this.execute(new GitLabOperation<List<MergeRequest>>(){

            @Override
            List<MergeRequest> execute(GitLabClient client) {
                return client.getMergeRequests(projectId, state, page, perPage);
            }
        });
    }

    @Override
    public List<Branch> getBranches(final String projectId) {
        return this.execute(new GitLabOperation<List<Branch>>(){

            @Override
            List<Branch> execute(GitLabClient client) {
                return client.getBranches(projectId);
            }
        });
    }

    @Override
    public Branch getBranch(final String projectId, final String branch) {
        return this.execute(new GitLabOperation<Branch>(){

            @Override
            Branch execute(GitLabClient client) {
                return client.getBranch(projectId, branch);
            }
        });
    }

    @Override
    public User getCurrentUser() {
        return this.execute(new GitLabOperation<User>(){

            @Override
            User execute(GitLabClient client) {
                return client.getCurrentUser();
            }
        });
    }

    @Override
    public User addUser(final String email, final String username, final String name, final String password) {
        return this.execute(new GitLabOperation<User>(){

            @Override
            User execute(GitLabClient client) {
                return client.addUser(email, username, name, password);
            }
        });
    }

    @Override
    public User updateUser(final String userId, final String email, final String username, final String name, final String password) {
        return this.execute(new GitLabOperation<User>(){

            @Override
            User execute(GitLabClient client) {
                return client.updateUser(userId, email, username, name, password);
            }
        });
    }

    @Override
    public List<Label> getLabels(final String projectId) {
        return this.execute(new GitLabOperation<List<Label>>(){

            @Override
            List<Label> execute(GitLabClient client) {
                return client.getLabels(projectId);
            }
        });
    }

    @Override
    public List<Pipeline> getPipelines(final String projectName) {
        return this.execute(new GitLabOperation<List<Pipeline>>(){

            @Override
            List<Pipeline> execute(GitLabClient client) {
                return client.getPipelines(projectName);
            }
        });
    }

    private GitLabClient delegate(boolean reset) {
        if (reset || this.delegate == null) {
            this.delegate = this.autodetectOrDie();
        }
        return this.delegate;
    }

    private GitLabClient autodetectOrDie() {
        GitLabClient client = this.autodetect();
        if (client != null) {
            return client;
        }
        throw new NoSuchElementException("no client-builder found that supports server at " + this.url);
    }

    private GitLabClient autodetect() {
        for (GitLabClientBuilder candidate : this.builders) {
            GitLabClient client = candidate.buildClient(this.url, this.token, this.ignoreCertificateErrors, this.connectionTimeout, this.readTimeout);
            try {
                client.getCurrentUser();
                return client;
            }
            catch (NotFoundException notFoundException) {
            }
        }
        return null;
    }

    private <R> R execute(GitLabOperation<R> operation) {
        return (R)((GitLabOperation)operation).execute(false);
    }

    private abstract class GitLabOperation<R> {
        private GitLabOperation() {
        }

        private R execute(boolean reset) {
            try {
                return this.execute(AutodetectingGitLabClient.this.delegate(reset));
            }
            catch (NotFoundException e) {
                if (reset) {
                    throw e;
                }
                return this.execute(true);
            }
        }

        abstract R execute(GitLabClient var1);
    }
}

