/*
 * Decompiled with CFR 0.152.
 */
package com.dabsquared.gitlabjenkins.connection;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.SystemCredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.dabsquared.gitlabjenkins.connection.GitLabApiToken;
import com.dabsquared.gitlabjenkins.connection.GitLabApiTokenImpl;
import com.dabsquared.gitlabjenkins.connection.GitLabConnectionConfig;
import com.dabsquared.gitlabjenkins.gitlab.api.GitLabClient;
import com.dabsquared.gitlabjenkins.gitlab.api.GitLabClientBuilder;
import com.dabsquared.gitlabjenkins.gitlab.api.impl.AutodetectGitLabClientBuilder;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.Item;
import hudson.model.ModelObject;
import hudson.security.ACL;
import hudson.util.Secret;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

public class GitLabConnection {
    private final String name;
    private final String url;
    private transient String apiToken;
    private String apiTokenId;
    private GitLabClientBuilder clientBuilder;
    private final boolean ignoreCertificateErrors;
    private final Integer connectionTimeout;
    private final Integer readTimeout;
    private transient GitLabClient apiCache;

    public GitLabConnection(String name, String url, String apiTokenId, boolean ignoreCertificateErrors, Integer connectionTimeout, Integer readTimeout) {
        this(name, url, apiTokenId, new AutodetectGitLabClientBuilder(), ignoreCertificateErrors, connectionTimeout, readTimeout);
    }

    @DataBoundConstructor
    public GitLabConnection(String name, String url, String apiTokenId, String clientBuilderId, boolean ignoreCertificateErrors, Integer connectionTimeout, Integer readTimeout) {
        this(name, url, apiTokenId, GitLabClientBuilder.getGitLabClientBuilderById(clientBuilderId), ignoreCertificateErrors, connectionTimeout, readTimeout);
    }

    @Restricted(value={NoExternalUse.class})
    public GitLabConnection(String name, String url, String apiTokenId, GitLabClientBuilder clientBuilder, boolean ignoreCertificateErrors, Integer connectionTimeout, Integer readTimeout) {
        this.name = name;
        this.url = url;
        this.apiTokenId = apiTokenId;
        this.clientBuilder = clientBuilder;
        this.ignoreCertificateErrors = ignoreCertificateErrors;
        this.connectionTimeout = connectionTimeout;
        this.readTimeout = readTimeout;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public String getApiTokenId() {
        return this.apiTokenId;
    }

    public String getClientBuilderId() {
        return this.clientBuilder.id();
    }

    public boolean isIgnoreCertificateErrors() {
        return this.ignoreCertificateErrors;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public GitLabClient getClient() {
        if (this.apiCache == null) {
            this.apiCache = this.clientBuilder.buildClient(this.url, this.getApiToken(this.apiTokenId), this.ignoreCertificateErrors, this.connectionTimeout, this.readTimeout);
        }
        return this.apiCache;
    }

    private String getApiToken(String apiTokenId) {
        StandardCredentials credentials = (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (Item)null, (Authentication)ACL.SYSTEM, new ArrayList()), (CredentialsMatcher)CredentialsMatchers.withId((String)apiTokenId));
        if (credentials != null) {
            if (credentials instanceof GitLabApiToken) {
                return ((GitLabApiToken)credentials).getApiToken().getPlainText();
            }
            if (credentials instanceof StringCredentials) {
                return ((StringCredentials)credentials).getSecret().getPlainText();
            }
        }
        throw new IllegalStateException("No credentials found for credentialsId: " + apiTokenId);
    }

    protected GitLabConnection readResolve() {
        if (this.connectionTimeout == null || this.readTimeout == null) {
            return new GitLabConnection(this.name, this.url, this.apiTokenId, new AutodetectGitLabClientBuilder(), this.ignoreCertificateErrors, (Integer)10, (Integer)10);
        }
        if (this.clientBuilder == null) {
            return new GitLabConnection(this.name, this.url, this.apiTokenId, new AutodetectGitLabClientBuilder(), this.ignoreCertificateErrors, this.connectionTimeout, this.readTimeout);
        }
        return this;
    }

    @Initializer(after=InitMilestone.PLUGINS_STARTED)
    public static void migrate() throws IOException {
        GitLabConnectionConfig descriptor = (GitLabConnectionConfig)Jenkins.getInstance().getDescriptor(GitLabConnectionConfig.class);
        for (GitLabConnection connection : descriptor.getConnections()) {
            if (connection.apiTokenId != null || connection.apiToken == null) continue;
            for (CredentialsStore credentialsStore : CredentialsProvider.lookupStores((ModelObject)Jenkins.getInstance())) {
                if (!(credentialsStore instanceof SystemCredentialsProvider.StoreImpl)) continue;
                List domains = credentialsStore.getDomains();
                connection.apiTokenId = UUID.randomUUID().toString();
                credentialsStore.addCredentials((Domain)domains.get(0), (Credentials)new GitLabApiTokenImpl(CredentialsScope.SYSTEM, connection.apiTokenId, "GitLab API Token", Secret.fromString((String)connection.apiToken)));
            }
        }
        descriptor.save();
    }
}

