/*
 * Decompiled with CFR 0.152.
 */
package com.dabsquared.gitlabjenkins.trigger.filter;

import com.dabsquared.gitlabjenkins.trigger.filter.BranchFilter;
import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.util.AntPathMatcher;

class NameBasedFilter
implements BranchFilter {
    private final List<String> includedBranches;
    private final List<String> excludedBranches;

    public NameBasedFilter(String includedBranches, String excludedBranches) {
        this.includedBranches = this.convert(includedBranches);
        this.excludedBranches = this.convert(excludedBranches);
    }

    @Override
    public boolean isBranchAllowed(String sourceBranchName, String targetBranchName) {
        return this.hasNoBranchSpecs() || this.isBranchNotExcluded(targetBranchName) && this.isBranchIncluded(targetBranchName);
    }

    private boolean hasNoBranchSpecs() {
        return this.includedBranches.isEmpty() && this.excludedBranches.isEmpty();
    }

    private boolean isBranchNotExcluded(String branchName) {
        AntPathMatcher matcher = new AntPathMatcher();
        for (String excludePattern : this.excludedBranches) {
            if (!matcher.match(excludePattern, branchName)) continue;
            return false;
        }
        return true;
    }

    private boolean isBranchIncluded(String branchName) {
        AntPathMatcher matcher = new AntPathMatcher();
        for (String includePattern : this.includedBranches) {
            if (!matcher.match(includePattern, branchName)) continue;
            return true;
        }
        return this.includedBranches.isEmpty();
    }

    private List<String> convert(String commaSeparatedString) {
        if (commaSeparatedString == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String s : Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)commaSeparatedString)) {
            result.add(s);
        }
        return result;
    }
}

