/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gitlablogo;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.gitlablogo.api.GitlabApi;
import org.jenkinsci.plugins.gitlablogo.api.Project;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class GitlabLogoProperty
extends JobProperty<Job<?, ?>> {
    private final String repositoryName;

    @DataBoundConstructor
    public GitlabLogoProperty(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public boolean isAvailable() {
        return StringUtils.isNotEmpty((String)this.repositoryName);
    }

    public boolean isDefaultIcon() {
        return StringUtils.isEmpty((String)this.getIconUrl());
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public String getIconUrl() {
        Project project = this.getProject();
        if (project == null) {
            return "";
        }
        return project.avatarUrl;
    }

    public String getRepositoryUrl() {
        Project project = this.getProject();
        if (project == null) {
            return "";
        }
        return project.webUrl;
    }

    private Project getProject() {
        DescriptorImpl descriptor = this.getDescriptor();
        GitlabApi api = new GitlabApi(descriptor.getEndpointUrl(), descriptor.getPrivateToken());
        return api.getCachedProject(this.getRepositoryName());
    }

    @Extension
    public static final class DescriptorImpl
    extends JobPropertyDescriptor {
        private String privateToken;
        private String endpointUrl;

        public DescriptorImpl() {
            super(GitlabLogoProperty.class);
            super.load();
        }

        public String getDisplayName() {
            return "GitLab logo";
        }

        public boolean isApplicable(Class<? extends Job> jobType) {
            return true;
        }

        public GitlabLogoProperty newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (GitlabLogoProperty)((Object)req.bindJSON(GitlabLogoProperty.class, formData));
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.privateToken = formData.getString("privateToken");
            this.endpointUrl = formData.getString("endpointUrl");
            this.save();
            return super.configure(req, formData);
        }

        public String getPrivateToken() {
            return this.privateToken;
        }

        public String getEndpointUrl() {
            return this.endpointUrl;
        }

        public void doClearCache(StaplerRequest req, StaplerResponse rsp) {
            GitlabApi.clearCache();
        }
    }
}

