/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins;

import hudson.model.User;
import hudson.model.UserProperty;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.GithubAccessTokenProperty;
import org.jfree.util.Log;

public class GithubSecretStorage {
    private GithubSecretStorage() {
    }

    public static boolean contains(@Nonnull User user) {
        return user.getProperty(GithubAccessTokenProperty.class) != null;
    }

    @CheckForNull
    public static String retrieve(@Nonnull User user) {
        GithubAccessTokenProperty property = (GithubAccessTokenProperty)user.getProperty(GithubAccessTokenProperty.class);
        if (property == null) {
            Log.debug((Object)("Cache miss for username: " + user.getId()));
            return null;
        }
        Log.debug((Object)("Token retrieved using cache for username: " + user.getId()));
        return property.getAccessToken().getPlainText();
    }

    public static void put(@Nonnull User user, @Nonnull String accessToken) {
        Log.debug((Object)("Populating the cache for username: " + user.getId()));
        try {
            user.addProperty((UserProperty)new GithubAccessTokenProperty(accessToken));
        }
        catch (IOException e) {
            Log.warn((Object)("Received an exception when trying to add the GitHub access token to the user: " + user.getId()), (Exception)e);
        }
    }
}

