/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.userdetails.User;
import org.acegisecurity.userdetails.UserDetails;
import org.jenkinsci.plugins.GithubAuthenticationToken;
import org.kohsuke.github.GHUser;

@SuppressFBWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"})
public class GithubOAuthUserDetails
extends User
implements UserDetails {
    private static final long serialVersionUID = 1L;
    private boolean hasGrantedAuthorities;
    private final GithubAuthenticationToken authenticationToken;

    public GithubOAuthUserDetails(@Nonnull String login, @Nonnull GrantedAuthority[] authorities) {
        super(login, "", true, true, true, true, authorities);
        this.authenticationToken = null;
        this.hasGrantedAuthorities = true;
    }

    public GithubOAuthUserDetails(@Nonnull String login, @Nonnull GithubAuthenticationToken authenticationToken) {
        super(login, "", true, true, true, true, new GrantedAuthority[0]);
        this.authenticationToken = authenticationToken;
        this.hasGrantedAuthorities = false;
    }

    public GrantedAuthority[] getAuthorities() {
        if (!this.hasGrantedAuthorities) {
            try {
                GHUser user = this.authenticationToken.loadUser(this.getUsername());
                if (user != null) {
                    this.setAuthorities(this.authenticationToken.getAuthorities());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return super.getAuthorities();
    }
}

