/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins;

import hudson.Extension;
import hudson.model.UnprotectedRootAction;
import hudson.security.SecurityRealm;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.GithubSecurityRealm;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
public class GithubLogoutAction
implements UnprotectedRootAction {
    static final String POST_LOGOUT_URL = "githubLogout";

    public String getDisplayName() {
        return "Github Logout";
    }

    public String getIconFileName() {
        return null;
    }

    public String getUrlName() {
        return POST_LOGOUT_URL;
    }

    @Restricted(value={NoExternalUse.class})
    public String getGitHubURL() {
        Jenkins j = Jenkins.getInstance();
        assert (j != null);
        SecurityRealm r = j.getSecurityRealm();
        if (r instanceof GithubSecurityRealm) {
            GithubSecurityRealm ghsr = (GithubSecurityRealm)r;
            return ghsr.getGithubWebUri();
        }
        return "";
    }

    @Restricted(value={NoExternalUse.class})
    public String getGitHubText() {
        Jenkins j = Jenkins.getInstance();
        assert (j != null);
        SecurityRealm r = j.getSecurityRealm();
        if (r instanceof GithubSecurityRealm) {
            GithubSecurityRealm ghsr = (GithubSecurityRealm)r;
            return ghsr.getDescriptor().getDefaultGithubWebUri().equals(ghsr.getGithubWebUri()) ? "GitHub" : "GitHub Enterprise";
        }
        return "";
    }
}

