/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins;

import com.google.common.collect.ImmutableList;
import hudson.Extension;
import hudson.model.AbstractItem;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.security.ACL;
import hudson.security.AuthorizationStrategy;
import java.util.Collection;
import javax.annotation.Nonnull;
import jenkins.branch.MultiBranchProject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.GithubRequireOrganizationMembershipACL;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.multibranch.BranchJobProperty;
import org.kohsuke.stapler.DataBoundConstructor;

public class GithubAuthorizationStrategy
extends AuthorizationStrategy {
    private final GithubRequireOrganizationMembershipACL rootACL;

    @DataBoundConstructor
    public GithubAuthorizationStrategy(String adminUserNames, boolean authenticatedUserReadPermission, boolean useRepositoryPermissions, boolean authenticatedUserCreateJobPermission, String organizationNames, boolean allowGithubWebHookPermission, boolean allowCcTrayPermission, boolean allowAnonymousReadPermission, boolean allowAnonymousJobStatusPermission) {
        this.rootACL = new GithubRequireOrganizationMembershipACL(adminUserNames, organizationNames, authenticatedUserReadPermission, useRepositoryPermissions, authenticatedUserCreateJobPermission, allowGithubWebHookPermission, allowCcTrayPermission, allowAnonymousReadPermission, allowAnonymousJobStatusPermission);
    }

    @Nonnull
    public ACL getRootACL() {
        return this.rootACL;
    }

    @Nonnull
    public ACL getACL(@Nonnull AbstractItem item) {
        if (item instanceof MultiBranchProject) {
            GithubRequireOrganizationMembershipACL githubACL = (GithubRequireOrganizationMembershipACL)this.getRootACL();
            return githubACL.cloneForProject(item);
        }
        return this.getRootACL();
    }

    @Nonnull
    public ACL getACL(@Nonnull Job<?, ?> job) {
        if (job instanceof WorkflowJob && job.getProperty(BranchJobProperty.class) != null || job instanceof AbstractProject) {
            GithubRequireOrganizationMembershipACL githubACL = (GithubRequireOrganizationMembershipACL)this.getRootACL();
            return githubACL.cloneForProject((AbstractItem)job);
        }
        return this.getRootACL();
    }

    @Nonnull
    public Collection<String> getGroups() {
        return ImmutableList.of();
    }

    private Object readResolve() {
        return this;
    }

    public String getOrganizationNames() {
        return StringUtils.join(this.rootACL.getOrganizationNameList().iterator(), (String)", ");
    }

    public String getAdminUserNames() {
        return StringUtils.join(this.rootACL.getAdminUserNameList().iterator(), (String)", ");
    }

    public boolean isUseRepositoryPermissions() {
        return this.rootACL.isUseRepositoryPermissions();
    }

    public boolean isAuthenticatedUserCreateJobPermission() {
        return this.rootACL.isAuthenticatedUserCreateJobPermission();
    }

    public boolean isAuthenticatedUserReadPermission() {
        return this.rootACL.isAuthenticatedUserReadPermission();
    }

    public boolean isAllowGithubWebHookPermission() {
        return this.rootACL.isAllowGithubWebHookPermission();
    }

    public boolean isAllowCcTrayPermission() {
        return this.rootACL.isAllowCcTrayPermission();
    }

    public boolean isAllowAnonymousReadPermission() {
        return this.rootACL.isAllowAnonymousReadPermission();
    }

    public boolean isAllowAnonymousJobStatusPermission() {
        return this.rootACL.isAllowAnonymousJobStatusPermission();
    }

    public boolean equals(Object object) {
        if (object instanceof GithubAuthorizationStrategy) {
            GithubAuthorizationStrategy obj = (GithubAuthorizationStrategy)((Object)object);
            return this.getOrganizationNames().equals(obj.getOrganizationNames()) && this.getAdminUserNames().equals(obj.getAdminUserNames()) && this.isUseRepositoryPermissions() == obj.isUseRepositoryPermissions() && this.isAuthenticatedUserCreateJobPermission() == obj.isAuthenticatedUserCreateJobPermission() && this.isAuthenticatedUserReadPermission() == obj.isAuthenticatedUserReadPermission() && this.isAllowGithubWebHookPermission() == obj.isAllowGithubWebHookPermission() && this.isAllowCcTrayPermission() == obj.isAllowCcTrayPermission() && this.isAllowAnonymousReadPermission() == obj.isAllowAnonymousReadPermission() && this.isAllowAnonymousJobStatusPermission() == obj.isAllowAnonymousJobStatusPermission();
        }
        return false;
    }

    public int hashCode() {
        return this.rootACL != null ? ((Object)((Object)this.rootACL)).hashCode() : 0;
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<AuthorizationStrategy> {
        public String getDisplayName() {
            return "GitHub Committer Authorization Strategy";
        }

        public String getHelpFile() {
            return "/plugin/github-oauth/help/help-authorization-strategy.html";
        }
    }
}

