/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github_branch_source;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.jcip.annotations.GuardedBy;

class SinglePassIterable<V>
implements Iterable<V> {
    @GuardedBy(value="items")
    @CheckForNull
    private Iterator<V> delegate;
    private final List<V> items;

    public SinglePassIterable(@NonNull Iterable<V> delegate) {
        this(delegate.iterator());
    }

    public SinglePassIterable(@NonNull Iterator<V> delegate) {
        this.delegate = delegate;
        this.items = new ArrayList<V>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Iterator<V> iterator() {
        List<V> list = this.items;
        synchronized (list) {
            if (this.delegate == null || !this.delegate.hasNext()) {
                return Collections.unmodifiableList(this.items).iterator();
            }
        }
        return new Iterator<V>(){
            int index = 0;

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNext() {
                List list = SinglePassIterable.this.items;
                synchronized (list) {
                    if (this.index < SinglePassIterable.this.items.size()) {
                        return true;
                    }
                    if (SinglePassIterable.this.delegate != null) {
                        if (SinglePassIterable.this.delegate.hasNext()) {
                            return true;
                        }
                        SinglePassIterable.this.delegate = null;
                        SinglePassIterable.this.completed();
                    }
                    return false;
                }
            }

            @Override
            public V next() {
                List list = SinglePassIterable.this.items;
                synchronized (list) {
                    if (this.index < SinglePassIterable.this.items.size()) {
                        return SinglePassIterable.this.items.get(this.index++);
                    }
                    try {
                        if (SinglePassIterable.this.delegate != null && SinglePassIterable.this.delegate.hasNext()) {
                            Object element = SinglePassIterable.this.delegate.next();
                            SinglePassIterable.this.observe(element);
                            SinglePassIterable.this.items.add(element);
                            return element;
                        }
                        throw new NoSuchElementException();
                    }
                    catch (NoSuchElementException e) {
                        if (SinglePassIterable.this.delegate != null) {
                            SinglePassIterable.this.delegate = null;
                            SinglePassIterable.this.completed();
                        }
                        throw e;
                    }
                }
            }
        };
    }

    protected void observe(V v) {
    }

    protected void completed() {
    }
}

