/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github_branch_source;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Util;
import hudson.model.TaskListener;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadOrigin;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.mixin.ChangeRequestCheckoutStrategy;
import jenkins.scm.api.trait.SCMSourceContext;
import jenkins.scm.api.trait.SCMSourceRequest;
import net.jcip.annotations.GuardedBy;
import org.jenkinsci.plugins.github_branch_source.BranchSCMHead;
import org.jenkinsci.plugins.github_branch_source.Connector;
import org.jenkinsci.plugins.github_branch_source.GitHubPermissionsSource;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSourceContext;
import org.jenkinsci.plugins.github_branch_source.GitHubTagSCMHead;
import org.jenkinsci.plugins.github_branch_source.PullRequestSCMHead;
import org.kohsuke.github.GHBranch;
import org.kohsuke.github.GHPermissionType;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHRef;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;

public class GitHubSCMSourceRequest
extends SCMSourceRequest {
    private final boolean fetchBranches;
    private final boolean fetchTags;
    private final boolean fetchOriginPRs;
    private final boolean fetchForkPRs;
    @NonNull
    private final Set<ChangeRequestCheckoutStrategy> originPRStrategies;
    @NonNull
    private final Set<ChangeRequestCheckoutStrategy> forkPRStrategies;
    @CheckForNull
    private final Set<Integer> requestedPullRequestNumbers;
    @CheckForNull
    private final Set<String> requestedOriginBranchNames;
    @CheckForNull
    private final Set<String> requestedTagNames;
    @CheckForNull
    private Iterable<GHPullRequest> pullRequests;
    @CheckForNull
    private Iterable<GHBranch> branches;
    @CheckForNull
    private Iterable<GHRef> tags;
    @CheckForNull
    private Set<String> collaboratorNames;
    @CheckForNull
    private GitHub gitHub;
    @CheckForNull
    private GHRepository repository;
    @GuardedBy(value="self")
    @NonNull
    private final Map<String, GHPermissionType> permissions = new HashMap<String, GHPermissionType>();
    @CheckForNull
    private GitHubPermissionsSource permissionsSource;

    GitHubSCMSourceRequest(SCMSource source, GitHubSCMSourceContext context, TaskListener listener) {
        super(source, (SCMSourceContext)context, listener);
        this.fetchBranches = context.wantBranches();
        this.fetchTags = context.wantTags();
        this.fetchOriginPRs = context.wantOriginPRs();
        this.fetchForkPRs = context.wantForkPRs();
        this.originPRStrategies = this.fetchOriginPRs && !context.originPRStrategies().isEmpty() ? Collections.unmodifiableSet(EnumSet.copyOf(context.originPRStrategies())) : Collections.emptySet();
        this.forkPRStrategies = this.fetchForkPRs && !context.forkPRStrategies().isEmpty() ? Collections.unmodifiableSet(EnumSet.copyOf(context.forkPRStrategies())) : Collections.emptySet();
        Set includes = context.observer().getIncludes();
        if (includes != null) {
            HashSet<Integer> pullRequestNumbers = new HashSet<Integer>(includes.size());
            HashSet<String> branchNames = new HashSet<String>(includes.size());
            HashSet<String> tagNames = new HashSet<String>(includes.size());
            for (SCMHead h : includes) {
                if (h instanceof BranchSCMHead) {
                    branchNames.add(h.getName());
                    continue;
                }
                if (h instanceof PullRequestSCMHead) {
                    pullRequestNumbers.add(((PullRequestSCMHead)h).getNumber());
                    if (!SCMHeadOrigin.DEFAULT.equals((Object)h.getOrigin())) continue;
                    branchNames.add(((PullRequestSCMHead)h).getOriginName());
                    continue;
                }
                if (!(h instanceof GitHubTagSCMHead)) continue;
                tagNames.add(h.getName());
            }
            this.requestedPullRequestNumbers = Collections.unmodifiableSet(pullRequestNumbers);
            this.requestedOriginBranchNames = Collections.unmodifiableSet(branchNames);
            this.requestedTagNames = Collections.unmodifiableSet(tagNames);
        } else {
            this.requestedPullRequestNumbers = null;
            this.requestedOriginBranchNames = null;
            this.requestedTagNames = null;
        }
    }

    public final boolean isFetchBranches() {
        return this.fetchBranches;
    }

    public final boolean isFetchTags() {
        return this.fetchTags;
    }

    public final boolean isFetchPRs() {
        return this.isFetchOriginPRs() || this.isFetchForkPRs();
    }

    public final boolean isFetchOriginPRs() {
        return this.fetchOriginPRs;
    }

    public final boolean isFetchForkPRs() {
        return this.fetchForkPRs;
    }

    @NonNull
    public final Set<ChangeRequestCheckoutStrategy> getOriginPRStrategies() {
        return this.originPRStrategies;
    }

    @NonNull
    public final Set<ChangeRequestCheckoutStrategy> getForkPRStrategies() {
        return this.forkPRStrategies;
    }

    @NonNull
    public final Set<ChangeRequestCheckoutStrategy> getPRStrategies(boolean fork) {
        if (fork) {
            return this.fetchForkPRs ? this.getForkPRStrategies() : Collections.emptySet();
        }
        return this.fetchOriginPRs ? this.getOriginPRStrategies() : Collections.emptySet();
    }

    public final Map<Boolean, Set<ChangeRequestCheckoutStrategy>> getPRStrategies() {
        HashMap<Boolean, Set<ChangeRequestCheckoutStrategy>> result = new HashMap<Boolean, Set<ChangeRequestCheckoutStrategy>>();
        for (Boolean fork : new Boolean[]{Boolean.TRUE, Boolean.FALSE}) {
            result.put(fork, this.getPRStrategies(fork));
        }
        return result;
    }

    @CheckForNull
    public final Set<Integer> getRequestedPullRequestNumbers() {
        return this.requestedPullRequestNumbers;
    }

    @CheckForNull
    public final Set<String> getRequestedOriginBranchNames() {
        return this.requestedOriginBranchNames;
    }

    @CheckForNull
    public final Set<String> getRequestedTagNames() {
        return this.requestedTagNames;
    }

    public void setPullRequests(@CheckForNull Iterable<GHPullRequest> pullRequests) {
        this.pullRequests = pullRequests;
    }

    @NonNull
    public Iterable<GHPullRequest> getPullRequests() {
        return Util.fixNull(this.pullRequests);
    }

    public final void setBranches(@CheckForNull Iterable<GHBranch> branches) {
        this.branches = branches;
    }

    @NonNull
    public final Iterable<GHBranch> getBranches() {
        return Util.fixNull(this.branches);
    }

    public final void setTags(@CheckForNull Iterable<GHRef> tags) {
        this.tags = tags;
    }

    @NonNull
    public final Iterable<GHRef> getTags() {
        return Util.fixNull(this.tags);
    }

    public final void setCollaboratorNames(@CheckForNull Set<String> collaboratorNames) {
        this.collaboratorNames = collaboratorNames;
    }

    public final Set<String> getCollaboratorNames() {
        return this.collaboratorNames;
    }

    public final void checkApiRateLimit() throws IOException, InterruptedException {
        if (this.gitHub != null) {
            Connector.checkApiRateLimit(this.listener(), this.gitHub);
        }
    }

    @CheckForNull
    public GitHub getGitHub() {
        return this.gitHub;
    }

    public void setGitHub(@CheckForNull GitHub gitHub) {
        this.gitHub = gitHub;
    }

    public GHRepository getRepository() {
        return this.repository;
    }

    public void setRepository(GHRepository repository) {
        this.repository = repository;
    }

    public void close() throws IOException {
        if (this.pullRequests instanceof Closeable) {
            ((Closeable)((Object)this.pullRequests)).close();
        }
        if (this.branches instanceof Closeable) {
            ((Closeable)((Object)this.branches)).close();
        }
        if (this.permissionsSource instanceof Closeable) {
            ((Closeable)((Object)this.permissionsSource)).close();
        }
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GHPermissionType getPermissions(String username) throws IOException, InterruptedException {
        Map<String, GHPermissionType> map = this.permissions;
        synchronized (map) {
            if (this.permissions.containsKey(username)) {
                return this.permissions.get(username);
            }
        }
        if (this.permissionsSource != null) {
            GHPermissionType result = this.permissionsSource.fetch(username);
            Map<String, GHPermissionType> map2 = this.permissions;
            synchronized (map2) {
                this.permissions.put(username, result);
            }
            return result;
        }
        if (this.repository != null && username.equalsIgnoreCase(this.repository.getOwnerName())) {
            return GHPermissionType.ADMIN;
        }
        if (this.collaboratorNames != null && this.collaboratorNames.contains(username)) {
            return GHPermissionType.WRITE;
        }
        return GHPermissionType.NONE;
    }

    @CheckForNull
    public GitHubPermissionsSource getPermissionsSource() {
        return this.permissionsSource;
    }

    public void setPermissionsSource(@CheckForNull GitHubPermissionsSource permissionsSource) {
        this.permissionsSource = permissionsSource;
    }
}

