/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github_branch_source;

import com.cloudbees.jenkins.GitHubWebHook;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsNameProvider;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.Extension;
import hudson.Functions;
import hudson.RestrictedSince;
import hudson.Util;
import hudson.console.HyperlinkNote;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.Action;
import hudson.model.Actionable;
import hudson.model.Item;
import hudson.model.Items;
import hudson.model.TaskListener;
import hudson.plugins.git.extensions.GitSCMExtension;
import hudson.scm.SCM;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.LogTaskListener;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.plugins.git.GitTagSCMHead;
import jenkins.plugins.git.GitTagSCMRevision;
import jenkins.plugins.git.MergeWithGitSCMExtension;
import jenkins.plugins.git.traits.GitBrowserSCMSourceTrait;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadCategory;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMProbe;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import jenkins.scm.api.SCMSourceDescriptor;
import jenkins.scm.api.SCMSourceEvent;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.metadata.ContributorMetadataAction;
import jenkins.scm.api.metadata.ObjectMetadataAction;
import jenkins.scm.api.metadata.PrimaryInstanceMetadataAction;
import jenkins.scm.api.mixin.ChangeRequestCheckoutStrategy;
import jenkins.scm.api.mixin.ChangeRequestSCMHead2;
import jenkins.scm.api.trait.SCMHeadAuthority;
import jenkins.scm.api.trait.SCMSourceRequest;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMTrait;
import jenkins.scm.api.trait.SCMTraitDescriptor;
import jenkins.scm.impl.ChangeRequestSCMHeadCategory;
import jenkins.scm.impl.TagSCMHeadCategory;
import jenkins.scm.impl.UncategorizedSCMHeadCategory;
import jenkins.scm.impl.form.NamedArrayList;
import jenkins.scm.impl.trait.Discovery;
import jenkins.scm.impl.trait.Selection;
import jenkins.scm.impl.trait.WildcardSCMHeadFilterTrait;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.github_branch_source.BranchDiscoveryTrait;
import org.jenkinsci.plugins.github_branch_source.BranchSCMHead;
import org.jenkinsci.plugins.github_branch_source.Connector;
import org.jenkinsci.plugins.github_branch_source.Endpoint;
import org.jenkinsci.plugins.github_branch_source.FillErrorResponse;
import org.jenkinsci.plugins.github_branch_source.ForkPullRequestDiscoveryTrait;
import org.jenkinsci.plugins.github_branch_source.GitHubConfiguration;
import org.jenkinsci.plugins.github_branch_source.GitHubDefaultBranch;
import org.jenkinsci.plugins.github_branch_source.GitHubLink;
import org.jenkinsci.plugins.github_branch_source.GitHubPermissionsSource;
import org.jenkinsci.plugins.github_branch_source.GitHubRepoMetadataAction;
import org.jenkinsci.plugins.github_branch_source.GitHubRepositoryInfo;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMBuilder;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMProbe;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSourceContext;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSourceRequest;
import org.jenkinsci.plugins.github_branch_source.GitHubTagSCMHead;
import org.jenkinsci.plugins.github_branch_source.LazyIterable;
import org.jenkinsci.plugins.github_branch_source.LazySet;
import org.jenkinsci.plugins.github_branch_source.Messages;
import org.jenkinsci.plugins.github_branch_source.OriginPullRequestDiscoveryTrait;
import org.jenkinsci.plugins.github_branch_source.PullRequestSCMHead;
import org.jenkinsci.plugins.github_branch_source.PullRequestSCMRevision;
import org.jenkinsci.plugins.github_branch_source.PullRequestSource;
import org.jenkinsci.plugins.github_branch_source.RateLimitExceededException;
import org.jenkinsci.plugins.github_branch_source.RepositoryUriResolver;
import org.jenkinsci.plugins.github_branch_source.SSHCheckoutTrait;
import org.jenkinsci.plugins.github_branch_source.SinglePassIterable;
import org.jenkinsci.plugins.structs.describable.CustomDescribableModel;
import org.jenkinsci.plugins.structs.describable.UninstantiatedDescribable;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.github.GHBranch;
import org.kohsuke.github.GHCommit;
import org.kohsuke.github.GHException;
import org.kohsuke.github.GHFileNotFoundException;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHMyself;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHPermissionType;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHRef;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHTagObject;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.HttpException;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.PagedIterator;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class GitHubSCMSource
extends AbstractGitSCMSource {
    public static final String VALID_GITHUB_REPO_NAME = "^[0-9A-Za-z._-]+$";
    public static final String VALID_GITHUB_USER_NAME = "^[A-Za-z0-9](?:[A-Za-z0-9]|-(?=[A-Za-z0-9])){0,38}$";
    public static final String VALID_GIT_SHA1 = "^[a-fA-F0-9]{40}$";
    public static final String GITHUB_URL = "https://api.github.com";
    public static final String GITHUB_COM = "github.com";
    private static final Logger LOGGER = Logger.getLogger(GitHubSCMSource.class.getName());
    private static final String R_PULL = "refs/pull/";
    private static int eventDelaySeconds = Math.min(300, Math.max(0, Integer.getInteger(GitHubSCMSource.class.getName() + ".eventDelaySeconds", 5)));
    private static int cacheSize = Math.min(1024, Math.max(0, Integer.getInteger(GitHubSCMSource.class.getName() + ".cacheSize", Functions.isWindows() ? 0 : 20)));
    private static final Object pullRequestSourceMapLock = new Object();
    @NonNull
    private String apiUri;
    @CheckForNull
    private String credentialsId;
    @NonNull
    private final String repoOwner;
    @NonNull
    private final String repository;
    @CheckForNull
    private final String repositoryUrl;
    @NonNull
    private List<SCMSourceTrait> traits;
    @Deprecated
    private transient String scanCredentialsId;
    @Deprecated
    private transient String checkoutCredentialsId;
    @Deprecated
    private String includes;
    @Deprecated
    private String excludes;
    @Deprecated
    private transient Boolean buildOriginBranch;
    @Deprecated
    private transient Boolean buildOriginBranchWithPR;
    @Deprecated
    private transient Boolean buildOriginPRMerge;
    @Deprecated
    private transient Boolean buildOriginPRHead;
    @Deprecated
    private transient Boolean buildForkPRMerge;
    @Deprecated
    private transient Boolean buildForkPRHead;
    @CheckForNull
    private transient URL resolvedRepositoryUrl;
    @CheckForNull
    private transient Set<String> collaboratorNames;
    @CheckForNull
    private transient GHRepository ghRepository;
    @NonNull
    private transient Map<Integer, ObjectMetadataAction> pullRequestMetadataCache;
    @NonNull
    private transient Map<Integer, ContributorMetadataAction> pullRequestContributorCache;
    @CheckForNull
    private transient Map<Integer, PullRequestSource> pullRequestSourceMap;

    @DataBoundConstructor
    public GitHubSCMSource(String repoOwner, String repository, String repositoryUrl, boolean configuredByUrl) {
        if (!configuredByUrl) {
            this.apiUri = GITHUB_URL;
            this.repoOwner = repoOwner;
            this.repository = repository;
            this.repositoryUrl = null;
        } else {
            GitHubRepositoryInfo info = GitHubRepositoryInfo.forRepositoryUrl(repositoryUrl);
            this.apiUri = info.getApiUri();
            this.repoOwner = info.getRepoOwner();
            this.repository = info.getRepository();
            this.repositoryUrl = info.getRepositoryUrl();
        }
        this.pullRequestMetadataCache = new ConcurrentHashMap<Integer, ObjectMetadataAction>();
        this.pullRequestContributorCache = new ConcurrentHashMap<Integer, ContributorMetadataAction>();
        this.traits = new ArrayList<SCMSourceTrait>();
    }

    @Deprecated
    public GitHubSCMSource(String repoOwner, String repository) {
        this(repoOwner, repository, null, false);
    }

    @Deprecated
    public GitHubSCMSource(@CheckForNull String id, @CheckForNull String apiUri, @NonNull String checkoutCredentialsId, @CheckForNull String scanCredentialsId, @NonNull String repoOwner, @NonNull String repository) {
        this(repoOwner, repository, null, false);
        this.setId(id);
        this.setApiUri(apiUri);
        this.setCredentialsId(scanCredentialsId);
        this.traits = new ArrayList<SCMSourceTrait>();
        this.traits.add(new BranchDiscoveryTrait(true, true));
        this.traits.add(new ForkPullRequestDiscoveryTrait(EnumSet.of(ChangeRequestCheckoutStrategy.MERGE), (SCMHeadAuthority<? super GitHubSCMSourceRequest, ? extends ChangeRequestSCMHead2, ? extends SCMRevision>)new ForkPullRequestDiscoveryTrait.TrustPermission()));
        if (!"SAME".equals(checkoutCredentialsId)) {
            this.traits.add(new SSHCheckoutTrait(checkoutCredentialsId));
        }
    }

    @Restricted(value={NoExternalUse.class})
    public boolean isConfiguredByUrl() {
        return this.repositoryUrl != null;
    }

    @NonNull
    public String getApiUri() {
        return this.apiUri;
    }

    @DataBoundSetter
    public void setApiUri(@CheckForNull String apiUri) {
        if (this.repositoryUrl != null) {
            return;
        }
        if ((apiUri = GitHubConfiguration.normalizeApiUri(Util.fixEmptyAndTrim((String)apiUri))) == null) {
            apiUri = GITHUB_URL;
        }
        this.apiUri = apiUri;
    }

    @CheckForNull
    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(@CheckForNull String credentialsId) {
        this.credentialsId = Util.fixEmpty((String)credentialsId);
    }

    @Exported
    @NonNull
    public String getRepoOwner() {
        return this.repoOwner;
    }

    @Exported
    @NonNull
    public String getRepository() {
        return this.repository;
    }

    @Restricted(value={NoExternalUse.class})
    @NonNull
    public String getRepositoryUrl() {
        if (this.repositoryUrl != null) {
            return this.repositoryUrl;
        }
        if (GITHUB_URL.equals(this.apiUri)) {
            return "https://github.com/" + this.repoOwner + '/' + this.repository;
        }
        return String.format("%s%s/%s", StringUtils.removeEnd((String)this.apiUri, (String)"api/v3"), this.repoOwner, this.repository);
    }

    public List<SCMSourceTrait> getTraits() {
        return this.traits;
    }

    @DataBoundSetter
    public void setTraits(@CheckForNull List<SCMSourceTrait> traits) {
        this.traits = new ArrayList<SCMSourceTrait>(Util.fixNull(traits));
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="Only non-null after we set them here!")
    private Object readResolve() {
        if (this.scanCredentialsId != null) {
            this.credentialsId = this.scanCredentialsId;
        }
        if (this.pullRequestMetadataCache == null) {
            this.pullRequestMetadataCache = new ConcurrentHashMap<Integer, ObjectMetadataAction>();
        }
        if (this.pullRequestContributorCache == null) {
            this.pullRequestContributorCache = new ConcurrentHashMap<Integer, ContributorMetadataAction>();
        }
        if (this.traits == null) {
            EnumSet<ChangeRequestCheckoutStrategy> s;
            boolean buildOriginBranch = this.buildOriginBranch == null || this.buildOriginBranch != false;
            boolean buildOriginBranchWithPR = this.buildOriginBranchWithPR == null || this.buildOriginBranchWithPR != false;
            boolean buildOriginPRMerge = this.buildOriginPRMerge != null && this.buildOriginPRMerge != false;
            boolean buildOriginPRHead = this.buildOriginPRHead != null && this.buildOriginPRHead != false;
            boolean buildForkPRMerge = this.buildForkPRMerge == null || this.buildForkPRMerge != false;
            boolean buildForkPRHead = this.buildForkPRHead != null && this.buildForkPRHead != false;
            ArrayList<SCMSourceTrait> traits = new ArrayList<SCMSourceTrait>();
            if (buildOriginBranch || buildOriginBranchWithPR) {
                traits.add(new BranchDiscoveryTrait(buildOriginBranch, buildOriginBranchWithPR));
            }
            if (buildOriginPRMerge || buildOriginPRHead) {
                s = EnumSet.noneOf(ChangeRequestCheckoutStrategy.class);
                if (buildOriginPRMerge) {
                    s.add(ChangeRequestCheckoutStrategy.MERGE);
                }
                if (buildOriginPRHead) {
                    s.add(ChangeRequestCheckoutStrategy.HEAD);
                }
                traits.add(new OriginPullRequestDiscoveryTrait(s));
            }
            if (buildForkPRMerge || buildForkPRHead) {
                s = EnumSet.noneOf(ChangeRequestCheckoutStrategy.class);
                if (buildForkPRMerge) {
                    s.add(ChangeRequestCheckoutStrategy.MERGE);
                }
                if (buildForkPRHead) {
                    s.add(ChangeRequestCheckoutStrategy.HEAD);
                }
                traits.add(new ForkPullRequestDiscoveryTrait(s, (SCMHeadAuthority<? super GitHubSCMSourceRequest, ? extends ChangeRequestSCMHead2, ? extends SCMRevision>)new ForkPullRequestDiscoveryTrait.TrustPermission()));
            }
            if (!"*".equals(this.includes) || !"".equals(this.excludes)) {
                traits.add((SCMSourceTrait)new WildcardSCMHeadFilterTrait(this.includes, this.excludes));
            }
            if (this.checkoutCredentialsId != null && !"SAME".equals(this.checkoutCredentialsId) && !this.checkoutCredentialsId.equals(this.scanCredentialsId)) {
                traits.add(new SSHCheckoutTrait(this.checkoutCredentialsId));
            }
            this.traits = traits;
        }
        if (StringUtils.isBlank((String)this.apiUri)) {
            this.setApiUri(GITHUB_URL);
        } else if (!StringUtils.equals((String)this.apiUri, (String)GitHubConfiguration.normalizeApiUri(this.apiUri))) {
            this.setApiUri(this.apiUri);
        }
        return this;
    }

    public static int getEventDelaySeconds() {
        return eventDelaySeconds;
    }

    @Restricted(value={NoExternalUse.class})
    public static void setEventDelaySeconds(int eventDelaySeconds) {
        GitHubSCMSource.eventDelaySeconds = Math.min(300, Math.max(0, eventDelaySeconds));
    }

    public static int getCacheSize() {
        return cacheSize;
    }

    @Restricted(value={NoExternalUse.class})
    public static void setCacheSize(int cacheSize) {
        GitHubSCMSource.cacheSize = Math.min(1024, Math.max(0, cacheSize));
    }

    public String getRemote() {
        return GitHubSCMBuilder.uriResolver((Item)this.getOwner(), this.apiUri, this.credentialsId).getRepositoryUri(this.apiUri, this.repoOwner, this.repository);
    }

    public String getPronoun() {
        return Messages.GitHubSCMSource_Pronoun();
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @RestrictedSince(value="2.2.0")
    public RepositoryUriResolver getUriResolver() {
        return GitHubSCMBuilder.uriResolver((Item)this.getOwner(), this.apiUri, this.credentialsId);
    }

    @Restricted(value={NoExternalUse.class})
    @Deprecated
    @RestrictedSince(value="2.2.0")
    @CheckForNull
    public String getScanCredentialsId() {
        return this.credentialsId;
    }

    @Restricted(value={DoNotUse.class})
    @Deprecated
    @RestrictedSince(value="2.2.0")
    public void setScanCredentialsId(@CheckForNull String credentialsId) {
        this.credentialsId = credentialsId;
    }

    @Restricted(value={DoNotUse.class})
    @Deprecated
    @RestrictedSince(value="2.2.0")
    @CheckForNull
    public String getCheckoutCredentialsId() {
        for (SCMSourceTrait trait : this.traits) {
            if (!(trait instanceof SSHCheckoutTrait)) continue;
            return StringUtils.defaultString((String)((SSHCheckoutTrait)trait).getCredentialsId(), (String)"ANONYMOUS");
        }
        return "SAME";
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @DataBoundSetter
    @RestrictedSince(value="2.2.0")
    public void setIncludes(@NonNull String includes) {
        for (int i = 0; i < this.traits.size(); ++i) {
            SCMSourceTrait trait = this.traits.get(i);
            if (!(trait instanceof WildcardSCMHeadFilterTrait)) continue;
            WildcardSCMHeadFilterTrait existing = (WildcardSCMHeadFilterTrait)trait;
            if ("*".equals(includes) && "".equals(existing.getExcludes())) {
                this.traits.remove(i);
            } else {
                this.traits.set(i, (SCMSourceTrait)new WildcardSCMHeadFilterTrait(includes, existing.getExcludes()));
            }
            return;
        }
        if (!"*".equals(includes)) {
            this.traits.add((SCMSourceTrait)new WildcardSCMHeadFilterTrait(includes, ""));
        }
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @DataBoundSetter
    @RestrictedSince(value="2.2.0")
    public void setExcludes(@NonNull String excludes) {
        for (int i = 0; i < this.traits.size(); ++i) {
            SCMSourceTrait trait = this.traits.get(i);
            if (!(trait instanceof WildcardSCMHeadFilterTrait)) continue;
            WildcardSCMHeadFilterTrait existing = (WildcardSCMHeadFilterTrait)trait;
            if ("*".equals(existing.getIncludes()) && "".equals(excludes)) {
                this.traits.remove(i);
            } else {
                this.traits.set(i, (SCMSourceTrait)new WildcardSCMHeadFilterTrait(existing.getIncludes(), excludes));
            }
            return;
        }
        if (!"".equals(excludes)) {
            this.traits.add((SCMSourceTrait)new WildcardSCMHeadFilterTrait("*", excludes));
        }
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @RestrictedSince(value="2.2.0")
    public boolean getBuildOriginBranch() {
        for (SCMTrait sCMTrait : this.traits) {
            if (!(sCMTrait instanceof BranchDiscoveryTrait)) continue;
            return ((BranchDiscoveryTrait)sCMTrait).isBuildBranch();
        }
        return false;
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @DataBoundSetter
    @RestrictedSince(value="2.2.0")
    public void setBuildOriginBranch(boolean buildOriginBranch) {
        for (int i = 0; i < this.traits.size(); ++i) {
            SCMTrait trait = (SCMTrait)this.traits.get(i);
            if (!(trait instanceof BranchDiscoveryTrait)) continue;
            BranchDiscoveryTrait previous = (BranchDiscoveryTrait)trait;
            if (buildOriginBranch || previous.isBuildBranchesWithPR()) {
                this.traits.set(i, new BranchDiscoveryTrait(buildOriginBranch, previous.isBuildBranchesWithPR()));
            } else {
                this.traits.remove(i);
            }
            return;
        }
        if (buildOriginBranch) {
            this.traits.add(new BranchDiscoveryTrait(buildOriginBranch, false));
        }
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @RestrictedSince(value="2.2.0")
    public boolean getBuildOriginBranchWithPR() {
        for (SCMTrait sCMTrait : this.traits) {
            if (!(sCMTrait instanceof BranchDiscoveryTrait)) continue;
            return ((BranchDiscoveryTrait)sCMTrait).isBuildBranchesWithPR();
        }
        return false;
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @DataBoundSetter
    @RestrictedSince(value="2.2.0")
    public void setBuildOriginBranchWithPR(boolean buildOriginBranchWithPR) {
        for (int i = 0; i < this.traits.size(); ++i) {
            SCMTrait trait = (SCMTrait)this.traits.get(i);
            if (!(trait instanceof BranchDiscoveryTrait)) continue;
            BranchDiscoveryTrait previous = (BranchDiscoveryTrait)trait;
            if (buildOriginBranchWithPR || previous.isBuildBranch()) {
                this.traits.set(i, new BranchDiscoveryTrait(previous.isBuildBranch(), buildOriginBranchWithPR));
            } else {
                this.traits.remove(i);
            }
            return;
        }
        if (buildOriginBranchWithPR) {
            this.traits.add(new BranchDiscoveryTrait(false, buildOriginBranchWithPR));
        }
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @RestrictedSince(value="2.2.0")
    public boolean getBuildOriginPRMerge() {
        for (SCMTrait sCMTrait : this.traits) {
            if (!(sCMTrait instanceof OriginPullRequestDiscoveryTrait)) continue;
            return ((OriginPullRequestDiscoveryTrait)sCMTrait).getStrategies().contains(ChangeRequestCheckoutStrategy.MERGE);
        }
        return false;
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @DataBoundSetter
    @RestrictedSince(value="2.2.0")
    public void setBuildOriginPRMerge(boolean buildOriginPRMerge) {
        for (int i = 0; i < this.traits.size(); ++i) {
            SCMTrait trait = (SCMTrait)this.traits.get(i);
            if (!(trait instanceof OriginPullRequestDiscoveryTrait)) continue;
            Set<ChangeRequestCheckoutStrategy> s = ((OriginPullRequestDiscoveryTrait)trait).getStrategies();
            if (buildOriginPRMerge) {
                s.add(ChangeRequestCheckoutStrategy.MERGE);
            } else {
                s.remove(ChangeRequestCheckoutStrategy.MERGE);
            }
            this.traits.set(i, new OriginPullRequestDiscoveryTrait(s));
            return;
        }
        if (buildOriginPRMerge) {
            this.traits.add(new OriginPullRequestDiscoveryTrait(EnumSet.of(ChangeRequestCheckoutStrategy.MERGE)));
        }
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @RestrictedSince(value="2.2.0")
    public boolean getBuildOriginPRHead() {
        for (SCMTrait sCMTrait : this.traits) {
            if (!(sCMTrait instanceof OriginPullRequestDiscoveryTrait)) continue;
            return ((OriginPullRequestDiscoveryTrait)sCMTrait).getStrategies().contains(ChangeRequestCheckoutStrategy.HEAD);
        }
        return false;
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @DataBoundSetter
    @RestrictedSince(value="2.2.0")
    public void setBuildOriginPRHead(boolean buildOriginPRHead) {
        for (int i = 0; i < this.traits.size(); ++i) {
            SCMTrait trait = (SCMTrait)this.traits.get(i);
            if (!(trait instanceof OriginPullRequestDiscoveryTrait)) continue;
            Set<ChangeRequestCheckoutStrategy> s = ((OriginPullRequestDiscoveryTrait)trait).getStrategies();
            if (buildOriginPRHead) {
                s.add(ChangeRequestCheckoutStrategy.HEAD);
            } else {
                s.remove(ChangeRequestCheckoutStrategy.HEAD);
            }
            this.traits.set(i, new OriginPullRequestDiscoveryTrait(s));
            return;
        }
        if (buildOriginPRHead) {
            this.traits.add(new OriginPullRequestDiscoveryTrait(EnumSet.of(ChangeRequestCheckoutStrategy.HEAD)));
        }
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @RestrictedSince(value="2.2.0")
    public boolean getBuildForkPRMerge() {
        for (SCMTrait sCMTrait : this.traits) {
            if (!(sCMTrait instanceof ForkPullRequestDiscoveryTrait)) continue;
            return ((ForkPullRequestDiscoveryTrait)sCMTrait).getStrategies().contains(ChangeRequestCheckoutStrategy.MERGE);
        }
        return false;
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @DataBoundSetter
    @RestrictedSince(value="2.2.0")
    public void setBuildForkPRMerge(boolean buildForkPRMerge) {
        for (int i = 0; i < this.traits.size(); ++i) {
            SCMTrait trait = (SCMTrait)this.traits.get(i);
            if (!(trait instanceof ForkPullRequestDiscoveryTrait)) continue;
            ForkPullRequestDiscoveryTrait forkTrait = (ForkPullRequestDiscoveryTrait)trait;
            Set<ChangeRequestCheckoutStrategy> s = forkTrait.getStrategies();
            if (buildForkPRMerge) {
                s.add(ChangeRequestCheckoutStrategy.MERGE);
            } else {
                s.remove(ChangeRequestCheckoutStrategy.MERGE);
            }
            this.traits.set(i, new ForkPullRequestDiscoveryTrait(s, forkTrait.getTrust()));
            return;
        }
        if (buildForkPRMerge) {
            this.traits.add(new ForkPullRequestDiscoveryTrait(EnumSet.of(ChangeRequestCheckoutStrategy.MERGE), (SCMHeadAuthority<? super GitHubSCMSourceRequest, ? extends ChangeRequestSCMHead2, ? extends SCMRevision>)new ForkPullRequestDiscoveryTrait.TrustPermission()));
        }
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @RestrictedSince(value="2.2.0")
    public boolean getBuildForkPRHead() {
        for (SCMTrait sCMTrait : this.traits) {
            if (!(sCMTrait instanceof ForkPullRequestDiscoveryTrait)) continue;
            return ((ForkPullRequestDiscoveryTrait)sCMTrait).getStrategies().contains(ChangeRequestCheckoutStrategy.HEAD);
        }
        return false;
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @DataBoundSetter
    @RestrictedSince(value="2.2.0")
    public void setBuildForkPRHead(boolean buildForkPRHead) {
        for (int i = 0; i < this.traits.size(); ++i) {
            SCMTrait trait = (SCMTrait)this.traits.get(i);
            if (!(trait instanceof ForkPullRequestDiscoveryTrait)) continue;
            ForkPullRequestDiscoveryTrait forkTrait = (ForkPullRequestDiscoveryTrait)trait;
            Set<ChangeRequestCheckoutStrategy> s = forkTrait.getStrategies();
            if (buildForkPRHead) {
                s.add(ChangeRequestCheckoutStrategy.HEAD);
            } else {
                s.remove(ChangeRequestCheckoutStrategy.HEAD);
            }
            this.traits.set(i, new ForkPullRequestDiscoveryTrait(s, forkTrait.getTrust()));
            return;
        }
        if (buildForkPRHead) {
            this.traits.add(new ForkPullRequestDiscoveryTrait(EnumSet.of(ChangeRequestCheckoutStrategy.HEAD), (SCMHeadAuthority<? super GitHubSCMSourceRequest, ? extends ChangeRequestSCMHead2, ? extends SCMRevision>)new ForkPullRequestDiscoveryTrait.TrustPermission()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void retrieve(@CheckForNull SCMSourceCriteria criteria, @NonNull SCMHeadObserver observer, @CheckForNull SCMHeadEvent<?> event, @NonNull TaskListener listener) throws IOException, InterruptedException {
        StandardCredentials credentials = Connector.lookupScanCredentials((Item)this.getOwner(), this.apiUri, this.credentialsId);
        final GitHub github = Connector.connect(this.apiUri, credentials);
        try {
            this.checkApiUrlValidity(github, credentials);
            Connector.checkApiRateLimit(listener, github);
            try {
                String fullName;
                block39: {
                    Connector.checkConnectionValidity(this.apiUri, listener, credentials, github);
                    if (StringUtils.isBlank((String)this.repository)) {
                        throw new AbortException("No repository selected, skipping");
                    }
                    fullName = this.repoOwner + "/" + this.repository;
                    final GHRepository ghRepository = this.ghRepository = github.getRepository(fullName);
                    listener.getLogger().format("Examining %s%n", HyperlinkNote.encodeTo((String)ghRepository.getHtmlUrl().toString(), (String)fullName));
                    this.resolvedRepositoryUrl = ghRepository.getHtmlUrl();
                    try (GitHubSCMSourceRequest request = ((GitHubSCMSourceContext)new GitHubSCMSourceContext(criteria, observer).withTraits(this.traits)).newRequest((SCMSource)this, listener);){
                        int count;
                        request.setGitHub(github);
                        request.setRepository(ghRepository);
                        if (request.isFetchPRs()) {
                            request.setPullRequests(new LazyPullRequests(request, ghRepository));
                        }
                        if (request.isFetchBranches()) {
                            request.setBranches(new LazyBranches(request, ghRepository));
                        }
                        if (request.isFetchTags()) {
                            request.setTags(new LazyTags(request, ghRepository));
                        }
                        request.setCollaboratorNames(new LazyContributorNames(request, listener, github, ghRepository, credentials));
                        request.setPermissionsSource(new GitHubPermissionsSource(){

                            @Override
                            public GHPermissionType fetch(String username) throws IOException, InterruptedException {
                                return ghRepository.getPermission(username);
                            }
                        });
                        if (request.isFetchBranches() && !request.isComplete()) {
                            listener.getLogger().format("%n  Checking branches...%n", new Object[0]);
                            count = 0;
                            for (GHBranch branch : request.getBranches()) {
                                ++count;
                                String branchName = branch.getName();
                                listener.getLogger().format("%n    Checking branch %s%n", HyperlinkNote.encodeTo((String)(this.resolvedRepositoryUrl + "/tree/" + (String)branchName), (String)branchName));
                                BranchSCMHead head = new BranchSCMHead(branchName);
                                if (request.process(head, (SCMRevision)new AbstractGitSCMSource.SCMRevisionImpl((SCMHead)head, branch.getSHA1()), (SCMSourceRequest.ProbeLambda)new SCMSourceRequest.ProbeLambda<BranchSCMHead, AbstractGitSCMSource.SCMRevisionImpl>(){

                                    @NonNull
                                    public SCMSourceCriteria.Probe create(@NonNull BranchSCMHead head, @Nullable AbstractGitSCMSource.SCMRevisionImpl revisionInfo) throws IOException, InterruptedException {
                                        return new GitHubSCMProbe(github, ghRepository, head, (SCMRevision)revisionInfo);
                                    }
                                }, new SCMSourceRequest.Witness[]{new CriteriaWitness(listener)})) {
                                    listener.getLogger().format("%n  %d branches were processed (query completed)%n", count);
                                    break;
                                }
                                request.checkApiRateLimit();
                            }
                            listener.getLogger().format("%n  %d branches were processed%n", count);
                        }
                        if (request.isFetchPRs() && !request.isComplete()) {
                            listener.getLogger().format("%n  Checking pull-requests...%n", new Object[0]);
                            count = 0;
                            int errorCount = 0;
                            Map<Boolean, Set<ChangeRequestCheckoutStrategy>> strategies = request.getPRStrategies();
                            GitHubSCMSource.validatePullRequests(request);
                            for (GHPullRequest pr : request.getPullRequests()) {
                                int number = pr.getNumber();
                                try {
                                    GitHubSCMSource.retrievePullRequest(github, ghRepository, pr, strategies, request, listener);
                                }
                                catch (FileNotFoundException e) {
                                    listener.getLogger().format("%n  Error while processing pull request %d%n", number);
                                    listener.getLogger().format("%n  Reason: %s%n", e);
                                    ++errorCount;
                                }
                                ++count;
                            }
                            listener.getLogger().format("%n  %d pull requests were processed%n", count);
                            if (errorCount > 0) {
                                listener.getLogger().format("%n  %d pull requests encountered errors and were orphaned.%n", count);
                            }
                        }
                        if (!request.isFetchTags() || request.isComplete()) break block39;
                        listener.getLogger().format("%n  Checking tags...%n", new Object[0]);
                        count = 0;
                        for (GHRef tag : request.getTags()) {
                            String tagName = tag.getRef();
                            if (!tagName.startsWith("refs/tags/")) continue;
                            tagName = tagName.substring("refs/tags/".length());
                            ++count;
                            listener.getLogger().format("%n    Checking tag %s%n", HyperlinkNote.encodeTo((String)(this.resolvedRepositoryUrl + "/tree/" + tagName), (String)tagName));
                            long tagDate = 0L;
                            String sha = tag.getObject().getSha();
                            if ("tag".equalsIgnoreCase(tag.getObject().getType())) {
                                try {
                                    GHTagObject tagObject = request.getRepository().getTagObject(sha);
                                    tagDate = tagObject.getTagger().getDate().getTime();
                                    sha = tagObject.getObject().getSha();
                                }
                                catch (IOException tagObject) {}
                            } else {
                                try {
                                    GHCommit commit = request.getRepository().getCommit(sha);
                                    tagDate = commit.getCommitDate().getTime();
                                }
                                catch (IOException commit) {
                                    // empty catch block
                                }
                            }
                            GitHubTagSCMHead head = new GitHubTagSCMHead(tagName, tagDate);
                            if (request.process((SCMHead)head, (SCMRevision)new GitTagSCMRevision((GitTagSCMHead)head, sha), (SCMSourceRequest.ProbeLambda)new SCMSourceRequest.ProbeLambda<GitHubTagSCMHead, GitTagSCMRevision>(){

                                @NonNull
                                public SCMSourceCriteria.Probe create(@NonNull GitHubTagSCMHead head, @Nullable GitTagSCMRevision revisionInfo) throws IOException, InterruptedException {
                                    return new GitHubSCMProbe(github, ghRepository, (SCMHead)head, (SCMRevision)revisionInfo);
                                }
                            }, new SCMSourceRequest.Witness[]{new CriteriaWitness(listener)})) {
                                listener.getLogger().format("%n  %d tags were processed (query completed)%n", count);
                                break;
                            }
                            request.checkApiRateLimit();
                        }
                        listener.getLogger().format("%n  %d tags were processed%n", count);
                    }
                }
                listener.getLogger().format("%nFinished examining %s%n%n", fullName);
            }
            catch (WrappedException e) {
                try {
                    e.unwrap();
                }
                catch (RateLimitExceededException rle) {
                    throw new AbortException(rle.getMessage());
                }
            }
        }
        finally {
            Connector.release(github);
        }
    }

    private static void validatePullRequests(GitHubSCMSourceRequest request) {
        Iterator<GHPullRequest> iterator = request.getPullRequests().iterator();
        while (iterator.hasNext()) {
            try {
                try {
                    iterator.next();
                }
                catch (NoSuchElementException e) {
                    break;
                }
                catch (WrappedException wrapped) {
                    wrapped.unwrap();
                }
            }
            catch (FileNotFoundException wrapped) {
            }
            catch (IOException | InterruptedException e) {
                throw new WrappedException(e);
            }
        }
    }

    private static void retrievePullRequest(final @NonNull GitHub github, final @NonNull GHRepository ghRepository, final @NonNull GHPullRequest pr, @NonNull Map<Boolean, Set<ChangeRequestCheckoutStrategy>> strategies, final @NonNull GitHubSCMSourceRequest request, final @NonNull TaskListener listener) throws IOException, InterruptedException {
        boolean fork;
        int number = pr.getNumber();
        listener.getLogger().format("%n    Checking pull request %s%n", HyperlinkNote.encodeTo((String)pr.getHtmlUrl().toString(), (String)("#" + number)));
        boolean bl = fork = !ghRepository.getOwner().equals((Object)pr.getHead().getUser());
        if (strategies.get(fork).isEmpty()) {
            if (fork) {
                listener.getLogger().format("    Submitted from fork, skipping%n%n", new Object[0]);
            } else {
                listener.getLogger().format("    Submitted from origin repository, skipping%n%n", new Object[0]);
            }
            return;
        }
        for (ChangeRequestCheckoutStrategy strategy : strategies.get(fork)) {
            String branchName = strategies.get(fork).size() == 1 ? "PR-" + number : "PR-" + number + "-" + strategy.name().toLowerCase(Locale.ENGLISH);
            if (strategy == ChangeRequestCheckoutStrategy.MERGE) {
                GitHubSCMSource.ensureDetailedGHPullRequest(pr, listener, github, ghRepository);
            }
            if (request.process(new PullRequestSCMHead(pr, branchName, strategy == ChangeRequestCheckoutStrategy.MERGE), null, (SCMSourceRequest.ProbeLambda)new SCMSourceRequest.ProbeLambda<PullRequestSCMHead, Void>(){

                @NonNull
                public SCMSourceCriteria.Probe create(@NonNull PullRequestSCMHead head, @Nullable Void revisionInfo) throws IOException, InterruptedException {
                    boolean trusted = request.isTrusted(head);
                    if (!trusted) {
                        listener.getLogger().format("    (not from a trusted source)%n", new Object[0]);
                    }
                    return new GitHubSCMProbe(github, ghRepository, trusted ? head : head.getTarget(), null);
                }
            }, (SCMSourceRequest.LazyRevisionLambda)new SCMSourceRequest.LazyRevisionLambda<PullRequestSCMHead, SCMRevision, Void>(){

                @NonNull
                public SCMRevision create(@NonNull PullRequestSCMHead head, @Nullable Void ignored) throws IOException, InterruptedException {
                    return GitHubSCMSource.createPullRequestSCMRevision(pr, head, listener, github, ghRepository);
                }
            }, new SCMSourceRequest.Witness[]{new MergabilityWitness(pr, strategy, listener), new CriteriaWitness(listener)})) {
                listener.getLogger().format("%n  Pull request %d processed (query completed)%n", number);
                continue;
            }
            request.checkApiRateLimit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    protected Set<String> retrieveRevisions(@NonNull TaskListener listener, Item retrieveContext) throws IOException, InterruptedException {
        StandardCredentials credentials = Connector.lookupScanCredentials(retrieveContext, this.apiUri, this.credentialsId);
        GitHub github = Connector.connect(this.apiUri, credentials);
        try {
            this.checkApiUrlValidity(github, credentials);
            Connector.checkApiRateLimit(listener, github);
            TreeSet<String> result = new TreeSet<String>();
            try {
                Connector.checkConnectionValidity(this.apiUri, listener, credentials, github);
                if (StringUtils.isBlank((String)this.repository)) {
                    throw new AbortException("No repository selected, skipping");
                }
                String fullName = this.repoOwner + "/" + this.repository;
                GHRepository ghRepository = this.ghRepository = github.getRepository(fullName);
                listener.getLogger().format("Listing %s%n", HyperlinkNote.encodeTo((String)ghRepository.getHtmlUrl().toString(), (String)fullName));
                this.resolvedRepositoryUrl = ghRepository.getHtmlUrl();
                GitHubSCMSourceContext context = (GitHubSCMSourceContext)new GitHubSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(this.traits);
                boolean wantBranches = context.wantBranches();
                boolean wantTags = context.wantTags();
                boolean wantPRs = context.wantPRs();
                boolean wantSinglePRs = context.forkPRStrategies().size() == 1 || context.originPRStrategies().size() == 1;
                boolean wantMultiPRs = context.forkPRStrategies().size() > 1 || context.originPRStrategies().size() > 1;
                TreeSet<ChangeRequestCheckoutStrategy> strategies = new TreeSet<ChangeRequestCheckoutStrategy>();
                strategies.addAll(context.forkPRStrategies());
                strategies.addAll(context.originPRStrategies());
                for (GHRef ref : ghRepository.listRefs()) {
                    String name = ref.getRef();
                    if (name.startsWith("refs/heads/") && wantBranches) {
                        String branchName = name.substring("refs/heads/".length());
                        listener.getLogger().format("%n  Found branch %s%n", HyperlinkNote.encodeTo((String)(this.resolvedRepositoryUrl + "/tree/" + branchName), (String)branchName));
                        result.add(branchName);
                        continue;
                    }
                    if (name.startsWith(R_PULL) && wantPRs) {
                        int index = name.indexOf(47, R_PULL.length());
                        if (index == -1) continue;
                        String number = name.substring(R_PULL.length(), index);
                        listener.getLogger().format("%n  Found pull request %s%n", HyperlinkNote.encodeTo((String)(this.resolvedRepositoryUrl + "/pull/" + number), (String)("#" + number)));
                        if (wantSinglePRs) {
                            result.add("PR-" + number);
                        }
                        if (!wantMultiPRs) continue;
                        for (ChangeRequestCheckoutStrategy strategy : strategies) {
                            result.add("PR-" + number + "-" + strategy.name().toLowerCase(Locale.ENGLISH));
                        }
                        continue;
                    }
                    if (!name.startsWith("refs/tags/") || !wantTags) continue;
                    String tagName = name.substring("refs/tags/".length());
                    listener.getLogger().format("%n  Found tag %s%n", HyperlinkNote.encodeTo((String)(this.resolvedRepositoryUrl + "/tree/" + tagName), (String)tagName));
                    result.add(tagName);
                }
                listener.getLogger().format("%nFinished listing %s%n%n", fullName);
            }
            catch (WrappedException e) {
                try {
                    e.unwrap();
                }
                catch (RateLimitExceededException rle) {
                    throw new AbortException(rle.getMessage());
                }
            }
            TreeSet<String> treeSet = result;
            return treeSet;
        }
        finally {
            Connector.release(github);
        }
    }

    /*
     * Exception decompiling
     */
    protected SCMRevision retrieve(@NonNull String headName, @NonNull TaskListener listener, Item retrieveContext) throws IOException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 15[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NonNull
    private Set<String> updateCollaboratorNames(@NonNull TaskListener listener, @CheckForNull StandardCredentials credentials, @NonNull GHRepository ghRepository) throws IOException {
        if (credentials == null && (this.apiUri == null || GITHUB_URL.equals(this.apiUri))) {
            listener.getLogger().println("Anonymous cannot query list of collaborators, assuming none");
            this.collaboratorNames = Collections.emptySet();
            return this.collaboratorNames;
        }
        try {
            this.collaboratorNames = new HashSet<String>(ghRepository.getCollaboratorNames());
            return this.collaboratorNames;
        }
        catch (FileNotFoundException e) {
            listener.getLogger().println("Not permitted to query list of collaborators, assuming none");
            this.collaboratorNames = Collections.emptySet();
            return this.collaboratorNames;
        }
        catch (HttpException e) {
            if (e.getResponseCode() == 401 || e.getResponseCode() == 404) {
                listener.getLogger().println("Not permitted to query list of collaborators, assuming none");
                this.collaboratorNames = Collections.emptySet();
                return this.collaboratorNames;
            }
            throw e;
        }
    }

    private void checkApiUrlValidity(GitHub github, StandardCredentials credentials) throws IOException {
        try {
            Connector.checkApiUrlValidity(github, credentials);
        }
        catch (HttpException e) {
            String message = String.format("It seems %s is unreachable", this.apiUri);
            throw new IOException(message, e);
        }
    }

    @NonNull
    protected SCMProbe createProbe(@NonNull SCMHead head, @CheckForNull SCMRevision revision) throws IOException {
        StandardCredentials credentials = Connector.lookupScanCredentials((Item)this.getOwner(), this.apiUri, this.credentialsId);
        GitHub github = Connector.connect(this.apiUri, credentials);
        try {
            String fullName = this.repoOwner + "/" + this.repository;
            GHRepository repo = github.getRepository(fullName);
            return new GitHubSCMProbe(github, repo, head, revision);
        }
        catch (IOException | Error | RuntimeException e) {
            Connector.release(github);
            throw e;
        }
    }

    @CheckForNull
    protected SCMRevision retrieve(SCMHead head, TaskListener listener) throws IOException, InterruptedException {
        StandardCredentials credentials = Connector.lookupScanCredentials((Item)this.getOwner(), this.apiUri, this.credentialsId);
        GitHub github = Connector.connect(this.apiUri, credentials);
        try {
            GHRepository ghRepository;
            block11: {
                this.checkApiUrlValidity(github, credentials);
                try {
                    Connector.checkConnectionValidity(this.apiUri, listener, credentials, github);
                    Connector.checkApiRateLimit(listener, github);
                    String fullName = this.repoOwner + "/" + this.repository;
                    ghRepository = this.ghRepository = github.getRepository(fullName);
                    this.resolvedRepositoryUrl = ghRepository.getHtmlUrl();
                    if (!(head instanceof PullRequestSCMHead)) break block11;
                    PullRequestSCMHead prhead = (PullRequestSCMHead)head;
                    Connector.checkApiRateLimit(listener, github);
                    GHPullRequest pr = ghRepository.getPullRequest(prhead.getNumber());
                    if (prhead.isMerge()) {
                        GitHubSCMSource.ensureDetailedGHPullRequest(pr, listener, github, ghRepository);
                    }
                    PullRequestSCMRevision prRev = GitHubSCMSource.createPullRequestSCMRevision(pr, prhead, listener, github, ghRepository);
                    prRev.validateMergeHash();
                    PullRequestSCMRevision pullRequestSCMRevision = prRev;
                    return pullRequestSCMRevision;
                }
                catch (RateLimitExceededException rle) {
                    throw new AbortException(rle.getMessage());
                }
            }
            if (head instanceof GitHubTagSCMHead) {
                GitHubTagSCMHead tagHead = (GitHubTagSCMHead)head;
                GHRef tag = ghRepository.getRef("tags/" + tagHead.getName());
                String sha = tag.getObject().getSha();
                if ("tag".equalsIgnoreCase(tag.getObject().getType())) {
                    GHTagObject tagObject = ghRepository.getTagObject(sha);
                    sha = tagObject.getObject().getSha();
                }
                GitTagSCMRevision gitTagSCMRevision = new GitTagSCMRevision((GitTagSCMHead)tagHead, sha);
                return gitTagSCMRevision;
            }
            AbstractGitSCMSource.SCMRevisionImpl sCMRevisionImpl = new AbstractGitSCMSource.SCMRevisionImpl(head, ghRepository.getRef("heads/" + head.getName()).getObject().getSha());
            return sCMRevisionImpl;
        }
        finally {
            Connector.release(github);
        }
    }

    private static PullRequestSCMRevision createPullRequestSCMRevision(GHPullRequest pr, PullRequestSCMHead prhead, TaskListener listener, GitHub github, GHRepository ghRepository) throws IOException, InterruptedException {
        String baseHash = pr.getBase().getSha();
        String prHeadHash = pr.getHead().getSha();
        String mergeHash = null;
        if (prhead.isMerge()) {
            if (Boolean.FALSE.equals(pr.getMergeable())) {
                mergeHash = "NOT_MERGEABLE";
            } else if (Boolean.TRUE.equals(pr.getMergeable())) {
                String proposedMergeHash = pr.getMergeCommitSha();
                GHCommit commit = null;
                try {
                    commit = ghRepository.getCommit(proposedMergeHash);
                }
                catch (FileNotFoundException e) {
                    listener.getLogger().format("Pull request %s : github merge_commit_sha not found (%s). Close and reopen the PR to reset its merge hash.%n", pr.getNumber(), proposedMergeHash);
                }
                catch (IOException e) {
                    throw new AbortException("Error while retrieving pull request " + pr.getNumber() + " merge hash : " + e.toString());
                }
                if (commit != null) {
                    List parents = commit.getParentSHA1s();
                    if (parents.size() != 2) {
                        listener.getLogger().format("WARNING: Invalid github merge_commit_sha for pull request %s : merge commit %s with parents - %s.%n", pr.getNumber(), proposedMergeHash, StringUtils.join((Collection)parents, (String)"+"));
                    } else if (!parents.contains(prHeadHash)) {
                        listener.getLogger().format("WARNING: Invalid  github merge_commit_sha for pull request %s : Head commit %s does match merge commit %s with parents - %s.%n", pr.getNumber(), prHeadHash, proposedMergeHash, StringUtils.join((Collection)parents, (String)"+"));
                    } else {
                        mergeHash = proposedMergeHash;
                        String string = baseHash = prHeadHash.equals(parents.get(0)) ? (String)parents.get(1) : (String)parents.get(0);
                    }
                }
            }
            if (mergeHash == null) {
                baseHash = ghRepository.getRef("heads/" + pr.getBase().getRef()).getObject().getSha();
            }
        }
        return new PullRequestSCMRevision(prhead, baseHash, prHeadHash, mergeHash);
    }

    private static void ensureDetailedGHPullRequest(GHPullRequest pr, TaskListener listener, GitHub github, GHRepository ghRepository) throws IOException, InterruptedException {
        long sleep = 1000L;
        Connector.checkApiRateLimit(listener, github);
        for (int retryCountdown = 4; pr.getMergeable() == null && retryCountdown > 1; --retryCountdown) {
            listener.getLogger().format("Waiting for GitHub to create a merge commit for pull request %d.  Retrying %d more times...%n", pr.getNumber(), retryCountdown);
            Thread.sleep(1000L);
            Connector.checkApiRateLimit(listener, github);
        }
    }

    public SCM build(SCMHead head, SCMRevision revision) {
        return ((GitHubSCMBuilder)new GitHubSCMBuilder(this, head, revision).withTraits(this.traits)).build();
    }

    @CheckForNull
    URL getResolvedRepositoryUrl() {
        return this.resolvedRepositoryUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    PullRequestSource retrievePullRequestSource(int number) {
        Object object = pullRequestSourceMapLock;
        synchronized (object) {
            Map<Integer, PullRequestSource> pullRequestSourceMap = this.pullRequestSourceMap;
            if (pullRequestSourceMap == null) {
                this.pullRequestSourceMap = pullRequestSourceMap = new HashMap<Integer, PullRequestSource>();
                if (StringUtils.isNotBlank((String)this.repository)) {
                    String fullName = this.repoOwner + "/" + this.repository;
                    LOGGER.log(Level.INFO, "Getting remote pull requests from {0}", fullName);
                    StandardCredentials credentials = Connector.lookupScanCredentials((Item)this.getOwner(), this.apiUri, this.credentialsId);
                    LogTaskListener listener = new LogTaskListener(LOGGER, Level.INFO);
                    try {
                        GitHub github = Connector.connect(this.apiUri, credentials);
                        try {
                            this.checkApiUrlValidity(github, credentials);
                            Connector.checkApiRateLimit((TaskListener)listener, github);
                            this.ghRepository = github.getRepository(fullName);
                            LOGGER.log(Level.INFO, "Got remote pull requests from {0}", fullName);
                            int n = 0;
                            for (GHPullRequest pr : this.ghRepository.queryPullRequests().state(GHIssueState.OPEN).list()) {
                                GHRepository repository = pr.getHead().getRepository();
                                pullRequestSourceMap.put(pr.getNumber(), new PullRequestSource(repository == null ? null : repository.getOwnerName(), repository == null ? null : repository.getName(), pr.getHead().getRef()));
                                if (++n % 30 != 0) continue;
                                Connector.checkApiRateLimit((TaskListener)listener, github);
                            }
                        }
                        finally {
                            Connector.release(github);
                        }
                    }
                    catch (IOException | InterruptedException e) {
                        LOGGER.log(Level.WARNING, "Could not get all pull requests from " + fullName + ", there may be rebuilds", e);
                    }
                }
            }
            return pullRequestSourceMap.get(number);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SCMRevision getTrustedRevision(SCMRevision revision, TaskListener listener) throws IOException, InterruptedException {
        if (!(revision instanceof PullRequestSCMRevision)) return revision;
        PullRequestSCMHead head = (PullRequestSCMHead)revision.getHead();
        try (GitHubSCMSourceRequest request = ((GitHubSCMSourceContext)new GitHubSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(this.traits)).newRequest((SCMSource)this, listener);){
            if (this.collaboratorNames != null) {
                request.setCollaboratorNames(this.collaboratorNames);
            } else {
                request.setCollaboratorNames(new DeferredContributorNames(request, listener));
            }
            request.setPermissionsSource(new DeferredPermissionsSource(listener));
            if (request.isTrusted(head)) {
                SCMRevision sCMRevision = revision;
                return sCMRevision;
            }
        }
        catch (WrappedException wrapped) {
            try {
                wrapped.unwrap();
            }
            catch (HttpException e) {
                listener.getLogger().format("It seems %s is unreachable, assuming no trusted collaborators%n", this.apiUri);
                this.collaboratorNames = Collections.singleton(this.repoOwner);
            }
        }
        PullRequestSCMRevision rev = (PullRequestSCMRevision)revision;
        listener.getLogger().format("Loading trusted files from base branch %s at %s rather than %s%n", head.getTarget().getName(), rev.getBaseHash(), rev.getPullHash());
        return new AbstractGitSCMSource.SCMRevisionImpl((SCMHead)head.getTarget(), rev.getBaseHash());
    }

    protected boolean isCategoryEnabled(@NonNull SCMHeadCategory category) {
        for (SCMSourceTrait trait : this.traits) {
            if (!trait.isCategoryEnabled(category)) continue;
            return true;
        }
        return false;
    }

    @NonNull
    protected List<Action> retrieveActions(@NonNull SCMHead head, @CheckForNull SCMHeadEvent event, @NonNull TaskListener listener) throws IOException, InterruptedException {
        ArrayList<Action> result = new ArrayList<Action>();
        SCMSourceOwner owner = this.getOwner();
        if (owner instanceof Actionable) {
            GitHubLink repoLink = (GitHubLink)((Actionable)owner).getAction(GitHubLink.class);
            if (repoLink != null) {
                String url;
                ObjectMetadataAction metadataAction = null;
                if (head instanceof PullRequestSCMHead) {
                    ContributorMetadataAction contributor;
                    int number = ((PullRequestSCMHead)head).getNumber();
                    url = repoLink.getUrl() + "/pull/" + number;
                    metadataAction = this.pullRequestMetadataCache.get(number);
                    if (metadataAction == null) {
                        metadataAction = new ObjectMetadataAction(null, null, url);
                    }
                    if ((contributor = this.pullRequestContributorCache.get(number)) != null) {
                        result.add((Action)contributor);
                    }
                } else {
                    url = repoLink.getUrl() + "/tree/" + head.getName();
                    metadataAction = new ObjectMetadataAction(head.getName(), null, url);
                }
                result.add(new GitHubLink("icon-github-branch", url));
                result.add((Action)metadataAction);
            }
            if (head instanceof BranchSCMHead) {
                for (GitHubDefaultBranch p : ((Actionable)owner).getActions(GitHubDefaultBranch.class)) {
                    if (!StringUtils.equals((String)this.getRepoOwner(), (String)p.getRepoOwner()) || !StringUtils.equals((String)this.repository, (String)p.getRepository()) || !StringUtils.equals((String)p.getDefaultBranch(), (String)head.getName())) continue;
                    result.add((Action)new PrimaryInstanceMetadataAction());
                    break;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    protected List<Action> retrieveActions(@CheckForNull SCMSourceEvent event, @NonNull TaskListener listener) throws IOException {
        ArrayList<Action> result = new ArrayList<Action>();
        result.add((Action)new GitHubRepoMetadataAction());
        String repository = this.repository;
        StandardCredentials credentials = Connector.lookupScanCredentials((Item)this.getOwner(), this.apiUri, this.credentialsId);
        GitHub hub = Connector.connect(this.apiUri, credentials);
        try {
            Connector.checkConnectionValidity(this.apiUri, listener, credentials, hub);
            try {
                this.ghRepository = hub.getRepository(this.getRepoOwner() + '/' + repository);
                this.resolvedRepositoryUrl = this.ghRepository.getHtmlUrl();
            }
            catch (FileNotFoundException e) {
                throw new AbortException(String.format("Invalid scan credentials when using %s to connect to %s/%s on %s", credentials == null ? "anonymous access" : CredentialsNameProvider.name((Credentials)credentials), this.repoOwner, repository, this.apiUri));
            }
            result.add((Action)new ObjectMetadataAction(null, this.ghRepository.getDescription(), Util.fixEmpty((String)this.ghRepository.getHomepage())));
            result.add(new GitHubLink("icon-github-repo", this.ghRepository.getHtmlUrl()));
            if (StringUtils.isNotBlank((String)this.ghRepository.getDefaultBranch())) {
                result.add((Action)new GitHubDefaultBranch(this.getRepoOwner(), repository, this.ghRepository.getDefaultBranch()));
            }
            ArrayList<Action> arrayList = result;
            return arrayList;
        }
        finally {
            Connector.release(hub);
        }
    }

    public void afterSave() {
        SCMSourceOwner owner = this.getOwner();
        if (owner != null) {
            GitHubWebHook.get().registerHookFor((Item)owner);
        }
    }

    private class DeferredPermissionsSource
    extends GitHubPermissionsSource
    implements Closeable {
        private final TaskListener listener;
        private GitHub github;
        private GHRepository repo;

        public DeferredPermissionsSource(TaskListener listener) {
            this.listener = listener;
        }

        @Override
        public GHPermissionType fetch(String username) throws IOException, InterruptedException {
            if (this.repo == null) {
                this.listener.getLogger().format("Connecting to %s to check permissions of obtain list of %s for %s/%s%n", GitHubSCMSource.this.apiUri, username, GitHubSCMSource.this.repoOwner, GitHubSCMSource.this.repository);
                StandardCredentials credentials = Connector.lookupScanCredentials((Item)GitHubSCMSource.this.getOwner(), GitHubSCMSource.this.apiUri, GitHubSCMSource.this.credentialsId);
                this.github = Connector.connect(GitHubSCMSource.this.apiUri, credentials);
                String fullName = GitHubSCMSource.this.repoOwner + "/" + GitHubSCMSource.this.repository;
                this.repo = this.github.getRepository(fullName);
            }
            return this.repo.getPermission(username);
        }

        @Override
        public void close() throws IOException {
            if (this.github != null) {
                Connector.release(this.github);
                this.github = null;
                this.repo = null;
            }
        }
    }

    private class DeferredContributorNames
    extends LazySet<String> {
        private final GitHubSCMSourceRequest request;
        private final TaskListener listener;

        public DeferredContributorNames(GitHubSCMSourceRequest request, TaskListener listener) {
            this.request = request;
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        @NonNull
        protected Set<String> create() {
            if (GitHubSCMSource.this.collaboratorNames != null) {
                return GitHubSCMSource.this.collaboratorNames;
            }
            this.listener.getLogger().format("Connecting to %s to obtain list of collaborators for %s/%s%n", GitHubSCMSource.this.apiUri, GitHubSCMSource.this.repoOwner, GitHubSCMSource.this.repository);
            StandardCredentials credentials = Connector.lookupScanCredentials((Item)GitHubSCMSource.this.getOwner(), GitHubSCMSource.this.apiUri, GitHubSCMSource.this.credentialsId);
            try {
                GitHub github = Connector.connect(GitHubSCMSource.this.apiUri, credentials);
                try {
                    String credentialsName;
                    GitHubSCMSource.this.checkApiUrlValidity(github, credentials);
                    Connector.checkApiRateLimit(this.listener, github);
                    Connector.checkConnectionValidity(GitHubSCMSource.this.apiUri, this.listener, credentials, github);
                    String string = credentialsName = credentials == null ? "anonymous access" : CredentialsNameProvider.name((Credentials)credentials);
                    if (credentials != null && !Connector.isCredentialValid(github)) {
                        this.listener.getLogger().format("Invalid scan credentials %s to connect to %s, assuming no trusted collaborators%n", credentialsName, GitHubSCMSource.this.apiUri);
                        GitHubSCMSource.this.collaboratorNames = Collections.singleton(GitHubSCMSource.this.repoOwner);
                    } else {
                        if (!github.isAnonymous()) {
                            this.listener.getLogger().format("Connecting to %s using %s%n", GitHubSCMSource.this.apiUri, credentialsName);
                        } else {
                            this.listener.getLogger().format("Connecting to %s with no credentials, anonymous access%n", GitHubSCMSource.this.apiUri);
                        }
                        if (!StringUtils.isBlank((String)GitHubSCMSource.this.getRepository())) {
                            this.request.checkApiRateLimit();
                            String fullName = GitHubSCMSource.this.repoOwner + "/" + GitHubSCMSource.this.repository;
                            GitHubSCMSource.this.ghRepository = github.getRepository(fullName);
                            GitHubSCMSource.this.resolvedRepositoryUrl = GitHubSCMSource.this.ghRepository.getHtmlUrl();
                            LazyContributorNames lazyContributorNames = new LazyContributorNames(this.request, this.listener, github, GitHubSCMSource.this.ghRepository, credentials);
                            return lazyContributorNames;
                        }
                        GitHubSCMSource.this.collaboratorNames = Collections.singleton(GitHubSCMSource.this.repoOwner);
                    }
                    Set set = GitHubSCMSource.this.collaboratorNames;
                    return set;
                }
                finally {
                    Connector.release(github);
                }
            }
            catch (IOException | InterruptedException e) {
                throw new WrappedException(e);
            }
        }
    }

    private class LazyContributorNames
    extends LazySet<String> {
        private final GitHubSCMSourceRequest request;
        private final TaskListener listener;
        private final GitHub github;
        private final GHRepository repo;
        private final StandardCredentials credentials;

        public LazyContributorNames(GitHubSCMSourceRequest request, TaskListener listener, GitHub github, GHRepository repo, StandardCredentials credentials) {
            this.request = request;
            this.listener = listener;
            this.github = github;
            this.repo = repo;
            this.credentials = credentials;
        }

        @Override
        @NonNull
        protected Set<String> create() {
            try {
                return GitHubSCMSource.this.updateCollaboratorNames(this.listener, this.credentials, this.repo);
            }
            catch (IOException e) {
                throw new WrappedException(e);
            }
        }
    }

    private static class MergabilityWitness
    implements SCMSourceRequest.Witness<PullRequestSCMHead, PullRequestSCMRevision> {
        private final GHPullRequest pr;
        private final ChangeRequestCheckoutStrategy strategy;
        private final TaskListener listener;

        public MergabilityWitness(GHPullRequest pr, ChangeRequestCheckoutStrategy strategy, TaskListener listener) {
            this.pr = pr;
            this.strategy = strategy;
            this.listener = listener;
        }

        public void record(@NonNull PullRequestSCMHead head, PullRequestSCMRevision revision, boolean isMatch) {
            if (isMatch) {
                Boolean mergeable;
                try {
                    mergeable = this.pr.getMergeable();
                }
                catch (IOException e) {
                    throw new WrappedException(e);
                }
                if (Boolean.FALSE.equals(mergeable)) {
                    switch (this.strategy) {
                        case MERGE: {
                            this.listener.getLogger().format("      Not mergeable, build likely to fail%n", new Object[0]);
                            break;
                        }
                        default: {
                            this.listener.getLogger().format("      Not mergeable, but will be built anyway%n", new Object[0]);
                        }
                    }
                }
            }
        }
    }

    private static class CriteriaWitness
    implements SCMSourceRequest.Witness {
        private final TaskListener listener;

        public CriteriaWitness(TaskListener listener) {
            this.listener = listener;
        }

        public void record(@NonNull SCMHead head, SCMRevision revision, boolean isMatch) {
            if (isMatch) {
                this.listener.getLogger().format("    Met criteria%n", new Object[0]);
            } else {
                this.listener.getLogger().format("    Does not meet criteria%n", new Object[0]);
            }
        }
    }

    @Restricted(value={NoExternalUse.class})
    static class LazyTags
    extends LazyIterable<GHRef> {
        private final GitHubSCMSourceRequest request;
        private final GHRepository repo;

        public LazyTags(GitHubSCMSourceRequest request, GHRepository repo) {
            this.request = request;
            this.repo = repo;
        }

        @Override
        protected Iterable<GHRef> create() {
            try {
                this.request.checkApiRateLimit();
                Set<String> tagNames = this.request.getRequestedTagNames();
                if (tagNames != null && tagNames.size() == 1) {
                    String tagName = tagNames.iterator().next();
                    this.request.listener().getLogger().format("%n  Getting remote tag %s...%n", tagName);
                    try {
                        GHRef tag = this.repo.getRef("tags/" + tagName);
                        return Collections.singletonList(tag);
                    }
                    catch (FileNotFoundException e) {
                        return Collections.emptyList();
                    }
                    catch (Error e) {
                        if (e.getCause() instanceof GHFileNotFoundException) {
                            return Collections.emptyList();
                        }
                        throw e;
                    }
                }
                this.request.listener().getLogger().format("%n  Getting remote tags...%n", new Object[0]);
                PagedIterable iterable = this.repo.listRefs("tags");
                return new Iterable<GHRef>((Iterable)iterable){
                    final /* synthetic */ Iterable val$iterable;
                    {
                        this.val$iterable = iterable;
                    }

                    @Override
                    public Iterator<GHRef> iterator() {
                        Iterator iterator;
                        try {
                            iterator = this.val$iterable.iterator();
                        }
                        catch (Error e) {
                            if (e.getCause() instanceof GHFileNotFoundException) {
                                return Collections.emptyList().iterator();
                            }
                            throw e;
                        }
                        return new Iterator<GHRef>(){
                            boolean hadAtLeastOne;
                            boolean hasNone;

                            @Override
                            public boolean hasNext() {
                                try {
                                    boolean hasNext = iterator.hasNext();
                                    this.hadAtLeastOne = this.hadAtLeastOne || hasNext;
                                    return hasNext;
                                }
                                catch (Error e) {
                                    if (e.getCause() instanceof GHFileNotFoundException) {
                                        return false;
                                    }
                                    throw e;
                                }
                                catch (GHException e) {
                                    if (this.hadAtLeastOne) {
                                        throw e;
                                    }
                                    try {
                                        boolean bl = this.hasNone = this.hasNone || repo.getRefs("tags").length == 0;
                                        if (this.hasNone) {
                                            return false;
                                        }
                                        throw e;
                                    }
                                    catch (FileNotFoundException e1) {
                                        this.hasNone = true;
                                        return false;
                                    }
                                    catch (IOException e1) {
                                        e.addSuppressed((Throwable)e1);
                                        throw e;
                                    }
                                }
                            }

                            @Override
                            public GHRef next() {
                                if (!this.hasNext()) {
                                    throw new NoSuchElementException();
                                }
                                return (GHRef)iterator.next();
                            }

                            @Override
                            public void remove() {
                                throw new UnsupportedOperationException("remove");
                            }
                        };
                    }
                };
            }
            catch (IOException | InterruptedException e) {
                throw new WrappedException(e);
            }
        }
    }

    private static class LazyBranches
    extends LazyIterable<GHBranch> {
        private final GitHubSCMSourceRequest request;
        private final GHRepository repo;

        public LazyBranches(GitHubSCMSourceRequest request, GHRepository repo) {
            this.request = request;
            this.repo = repo;
        }

        @Override
        protected Iterable<GHBranch> create() {
            try {
                this.request.checkApiRateLimit();
                Set<String> branchNames = this.request.getRequestedOriginBranchNames();
                if (branchNames != null && branchNames.size() == 1) {
                    String branchName = branchNames.iterator().next();
                    this.request.listener().getLogger().format("%n  Getting remote branch %s...%n", branchName);
                    try {
                        GHBranch branch = this.repo.getBranch(branchName);
                        return Collections.singletonList(branch);
                    }
                    catch (FileNotFoundException e) {
                        return Collections.emptyList();
                    }
                }
                this.request.listener().getLogger().format("%n  Getting remote branches...%n", new Object[0]);
                ArrayList<GHBranch> values = new ArrayList<GHBranch>(this.repo.getBranches().values());
                final String defaultBranch = StringUtils.defaultIfBlank((String)this.repo.getDefaultBranch(), (String)"master");
                Collections.sort(values, new Comparator<GHBranch>(){

                    @Override
                    public int compare(GHBranch o1, GHBranch o2) {
                        if (defaultBranch.equals(o1.getName())) {
                            return -1;
                        }
                        if (defaultBranch.equals(o2.getName())) {
                            return 1;
                        }
                        return 0;
                    }
                });
                return values;
            }
            catch (IOException | InterruptedException e) {
                throw new WrappedException(e);
            }
        }
    }

    private class LazyPullRequests
    extends LazyIterable<GHPullRequest>
    implements Closeable {
        private final GitHubSCMSourceRequest request;
        private final GHRepository repo;
        private Set<Integer> pullRequestMetadataKeys = new HashSet<Integer>();
        private boolean fullScanRequested = false;
        private boolean iterationCompleted = false;

        public LazyPullRequests(GitHubSCMSourceRequest request, GHRepository repo) {
            this.request = request;
            this.repo = repo;
        }

        @Override
        protected Iterable<GHPullRequest> create() {
            try {
                this.request.checkApiRateLimit();
                Set<Integer> prs = this.request.getRequestedPullRequestNumbers();
                if (prs != null && prs.size() == 1) {
                    Integer number = prs.iterator().next();
                    this.request.listener().getLogger().format("%n  Getting remote pull request #%d...%n", number);
                    GHPullRequest pullRequest = this.repo.getPullRequest(number.intValue());
                    if (pullRequest.getState() != GHIssueState.OPEN) {
                        return Collections.emptyList();
                    }
                    return new CacheUdatingIterable(Collections.singletonList(pullRequest));
                }
                Set<String> branchNames = this.request.getRequestedOriginBranchNames();
                if (branchNames != null && branchNames.size() == 1) {
                    String branchName = branchNames.iterator().next();
                    this.request.listener().getLogger().format("%n  Getting remote pull requests from branch %s...%n", branchName);
                    return new CacheUdatingIterable((Iterable<GHPullRequest>)this.repo.queryPullRequests().state(GHIssueState.OPEN).head(this.repo.getOwnerName() + ":" + branchName).list());
                }
                this.request.listener().getLogger().format("%n  Getting remote pull requests...%n", new Object[0]);
                this.fullScanRequested = true;
                return new CacheUdatingIterable((Iterable<GHPullRequest>)this.repo.queryPullRequests().state(GHIssueState.OPEN).list());
            }
            catch (IOException | InterruptedException e) {
                throw new WrappedException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            if (this.fullScanRequested && this.iterationCompleted) {
                GitHubSCMSource.this.pullRequestMetadataCache.keySet().retainAll(this.pullRequestMetadataKeys);
                GitHubSCMSource.this.pullRequestContributorCache.keySet().retainAll(this.pullRequestMetadataKeys);
                if (Jenkins.getActiveInstance().getInitLevel().compareTo((Enum)InitMilestone.JOB_LOADED) > 0) {
                    Object object = pullRequestSourceMapLock;
                    synchronized (object) {
                        GitHubSCMSource.this.pullRequestSourceMap = null;
                    }
                }
            }
        }

        private class CacheUdatingIterable
        extends SinglePassIterable<GHPullRequest> {
            private Map<String, GHUser> users;

            CacheUdatingIterable(Iterable<GHPullRequest> delegate) {
                super(delegate);
                this.users = new HashMap<String, GHUser>();
            }

            @Override
            public void observe(GHPullRequest pr) {
                int number = pr.getNumber();
                GHUser user = null;
                try {
                    user = pr.getUser();
                    if (this.users.containsKey(user.getLogin())) {
                        user = this.users.get(user.getLogin());
                    } else {
                        LazyPullRequests.this.request.checkApiRateLimit();
                    }
                    ContributorMetadataAction contributor = new ContributorMetadataAction(user.getLogin(), user.getName(), user.getEmail());
                    GitHubSCMSource.this.pullRequestContributorCache.put(number, contributor);
                    this.users.put(user.getLogin(), user);
                }
                catch (FileNotFoundException e) {
                    LazyPullRequests.this.request.listener().getLogger().format("%n  Could not find user %s for pull request %d.%n", user == null ? "null" : user.getLogin(), number);
                    throw new WrappedException(e);
                }
                catch (IOException | InterruptedException e) {
                    throw new WrappedException(e);
                }
                GitHubSCMSource.this.pullRequestMetadataCache.put(number, new ObjectMetadataAction(pr.getTitle(), pr.getBody(), pr.getHtmlUrl().toExternalForm()));
                LazyPullRequests.this.pullRequestMetadataKeys.add(number);
            }

            @Override
            public void completed() {
                LazyPullRequests.this.iterationCompleted = true;
            }
        }
    }

    @Symbol(value={"github"})
    @Extension
    public static class DescriptorImpl
    extends SCMSourceDescriptor
    implements CustomDescribableModel {
        @Deprecated
        @Restricted(value={DoNotUse.class})
        @RestrictedSince(value="2.2.0")
        public static final String defaultIncludes = "*";
        @Deprecated
        @Restricted(value={DoNotUse.class})
        @RestrictedSince(value="2.2.0")
        public static final String defaultExcludes = "";
        public static final String ANONYMOUS = "ANONYMOUS";
        public static final String SAME = "SAME";
        @Deprecated
        @Restricted(value={DoNotUse.class})
        @RestrictedSince(value="2.2.0")
        public static final boolean defaultBuildOriginBranch = true;
        @Deprecated
        @Restricted(value={DoNotUse.class})
        @RestrictedSince(value="2.2.0")
        public static final boolean defaultBuildOriginBranchWithPR = true;
        @Deprecated
        @Restricted(value={DoNotUse.class})
        @RestrictedSince(value="2.2.0")
        public static final boolean defaultBuildOriginPRMerge = false;
        @Deprecated
        @Restricted(value={DoNotUse.class})
        @RestrictedSince(value="2.2.0")
        public static final boolean defaultBuildOriginPRHead = false;
        @Deprecated
        @Restricted(value={DoNotUse.class})
        @RestrictedSince(value="2.2.0")
        public static final boolean defaultBuildForkPRMerge = true;
        @Deprecated
        @Restricted(value={DoNotUse.class})
        @RestrictedSince(value="2.2.0")
        public static final boolean defaultBuildForkPRHead = false;

        @Initializer(before=InitMilestone.PLUGINS_STARTED)
        public static void addAliases() {
            Items.XSTREAM2.addCompatibilityAlias("org.jenkinsci.plugins.github_branch_source.OriginGitHubSCMSource", GitHubSCMSource.class);
        }

        public String getDisplayName() {
            return Messages.GitHubSCMSource_DisplayName();
        }

        @Nonnull
        public Map<String, Object> customInstantiate(@Nonnull Map<String, Object> arguments) {
            TreeMap<String, Object> arguments2 = new TreeMap<String, Object>(arguments);
            arguments2.remove("repositoryUrl");
            arguments2.remove("configuredByUrl");
            return arguments2;
        }

        @Nonnull
        public UninstantiatedDescribable customUninstantiate(@Nonnull UninstantiatedDescribable ud) {
            TreeMap scmArguments = new TreeMap(ud.getArguments());
            scmArguments.remove("repositoryUrl");
            scmArguments.remove("configuredByUrl");
            return ud.withArguments(scmArguments);
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath @CheckForNull Item context, @QueryParameter String apiUri, @QueryParameter String credentialsId) {
            if (context == null ? !Jenkins.getActiveInstance().hasPermission(Jenkins.ADMINISTER) : !context.hasPermission(Item.EXTENDED_READ)) {
                return new StandardListBoxModel().includeCurrentValue(credentialsId);
            }
            return Connector.listScanCredentials(context, apiUri);
        }

        @RequirePOST
        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckCredentialsId(@AncestorInPath @CheckForNull Item context, @QueryParameter String apiUri, @QueryParameter String value) {
            return Connector.checkScanCredentials(context, apiUri, value);
        }

        @RequirePOST
        @Restricted(value={NoExternalUse.class})
        public FormValidation doValidateRepositoryUrlAndCredentials(@AncestorInPath @CheckForNull Item context, @QueryParameter String repositoryUrl, @QueryParameter String credentialsId) {
            GitHubRepositoryInfo info;
            if (context == null && !Jenkins.get().hasPermission(Jenkins.ADMINISTER) || context != null && !context.hasPermission(Item.EXTENDED_READ)) {
                return FormValidation.error((String)"Unable to validate repository information");
            }
            if (context != null && !context.hasPermission(CredentialsProvider.USE_ITEM)) {
                return FormValidation.error((String)"Unable to validate repository information");
            }
            try {
                info = GitHubRepositoryInfo.forRepositoryUrl(repositoryUrl);
            }
            catch (IllegalArgumentException e) {
                return FormValidation.error((Throwable)e, (String)e.getMessage());
            }
            StandardCredentials credentials = Connector.lookupScanCredentials(context, info.getApiUri(), credentialsId);
            StringBuilder sb = new StringBuilder();
            try {
                GHRepository repo;
                GitHub github = Connector.connect(info.getApiUri(), credentials);
                if (github.isCredentialValid()) {
                    sb.append("Credentials ok.");
                }
                if ((repo = github.getRepository(info.getRepoOwner() + "/" + info.getRepository())) != null) {
                    sb.append(" Connected to ");
                    sb.append(repo.getHtmlUrl());
                    sb.append(".");
                }
            }
            catch (IOException e) {
                return FormValidation.error((Throwable)e, (String)("Error validating repository information. " + sb.toString()));
            }
            return FormValidation.ok((String)sb.toString());
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckIncludes(@QueryParameter String value) {
            if (value.isEmpty()) {
                return FormValidation.warning((String)Messages.GitHubSCMSource_did_you_mean_to_use_to_match_all_branches());
            }
            return FormValidation.ok();
        }

        @RequirePOST
        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckScanCredentialsId(@AncestorInPath @CheckForNull Item context, @QueryParameter String apiUri, @QueryParameter String scanCredentialsId) {
            return this.doCheckCredentialsId(context, apiUri, scanCredentialsId);
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckBuildOriginBranchWithPR(@QueryParameter boolean buildOriginBranch, @QueryParameter boolean buildOriginBranchWithPR, @QueryParameter boolean buildOriginPRMerge, @QueryParameter boolean buildOriginPRHead, @QueryParameter boolean buildForkPRMerge, @QueryParameter boolean buildForkPRHead) {
            if (!(!buildOriginBranch || buildOriginBranchWithPR || buildOriginPRMerge || buildOriginPRHead || buildForkPRMerge || buildForkPRHead)) {
                return FormValidation.warning((String)"If you are not building any PRs, all origin branches will be built.");
            }
            return FormValidation.ok();
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckBuildOriginPRHead(@QueryParameter boolean buildOriginBranchWithPR, @QueryParameter boolean buildOriginPRMerge, @QueryParameter boolean buildOriginPRHead) {
            if (buildOriginBranchWithPR && buildOriginPRHead) {
                return FormValidation.warning((String)"Redundant to build an origin PR both as a branch and as an unmerged PR.");
            }
            if (buildOriginPRMerge && buildOriginPRHead) {
                return FormValidation.ok((String)"Merged vs. unmerged PRs will be distinguished in the job name (*-merge vs. *-head).");
            }
            return FormValidation.ok();
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckBuildForkPRHead(@QueryParameter boolean buildOriginBranch, @QueryParameter boolean buildOriginBranchWithPR, @QueryParameter boolean buildOriginPRMerge, @QueryParameter boolean buildOriginPRHead, @QueryParameter boolean buildForkPRMerge, @QueryParameter boolean buildForkPRHead) {
            if (!(buildOriginBranch || buildOriginBranchWithPR || buildOriginPRMerge || buildOriginPRHead || buildForkPRMerge || buildForkPRHead)) {
                return FormValidation.warning((String)"You need to build something!");
            }
            if (buildForkPRMerge && buildForkPRHead) {
                return FormValidation.ok((String)"Merged vs. unmerged PRs will be distinguished in the job name (*-merge vs. *-head).");
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillApiUriItems() {
            ListBoxModel result = new ListBoxModel();
            result.add("GitHub", defaultExcludes);
            for (Endpoint e : GitHubConfiguration.get().getEndpoints()) {
                result.add(e.getName() == null ? e.getApiUri() : e.getName() + " (" + e.getApiUri() + ")", e.getApiUri());
            }
            return result;
        }

        public boolean isApiUriSelectable() {
            return !GitHubConfiguration.get().getEndpoints().isEmpty();
        }

        @RequirePOST
        public ListBoxModel doFillOrganizationItems(@AncestorInPath @CheckForNull Item context, @QueryParameter String apiUri, @QueryParameter String credentialsId) throws IOException {
            if (credentialsId == null) {
                return new ListBoxModel();
            }
            if (context == null && !Jenkins.getActiveInstance().hasPermission(Jenkins.ADMINISTER) || context != null && !context.hasPermission(Item.EXTENDED_READ)) {
                return new ListBoxModel();
            }
            if (context != null && !context.hasPermission(CredentialsProvider.USE_ITEM)) {
                return new ListBoxModel();
            }
            try {
                StandardCredentials credentials = Connector.lookupScanCredentials(context, apiUri, credentialsId);
                GitHub github = Connector.connect(apiUri, credentials);
                if (!github.isAnonymous()) {
                    ListBoxModel model = new ListBoxModel();
                    for (Map.Entry entry : github.getMyOrganizations().entrySet()) {
                        model.add((String)entry.getKey(), ((GHOrganization)entry.getValue()).getAvatarUrl());
                    }
                    return model;
                }
            }
            catch (FillErrorResponse e) {
                throw e;
            }
            catch (Throwable e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
                throw new FillErrorResponse(e.getMessage(), false);
            }
            throw new FillErrorResponse(Messages.GitHubSCMSource_CouldNotConnectionGithub(credentialsId), true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @RequirePOST
        public ListBoxModel doFillRepositoryItems(@AncestorInPath @CheckForNull Item context, @QueryParameter String apiUri, @QueryParameter String credentialsId, @QueryParameter String repoOwner, @QueryParameter boolean configuredByUrl) throws IOException {
            if (configuredByUrl) {
                return new ListBoxModel();
            }
            if ((repoOwner = Util.fixEmptyAndTrim((String)repoOwner)) == null) {
                return new ListBoxModel();
            }
            if (context == null) {
                if (!Jenkins.getActiveInstance().hasPermission(Jenkins.ADMINISTER)) return new ListBoxModel();
            }
            if (context != null && !context.hasPermission(Item.EXTENDED_READ)) {
                return new ListBoxModel();
            }
            if (context != null && !context.hasPermission(CredentialsProvider.USE_ITEM)) {
                return new ListBoxModel();
            }
            try {
                StandardCredentials credentials = Connector.lookupScanCredentials(context, apiUri, credentialsId);
                GitHub github = Connector.connect(apiUri, credentials);
                try {
                    if (!github.isAnonymous()) {
                        GHMyself myself;
                        try {
                            myself = github.getMyself();
                        }
                        catch (IllegalStateException e) {
                            LOGGER.log(Level.WARNING, e.getMessage(), e);
                            throw new FillErrorResponse(e.getMessage(), false);
                        }
                        catch (IOException e) {
                            LogRecord lr = new LogRecord(Level.WARNING, "Exception retrieving the repositories of the owner {0} on {1} with credentials {2}");
                            lr.setThrown(e);
                            lr.setParameters(new Object[]{repoOwner, apiUri, credentials == null ? "anonymous access" : CredentialsNameProvider.name((Credentials)credentials)});
                            LOGGER.log(lr);
                            throw new FillErrorResponse(e.getMessage(), false);
                        }
                        if (myself != null && repoOwner.equalsIgnoreCase(myself.getLogin())) {
                            TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
                            PagedIterator lr = myself.listRepositories(100, GHMyself.RepositoryListFilter.ALL).iterator();
                            while (true) {
                                if (!lr.hasNext()) {
                                    lr = DescriptorImpl.nameAndValueModel(result);
                                    return lr;
                                }
                                GHRepository repo = (GHRepository)lr.next();
                                result.add(repo.getName());
                            }
                        }
                    }
                    GHOrganization org = null;
                    try {
                        org = github.getOrganization(repoOwner);
                    }
                    catch (FileNotFoundException fnf) {
                        LOGGER.log(Level.FINE, "There is not any GH Organization named {0}", repoOwner);
                    }
                    catch (IOException e) {
                        LogRecord lr = new LogRecord(Level.WARNING, "Exception retrieving the repositories of the organization {0} on {1} with credentials {2}");
                        lr.setThrown(e);
                        lr.setParameters(new Object[]{repoOwner, apiUri, credentials == null ? "anonymous access" : CredentialsNameProvider.name((Credentials)credentials)});
                        LOGGER.log(lr);
                        throw new FillErrorResponse(e.getMessage(), false);
                    }
                    if (org != null && repoOwner.equalsIgnoreCase(org.getLogin())) {
                        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
                        LOGGER.log(Level.FINE, "as {0} looking for repositories in {1}", new Object[]{credentialsId, repoOwner});
                        PagedIterator lr = org.listRepositories(100).iterator();
                        while (true) {
                            if (!lr.hasNext()) {
                                LOGGER.log(Level.FINE, "as {0} result of {1} is {2}", new Object[]{credentialsId, repoOwner, result});
                                lr = DescriptorImpl.nameAndValueModel(result);
                                return lr;
                            }
                            GHRepository repo = (GHRepository)lr.next();
                            LOGGER.log(Level.FINE, "as {0} found {1}/{2}", new Object[]{credentialsId, repoOwner, repo.getName()});
                            result.add(repo.getName());
                        }
                    }
                    GHUser user = null;
                    try {
                        user = github.getUser(repoOwner);
                    }
                    catch (FileNotFoundException fnf) {
                        LOGGER.log(Level.FINE, "There is not any GH User named {0}", repoOwner);
                    }
                    catch (IOException e) {
                        LogRecord lr = new LogRecord(Level.WARNING, "Exception retrieving the repositories of the user {0} on {1} with credentials {2}");
                        lr.setThrown(e);
                        lr.setParameters(new Object[]{repoOwner, apiUri, credentials == null ? "anonymous access" : CredentialsNameProvider.name((Credentials)credentials)});
                        LOGGER.log(lr);
                        throw new FillErrorResponse(e.getMessage(), false);
                    }
                    if (user == null) throw new FillErrorResponse(Messages.GitHubSCMSource_NoMatchingOwner(repoOwner), true);
                    if (!repoOwner.equalsIgnoreCase(user.getLogin())) throw new FillErrorResponse(Messages.GitHubSCMSource_NoMatchingOwner(repoOwner), true);
                    TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
                    for (GHRepository repo : user.listRepositories(100)) {
                        result.add(repo.getName());
                    }
                    PagedIterator pagedIterator = DescriptorImpl.nameAndValueModel(result);
                    return pagedIterator;
                }
                finally {
                    Connector.release(github);
                }
            }
            catch (FillErrorResponse e) {
                throw e;
            }
            catch (Throwable e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
                throw new FillErrorResponse(e.getMessage(), false);
            }
        }

        private static ListBoxModel nameAndValueModel(Collection<String> items) {
            ListBoxModel model = new ListBoxModel();
            for (String item : items) {
                model.add(item);
            }
            return model;
        }

        public List<NamedArrayList<? extends SCMTraitDescriptor<?>>> getTraitsDescriptorLists() {
            ArrayList all = new ArrayList();
            all.addAll(SCMSourceTrait._for((SCMSourceDescriptor)this, GitHubSCMSourceContext.class, null));
            all.addAll(SCMSourceTrait._for((SCMSourceDescriptor)this, null, GitHubSCMBuilder.class));
            HashSet<SCMTraitDescriptor> dedup = new HashSet<SCMTraitDescriptor>();
            Iterator iterator = all.iterator();
            while (iterator.hasNext()) {
                SCMTraitDescriptor d = (SCMTraitDescriptor)iterator.next();
                if (dedup.contains(d) || d instanceof GitBrowserSCMSourceTrait.DescriptorImpl) {
                    iterator.remove();
                    continue;
                }
                dedup.add(d);
            }
            ArrayList result = new ArrayList();
            NamedArrayList.select(all, (String)"Within repository", (NamedArrayList.Predicate)NamedArrayList.anyOf((NamedArrayList.Predicate[])new NamedArrayList.Predicate[]{NamedArrayList.withAnnotation(Discovery.class), NamedArrayList.withAnnotation(Selection.class)}), (boolean)true, result);
            NamedArrayList.select(all, (String)"General", null, (boolean)true, result);
            return result;
        }

        public List<SCMSourceTrait> getTraitsDefaults() {
            return Arrays.asList(new SCMSourceTrait[]{new BranchDiscoveryTrait(true, false), new OriginPullRequestDiscoveryTrait(EnumSet.of(ChangeRequestCheckoutStrategy.MERGE)), new ForkPullRequestDiscoveryTrait(EnumSet.of(ChangeRequestCheckoutStrategy.MERGE), (SCMHeadAuthority<? super GitHubSCMSourceRequest, ? extends ChangeRequestSCMHead2, ? extends SCMRevision>)new ForkPullRequestDiscoveryTrait.TrustPermission())});
        }

        @NonNull
        protected SCMHeadCategory[] createCategories() {
            return new SCMHeadCategory[]{new UncategorizedSCMHeadCategory(Messages._GitHubSCMSource_UncategorizedCategory()), new ChangeRequestSCMHeadCategory(Messages._GitHubSCMSource_ChangeRequestCategory()), new TagSCMHeadCategory(Messages._GitHubSCMSource_TagCategory())};
        }
    }

    @Restricted(value={NoExternalUse.class})
    @Deprecated
    @RestrictedSince(value="2.2.0")
    private static class MergeWith
    extends GitSCMExtension {
        private final String baseName;
        private final String baseHash;

        private MergeWith(String baseName, String baseHash) {
            this.baseName = baseName;
            this.baseHash = baseHash;
        }

        private Object readResolve() throws ObjectStreamException {
            return new MergeWithGitSCMExtension("remotes/origin/" + this.baseName, this.baseHash);
        }
    }

    private static class WrappedException
    extends RuntimeException {
        public WrappedException(Throwable cause) {
            super(cause);
        }

        public void unwrap() throws IOException, InterruptedException {
            Throwable cause = this.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof InterruptedException) {
                throw (InterruptedException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw this;
        }
    }
}

