/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github_branch_source;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import java.util.ArrayList;
import java.util.List;
import jenkins.scm.api.trait.SCMNavigatorContext;
import jenkins.scm.api.trait.SCMNavigatorTrait;
import jenkins.scm.api.trait.SCMNavigatorTraitDescriptor;
import jenkins.scm.impl.trait.Selection;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMNavigatorContext;
import org.jenkinsci.plugins.github_branch_source.Messages;
import org.kohsuke.stapler.DataBoundConstructor;

public class TopicsTrait
extends SCMNavigatorTrait {
    @NonNull
    private transient List<String> topics;
    private final String topicList;

    @DataBoundConstructor
    public TopicsTrait(@NonNull String topicList) {
        this.topicList = topicList;
        this.topics = new ArrayList<String>();
        for (String topic : topicList.split(",")) {
            this.topics.add(topic.trim());
        }
    }

    @NonNull
    public List<String> getTopics() {
        return this.topics;
    }

    @NonNull
    public String getTopicList() {
        return this.topicList;
    }

    protected void decorateContext(SCMNavigatorContext<?, ?> context) {
        super.decorateContext(context);
        ((GitHubSCMNavigatorContext)context).setTopics(this.topics);
    }

    private Object readResolve() {
        if (this.topicList != null) {
            ArrayList<String> tmpTopics = new ArrayList<String>();
            for (String topic : this.topicList.split(",")) {
                tmpTopics.add(topic.trim());
            }
            this.topics = tmpTopics;
        }
        return this;
    }

    @Symbol(value={"gitHubTopicsFilter"})
    @Extension
    @Selection
    public static class DescriptorImpl
    extends SCMNavigatorTraitDescriptor {
        public Class<? extends SCMNavigatorContext> getContextClass() {
            return GitHubSCMNavigatorContext.class;
        }

        @NonNull
        public String getDisplayName() {
            return Messages.TopicsTrait_displayName();
        }
    }
}

