/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github_branch_source;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadMigration;
import jenkins.scm.api.SCMHeadOrigin;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.mixin.ChangeRequestCheckoutStrategy;
import jenkins.scm.api.mixin.ChangeRequestSCMHead2;
import org.jenkinsci.plugins.github_branch_source.BranchSCMHead;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSource;
import org.jenkinsci.plugins.github_branch_source.Messages;
import org.jenkinsci.plugins.github_branch_source.PullRequestSCMRevision;
import org.jenkinsci.plugins.github_branch_source.PullRequestSource;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHRepository;

public class PullRequestSCMHead
extends SCMHead
implements ChangeRequestSCMHead2 {
    private static final Logger LOGGER = Logger.getLogger(PullRequestSCMHead.class.getName());
    private static final AtomicBoolean UPGRADE_SKIPPED_2_0_X = new AtomicBoolean(false);
    private static final long serialVersionUID = 1L;
    private Boolean merge;
    private final int number;
    private final BranchSCMHead target;
    private final String sourceOwner;
    private final String sourceRepo;
    private final String sourceBranch;
    private final SCMHeadOrigin origin;
    private transient Metadata metadata;

    PullRequestSCMHead(PullRequestSCMHead copy) {
        super(copy.getName());
        this.merge = copy.merge;
        this.number = copy.number;
        this.target = copy.target;
        this.sourceOwner = copy.sourceOwner;
        this.sourceRepo = copy.sourceRepo;
        this.sourceBranch = copy.sourceBranch;
        this.origin = copy.origin;
        this.metadata = copy.metadata;
    }

    PullRequestSCMHead(GHPullRequest pr, String name, boolean merge) {
        super(name);
        this.merge = merge;
        this.number = pr.getNumber();
        this.target = new BranchSCMHead(pr.getBase().getRef());
        GHRepository repository = pr.getHead().getRepository();
        this.sourceOwner = repository == null ? null : repository.getOwnerName();
        this.sourceRepo = repository == null ? null : repository.getName();
        this.sourceBranch = pr.getHead().getRef();
        this.origin = pr.getRepository().getOwnerName().equalsIgnoreCase(this.sourceOwner) ? SCMHeadOrigin.DEFAULT : (pr.getBase().getRepository().getName().equalsIgnoreCase(this.sourceRepo) ? new SCMHeadOrigin.Fork(this.sourceOwner) : new SCMHeadOrigin.Fork(repository == null ? this.sourceOwner : repository.getFullName()));
    }

    public PullRequestSCMHead(@NonNull String name, String sourceOwner, String sourceRepo, String sourceBranch, int number, BranchSCMHead target, SCMHeadOrigin origin, ChangeRequestCheckoutStrategy strategy) {
        super(name);
        this.merge = ChangeRequestCheckoutStrategy.MERGE == strategy;
        this.number = number;
        this.target = target;
        this.sourceOwner = sourceOwner;
        this.sourceRepo = sourceRepo;
        this.sourceBranch = sourceBranch;
        this.origin = origin;
    }

    public String getPronoun() {
        return Messages.PullRequestSCMHead_Pronoun();
    }

    public int getNumber() {
        return this.number;
    }

    @SuppressFBWarnings(value={"SE_PRIVATE_READ_RESOLVE_NOT_INHERITED"})
    private Object readResolve() {
        if (this.merge == null) {
            this.merge = true;
        }
        if (this.metadata != null) {
            if (UPGRADE_SKIPPED_2_0_X.compareAndSet(false, true)) {
                LOGGER.log(Level.WARNING, "GitHub Branch Source plugin was directly upgraded from 1.x to 2.2.0 or newer without completing a full fetch from all repositories. Consequently startup may be delayed while GitHub is queried for the missing information");
            }
            return new FixMetadata(this.getName(), this.merge, this.metadata.getNumber(), new BranchSCMHead(this.metadata.getBaseRef()));
        }
        if (this.origin == null && !(this instanceof FixOrigin)) {
            return new FixOrigin(this);
        }
        return this;
    }

    public boolean isMerge() {
        return this.merge;
    }

    @NonNull
    public ChangeRequestCheckoutStrategy getCheckoutStrategy() {
        return this.merge != false ? ChangeRequestCheckoutStrategy.MERGE : ChangeRequestCheckoutStrategy.HEAD;
    }

    @NonNull
    public String getId() {
        return Integer.toString(this.number);
    }

    @NonNull
    public BranchSCMHead getTarget() {
        return this.target;
    }

    @NonNull
    public String getOriginName() {
        return this.sourceBranch;
    }

    public String getSourceOwner() {
        return this.sourceOwner;
    }

    public String getSourceBranch() {
        return this.sourceBranch;
    }

    public String getSourceRepo() {
        return this.sourceRepo;
    }

    @NonNull
    public SCMHeadOrigin getOrigin() {
        return this.origin == null ? SCMHeadOrigin.DEFAULT : this.origin;
    }

    @Restricted(value={NoExternalUse.class})
    @Extension
    public static class FixMetadataMigration
    extends SCMHeadMigration<GitHubSCMSource, FixMetadata, PullRequestSCMRevision> {
        public FixMetadataMigration() {
            super(GitHubSCMSource.class, FixMetadata.class, PullRequestSCMRevision.class);
        }

        public PullRequestSCMHead migrate(@NonNull GitHubSCMSource source, @NonNull FixMetadata head) {
            PullRequestSource src = source.retrievePullRequestSource(head.getNumber());
            return new PullRequestSCMHead(head.getName(), src == null ? null : src.getSourceOwner(), src == null ? null : src.getSourceRepo(), src == null ? null : src.getSourceBranch(), head.getNumber(), (BranchSCMHead)head.getTarget(), (SCMHeadOrigin)(src != null && source.getRepoOwner().equalsIgnoreCase(src.getSourceOwner()) ? SCMHeadOrigin.DEFAULT : new SCMHeadOrigin.Fork(head.getSourceOwner())), head.getCheckoutStrategy());
        }

        public SCMRevision migrate(@NonNull GitHubSCMSource source, @NonNull PullRequestSCMRevision revision) {
            PullRequestSCMHead head = this.migrate(source, (FixMetadata)revision.getHead());
            return head != null ? new PullRequestSCMRevision(head, revision.getBaseHash(), revision.getPullHash()) : null;
        }
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    public static class FixMetadata
    extends PullRequestSCMHead {
        FixMetadata(String name, Boolean merge, int number, BranchSCMHead branchSCMHead) {
            super(name, null, null, null, number, branchSCMHead, null, merge != false ? ChangeRequestCheckoutStrategy.MERGE : ChangeRequestCheckoutStrategy.HEAD);
        }
    }

    @Restricted(value={NoExternalUse.class})
    @Extension
    public static class FixOriginMigration
    extends SCMHeadMigration<GitHubSCMSource, FixOrigin, PullRequestSCMRevision> {
        public FixOriginMigration() {
            super(GitHubSCMSource.class, FixOrigin.class, PullRequestSCMRevision.class);
        }

        public PullRequestSCMHead migrate(@NonNull GitHubSCMSource source, @NonNull FixOrigin head) {
            return new PullRequestSCMHead(head.getName(), head.getSourceOwner(), head.getSourceRepo(), head.getSourceBranch(), head.getNumber(), (BranchSCMHead)head.getTarget(), (SCMHeadOrigin)(source.getRepoOwner().equalsIgnoreCase(head.getSourceOwner()) ? SCMHeadOrigin.DEFAULT : new SCMHeadOrigin.Fork(head.getSourceOwner())), head.getCheckoutStrategy());
        }

        public SCMRevision migrate(@NonNull GitHubSCMSource source, @NonNull PullRequestSCMRevision revision) {
            PullRequestSCMHead head = this.migrate(source, (FixOrigin)revision.getHead());
            return head != null ? new PullRequestSCMRevision(head, revision.getBaseHash(), revision.getPullHash()) : null;
        }
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    public static class FixOrigin
    extends PullRequestSCMHead {
        FixOrigin(PullRequestSCMHead pullRequestSCMHead) {
            super(pullRequestSCMHead);
        }
    }

    private static class Metadata {
        private final int number;
        private final String url;
        private final String userLogin;
        private final String baseRef;

        public Metadata(int number, String url, String userLogin, String baseRef) {
            this.number = number;
            this.url = url;
            this.userLogin = userLogin;
            this.baseRef = baseRef;
        }

        public int getNumber() {
            return this.number;
        }

        public String getUrl() {
            return this.url;
        }

        public String getUserLogin() {
            return this.userLogin;
        }

        public String getBaseRef() {
            return this.baseRef;
        }
    }
}

