/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github_branch_source;

import com.fasterxml.jackson.databind.JsonMappingException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import jenkins.scm.api.SCMFile;
import org.jenkinsci.plugins.github_branch_source.GitHubClosable;
import org.kohsuke.github.GHContent;
import org.kohsuke.github.GHRepository;

class GitHubSCMFile
extends SCMFile {
    private TypeInfo info;
    private final GitHubClosable closable;
    private final GHRepository repo;
    private final String ref;
    private transient Object metadata;
    private transient boolean resolved;

    GitHubSCMFile(GitHubClosable closable, GHRepository repo, String ref) {
        this.closable = closable;
        this.type(SCMFile.Type.DIRECTORY);
        this.info = TypeInfo.DIRECTORY_ASSUMED;
        this.repo = repo;
        this.ref = ref;
    }

    private GitHubSCMFile(@NonNull GitHubSCMFile parent, String name, TypeInfo info) {
        super((SCMFile)parent, name);
        this.closable = parent.closable;
        this.info = info;
        this.repo = parent.repo;
        this.ref = parent.ref;
    }

    private GitHubSCMFile(@NonNull GitHubSCMFile parent, String name, GHContent metadata) {
        super((SCMFile)parent, name);
        this.closable = parent.closable;
        this.repo = parent.repo;
        this.ref = parent.ref;
        if (metadata.isDirectory()) {
            this.info = TypeInfo.DIRECTORY_CONFIRMED;
        } else {
            this.info = TypeInfo.NON_DIRECTORY_CONFIRMED;
            this.metadata = metadata;
            this.resolved = true;
        }
    }

    private void checkOpen() throws IOException {
        if (!this.closable.isOpen() || !this.resolved && this.repo == null) {
            throw new IOException("Closed");
        }
    }

    private Object metadata() throws IOException {
        if (this.metadata == null && !this.resolved) {
            try {
                switch (this.info) {
                    case DIRECTORY_ASSUMED: {
                        this.metadata = this.repo.getDirectoryContent(this.getPath(), (String)(this.ref.indexOf(47) == -1 ? this.ref : "refs/" + this.ref));
                        this.info = TypeInfo.DIRECTORY_CONFIRMED;
                        this.resolved = true;
                        break;
                    }
                    case DIRECTORY_CONFIRMED: {
                        this.metadata = this.repo.getDirectoryContent(this.getPath(), (String)(this.ref.indexOf(47) == -1 ? this.ref : "refs/" + this.ref));
                        this.resolved = true;
                        break;
                    }
                    case NON_DIRECTORY_CONFIRMED: {
                        this.metadata = this.repo.getFileContent(this.getPath(), (String)(this.ref.indexOf(47) == -1 ? this.ref : "refs/" + this.ref));
                        this.resolved = true;
                        break;
                    }
                    case UNRESOLVED: {
                        this.checkOpen();
                        try {
                            this.metadata = this.repo.getFileContent(this.getPath(), (String)(this.ref.indexOf(47) == -1 ? this.ref : "refs/" + this.ref));
                            this.info = TypeInfo.NON_DIRECTORY_CONFIRMED;
                            this.resolved = true;
                            break;
                        }
                        catch (IOException e) {
                            if (e.getCause() instanceof JsonMappingException || e.getCause() != null && e.getCause().getCause() instanceof JsonMappingException) {
                                this.metadata = this.repo.getDirectoryContent(this.getPath(), (String)(this.ref.indexOf(47) == -1 ? this.ref : "refs/" + this.ref));
                                this.info = TypeInfo.DIRECTORY_CONFIRMED;
                                this.resolved = true;
                                break;
                            }
                            throw e;
                        }
                    }
                }
            }
            catch (FileNotFoundException e) {
                this.metadata = null;
                this.resolved = true;
            }
        }
        return this.metadata;
    }

    @NonNull
    protected SCMFile newChild(String name, boolean assumeIsDirectory) {
        return new GitHubSCMFile(this, name, assumeIsDirectory ? TypeInfo.DIRECTORY_ASSUMED : TypeInfo.UNRESOLVED);
    }

    @NonNull
    public Iterable<SCMFile> children() throws IOException {
        this.checkOpen();
        List content = this.repo.getDirectoryContent(this.getPath(), (String)(this.ref.indexOf(47) == -1 ? this.ref : "refs/" + this.ref));
        ArrayList<SCMFile> result = new ArrayList<SCMFile>(content.size());
        for (GHContent c : content) {
            result.add(new GitHubSCMFile(this, c.getName(), c));
        }
        return result;
    }

    public long lastModified() throws IOException, InterruptedException {
        return 0L;
    }

    @NonNull
    protected SCMFile.Type type() throws IOException, InterruptedException {
        Object metadata = this.metadata();
        if (metadata instanceof List) {
            return SCMFile.Type.DIRECTORY;
        }
        if (metadata instanceof GHContent) {
            GHContent content = (GHContent)metadata;
            if ("symlink".equals(content.getType())) {
                return SCMFile.Type.LINK;
            }
            if (content.isFile()) {
                return SCMFile.Type.REGULAR_FILE;
            }
            return SCMFile.Type.OTHER;
        }
        return SCMFile.Type.NONEXISTENT;
    }

    @NonNull
    public InputStream content() throws IOException, InterruptedException {
        Object metadata = this.metadata();
        if (metadata instanceof List) {
            throw new IOException("Directory");
        }
        if (metadata instanceof GHContent) {
            return ((GHContent)metadata).read();
        }
        throw new FileNotFoundException(this.getPath());
    }

    private static enum TypeInfo {
        UNRESOLVED,
        DIRECTORY_ASSUMED,
        DIRECTORY_CONFIRMED,
        NON_DIRECTORY_CONFIRMED;

    }
}

