// CHECKSTYLE:OFF

package org.jenkinsci.plugins.github_branch_source;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code ForkPullRequestDiscoveryTrait.mergeOnly}: {@code Merging
     * the pull request with the current target branch revision}.
     * 
     * @return
     *     {@code Merging the pull request with the current target branch
     *     revision}
     */
    public static String ForkPullRequestDiscoveryTrait_mergeOnly() {
        return holder.format("ForkPullRequestDiscoveryTrait.mergeOnly");
    }

    /**
     * Key {@code ForkPullRequestDiscoveryTrait.mergeOnly}: {@code Merging
     * the pull request with the current target branch revision}.
     * 
     * @return
     *     {@code Merging the pull request with the current target branch
     *     revision}
     */
    public static Localizable _ForkPullRequestDiscoveryTrait_mergeOnly() {
        return new Localizable(holder, "ForkPullRequestDiscoveryTrait.mergeOnly");
    }

    /**
     * Key {@code GitHubBuildStatusNotification.CommitStatusSet}: {@code
     * GitHub has been notified of this commit’s build result}.
     * 
     * @return
     *     {@code GitHub has been notified of this commit’s build result}
     */
    public static String GitHubBuildStatusNotification_CommitStatusSet() {
        return holder.format("GitHubBuildStatusNotification.CommitStatusSet");
    }

    /**
     * Key {@code GitHubBuildStatusNotification.CommitStatusSet}: {@code
     * GitHub has been notified of this commit’s build result}.
     * 
     * @return
     *     {@code GitHub has been notified of this commit’s build result}
     */
    public static Localizable _GitHubBuildStatusNotification_CommitStatusSet() {
        return new Localizable(holder, "GitHubBuildStatusNotification.CommitStatusSet");
    }

    /**
     * Key {@code GitHubTagSCMHead.Pronoun}: {@code Tag}.
     * 
     * @return
     *     {@code Tag}
     */
    public static String GitHubTagSCMHead_Pronoun() {
        return holder.format("GitHubTagSCMHead.Pronoun");
    }

    /**
     * Key {@code GitHubTagSCMHead.Pronoun}: {@code Tag}.
     * 
     * @return
     *     {@code Tag}
     */
    public static Localizable _GitHubTagSCMHead_Pronoun() {
        return new Localizable(holder, "GitHubTagSCMHead.Pronoun");
    }

    /**
     * Key {@code GitHubSCMNavigator.DisplayName}: {@code GitHub
     * Organization}.
     * 
     * @return
     *     {@code GitHub Organization}
     */
    public static String GitHubSCMNavigator_DisplayName() {
        return holder.format("GitHubSCMNavigator.DisplayName");
    }

    /**
     * Key {@code GitHubSCMNavigator.DisplayName}: {@code GitHub
     * Organization}.
     * 
     * @return
     *     {@code GitHub Organization}
     */
    public static Localizable _GitHubSCMNavigator_DisplayName() {
        return new Localizable(holder, "GitHubSCMNavigator.DisplayName");
    }

    /**
     * Key {@code ForkPullRequestDiscoveryTrait.headOnly}: {@code The current
     * pull request revision}.
     * 
     * @return
     *     {@code The current pull request revision}
     */
    public static String ForkPullRequestDiscoveryTrait_headOnly() {
        return holder.format("ForkPullRequestDiscoveryTrait.headOnly");
    }

    /**
     * Key {@code ForkPullRequestDiscoveryTrait.headOnly}: {@code The current
     * pull request revision}.
     * 
     * @return
     *     {@code The current pull request revision}
     */
    public static Localizable _ForkPullRequestDiscoveryTrait_headOnly() {
        return new Localizable(holder, "ForkPullRequestDiscoveryTrait.headOnly");
    }

    /**
     * Key {@code GitHubBranchFilter.DisplayName}: {@code GitHub Branch Jobs
     * Only}.
     * 
     * @return
     *     {@code GitHub Branch Jobs Only}
     */
    public static String GitHubBranchFilter_DisplayName() {
        return holder.format("GitHubBranchFilter.DisplayName");
    }

    /**
     * Key {@code GitHubBranchFilter.DisplayName}: {@code GitHub Branch Jobs
     * Only}.
     * 
     * @return
     *     {@code GitHub Branch Jobs Only}
     */
    public static Localizable _GitHubBranchFilter_DisplayName() {
        return new Localizable(holder, "GitHubBranchFilter.DisplayName");
    }

    /**
     * Key {@code PullRequestSCMHead.Pronoun}: {@code Pull Request}.
     * 
     * @return
     *     {@code Pull Request}
     */
    public static String PullRequestSCMHead_Pronoun() {
        return holder.format("PullRequestSCMHead.Pronoun");
    }

    /**
     * Key {@code PullRequestSCMHead.Pronoun}: {@code Pull Request}.
     * 
     * @return
     *     {@code Pull Request}
     */
    public static Localizable _PullRequestSCMHead_Pronoun() {
        return new Localizable(holder, "PullRequestSCMHead.Pronoun");
    }

    /**
     * Key {@code GitHubSCMNavigator.general}: {@code General}.
     * 
     * @return
     *     {@code General}
     */
    public static String GitHubSCMNavigator_general() {
        return holder.format("GitHubSCMNavigator.general");
    }

    /**
     * Key {@code GitHubSCMNavigator.general}: {@code General}.
     * 
     * @return
     *     {@code General}
     */
    public static Localizable _GitHubSCMNavigator_general() {
        return new Localizable(holder, "GitHubSCMNavigator.general");
    }

    /**
     * Key {@code BranchDiscoveryTrait.authorityDisplayName}: {@code Trust
     * origin branches}.
     * 
     * @return
     *     {@code Trust origin branches}
     */
    public static String BranchDiscoveryTrait_authorityDisplayName() {
        return holder.format("BranchDiscoveryTrait.authorityDisplayName");
    }

    /**
     * Key {@code BranchDiscoveryTrait.authorityDisplayName}: {@code Trust
     * origin branches}.
     * 
     * @return
     *     {@code Trust origin branches}
     */
    public static Localizable _BranchDiscoveryTrait_authorityDisplayName() {
        return new Localizable(holder, "BranchDiscoveryTrait.authorityDisplayName");
    }

    /**
     * Key {@code ApiRateLimitChecker.ThrottleForNormalize}: {@code Normalize
     * API requests}.
     * 
     * @return
     *     {@code Normalize API requests}
     */
    public static String ApiRateLimitChecker_ThrottleForNormalize() {
        return holder.format("ApiRateLimitChecker.ThrottleForNormalize");
    }

    /**
     * Key {@code ApiRateLimitChecker.ThrottleForNormalize}: {@code Normalize
     * API requests}.
     * 
     * @return
     *     {@code Normalize API requests}
     */
    public static Localizable _ApiRateLimitChecker_ThrottleForNormalize() {
        return new Localizable(holder, "ApiRateLimitChecker.ThrottleForNormalize");
    }

    /**
     * Key {@code GitHubBuildStatusNotification.CommitStatus.Aborted}: {@code
     * The build of this commit was aborted}.
     * 
     * @return
     *     {@code The build of this commit was aborted}
     */
    public static String GitHubBuildStatusNotification_CommitStatus_Aborted() {
        return holder.format("GitHubBuildStatusNotification.CommitStatus.Aborted");
    }

    /**
     * Key {@code GitHubBuildStatusNotification.CommitStatus.Aborted}: {@code
     * The build of this commit was aborted}.
     * 
     * @return
     *     {@code The build of this commit was aborted}
     */
    public static Localizable _GitHubBuildStatusNotification_CommitStatus_Aborted() {
        return new Localizable(holder, "GitHubBuildStatusNotification.CommitStatus.Aborted");
    }

    /**
     * Key {@code TopicsTrait.displayName}: {@code Filter by Repository
     * Topics}.
     * 
     * @return
     *     {@code Filter by Repository Topics}
     */
    public static String TopicsTrait_displayName() {
        return holder.format("TopicsTrait.displayName");
    }

    /**
     * Key {@code TopicsTrait.displayName}: {@code Filter by Repository
     * Topics}.
     * 
     * @return
     *     {@code Filter by Repository Topics}
     */
    public static Localizable _TopicsTrait_displayName() {
        return new Localizable(holder, "TopicsTrait.displayName");
    }

    /**
     * Key {@code GitHubBuildStatusNotification.CommitStatus.Queued}: {@code
     * This commit is scheduled to be built}.
     * 
     * @return
     *     {@code This commit is scheduled to be built}
     */
    public static String GitHubBuildStatusNotification_CommitStatus_Queued() {
        return holder.format("GitHubBuildStatusNotification.CommitStatus.Queued");
    }

    /**
     * Key {@code GitHubBuildStatusNotification.CommitStatus.Queued}: {@code
     * This commit is scheduled to be built}.
     * 
     * @return
     *     {@code This commit is scheduled to be built}
     */
    public static Localizable _GitHubBuildStatusNotification_CommitStatus_Queued() {
        return new Localizable(holder, "GitHubBuildStatusNotification.CommitStatus.Queued");
    }

    /**
     * Key {@code ExcludePublicRepositoriesTrait.displayName}: {@code Exclude
     * public repositories}.
     * 
     * @return
     *     {@code Exclude public repositories}
     */
    public static String ExcludePublicRepositoriesTrait_displayName() {
        return holder.format("ExcludePublicRepositoriesTrait.displayName");
    }

    /**
     * Key {@code ExcludePublicRepositoriesTrait.displayName}: {@code Exclude
     * public repositories}.
     * 
     * @return
     *     {@code Exclude public repositories}
     */
    public static Localizable _ExcludePublicRepositoriesTrait_displayName() {
        return new Localizable(holder, "ExcludePublicRepositoriesTrait.displayName");
    }

    /**
     * Key {@code GitHubSCMNavigator.withinRepository}: {@code Within
     * repository}.
     * 
     * @return
     *     {@code Within repository}
     */
    public static String GitHubSCMNavigator_withinRepository() {
        return holder.format("GitHubSCMNavigator.withinRepository");
    }

    /**
     * Key {@code GitHubSCMNavigator.withinRepository}: {@code Within
     * repository}.
     * 
     * @return
     *     {@code Within repository}
     */
    public static Localizable _GitHubSCMNavigator_withinRepository() {
        return new Localizable(holder, "GitHubSCMNavigator.withinRepository");
    }

    /**
     * Key {@code ForkPullRequestDiscoveryTrait.displayName}: {@code Discover
     * pull requests from forks}.
     * 
     * @return
     *     {@code Discover pull requests from forks}
     */
    public static String ForkPullRequestDiscoveryTrait_displayName() {
        return holder.format("ForkPullRequestDiscoveryTrait.displayName");
    }

    /**
     * Key {@code ForkPullRequestDiscoveryTrait.displayName}: {@code Discover
     * pull requests from forks}.
     * 
     * @return
     *     {@code Discover pull requests from forks}
     */
    public static Localizable _ForkPullRequestDiscoveryTrait_displayName() {
        return new Localizable(holder, "ForkPullRequestDiscoveryTrait.displayName");
    }

    /**
     * Key {@code GitHubSCMSource.DisplayName}: {@code GitHub}.
     * 
     * @return
     *     {@code GitHub}
     */
    public static String GitHubSCMSource_DisplayName() {
        return holder.format("GitHubSCMSource.DisplayName");
    }

    /**
     * Key {@code GitHubSCMSource.DisplayName}: {@code GitHub}.
     * 
     * @return
     *     {@code GitHub}
     */
    public static Localizable _GitHubSCMSource_DisplayName() {
        return new Localizable(holder, "GitHubSCMSource.DisplayName");
    }

    /**
     * Key {@code ForkPullRequestDiscoveryTrait.contributorsDisplayName}:
     * {@code Collaborators}.
     * 
     * @return
     *     {@code Collaborators}
     */
    public static String ForkPullRequestDiscoveryTrait_contributorsDisplayName() {
        return holder.format("ForkPullRequestDiscoveryTrait.contributorsDisplayName");
    }

    /**
     * Key {@code ForkPullRequestDiscoveryTrait.contributorsDisplayName}:
     * {@code Collaborators}.
     * 
     * @return
     *     {@code Collaborators}
     */
    public static Localizable _ForkPullRequestDiscoveryTrait_contributorsDisplayName() {
        return new Localizable(holder, "ForkPullRequestDiscoveryTrait.contributorsDisplayName");
    }

    /**
     * Key {@code ForkPullRequestDiscoveryTrait.nobodyDisplayName}: {@code
     * Nobody}.
     * 
     * @return
     *     {@code Nobody}
     */
    public static String ForkPullRequestDiscoveryTrait_nobodyDisplayName() {
        return holder.format("ForkPullRequestDiscoveryTrait.nobodyDisplayName");
    }

    /**
     * Key {@code ForkPullRequestDiscoveryTrait.nobodyDisplayName}: {@code
     * Nobody}.
     * 
     * @return
     *     {@code Nobody}
     */
    public static Localizable _ForkPullRequestDiscoveryTrait_nobodyDisplayName() {
        return new Localizable(holder, "ForkPullRequestDiscoveryTrait.nobodyDisplayName");
    }

    /**
     * Key {@code GitHubSCMSource.ChangeRequestCategory}: {@code Pull
     * Requests}.
     * 
     * @return
     *     {@code Pull Requests}
     */
    public static String GitHubSCMSource_ChangeRequestCategory() {
        return holder.format("GitHubSCMSource.ChangeRequestCategory");
    }

    /**
     * Key {@code GitHubSCMSource.ChangeRequestCategory}: {@code Pull
     * Requests}.
     * 
     * @return
     *     {@code Pull Requests}
     */
    public static Localizable _GitHubSCMSource_ChangeRequestCategory() {
        return new Localizable(holder, "GitHubSCMSource.ChangeRequestCategory");
    }

    /**
     * Key {@code BranchDiscoveryTrait.excludePRs}: {@code Exclude branches
     * that are also filed as PRs}.
     * 
     * @return
     *     {@code Exclude branches that are also filed as PRs}
     */
    public static String BranchDiscoveryTrait_excludePRs() {
        return holder.format("BranchDiscoveryTrait.excludePRs");
    }

    /**
     * Key {@code BranchDiscoveryTrait.excludePRs}: {@code Exclude branches
     * that are also filed as PRs}.
     * 
     * @return
     *     {@code Exclude branches that are also filed as PRs}
     */
    public static Localizable _BranchDiscoveryTrait_excludePRs() {
        return new Localizable(holder, "BranchDiscoveryTrait.excludePRs");
    }

    /**
     * Key {@code GitHubSCMSource.NoMatchingOwner}: {@code Could not find
     * owner: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Could not find owner: {0}}
     */
    public static String GitHubSCMSource_NoMatchingOwner(Object arg0) {
        return holder.format("GitHubSCMSource.NoMatchingOwner", arg0);
    }

    /**
     * Key {@code GitHubSCMSource.NoMatchingOwner}: {@code Could not find
     * owner: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Could not find owner: {0}}
     */
    public static Localizable _GitHubSCMSource_NoMatchingOwner(Object arg0) {
        return new Localizable(holder, "GitHubSCMSource.NoMatchingOwner", arg0);
    }

    /**
     * Key {@code GitHubRepoMetadataAction.IconDescription}: {@code GitHub
     * Repository}.
     * 
     * @return
     *     {@code GitHub Repository}
     */
    public static String GitHubRepoMetadataAction_IconDescription() {
        return holder.format("GitHubRepoMetadataAction.IconDescription");
    }

    /**
     * Key {@code GitHubRepoMetadataAction.IconDescription}: {@code GitHub
     * Repository}.
     * 
     * @return
     *     {@code GitHub Repository}
     */
    public static Localizable _GitHubRepoMetadataAction_IconDescription() {
        return new Localizable(holder, "GitHubRepoMetadataAction.IconDescription");
    }

    /**
     * Key {@code GitHubBuildStatusNotification.CommitStatus.Good}: {@code
     * This commit looks good}.
     * 
     * @return
     *     {@code This commit looks good}
     */
    public static String GitHubBuildStatusNotification_CommitStatus_Good() {
        return holder.format("GitHubBuildStatusNotification.CommitStatus.Good");
    }

    /**
     * Key {@code GitHubBuildStatusNotification.CommitStatus.Good}: {@code
     * This commit looks good}.
     * 
     * @return
     *     {@code This commit looks good}
     */
    public static Localizable _GitHubBuildStatusNotification_CommitStatus_Good() {
        return new Localizable(holder, "GitHubBuildStatusNotification.CommitStatus.Good");
    }

    /**
     * Key {@code ExcludeForkedRepositoriesTrait.displayName}: {@code Exclude
     * repositories that are forks of another repository}.
     * 
     * @return
     *     {@code Exclude repositories that are forks of another repository}
     */
    public static String ExcludeForkedRepositoriesTrait_displayName() {
        return holder.format("ExcludeForkedRepositoriesTrait.displayName");
    }

    /**
     * Key {@code ExcludeForkedRepositoriesTrait.displayName}: {@code Exclude
     * repositories that are forks of another repository}.
     * 
     * @return
     *     {@code Exclude repositories that are forks of another repository}
     */
    public static Localizable _ExcludeForkedRepositoriesTrait_displayName() {
        return new Localizable(holder, "ExcludeForkedRepositoriesTrait.displayName");
    }

    /**
     * Key {@code GitHubBuildStatusNotification.CommitStatus.Unstable}:
     * {@code This commit failed tests or other validations}.
     * 
     * @return
     *     {@code This commit failed tests or other validations}
     */
    public static String GitHubBuildStatusNotification_CommitStatus_Unstable() {
        return holder.format("GitHubBuildStatusNotification.CommitStatus.Unstable");
    }

    /**
     * Key {@code GitHubBuildStatusNotification.CommitStatus.Unstable}:
     * {@code This commit failed tests or other validations}.
     * 
     * @return
     *     {@code This commit failed tests or other validations}
     */
    public static Localizable _GitHubBuildStatusNotification_CommitStatus_Unstable() {
        return new Localizable(holder, "GitHubBuildStatusNotification.CommitStatus.Unstable");
    }

    /**
     * Key {@code GitHubBuildStatusNotification.CommitStatus.Other}: {@code
     * Something is wrong with the build of this commit}.
     * 
     * @return
     *     {@code Something is wrong with the build of this commit}
     */
    public static String GitHubBuildStatusNotification_CommitStatus_Other() {
        return holder.format("GitHubBuildStatusNotification.CommitStatus.Other");
    }

    /**
     * Key {@code GitHubBuildStatusNotification.CommitStatus.Other}: {@code
     * Something is wrong with the build of this commit}.
     * 
     * @return
     *     {@code Something is wrong with the build of this commit}
     */
    public static Localizable _GitHubBuildStatusNotification_CommitStatus_Other() {
        return new Localizable(holder, "GitHubBuildStatusNotification.CommitStatus.Other");
    }

    /**
     * Key {@code TagDiscoveryTrait.displayName}: {@code Discover tags}.
     * 
     * @return
     *     {@code Discover tags}
     */
    public static String TagDiscoveryTrait_displayName() {
        return holder.format("TagDiscoveryTrait.displayName");
    }

    /**
     * Key {@code TagDiscoveryTrait.displayName}: {@code Discover tags}.
     * 
     * @return
     *     {@code Discover tags}
     */
    public static Localizable _TagDiscoveryTrait_displayName() {
        return new Localizable(holder, "TagDiscoveryTrait.displayName");
    }

    /**
     * Key {@code ApiRateLimitChecker.ThrottleOnOver}: {@code Throttle
     * at/near rate limit}.
     * 
     * @return
     *     {@code Throttle at/near rate limit}
     */
    public static String ApiRateLimitChecker_ThrottleOnOver() {
        return holder.format("ApiRateLimitChecker.ThrottleOnOver");
    }

    /**
     * Key {@code ApiRateLimitChecker.ThrottleOnOver}: {@code Throttle
     * at/near rate limit}.
     * 
     * @return
     *     {@code Throttle at/near rate limit}
     */
    public static Localizable _ApiRateLimitChecker_ThrottleOnOver() {
        return new Localizable(holder, "ApiRateLimitChecker.ThrottleOnOver");
    }

    /**
     * Key {@code GitHubOrgMetadataAction.IconDescription}: {@code GitHub
     * Organization}.
     * 
     * @return
     *     {@code GitHub Organization}
     */
    public static String GitHubOrgMetadataAction_IconDescription() {
        return holder.format("GitHubOrgMetadataAction.IconDescription");
    }

    /**
     * Key {@code GitHubOrgMetadataAction.IconDescription}: {@code GitHub
     * Organization}.
     * 
     * @return
     *     {@code GitHub Organization}
     */
    public static Localizable _GitHubOrgMetadataAction_IconDescription() {
        return new Localizable(holder, "GitHubOrgMetadataAction.IconDescription");
    }

    /**
     * Key {@code TagDiscoveryTrait.authorityDisplayName}: {@code Trust
     * origin tags}.
     * 
     * @return
     *     {@code Trust origin tags}
     */
    public static String TagDiscoveryTrait_authorityDisplayName() {
        return holder.format("TagDiscoveryTrait.authorityDisplayName");
    }

    /**
     * Key {@code TagDiscoveryTrait.authorityDisplayName}: {@code Trust
     * origin tags}.
     * 
     * @return
     *     {@code Trust origin tags}
     */
    public static Localizable _TagDiscoveryTrait_authorityDisplayName() {
        return new Localizable(holder, "TagDiscoveryTrait.authorityDisplayName");
    }

    /**
     * Key {@code GitHubSCMNavigator.Description}: {@code Scans a GitHub
     * organization (or user account) for all repositories matching some
     * defined markers.}.
     * 
     * @return
     *     {@code Scans a GitHub organization (or user account) for all
     *     repositories matching some defined markers.}
     */
    public static String GitHubSCMNavigator_Description() {
        return holder.format("GitHubSCMNavigator.Description");
    }

    /**
     * Key {@code GitHubSCMNavigator.Description}: {@code Scans a GitHub
     * organization (or user account) for all repositories matching some
     * defined markers.}.
     * 
     * @return
     *     {@code Scans a GitHub organization (or user account) for all
     *     repositories matching some defined markers.}
     */
    public static Localizable _GitHubSCMNavigator_Description() {
        return new Localizable(holder, "GitHubSCMNavigator.Description");
    }

    /**
     * Key {@code IgnoreDraftPullRequestFilterTrait.DisplayName}: {@code
     * Ignore pull requests marked as drafts}.
     * 
     * @return
     *     {@code Ignore pull requests marked as drafts}
     */
    public static String IgnoreDraftPullRequestFilterTrait_DisplayName() {
        return holder.format("IgnoreDraftPullRequestFilterTrait.DisplayName");
    }

    /**
     * Key {@code IgnoreDraftPullRequestFilterTrait.DisplayName}: {@code
     * Ignore pull requests marked as drafts}.
     * 
     * @return
     *     {@code Ignore pull requests marked as drafts}
     */
    public static Localizable _IgnoreDraftPullRequestFilterTrait_DisplayName() {
        return new Localizable(holder, "IgnoreDraftPullRequestFilterTrait.DisplayName");
    }

    /**
     * Key {@code ForkPullRequestDiscoveryTrait.everyoneDisplayName}: {@code
     * Everyone}.
     * 
     * @return
     *     {@code Everyone}
     */
    public static String ForkPullRequestDiscoveryTrait_everyoneDisplayName() {
        return holder.format("ForkPullRequestDiscoveryTrait.everyoneDisplayName");
    }

    /**
     * Key {@code ForkPullRequestDiscoveryTrait.everyoneDisplayName}: {@code
     * Everyone}.
     * 
     * @return
     *     {@code Everyone}
     */
    public static Localizable _ForkPullRequestDiscoveryTrait_everyoneDisplayName() {
        return new Localizable(holder, "ForkPullRequestDiscoveryTrait.everyoneDisplayName");
    }

    /**
     * Key {@code GitHubSCMNavigator.Pronoun}: {@code Organization}.
     * 
     * @return
     *     {@code Organization}
     */
    public static String GitHubSCMNavigator_Pronoun() {
        return holder.format("GitHubSCMNavigator.Pronoun");
    }

    /**
     * Key {@code GitHubSCMNavigator.Pronoun}: {@code Organization}.
     * 
     * @return
     *     {@code Organization}
     */
    public static Localizable _GitHubSCMNavigator_Pronoun() {
        return new Localizable(holder, "GitHubSCMNavigator.Pronoun");
    }

    /**
     * Key {@code TeamSlugTrait.displayName}: {@code Github team slug}.
     * 
     * @return
     *     {@code Github team slug}
     */
    public static String TeamSlugTrait_displayName() {
        return holder.format("TeamSlugTrait.displayName");
    }

    /**
     * Key {@code TeamSlugTrait.displayName}: {@code Github team slug}.
     * 
     * @return
     *     {@code Github team slug}
     */
    public static Localizable _TeamSlugTrait_displayName() {
        return new Localizable(holder, "TeamSlugTrait.displayName");
    }

    /**
     * Key {@code GitHubAppCredentials.displayName}: {@code GitHub App}.
     * 
     * @return
     *     {@code GitHub App}
     */
    public static String GitHubAppCredentials_displayName() {
        return holder.format("GitHubAppCredentials.displayName");
    }

    /**
     * Key {@code GitHubAppCredentials.displayName}: {@code GitHub App}.
     * 
     * @return
     *     {@code GitHub App}
     */
    public static Localizable _GitHubAppCredentials_displayName() {
        return new Localizable(holder, "GitHubAppCredentials.displayName");
    }

    /**
     * Key {@code SSHCheckoutTrait.displayName}: {@code Checkout over SSH}.
     * 
     * @return
     *     {@code Checkout over SSH}
     */
    public static String SSHCheckoutTrait_displayName() {
        return holder.format("SSHCheckoutTrait.displayName");
    }

    /**
     * Key {@code SSHCheckoutTrait.displayName}: {@code Checkout over SSH}.
     * 
     * @return
     *     {@code Checkout over SSH}
     */
    public static Localizable _SSHCheckoutTrait_displayName() {
        return new Localizable(holder, "SSHCheckoutTrait.displayName");
    }

    /**
     * Key {@code GitHubPullRequestFilter.DisplayName}: {@code GitHub Pull
     * Request Jobs Only}.
     * 
     * @return
     *     {@code GitHub Pull Request Jobs Only}
     */
    public static String GitHubPullRequestFilter_DisplayName() {
        return holder.format("GitHubPullRequestFilter.DisplayName");
    }

    /**
     * Key {@code GitHubPullRequestFilter.DisplayName}: {@code GitHub Pull
     * Request Jobs Only}.
     * 
     * @return
     *     {@code GitHub Pull Request Jobs Only}
     */
    public static Localizable _GitHubPullRequestFilter_DisplayName() {
        return new Localizable(holder, "GitHubPullRequestFilter.DisplayName");
    }

    /**
     * Key {@code GitHubBuildStatusNotification.CommitStatus.Pending}: {@code
     * This commit is being built}.
     * 
     * @return
     *     {@code This commit is being built}
     */
    public static String GitHubBuildStatusNotification_CommitStatus_Pending() {
        return holder.format("GitHubBuildStatusNotification.CommitStatus.Pending");
    }

    /**
     * Key {@code GitHubBuildStatusNotification.CommitStatus.Pending}: {@code
     * This commit is being built}.
     * 
     * @return
     *     {@code This commit is being built}
     */
    public static Localizable _GitHubBuildStatusNotification_CommitStatus_Pending() {
        return new Localizable(holder, "GitHubBuildStatusNotification.CommitStatus.Pending");
    }

    /**
     * Key {@code GitHubSCMSource.CouldNotConnectionGithub}: {@code Could not
     * connect github with credential: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Could not connect github with credential: {0}}
     */
    public static String GitHubSCMSource_CouldNotConnectionGithub(Object arg0) {
        return holder.format("GitHubSCMSource.CouldNotConnectionGithub", arg0);
    }

    /**
     * Key {@code GitHubSCMSource.CouldNotConnectionGithub}: {@code Could not
     * connect github with credential: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Could not connect github with credential: {0}}
     */
    public static Localizable _GitHubSCMSource_CouldNotConnectionGithub(Object arg0) {
        return new Localizable(holder, "GitHubSCMSource.CouldNotConnectionGithub", arg0);
    }

    /**
     * Key {@code OriginPullRequestDiscoveryTrait.authorityDisplayName}:
     * {@code Trust origin pull requests}.
     * 
     * @return
     *     {@code Trust origin pull requests}
     */
    public static String OriginPullRequestDiscoveryTrait_authorityDisplayName() {
        return holder.format("OriginPullRequestDiscoveryTrait.authorityDisplayName");
    }

    /**
     * Key {@code OriginPullRequestDiscoveryTrait.authorityDisplayName}:
     * {@code Trust origin pull requests}.
     * 
     * @return
     *     {@code Trust origin pull requests}
     */
    public static Localizable _OriginPullRequestDiscoveryTrait_authorityDisplayName() {
        return new Localizable(holder, "OriginPullRequestDiscoveryTrait.authorityDisplayName");
    }

    /**
     * Key {@code BranchDiscoveryTrait.onlyPRs}: {@code Only branches that
     * are also filed as PRs}.
     * 
     * @return
     *     {@code Only branches that are also filed as PRs}
     */
    public static String BranchDiscoveryTrait_onlyPRs() {
        return holder.format("BranchDiscoveryTrait.onlyPRs");
    }

    /**
     * Key {@code BranchDiscoveryTrait.onlyPRs}: {@code Only branches that
     * are also filed as PRs}.
     * 
     * @return
     *     {@code Only branches that are also filed as PRs}
     */
    public static Localizable _BranchDiscoveryTrait_onlyPRs() {
        return new Localizable(holder, "BranchDiscoveryTrait.onlyPRs");
    }

    /**
     * Key {@code ForkPullRequestDiscoveryTrait.headAndMerge}: {@code Both
     * the current pull request revision and the pull request merged with the
     * current target branch revision}.
     * 
     * @return
     *     {@code Both the current pull request revision and the pull request
     *     merged with the current target branch revision}
     */
    public static String ForkPullRequestDiscoveryTrait_headAndMerge() {
        return holder.format("ForkPullRequestDiscoveryTrait.headAndMerge");
    }

    /**
     * Key {@code ForkPullRequestDiscoveryTrait.headAndMerge}: {@code Both
     * the current pull request revision and the pull request merged with the
     * current target branch revision}.
     * 
     * @return
     *     {@code Both the current pull request revision and the pull request
     *     merged with the current target branch revision}
     */
    public static Localizable _ForkPullRequestDiscoveryTrait_headAndMerge() {
        return new Localizable(holder, "ForkPullRequestDiscoveryTrait.headAndMerge");
    }

    /**
     * Key {@code ExcludePrivateRepositoriesTrait.displayName}: {@code
     * Exclude private repositories}.
     * 
     * @return
     *     {@code Exclude private repositories}
     */
    public static String ExcludePrivateRepositoriesTrait_displayName() {
        return holder.format("ExcludePrivateRepositoriesTrait.displayName");
    }

    /**
     * Key {@code ExcludePrivateRepositoriesTrait.displayName}: {@code
     * Exclude private repositories}.
     * 
     * @return
     *     {@code Exclude private repositories}
     */
    public static Localizable _ExcludePrivateRepositoriesTrait_displayName() {
        return new Localizable(holder, "ExcludePrivateRepositoriesTrait.displayName");
    }

    /**
     * Key {@code GitHubSCMSource.Pronoun}: {@code Repository}.
     * 
     * @return
     *     {@code Repository}
     */
    public static String GitHubSCMSource_Pronoun() {
        return holder.format("GitHubSCMSource.Pronoun");
    }

    /**
     * Key {@code GitHubSCMSource.Pronoun}: {@code Repository}.
     * 
     * @return
     *     {@code Repository}
     */
    public static Localizable _GitHubSCMSource_Pronoun() {
        return new Localizable(holder, "GitHubSCMSource.Pronoun");
    }

    /**
     * Key {@code SSHCheckoutTrait.missingCredentials}: {@code The currently
     * configured credentials cannot be found}.
     * 
     * @return
     *     {@code The currently configured credentials cannot be found}
     */
    public static String SSHCheckoutTrait_missingCredentials() {
        return holder.format("SSHCheckoutTrait.missingCredentials");
    }

    /**
     * Key {@code SSHCheckoutTrait.missingCredentials}: {@code The currently
     * configured credentials cannot be found}.
     * 
     * @return
     *     {@code The currently configured credentials cannot be found}
     */
    public static Localizable _SSHCheckoutTrait_missingCredentials() {
        return new Localizable(holder, "SSHCheckoutTrait.missingCredentials");
    }

    /**
     * Key {@code GitHubSCMSource.TagCategory}: {@code Tags}.
     * 
     * @return
     *     {@code Tags}
     */
    public static String GitHubSCMSource_TagCategory() {
        return holder.format("GitHubSCMSource.TagCategory");
    }

    /**
     * Key {@code GitHubSCMSource.TagCategory}: {@code Tags}.
     * 
     * @return
     *     {@code Tags}
     */
    public static Localizable _GitHubSCMSource_TagCategory() {
        return new Localizable(holder, "GitHubSCMSource.TagCategory");
    }

    /**
     * Key {@code
     * OriginPullRequestDiscoveryTrait.discoverPullRequestsFromOrigin}:
     * {@code Discover pull requests from origin}.
     * 
     * @return
     *     {@code Discover pull requests from origin}
     */
    public static String OriginPullRequestDiscoveryTrait_discoverPullRequestsFromOrigin() {
        return holder.format("OriginPullRequestDiscoveryTrait.discoverPullRequestsFromOrigin");
    }

    /**
     * Key {@code
     * OriginPullRequestDiscoveryTrait.discoverPullRequestsFromOrigin}:
     * {@code Discover pull requests from origin}.
     * 
     * @return
     *     {@code Discover pull requests from origin}
     */
    public static Localizable _OriginPullRequestDiscoveryTrait_discoverPullRequestsFromOrigin() {
        return new Localizable(holder, "OriginPullRequestDiscoveryTrait.discoverPullRequestsFromOrigin");
    }

    /**
     * Key {@code GitHubSCMSource.UncategorizedCategory}: {@code Branches}.
     * 
     * @return
     *     {@code Branches}
     */
    public static String GitHubSCMSource_UncategorizedCategory() {
        return holder.format("GitHubSCMSource.UncategorizedCategory");
    }

    /**
     * Key {@code GitHubSCMSource.UncategorizedCategory}: {@code Branches}.
     * 
     * @return
     *     {@code Branches}
     */
    public static Localizable _GitHubSCMSource_UncategorizedCategory() {
        return new Localizable(holder, "GitHubSCMSource.UncategorizedCategory");
    }

    /**
     * Key {@code SSHCheckoutTrait.useAgentKey}: {@code - use build agent''s
     * key -}.
     * 
     * @return
     *     {@code - use build agent''s key -}
     */
    public static String SSHCheckoutTrait_useAgentKey() {
        return holder.format("SSHCheckoutTrait.useAgentKey");
    }

    /**
     * Key {@code SSHCheckoutTrait.useAgentKey}: {@code - use build agent''s
     * key -}.
     * 
     * @return
     *     {@code - use build agent''s key -}
     */
    public static Localizable _SSHCheckoutTrait_useAgentKey() {
        return new Localizable(holder, "SSHCheckoutTrait.useAgentKey");
    }

    /**
     * Key {@code ApiRateLimitChecker.NoThrottle}: {@code Never check rate
     * limit (NOT RECOMMENDED)}.
     * 
     * @return
     *     {@code Never check rate limit (NOT RECOMMENDED)}
     */
    public static String ApiRateLimitChecker_NoThrottle() {
        return holder.format("ApiRateLimitChecker.NoThrottle");
    }

    /**
     * Key {@code ApiRateLimitChecker.NoThrottle}: {@code Never check rate
     * limit (NOT RECOMMENDED)}.
     * 
     * @return
     *     {@code Never check rate limit (NOT RECOMMENDED)}
     */
    public static Localizable _ApiRateLimitChecker_NoThrottle() {
        return new Localizable(holder, "ApiRateLimitChecker.NoThrottle");
    }

    /**
     * Key {@code BranchDiscoveryTrait.allBranches}: {@code All branches}.
     * 
     * @return
     *     {@code All branches}
     */
    public static String BranchDiscoveryTrait_allBranches() {
        return holder.format("BranchDiscoveryTrait.allBranches");
    }

    /**
     * Key {@code BranchDiscoveryTrait.allBranches}: {@code All branches}.
     * 
     * @return
     *     {@code All branches}
     */
    public static Localizable _BranchDiscoveryTrait_allBranches() {
        return new Localizable(holder, "BranchDiscoveryTrait.allBranches");
    }

    /**
     * Key {@code BranchDiscoveryTrait.displayName}: {@code Discover
     * branches}.
     * 
     * @return
     *     {@code Discover branches}
     */
    public static String BranchDiscoveryTrait_displayName() {
        return holder.format("BranchDiscoveryTrait.displayName");
    }

    /**
     * Key {@code BranchDiscoveryTrait.displayName}: {@code Discover
     * branches}.
     * 
     * @return
     *     {@code Discover branches}
     */
    public static Localizable _BranchDiscoveryTrait_displayName() {
        return new Localizable(holder, "BranchDiscoveryTrait.displayName");
    }

    /**
     * Key {@code ForkPullRequestDiscoveryTrait.permissionsDisplayName}:
     * {@code From users with Admin or Write permission}.
     * 
     * @return
     *     {@code From users with Admin or Write permission}
     */
    public static String ForkPullRequestDiscoveryTrait_permissionsDisplayName() {
        return holder.format("ForkPullRequestDiscoveryTrait.permissionsDisplayName");
    }

    /**
     * Key {@code ForkPullRequestDiscoveryTrait.permissionsDisplayName}:
     * {@code From users with Admin or Write permission}.
     * 
     * @return
     *     {@code From users with Admin or Write permission}
     */
    public static Localizable _ForkPullRequestDiscoveryTrait_permissionsDisplayName() {
        return new Localizable(holder, "ForkPullRequestDiscoveryTrait.permissionsDisplayName");
    }

    /**
     * Key {@code GitHubBuildStatusNotification.CommitStatus.Failure}: {@code
     * This commit cannot be built}.
     * 
     * @return
     *     {@code This commit cannot be built}
     */
    public static String GitHubBuildStatusNotification_CommitStatus_Failure() {
        return holder.format("GitHubBuildStatusNotification.CommitStatus.Failure");
    }

    /**
     * Key {@code GitHubBuildStatusNotification.CommitStatus.Failure}: {@code
     * This commit cannot be built}.
     * 
     * @return
     *     {@code This commit cannot be built}
     */
    public static Localizable _GitHubBuildStatusNotification_CommitStatus_Failure() {
        return new Localizable(holder, "GitHubBuildStatusNotification.CommitStatus.Failure");
    }

    /**
     * Key {@code GitHubSCMSource.did_you_mean_to_use_to_match_all_branches}:
     * {@code Did you mean to use * to match all branches?}.
     * 
     * @return
     *     {@code Did you mean to use * to match all branches?}
     */
    public static String GitHubSCMSource_did_you_mean_to_use_to_match_all_branches() {
        return holder.format("GitHubSCMSource.did_you_mean_to_use_to_match_all_branches");
    }

    /**
     * Key {@code GitHubSCMSource.did_you_mean_to_use_to_match_all_branches}:
     * {@code Did you mean to use * to match all branches?}.
     * 
     * @return
     *     {@code Did you mean to use * to match all branches?}
     */
    public static Localizable _GitHubSCMSource_did_you_mean_to_use_to_match_all_branches() {
        return new Localizable(holder, "GitHubSCMSource.did_you_mean_to_use_to_match_all_branches");
    }

    /**
     * Key {@code SSHCheckoutTrait.incompatibleCredentials}: {@code The
     * currently configured credentials are incompatible with this
     * behaviour}.
     * 
     * @return
     *     {@code The currently configured credentials are incompatible with this
     *     behaviour}
     */
    public static String SSHCheckoutTrait_incompatibleCredentials() {
        return holder.format("SSHCheckoutTrait.incompatibleCredentials");
    }

    /**
     * Key {@code SSHCheckoutTrait.incompatibleCredentials}: {@code The
     * currently configured credentials are incompatible with this
     * behaviour}.
     * 
     * @return
     *     {@code The currently configured credentials are incompatible with this
     *     behaviour}
     */
    public static Localizable _SSHCheckoutTrait_incompatibleCredentials() {
        return new Localizable(holder, "SSHCheckoutTrait.incompatibleCredentials");
    }

    /**
     * Key {@code GitHubLink.DisplayName}: {@code GitHub}.
     * 
     * @return
     *     {@code GitHub}
     */
    public static String GitHubLink_DisplayName() {
        return holder.format("GitHubLink.DisplayName");
    }

    /**
     * Key {@code GitHubLink.DisplayName}: {@code GitHub}.
     * 
     * @return
     *     {@code GitHub}
     */
    public static Localizable _GitHubLink_DisplayName() {
        return new Localizable(holder, "GitHubLink.DisplayName");
    }

    /**
     * Key {@code ExcludeArchivedRepositoriesTrait.displayName}: {@code
     * Exclude archived repositories}.
     * 
     * @return
     *     {@code Exclude archived repositories}
     */
    public static String ExcludeArchivedRepositoriesTrait_displayName() {
        return holder.format("ExcludeArchivedRepositoriesTrait.displayName");
    }

    /**
     * Key {@code ExcludeArchivedRepositoriesTrait.displayName}: {@code
     * Exclude archived repositories}.
     * 
     * @return
     *     {@code Exclude archived repositories}
     */
    public static Localizable _ExcludeArchivedRepositoriesTrait_displayName() {
        return new Localizable(holder, "ExcludeArchivedRepositoriesTrait.displayName");
    }

    /**
     * Key {@code GitHubSCMNavigator.UncategorizedCategory}: {@code
     * Repositories}.
     * 
     * @return
     *     {@code Repositories}
     */
    public static String GitHubSCMNavigator_UncategorizedCategory() {
        return holder.format("GitHubSCMNavigator.UncategorizedCategory");
    }

    /**
     * Key {@code GitHubSCMNavigator.UncategorizedCategory}: {@code
     * Repositories}.
     * 
     * @return
     *     {@code Repositories}
     */
    public static Localizable _GitHubSCMNavigator_UncategorizedCategory() {
        return new Localizable(holder, "GitHubSCMNavigator.UncategorizedCategory");
    }

    /**
     * Key {@code BranchSCMHead.Pronoun}: {@code Branch}.
     * 
     * @return
     *     {@code Branch}
     */
    public static String BranchSCMHead_Pronoun() {
        return holder.format("BranchSCMHead.Pronoun");
    }

    /**
     * Key {@code BranchSCMHead.Pronoun}: {@code Branch}.
     * 
     * @return
     *     {@code Branch}
     */
    public static Localizable _BranchSCMHead_Pronoun() {
        return new Localizable(holder, "BranchSCMHead.Pronoun");
    }

}
