/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.extensions.impl;

import hudson.Extension;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.extensions.GitSCMExtension;
import hudson.plugins.git.extensions.GitSCMExtensionDescriptor;
import java.io.IOException;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.kohsuke.stapler.DataBoundConstructor;

public class WipeWorkspace
extends GitSCMExtension {
    @DataBoundConstructor
    public WipeWorkspace() {
    }

    @Override
    public void beforeCheckout(GitSCM scm, Run<?, ?> build, GitClient git, TaskListener listener) throws IOException, InterruptedException, GitException {
        if (build != null && build.getClass().getName().startsWith("org.jenkinsci.plugins.workflow.job.")) {
            listener.getLogger().println("DEPRECATED: The 'Wipe out repository & force clone' extension is deprecated for Pipeline jobs. Pipeline users should use the deleteDir() step instead.");
        }
        listener.getLogger().println("Wiping out workspace first.");
        git.getWorkTree().deleteContents();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        return o instanceof WipeWorkspace;
    }

    public int hashCode() {
        return WipeWorkspace.class.hashCode();
    }

    public String toString() {
        return "WipeWorkspace{}";
    }

    @Extension
    public static class DescriptorImpl
    extends GitSCMExtensionDescriptor {
        public String getDisplayName() {
            return "Wipe out repository & force clone";
        }
    }
}

