/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.PersistentDescriptor;
import hudson.plugins.git.GitException;
import hudson.remoting.Channel;
import java.io.IOException;
import jenkins.model.GlobalConfiguration;
import jenkins.model.GlobalConfigurationCategory;
import jenkins.plugins.git.DisableHooks;
import jenkins.plugins.git.UnsetHooks;
import org.eclipse.jgit.lib.Repository;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.gitclient.RepositoryCallback;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
@Symbol(value={"gitHooks"})
@Restricted(value={NoExternalUse.class})
public class GitHooksConfiguration
extends GlobalConfiguration
implements PersistentDescriptor {
    private boolean allowedOnController = false;
    private boolean allowedOnAgents = false;

    @NonNull
    public static GitHooksConfiguration get() {
        GitHooksConfiguration configuration = (GitHooksConfiguration)((Object)GlobalConfiguration.all().get(GitHooksConfiguration.class));
        if (configuration == null) {
            throw new IllegalStateException("[BUG] No configuration registered, make sure not running on an agent or that Jenkins has started properly.");
        }
        return configuration;
    }

    public boolean isAllowedOnController() {
        return this.allowedOnController;
    }

    public void setAllowedOnController(boolean allowedOnController) {
        this.allowedOnController = allowedOnController;
        this.save();
    }

    public boolean isAllowedOnAgents() {
        return this.allowedOnAgents;
    }

    public void setAllowedOnAgents(boolean allowedOnAgents) {
        this.allowedOnAgents = allowedOnAgents;
        this.save();
    }

    @NonNull
    public GlobalConfigurationCategory getCategory() {
        return GlobalConfigurationCategory.get(GlobalConfigurationCategory.Security.class);
    }

    public static void configure(GitClient client) throws GitException, IOException, InterruptedException {
        GitHooksConfiguration configuration = GitHooksConfiguration.get();
        GitHooksConfiguration.configure(client, configuration.isAllowedOnController(), configuration.isAllowedOnAgents());
    }

    public static void configure(GitClient client, boolean allowedOnController, boolean allowedOnAgents) throws GitException, IOException, InterruptedException {
        if (Channel.current() == null) {
            try (Repository ignored = client.getRepository();){
                GitHooksConfiguration.configure(client, allowedOnController);
            }
            catch (UnsupportedOperationException e) {
                GitHooksConfiguration.configure(client, allowedOnAgents);
            }
        } else {
            GitHooksConfiguration.configure(client, allowedOnAgents);
        }
    }

    public static void configure(GitClient client, boolean allowed) throws GitException, IOException, InterruptedException {
        if (!allowed) {
            client.withRepository((RepositoryCallback)new DisableHooks());
        } else {
            client.withRepository((RepositoryCallback)new UnsetHooks());
        }
    }
}

