/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.browser;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.scm.EditType;
import hudson.scm.RepositoryBrowser;
import java.io.IOException;
import java.net.URL;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest2;

public class RedmineWeb
extends GitRepositoryBrowser {
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public RedmineWeb(String repoUrl) {
        super(repoUrl);
    }

    public URL getChangeSetLink(GitChangeSet changeSet) throws IOException {
        URL url = this.getUrl();
        return new URL(url, "diff?rev=" + changeSet.getId());
    }

    @Override
    public URL getDiffLink(GitChangeSet.Path path) throws IOException {
        GitChangeSet changeSet = path.getChangeSet();
        URL url = this.getUrl();
        URL changeSetLink = new URL(url, "revisions/" + changeSet.getId());
        URL difflink = path.getEditType().equals(EditType.ADD) ? this.getFileLink(path) : new URL(changeSetLink, changeSetLink.getPath() + "/diff/" + path.getPath());
        return difflink;
    }

    @Override
    public URL getFileLink(GitChangeSet.Path path) throws IOException {
        if (path.getEditType().equals(EditType.DELETE)) {
            return RedmineWeb.encodeURL(this.getDiffLink(path));
        }
        String spec = "revisions/" + path.getChangeSet().getId() + "/entry/" + path.getPath();
        URL url = this.getUrl();
        return RedmineWeb.encodeURL(new URL(url, url.getPath() + spec));
    }

    @Extension
    @Symbol(value={"redmine"})
    public static class RedmineWebDescriptor
    extends Descriptor<RepositoryBrowser<?>> {
        @NonNull
        public String getDisplayName() {
            return "redmineweb";
        }

        public RedmineWeb newInstance(@NonNull StaplerRequest2 req, @NonNull JSONObject jsonObject) throws Descriptor.FormException {
            return (RedmineWeb)((Object)req.bindJSON(RedmineWeb.class, jsonObject));
        }
    }
}

