/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git.traits;

import hudson.Util;
import hudson.model.Descriptor;
import hudson.plugins.git.extensions.GitSCMExtension;
import java.util.ArrayList;
import java.util.List;
import jenkins.plugins.git.traits.GitSCMExtensionTraitDescriptor;
import jenkins.scm.api.trait.SCMSourceTrait;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.ClassRule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;

public class GitSCMExtensionTraitTest {
    @ClassRule
    public static JenkinsRule r = new JenkinsRule();

    public List<GitSCMExtensionTraitDescriptor> descriptors() {
        ArrayList<GitSCMExtensionTraitDescriptor> list = new ArrayList<GitSCMExtensionTraitDescriptor>();
        for (Descriptor d : SCMSourceTrait.all()) {
            if (!(d instanceof GitSCMExtensionTraitDescriptor)) continue;
            GitSCMExtensionTraitDescriptor descriptor = (GitSCMExtensionTraitDescriptor)d;
            list.add(descriptor);
        }
        return list;
    }

    @Test
    public void extensionClassesOverrideEquals() {
        for (GitSCMExtensionTraitDescriptor d : this.descriptors()) {
            MatcherAssert.assertThat((String)(d.getExtensionClass().getName() + " overrides equals(Object)"), (Object)Util.isOverridden(GitSCMExtension.class, (Class)d.getExtensionClass(), (String)"equals", (Class[])new Class[]{Object.class}), (Matcher)Matchers.is((Object)true));
        }
    }

    @Test
    public void extensionClassesOverrideHashCode() {
        for (GitSCMExtensionTraitDescriptor d : this.descriptors()) {
            MatcherAssert.assertThat((String)(d.getExtensionClass().getName() + " overrides hashCode()"), (Object)Util.isOverridden(GitSCMExtension.class, (Class)d.getExtensionClass(), (String)"hashCode", (Class[])new Class[0]), (Matcher)Matchers.is((Object)true));
        }
    }

    @Test
    public void extensionClassesOverrideToString() {
        for (GitSCMExtensionTraitDescriptor d : this.descriptors()) {
            MatcherAssert.assertThat((String)(d.getExtensionClass().getName() + " overrides toString()"), (Object)Util.isOverridden(GitSCMExtension.class, (Class)d.getExtensionClass(), (String)"toString", (Class[])new Class[0]), (Matcher)Matchers.is((Object)true));
        }
    }
}

