/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.UserRemoteConfig;
import java.util.ArrayList;
import java.util.List;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.eclipse.jgit.transport.RefSpec;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class AbstractGitSCMSourceTrivialTest {
    private AbstractGitSCMSource gitSCMSource = null;
    private final String expectedCredentialsId = "expected-credentials-id";
    private final String expectedIncludes = "*master release* fe?ture substring";
    private final String expectedExcludes = "release bugfix*";
    private final String expectedRemote = "origin";
    private final String expectedRefSpec = "+refs/heads/*:refs/remotes/origin/*";
    private final List<RefSpec> expectedRefSpecs = new ArrayList<RefSpec>();

    @Before
    public void setUp() throws Exception {
        if (this.expectedRefSpecs.isEmpty()) {
            this.expectedRefSpecs.add(new RefSpec("+refs/heads/*:refs/remotes/origin/*"));
        }
        this.gitSCMSource = new AbstractGitSCMSourceImpl();
    }

    @Test
    @Deprecated
    public void basicTestIsExcluded() {
        AbstractGitSCMSource abstractGitSCMSource = (AbstractGitSCMSource)Mockito.mock(AbstractGitSCMSource.class);
        Mockito.when((Object)abstractGitSCMSource.getIncludes()).thenReturn((Object)"*master release* fe?ture");
        Mockito.when((Object)abstractGitSCMSource.getExcludes()).thenReturn((Object)"release bugfix*");
        Mockito.when((Object)abstractGitSCMSource.isExcluded(Mockito.anyString())).thenCallRealMethod();
        Assert.assertFalse((boolean)abstractGitSCMSource.isExcluded("master"));
        Assert.assertFalse((boolean)abstractGitSCMSource.isExcluded("remote/master"));
        Assert.assertFalse((boolean)abstractGitSCMSource.isExcluded("release/X.Y"));
        Assert.assertFalse((boolean)abstractGitSCMSource.isExcluded("releaseX.Y"));
        Assert.assertFalse((boolean)abstractGitSCMSource.isExcluded("fe?ture"));
        Assert.assertTrue((boolean)abstractGitSCMSource.isExcluded("feature"));
        Assert.assertTrue((boolean)abstractGitSCMSource.isExcluded("release"));
        Assert.assertTrue((boolean)abstractGitSCMSource.isExcluded("bugfix"));
        Assert.assertTrue((boolean)abstractGitSCMSource.isExcluded("bugfix/test"));
        Assert.assertTrue((boolean)abstractGitSCMSource.isExcluded("test"));
        Mockito.when((Object)abstractGitSCMSource.getIncludes()).thenReturn((Object)"master feature/*");
        Mockito.when((Object)abstractGitSCMSource.getExcludes()).thenReturn((Object)"feature/*/private");
        Assert.assertFalse((boolean)abstractGitSCMSource.isExcluded("master"));
        Assert.assertTrue((boolean)abstractGitSCMSource.isExcluded("devel"));
        Assert.assertFalse((boolean)abstractGitSCMSource.isExcluded("feature/spiffy"));
        Assert.assertTrue((boolean)abstractGitSCMSource.isExcluded("feature/spiffy/private"));
    }

    @Test
    public void testGetCredentialsId() {
        Assert.assertEquals((Object)"expected-credentials-id", (Object)this.gitSCMSource.getCredentialsId());
    }

    @Test
    public void testGetRemote() {
        Assert.assertEquals((Object)"origin", (Object)this.gitSCMSource.getRemote());
    }

    @Test
    @Deprecated
    public void testGetIncludes() {
        Assert.assertEquals((Object)"*master release* fe?ture substring", (Object)this.gitSCMSource.getIncludes());
    }

    @Test
    @Deprecated
    public void testGetExcludes() {
        Assert.assertEquals((Object)"release bugfix*", (Object)this.gitSCMSource.getExcludes());
    }

    @Test
    @Deprecated
    public void testGetRemoteName() {
        Assert.assertEquals((Object)"origin", (Object)this.gitSCMSource.getRemoteName());
    }

    @Test
    @Deprecated
    public void testGetRefSpecs() {
        Assert.assertEquals(this.expectedRefSpecs, (Object)this.gitSCMSource.getRefSpecs());
    }

    @Test
    @Deprecated
    public void testIsExcluded() {
        Assert.assertFalse((boolean)this.gitSCMSource.isExcluded("master"));
        Assert.assertFalse((boolean)this.gitSCMSource.isExcluded("remote/master"));
        Assert.assertFalse((boolean)this.gitSCMSource.isExcluded("release/X.Y"));
        Assert.assertFalse((boolean)this.gitSCMSource.isExcluded("releaseX.Y"));
        Assert.assertFalse((boolean)this.gitSCMSource.isExcluded("fe?ture"));
        Assert.assertFalse((boolean)this.gitSCMSource.isExcluded("substring"));
        Assert.assertTrue((boolean)this.gitSCMSource.isExcluded("feature"));
        Assert.assertTrue((boolean)this.gitSCMSource.isExcluded("test"));
        Assert.assertTrue((boolean)this.gitSCMSource.isExcluded("foo/substring"));
        Assert.assertTrue((boolean)this.gitSCMSource.isExcluded("substring/end"));
        Assert.assertTrue((boolean)this.gitSCMSource.isExcluded("substring1"));
        Assert.assertTrue((boolean)this.gitSCMSource.isExcluded("remote/substring2"));
        Assert.assertTrue((boolean)this.gitSCMSource.isExcluded("origin/substring"));
        Assert.assertTrue((boolean)this.gitSCMSource.isExcluded("release"));
        Assert.assertTrue((boolean)this.gitSCMSource.isExcluded("bugfix"));
        Assert.assertTrue((boolean)this.gitSCMSource.isExcluded("bugfix/test"));
    }

    @Test
    @Deprecated
    public void testGetRemoteConfigs() {
        List remoteConfigs = this.gitSCMSource.getRemoteConfigs();
        Assert.assertEquals((Object)"origin", (Object)((UserRemoteConfig)remoteConfigs.get(0)).getName());
        Assert.assertEquals((Object)"+refs/heads/*:refs/remotes/origin/*", (Object)((UserRemoteConfig)remoteConfigs.get(0)).getRefspec());
        Assert.assertEquals((String)"Wrong number of entries in remoteConfigs", (long)1L, (long)remoteConfigs.size());
    }

    @Test
    public void testBuild() {
        String expectedBranchName = "origin/master";
        SCMHead head = new SCMHead("origin/master");
        SCMRevisionImpl revision = new SCMRevisionImpl(head);
        GitSCM gitSCM = (GitSCM)this.gitSCMSource.build(head, (SCMRevision)revision);
        List remoteConfigs = gitSCM.getUserRemoteConfigs();
        Assert.assertEquals((Object)"origin", (Object)((UserRemoteConfig)remoteConfigs.get(0)).getName());
        Assert.assertEquals((Object)"+refs/heads/*:refs/remotes/origin/*", (Object)((UserRemoteConfig)remoteConfigs.get(0)).getRefspec());
        Assert.assertEquals((String)"Wrong number of entries in remoteConfigs", (long)1L, (long)remoteConfigs.size());
        List branches = gitSCM.getBranches();
        Assert.assertEquals((Object)"origin/master", (Object)((BranchSpec)branches.get(0)).getName());
        Assert.assertEquals((String)"Wrong number of branches", (long)1L, (long)branches.size());
    }

    @Test
    public void equalsContractSCMRevisionImpl() {
        EqualsVerifier.forClass(AbstractGitSCMSource.SCMRevisionImpl.class).usingGetClass().verify();
    }

    public class AbstractGitSCMSourceImpl
    extends AbstractGitSCMSource {
        public AbstractGitSCMSourceImpl() {
            this.setId("AbstractGitSCMSourceImpl-id");
        }

        public String getCredentialsId() {
            return "expected-credentials-id";
        }

        public String getRemote() {
            return "origin";
        }

        @Deprecated
        public String getIncludes() {
            return "*master release* fe?ture substring";
        }

        @Deprecated
        public String getExcludes() {
            return "release bugfix*";
        }

        @Deprecated
        public List<RefSpec> getRefSpecs() {
            return AbstractGitSCMSourceTrivialTest.this.expectedRefSpecs;
        }
    }

    private class SCMRevisionImpl
    extends SCMRevision {
        protected SCMRevisionImpl(SCMHead scmh) {
            super(scmh);
        }

        public boolean equals(Object o) {
            throw new UnsupportedOperationException("Intentionally unimplemented");
        }

        public int hashCode() {
            throw new UnsupportedOperationException("Intentionally unimplemented");
        }
    }
}

