/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.FreeStyleBuild;
import hudson.model.FreeStyleProject;
import hudson.model.JobProperty;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Run;
import hudson.model.StringParameterDefinition;
import hudson.model.View;
import hudson.plugins.git.AbstractGitProject;
import hudson.plugins.git.ApiTokenPropertyConfiguration;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.GitStatus;
import hudson.plugins.git.UserRemoteConfig;
import hudson.scm.SCM;
import hudson.tasks.BatchFile;
import hudson.tasks.Shell;
import hudson.triggers.SCMTrigger;
import hudson.triggers.Trigger;
import hudson.util.RunList;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class GitStatusTest
extends AbstractGitProject {
    private GitStatus gitStatus;
    private HttpServletRequest requestWithNoParameter;
    private HttpServletRequest requestWithParameter;
    private String repoURL;
    private String branch;
    private String sha1;
    private String notifyCommitApiToken;

    @Before
    public void setUp() throws Exception {
        GitStatus.setAllowNotifyCommitParameters((boolean)false);
        GitStatus.setSafeParametersForTest(null);
        this.gitStatus = new GitStatus();
        this.requestWithNoParameter = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        this.requestWithParameter = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        this.repoURL = new File(".").getAbsolutePath();
        this.branch = "**";
        this.sha1 = "7bb68ef21dc90bd4f7b08eca876203b2e049198d";
        if (this.r.jenkins != null) {
            this.notifyCommitApiToken = ApiTokenPropertyConfiguration.get().generateApiToken("test").getString("value");
        }
    }

    @After
    public void resetAllowNotifyCommitParameters() throws Exception {
        GitStatus.setAllowNotifyCommitParameters((boolean)false);
        GitStatus.setSafeParametersForTest(null);
    }

    @After
    public void waitForAllJobsToComplete() throws Exception {
        this.r.jenkins.doQuietDown();
        Random random = new Random();
        Thread.sleep(500L + (long)random.nextInt(400));
        View allView = this.r.jenkins.getView("All");
        if (allView == null) {
            Assert.fail((String)"All view was not found when it should always be available");
            return;
        }
        RunList runList = allView.getBuilds();
        if (runList == null) {
            Logger.getLogger(GitStatusTest.class.getName()).log(Level.INFO, "No waiting, no entries in the runList");
            return;
        }
        runList.forEach(run -> {
            try {
                Logger.getLogger(GitStatusTest.class.getName()).log(Level.INFO, "Waiting for {0}", run);
                this.r.waitForCompletion(run);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(GitStatusTest.class.getName()).log(Level.SEVERE, "Interrupted waiting for GitStatusTest job", ex);
            }
        });
    }

    @Test
    public void testDoNotifyCommitWithNoBranches() throws Exception {
        SCMTrigger aMasterTrigger = this.setupProjectWithTrigger("a", "master", false);
        SCMTrigger aTopicTrigger = this.setupProjectWithTrigger("a", "topic", false);
        SCMTrigger bMasterTrigger = this.setupProjectWithTrigger("b", "master", false);
        SCMTrigger bTopicTrigger = this.setupProjectWithTrigger("b", "topic", false);
        this.gitStatus.doNotifyCommit(this.requestWithNoParameter, "a", "", null, this.notifyCommitApiToken);
        ((SCMTrigger)Mockito.verify((Object)aMasterTrigger)).run();
        ((SCMTrigger)Mockito.verify((Object)aTopicTrigger)).run();
        ((SCMTrigger)Mockito.verify((Object)bMasterTrigger, (VerificationMode)Mockito.never())).run();
        ((SCMTrigger)Mockito.verify((Object)bTopicTrigger, (VerificationMode)Mockito.never())).run();
        Assert.assertEquals((Object)"URL: a Branches: ", (Object)this.gitStatus.toString());
    }

    @Test
    public void testDoNotifyCommitWithNoMatchingUrl() throws Exception {
        SCMTrigger aMasterTrigger = this.setupProjectWithTrigger("a", "master", false);
        SCMTrigger aTopicTrigger = this.setupProjectWithTrigger("a", "topic", false);
        SCMTrigger bMasterTrigger = this.setupProjectWithTrigger("b", "master", false);
        SCMTrigger bTopicTrigger = this.setupProjectWithTrigger("b", "topic", false);
        this.gitStatus.doNotifyCommit(this.requestWithNoParameter, "nonexistent", "", null, this.notifyCommitApiToken);
        ((SCMTrigger)Mockito.verify((Object)aMasterTrigger, (VerificationMode)Mockito.never())).run();
        ((SCMTrigger)Mockito.verify((Object)aTopicTrigger, (VerificationMode)Mockito.never())).run();
        ((SCMTrigger)Mockito.verify((Object)bMasterTrigger, (VerificationMode)Mockito.never())).run();
        ((SCMTrigger)Mockito.verify((Object)bTopicTrigger, (VerificationMode)Mockito.never())).run();
        Assert.assertEquals((Object)"URL: nonexistent Branches: ", (Object)this.gitStatus.toString());
    }

    @Test
    public void testDoNotifyCommitWithOneBranch() throws Exception {
        SCMTrigger aMasterTrigger = this.setupProjectWithTrigger("a", "master", false);
        SCMTrigger aTopicTrigger = this.setupProjectWithTrigger("a", "topic", false);
        SCMTrigger bMasterTrigger = this.setupProjectWithTrigger("b", "master", false);
        SCMTrigger bTopicTrigger = this.setupProjectWithTrigger("b", "topic", false);
        this.gitStatus.doNotifyCommit(this.requestWithNoParameter, "a", "master", null, this.notifyCommitApiToken);
        ((SCMTrigger)Mockito.verify((Object)aMasterTrigger)).run();
        ((SCMTrigger)Mockito.verify((Object)aTopicTrigger, (VerificationMode)Mockito.never())).run();
        ((SCMTrigger)Mockito.verify((Object)bMasterTrigger, (VerificationMode)Mockito.never())).run();
        ((SCMTrigger)Mockito.verify((Object)bTopicTrigger, (VerificationMode)Mockito.never())).run();
        Assert.assertEquals((Object)"URL: a Branches: master", (Object)this.gitStatus.toString());
    }

    @Test
    public void testDoNotifyCommitWithTwoBranches() throws Exception {
        SCMTrigger aMasterTrigger = this.setupProjectWithTrigger("a", "master", false);
        SCMTrigger aTopicTrigger = this.setupProjectWithTrigger("a", "topic", false);
        SCMTrigger aFeatureTrigger = this.setupProjectWithTrigger("a", "feature/def", false);
        SCMTrigger bMasterTrigger = this.setupProjectWithTrigger("b", "master", false);
        SCMTrigger bTopicTrigger = this.setupProjectWithTrigger("b", "topic", false);
        SCMTrigger bFeatureTrigger = this.setupProjectWithTrigger("b", "feature/def", false);
        this.gitStatus.doNotifyCommit(this.requestWithNoParameter, "a", "master,topic,feature/def", null, this.notifyCommitApiToken);
        ((SCMTrigger)Mockito.verify((Object)aMasterTrigger)).run();
        ((SCMTrigger)Mockito.verify((Object)aTopicTrigger)).run();
        ((SCMTrigger)Mockito.verify((Object)aFeatureTrigger)).run();
        ((SCMTrigger)Mockito.verify((Object)bMasterTrigger, (VerificationMode)Mockito.never())).run();
        ((SCMTrigger)Mockito.verify((Object)bTopicTrigger, (VerificationMode)Mockito.never())).run();
        ((SCMTrigger)Mockito.verify((Object)bFeatureTrigger, (VerificationMode)Mockito.never())).run();
        Assert.assertEquals((Object)"URL: a Branches: master,topic,feature/def", (Object)this.gitStatus.toString());
    }

    @Test
    public void testDoNotifyCommitWithNoMatchingBranches() throws Exception {
        SCMTrigger aMasterTrigger = this.setupProjectWithTrigger("a", "master", false);
        SCMTrigger aTopicTrigger = this.setupProjectWithTrigger("a", "topic", false);
        SCMTrigger bMasterTrigger = this.setupProjectWithTrigger("b", "master", false);
        SCMTrigger bTopicTrigger = this.setupProjectWithTrigger("b", "topic", false);
        this.gitStatus.doNotifyCommit(this.requestWithNoParameter, "a", "nonexistent", null, this.notifyCommitApiToken);
        ((SCMTrigger)Mockito.verify((Object)aMasterTrigger, (VerificationMode)Mockito.never())).run();
        ((SCMTrigger)Mockito.verify((Object)aTopicTrigger, (VerificationMode)Mockito.never())).run();
        ((SCMTrigger)Mockito.verify((Object)bMasterTrigger, (VerificationMode)Mockito.never())).run();
        ((SCMTrigger)Mockito.verify((Object)bTopicTrigger, (VerificationMode)Mockito.never())).run();
        Assert.assertEquals((Object)"URL: a Branches: nonexistent", (Object)this.gitStatus.toString());
    }

    @Test
    public void testDoNotifyCommitWithSlashesInBranchNames() throws Exception {
        SCMTrigger aMasterTrigger = this.setupProjectWithTrigger("a", "master", false);
        SCMTrigger bMasterTrigger = this.setupProjectWithTrigger("b", "master", false);
        SCMTrigger aSlashesTrigger = this.setupProjectWithTrigger("a", "name/with/slashes", false);
        this.gitStatus.doNotifyCommit(this.requestWithParameter, "a", "name/with/slashes", null, this.notifyCommitApiToken);
        ((SCMTrigger)Mockito.verify((Object)aSlashesTrigger)).run();
        ((SCMTrigger)Mockito.verify((Object)bMasterTrigger, (VerificationMode)Mockito.never())).run();
        Assert.assertEquals((Object)"URL: a Branches: name/with/slashes", (Object)this.gitStatus.toString());
    }

    @Test
    public void testDoNotifyCommitWithParametrizedBranch() throws Exception {
        SCMTrigger aMasterTrigger = this.setupProjectWithTrigger("a", "$BRANCH_TO_BUILD", false);
        SCMTrigger bMasterTrigger = this.setupProjectWithTrigger("b", "master", false);
        SCMTrigger bTopicTrigger = this.setupProjectWithTrigger("b", "topic", false);
        this.gitStatus.doNotifyCommit(this.requestWithNoParameter, "a", "master", null, this.notifyCommitApiToken);
        ((SCMTrigger)Mockito.verify((Object)aMasterTrigger)).run();
        ((SCMTrigger)Mockito.verify((Object)bMasterTrigger, (VerificationMode)Mockito.never())).run();
        ((SCMTrigger)Mockito.verify((Object)bTopicTrigger, (VerificationMode)Mockito.never())).run();
        Assert.assertEquals((Object)"URL: a Branches: master", (Object)this.gitStatus.toString());
    }

    @Test
    public void testDoNotifyCommitWithIgnoredRepository() throws Exception {
        SCMTrigger aMasterTrigger = this.setupProjectWithTrigger("a", "master", true);
        this.gitStatus.doNotifyCommit(this.requestWithNoParameter, "a", null, "", this.notifyCommitApiToken);
        ((SCMTrigger)Mockito.verify((Object)aMasterTrigger, (VerificationMode)Mockito.never())).run();
        Assert.assertEquals((Object)"URL: a SHA1: ", (Object)this.gitStatus.toString());
    }

    @Test
    public void testDoNotifyCommitWithNoScmTrigger() throws Exception {
        this.setupProject("a", "master", null);
        this.gitStatus.doNotifyCommit(this.requestWithNoParameter, "a", null, "", this.notifyCommitApiToken);
        Assert.assertEquals((Object)"URL: a SHA1: ", (Object)this.gitStatus.toString());
    }

    @Test
    public void testDoNotifyCommitWithTwoBranchesAndAdditionalParameterAllowed() throws Exception {
        this.doNotifyCommitWithTwoBranchesAndAdditionalParameter(true, null);
    }

    @Test
    public void testDoNotifyCommitWithTwoBranchesAndAdditionalParameter() throws Exception {
        this.doNotifyCommitWithTwoBranchesAndAdditionalParameter(false, null);
    }

    @Test
    public void testDoNotifyCommitWithTwoBranchesAndAdditionalSafeParameter() throws Exception {
        this.doNotifyCommitWithTwoBranchesAndAdditionalParameter(false, "paramKey1");
    }

    @Test
    public void testDoNotifyCommitWithTwoBranchesAndAdditionalUnsafeParameter() throws Exception {
        this.doNotifyCommitWithTwoBranchesAndAdditionalParameter(false, "does,not,include,param");
    }

    private void doNotifyCommitWithTwoBranchesAndAdditionalParameter(boolean allowed, String safeParameters) throws Exception {
        if (allowed) {
            GitStatus.setAllowNotifyCommitParameters((boolean)true);
        }
        boolean allowedParamKey1 = allowed;
        if (safeParameters != null) {
            GitStatus.setSafeParametersForTest((String)safeParameters);
            if (safeParameters.contains("paramKey1")) {
                allowedParamKey1 = true;
            }
        }
        SCMTrigger aMasterTrigger = this.setupProjectWithTrigger("a", "master", false);
        SCMTrigger aTopicTrigger = this.setupProjectWithTrigger("a", "topic", false);
        SCMTrigger bMasterTrigger = this.setupProjectWithTrigger("b", "master", false);
        SCMTrigger bTopicTrigger = this.setupProjectWithTrigger("b", "topic", false);
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
        parameterMap.put("paramKey1", new String[]{"paramValue1"});
        Mockito.when((Object)this.requestWithParameter.getParameterMap()).thenReturn(parameterMap);
        this.gitStatus.doNotifyCommit(this.requestWithParameter, "a", "master,topic", null, this.notifyCommitApiToken);
        ((SCMTrigger)Mockito.verify((Object)aMasterTrigger)).run();
        ((SCMTrigger)Mockito.verify((Object)aTopicTrigger)).run();
        ((SCMTrigger)Mockito.verify((Object)bMasterTrigger, (VerificationMode)Mockito.never())).run();
        ((SCMTrigger)Mockito.verify((Object)bTopicTrigger, (VerificationMode)Mockito.never())).run();
        String expected = "URL: a Branches: master,topic" + (allowedParamKey1 ? " Parameters: paramKey1='paramValue1'" : "") + (allowedParamKey1 ? " More parameters: paramKey1='paramValue1'" : "");
        Assert.assertEquals((Object)expected, (Object)this.gitStatus.toString());
    }

    @Test
    public void testDoNotifyCommitBranchWithRegex() throws Exception {
        SCMTrigger trigger = this.setupProjectWithTrigger("remote", ":[^/]*/awesome-feature", false);
        this.gitStatus.doNotifyCommit(this.requestWithNoParameter, "remote", "feature/awesome-feature", null, this.notifyCommitApiToken);
        ((SCMTrigger)Mockito.verify((Object)trigger)).run();
    }

    @Test
    public void testDoNotifyCommitBranchWithWildcard() throws Exception {
        SCMTrigger trigger = this.setupProjectWithTrigger("remote", "origin/feature/*", false);
        this.gitStatus.doNotifyCommit(this.requestWithNoParameter, "remote", "feature/awesome-feature", null, this.notifyCommitApiToken);
        ((SCMTrigger)Mockito.verify((Object)trigger)).run();
    }

    private void assertAdditionalParameters(Collection<? extends Action> actions) {
        for (Action action : actions) {
            if (!(action instanceof ParametersAction)) continue;
            ParametersAction parametersAction = (ParametersAction)action;
            List parameters = parametersAction.getParameters();
            Assert.assertEquals((long)2L, (long)parameters.size());
            for (ParameterValue value : parameters) {
                Assert.assertTrue((value.getName().equals("paramKey1") && value.getValue().equals("paramValue1") || value.getName().equals("paramKey2") && value.getValue().equals("paramValue2") ? 1 : 0) != 0);
            }
        }
    }

    private SCMTrigger setupProjectWithTrigger(String url, String branchString, boolean ignoreNotifyCommit) throws Exception {
        SCMTrigger trigger = (SCMTrigger)Mockito.mock(SCMTrigger.class);
        ((SCMTrigger)Mockito.doReturn((Object)ignoreNotifyCommit).when((Object)trigger)).isIgnorePostCommitHooks();
        this.setupProject(url, branchString, trigger);
        return trigger;
    }

    private void setupProject(String url, String branchString, SCMTrigger trigger) throws Exception {
        FreeStyleProject project = this.r.createFreeStyleProject();
        GitSCM git = new GitSCM(Collections.singletonList(new UserRemoteConfig(url, null, null, null)), Collections.singletonList(new BranchSpec(branchString)), null, null, Collections.emptyList());
        project.setScm((SCM)git);
        if (trigger != null) {
            project.addTrigger((Trigger)trigger);
        }
    }

    private FreeStyleProject setupNotifyProject() throws Exception {
        FreeStyleProject project = this.r.createFreeStyleProject();
        project.setQuietPeriod(Integer.valueOf(0));
        GitSCM git = new GitSCM(Collections.singletonList(new UserRemoteConfig(this.repoURL, null, null, null)), Collections.singletonList(new BranchSpec(this.branch)), null, null, Collections.emptyList());
        project.setScm((SCM)git);
        project.addTrigger((Trigger)new SCMTrigger(""));
        return project;
    }

    private Map<String, String[]> setupParameterMap() {
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
        String[] repoURLs = new String[]{this.repoURL};
        parameterMap.put("url", repoURLs);
        String[] branches = new String[]{this.branch};
        parameterMap.put("branches", branches);
        String[] hashes = new String[]{this.sha1};
        parameterMap.put("sha1", hashes);
        return parameterMap;
    }

    private Map<String, String[]> setupParameterMap(String extraValue) {
        Map<String, String[]> parameterMap = this.setupParameterMap();
        String[] extra = new String[]{extraValue};
        parameterMap.put("extra", extra);
        return parameterMap;
    }

    @Test
    public void testDoNotifyCommit() throws Exception {
        this.setupNotifyProject();
        this.gitStatus.doNotifyCommit(this.requestWithNoParameter, this.repoURL, this.branch, this.sha1, this.notifyCommitApiToken);
        Assert.assertEquals((Object)("URL: " + this.repoURL + " SHA1: " + this.sha1 + " Branches: " + this.branch), (Object)this.gitStatus.toString());
    }

    @Test
    public void testDoNotifyCommitWithExtraParameterAllowed() throws Exception {
        this.doNotifyCommitWithExtraParameterAllowed(true, null);
    }

    @Test
    public void testDoNotifyCommitWithExtraParameter() throws Exception {
        this.doNotifyCommitWithExtraParameterAllowed(false, null);
    }

    @Test
    public void testDoNotifyCommitWithExtraSafeParameter() throws Exception {
        this.doNotifyCommitWithExtraParameterAllowed(false, "something,extra,is,here");
    }

    @Test
    public void testDoNotifyCommitWithExtraUnsafeParameter() throws Exception {
        this.doNotifyCommitWithExtraParameterAllowed(false, "something,is,not,here");
    }

    private void doNotifyCommitWithExtraParameterAllowed(boolean allowed, String safeParameters) throws Exception {
        if (allowed) {
            GitStatus.setAllowNotifyCommitParameters((boolean)true);
        }
        boolean allowedExtra = allowed;
        if (safeParameters != null) {
            GitStatus.setSafeParametersForTest((String)safeParameters);
            if (safeParameters.contains("extra")) {
                allowedExtra = true;
            }
        }
        this.setupNotifyProject();
        String extraValue = "An-extra-value";
        Mockito.when((Object)this.requestWithParameter.getParameterMap()).thenReturn(this.setupParameterMap(extraValue));
        this.gitStatus.doNotifyCommit(this.requestWithParameter, this.repoURL, this.branch, this.sha1, this.notifyCommitApiToken);
        String expected = "URL: " + this.repoURL + " SHA1: " + this.sha1 + " Branches: " + this.branch + (String)(allowedExtra ? " Parameters: extra='" + extraValue + "'" : "") + (String)(allowedExtra ? " More parameters: extra='" + extraValue + "'" : "");
        Assert.assertEquals((Object)expected, (Object)this.gitStatus.toString());
    }

    @Test
    public void testDoNotifyCommitWithNullValueExtraParameter() throws Exception {
        this.setupNotifyProject();
        Mockito.when((Object)this.requestWithParameter.getParameterMap()).thenReturn(this.setupParameterMap(null));
        this.gitStatus.doNotifyCommit(this.requestWithParameter, this.repoURL, this.branch, this.sha1, this.notifyCommitApiToken);
        Assert.assertEquals((Object)("URL: " + this.repoURL + " SHA1: " + this.sha1 + " Branches: " + this.branch), (Object)this.gitStatus.toString());
    }

    @Test
    public void testDoNotifyCommitWithDefaultParameterAllowed() throws Exception {
        this.doNotifyCommitWithDefaultParameter(true, null);
    }

    @Test
    public void testDoNotifyCommitWithDefaultParameter() throws Exception {
        this.doNotifyCommitWithDefaultParameter(false, null);
    }

    @Test
    public void testDoNotifyCommitWithDefaultSafeParameter() throws Exception {
        this.doNotifyCommitWithDefaultParameter(false, "A,B,C,extra");
    }

    @Test
    public void testDoNotifyCommitWithDefaultUnsafeParameterC() throws Exception {
        this.doNotifyCommitWithDefaultParameter(false, "A,B,extra");
    }

    @Test
    public void testDoNotifyCommitWithDefaultUnsafeParameterExtra() throws Exception {
        this.doNotifyCommitWithDefaultParameter(false, "A,B,C");
    }

    private void doNotifyCommitWithDefaultParameter(boolean allowed, String safeParameters) throws Exception {
        if (!this.runUnreliableTests()) {
            return;
        }
        if (allowed) {
            GitStatus.setAllowNotifyCommitParameters((boolean)true);
        }
        boolean allowedExtra = allowed;
        if (safeParameters != null) {
            GitStatus.setSafeParametersForTest((String)safeParameters);
            if (safeParameters.contains("extra")) {
                allowedExtra = true;
            }
        }
        this.repoURL = "https://github.com/jenkinsci/git-plugin.git";
        FreeStyleProject project = this.setupNotifyProject();
        project.addProperty((JobProperty)new ParametersDefinitionProperty(new ParameterDefinition[]{new StringParameterDefinition("A", "aaa"), new StringParameterDefinition("C", "ccc"), new StringParameterDefinition("B", "$A$C")}));
        BatchFile script = this.isWindows() ? new BatchFile("echo %A% %B% %C%") : new Shell("echo $A $B $C");
        project.getBuildersList().add((Object)script);
        FreeStyleBuild build = (FreeStyleBuild)project.scheduleBuild2(0, (Cause)new Cause.UserIdCause()).get();
        this.r.waitForMessage("aaa aaaccc ccc", (Run)build);
        String extraValue = "An-extra-value";
        Mockito.when((Object)this.requestWithParameter.getParameterMap()).thenReturn(this.setupParameterMap(extraValue));
        this.gitStatus.doNotifyCommit(this.requestWithParameter, this.repoURL, this.branch, this.sha1, this.notifyCommitApiToken);
        String expected = "URL: " + this.repoURL + " SHA1: " + this.sha1 + " Branches: " + this.branch + (String)(allowedExtra ? " Parameters: extra='" + extraValue + "'" : "") + " More parameters: " + (String)(allowedExtra ? "extra='" + extraValue + "'," : "") + "A='aaa',C='ccc',B='$A$C'";
        Assert.assertEquals((Object)expected, (Object)this.gitStatus.toString());
    }

    private boolean runUnreliableTests() {
        if (!this.isWindows()) {
            return true;
        }
        String jobUrl = System.getenv("JOB_URL");
        if (jobUrl == null) {
            return true;
        }
        return !jobUrl.contains("ci.jenkins.io");
    }

    private boolean isWindows() {
        return File.pathSeparatorChar == ';';
    }

    @Test
    public void testDoNotifyCommitTriggeredHeadersLimited() throws Exception {
        SCMTrigger[] projectTriggers = new SCMTrigger[50];
        for (int i = 0; i < projectTriggers.length; ++i) {
            projectTriggers[i] = this.setupProjectWithTrigger("a", "master", false);
        }
        HttpResponse rsp = this.gitStatus.doNotifyCommit(this.requestWithNoParameter, "a", "master", null, this.notifyCommitApiToken);
        StaplerRequest2 sReq = (StaplerRequest2)Mockito.mock(StaplerRequest2.class);
        StaplerResponse2 sRsp = (StaplerResponse2)Mockito.mock(StaplerResponse2.class);
        Mockito.when((Object)sRsp.getWriter()).thenReturn((Object)((PrintWriter)Mockito.mock(PrintWriter.class)));
        rsp.generateResponse(sReq, sRsp, null);
        ((StaplerResponse2)Mockito.verify((Object)sRsp, (VerificationMode)Mockito.times((int)11))).addHeader((String)Mockito.eq((Object)"Triggered"), Mockito.anyString());
        for (SCMTrigger projectTrigger : projectTriggers) {
            ((SCMTrigger)Mockito.verify((Object)projectTrigger)).run();
        }
        Assert.assertEquals((Object)"URL: a Branches: master", (Object)this.gitStatus.toString());
    }

    @Test
    public void testDoNotifyCommitWithWrongSha1Content() throws Exception {
        this.setupProjectWithTrigger("a", "master", false);
        String content = "<img src=onerror=alert(1)>";
        HttpResponse rsp = this.gitStatus.doNotifyCommit(this.requestWithNoParameter, "a", "master", content, this.notifyCommitApiToken);
        HttpResponses.HttpResponseException responseException = (HttpResponses.HttpResponseException)rsp;
        Assert.assertEquals(IllegalArgumentException.class, responseException.getCause().getClass());
        Assert.assertEquals((Object)"Illegal SHA1", (Object)responseException.getCause().getMessage());
    }

    @Test
    public void testDoNotifyCommitWithValidSha1AndValidApiToken() throws Exception {
        FreeStyleProject project = this.setupNotifyProject();
        this.gitStatus.doNotifyCommit(this.requestWithParameter, this.repoURL, this.branch, this.sha1, this.notifyCommitApiToken);
        this.r.waitUntilNoActivity();
        FreeStyleBuild lastBuild = (FreeStyleBuild)project.getLastBuild();
        Assert.assertNotNull((Object)lastBuild);
        Assert.assertEquals((long)lastBuild.getNumber(), (long)1L);
    }

    @Test
    public void testDoNotifyCommitWithUnauthenticatedPollingAllowed() throws Exception {
        GitStatus.NOTIFY_COMMIT_ACCESS_CONTROL = "disabled-for-polling";
        SCMTrigger trigger = this.setupProjectWithTrigger("a", "master", false);
        this.gitStatus.doNotifyCommit(this.requestWithNoParameter, "a", "master", null, null);
        ((SCMTrigger)Mockito.verify((Object)trigger)).run();
    }

    @Test
    public void testDoNotifyCommitWithAllowModeSha1() throws Exception {
        GitStatus.NOTIFY_COMMIT_ACCESS_CONTROL = "disabled";
        FreeStyleProject project = this.setupNotifyProject();
        this.gitStatus.doNotifyCommit(this.requestWithParameter, this.repoURL, this.branch, this.sha1, null);
        this.r.waitUntilNoActivity();
        FreeStyleBuild lastBuild = (FreeStyleBuild)project.getLastBuild();
        Assert.assertNotNull((Object)lastBuild);
        Assert.assertEquals((long)lastBuild.getNumber(), (long)1L);
    }
}

