/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.matrix.Axis;
import hudson.matrix.AxisList;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixProject;
import hudson.model.FreeStyleBuild;
import hudson.model.FreeStyleProject;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.User;
import hudson.plugins.git.AbstractGitTestCase;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.ChangelogToBranchOptions;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.UserMergeOptions;
import hudson.plugins.git.UserRemoteConfig;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.plugins.git.browser.GithubWeb;
import hudson.plugins.git.extensions.impl.ChangelogToBranch;
import hudson.plugins.git.extensions.impl.LocalBranch;
import hudson.plugins.git.extensions.impl.PreBuildMerge;
import hudson.plugins.git.extensions.impl.SparseCheckoutPath;
import hudson.plugins.git.util.BuildChooserContext;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.remoting.VirtualChannel;
import hudson.scm.SCM;
import hudson.slaves.DumbSlave;
import hudson.slaves.EnvironmentVariablesNodeProperty;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import jenkins.model.Jenkins;
import jenkins.plugins.git.CliGitCommand;
import jenkins.plugins.git.RandomOrder;
import jenkins.security.MasterToSlaveCallable;
import org.eclipse.jgit.storage.file.UserConfigFile;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.SystemReader;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Stopwatch;
import org.junit.rules.TestName;
import org.junit.runner.OrderWith;

@OrderWith(value=RandomOrder.class)
public class GitSCMSlowTest
extends AbstractGitTestCase {
    private final Random random = new Random();
    private boolean useChangelogToBranch = this.random.nextBoolean();
    private static boolean gpgsignEnabled = false;
    @ClassRule
    public static Stopwatch stopwatch = new Stopwatch();
    @Rule
    public TestName testName = new TestName();
    private static final int MAX_SECONDS_FOR_THESE_TESTS = 180;

    @BeforeClass
    public static void setGitDefaults() throws Exception {
        SystemReader.getInstance().getUserConfig().clear();
        CliGitCommand gitCmd = new CliGitCommand(null, new String[0]);
        gitCmd.setDefaults();
    }

    @BeforeClass
    public static void gpgsignCheck() throws Exception {
        File userGitConfig;
        File xdgGitConfig = userGitConfig = new File(System.getProperty("user.home"), ".gitconfig");
        String xdgDirName = System.getenv("XDG_CONFIG_HOME");
        if (xdgDirName != null) {
            xdgGitConfig = new File(xdgDirName, ".gitconfig");
        }
        UserConfigFile userConfig = new UserConfigFile(null, userGitConfig, xdgGitConfig, FS.DETECTED);
        userConfig.load();
        gpgsignEnabled = userConfig.getBoolean("commit", "gpgSign", false) || userConfig.getBoolean("tag", "gpgSign", false);
    }

    private boolean isTimeAvailable() {
        String env = System.getenv("CI");
        if (env == null || !Boolean.parseBoolean(env)) {
            return true;
        }
        return stopwatch.runtime(TimeUnit.SECONDS) <= 180L;
    }

    private void addChangelogToBranchExtension(GitSCM scm) {
        if (this.useChangelogToBranch) {
            ChangelogToBranchOptions changelogOptions = new ChangelogToBranchOptions("origin", "master");
            scm.getExtensions().add((Object)new ChangelogToBranch(changelogOptions));
        }
        this.useChangelogToBranch = !this.useChangelogToBranch;
    }

    @Test
    public void testConfigRoundtripURLPreserved() throws Exception {
        if (this.isWindows() || this.random.nextBoolean()) {
            return;
        }
        Assume.assumeTrue((String)"Test class max time 180 exceeded", (boolean)this.isTimeAvailable());
        FreeStyleProject p = this.createFreeStyleProject();
        String url = "https://github.com/jenkinsci/jenkins";
        GithubWeb browser = new GithubWeb("https://github.com/jenkinsci/jenkins");
        GitSCM scm = new GitSCM(this.createRepoList("https://github.com/jenkinsci/jenkins"), Collections.singletonList(new BranchSpec("")), (GitRepositoryBrowser)browser, null, null);
        p.setScm((SCM)scm);
        this.r.configRoundtrip((Item)p);
        this.r.assertEqualDataBoundBeans((Object)scm, (Object)p.getScm());
        Assert.assertEquals((String)"Wrong key", (Object)"git https://github.com/jenkinsci/jenkins", (Object)scm.getKey());
    }

    private List<UserRemoteConfig> createRepoList(String url) {
        ArrayList<UserRemoteConfig> repoList = new ArrayList<UserRemoteConfig>();
        repoList.add(new UserRemoteConfig(url, null, null, null));
        return repoList;
    }

    @Test
    public void testConfigRoundtripExtensionsPreserved() throws Exception {
        if (this.isWindows() || this.random.nextBoolean()) {
            return;
        }
        Assume.assumeTrue((String)"Test class max time 180 exceeded", (boolean)this.isTimeAvailable());
        FreeStyleProject p = this.createFreeStyleProject();
        String url = "https://github.com/jenkinsci/git-plugin.git";
        GithubWeb browser = new GithubWeb("https://github.com/jenkinsci/git-plugin.git");
        GitSCM scm = new GitSCM(this.createRepoList("https://github.com/jenkinsci/git-plugin.git"), Collections.singletonList(new BranchSpec("*/master")), (GitRepositoryBrowser)browser, null, null);
        p.setScm((SCM)scm);
        Assert.assertEquals(Collections.emptyList(), (Object)scm.getExtensions().toList());
        LocalBranch localBranchExtension = new LocalBranch("**");
        scm.getExtensions().add((Object)localBranchExtension);
        Assert.assertTrue((boolean)scm.getExtensions().toList().contains(localBranchExtension));
        p = (FreeStyleProject)this.r.configRoundtrip((Item)p);
        List extensions = scm.getExtensions().toList();
        Assert.assertTrue((boolean)extensions.contains(localBranchExtension));
        Assert.assertEquals((String)"Wrong extension count before reload", (long)1L, (long)extensions.size());
        this.r.assertEqualDataBoundBeans((Object)browser, (Object)p.getScm().getBrowser());
        p.doReload();
        GitSCM reloadedGit = (GitSCM)p.getScm();
        List reloadedExtensions = reloadedGit.getExtensions().toList();
        Assert.assertEquals((String)"Wrong extension count after reload", (long)1L, (long)reloadedExtensions.size());
        LocalBranch reloadedLocalBranch = (LocalBranch)reloadedExtensions.get(0);
        Assert.assertEquals((Object)localBranchExtension.getLocalBranch(), (Object)reloadedLocalBranch.getLocalBranch());
        this.r.assertEqualDataBoundBeans((Object)browser, (Object)reloadedGit.getBrowser());
    }

    @Test
    public void testConfigRoundtrip() throws Exception {
        if (this.isWindows() || this.random.nextBoolean()) {
            return;
        }
        Assume.assumeTrue((String)"Test class max time 180 exceeded", (boolean)this.isTimeAvailable());
        FreeStyleProject p = this.createFreeStyleProject();
        GitSCM scm = new GitSCM("https://github.com/jenkinsci/jenkins");
        p.setScm((SCM)scm);
        this.r.configRoundtrip((Item)p);
        this.r.assertEqualDataBoundBeans((Object)scm, (Object)p.getScm());
    }

    @Test
    public void testBuildChooserContext() throws Exception {
        Assume.assumeTrue((String)"Test class max time 180 exceeded", (boolean)this.isTimeAvailable());
        final FreeStyleProject p = this.createFreeStyleProject();
        final FreeStyleBuild b = this.r.buildAndAssertSuccess(p);
        GitSCM.BuildChooserContextImpl c = new GitSCM.BuildChooserContextImpl((Job)p, (Run)b, null);
        c.actOnBuild(new BuildChooserContext.ContextCallable<Run<?, ?>, Object>(){

            public Object invoke(Run param, VirtualChannel channel) throws IOException, InterruptedException {
                Assert.assertSame((Object)param, (Object)b);
                return null;
            }
        });
        c.actOnProject(new BuildChooserContext.ContextCallable<Job<?, ?>, Object>(){

            public Object invoke(Job param, VirtualChannel channel) throws IOException, InterruptedException {
                Assert.assertSame((Object)param, (Object)p);
                return null;
            }
        });
        DumbSlave agent = this.r.createOnlineSlave();
        Assert.assertEquals((Object)p.toString(), (Object)agent.getChannel().call((Callable)new BuildChooserContextTestCallable((BuildChooserContext)c)));
    }

    @Test
    public void testMergeFailedWithAgent() throws Exception {
        Assume.assumeTrue((String)"Test class max time 180 exceeded", (boolean)this.isTimeAvailable());
        FreeStyleProject project = this.setupSimpleProject("master");
        project.setAssignedLabel((Label)this.r.createSlave().getSelfLabel());
        GitSCM scm = new GitSCM(this.createRemoteRepositories(), Collections.singletonList(new BranchSpec("*")), null, null, Collections.emptyList());
        scm.getExtensions().add((Object)new PreBuildMerge(new UserMergeOptions("origin", "integration", null, null)));
        this.addChangelogToBranchExtension(scm);
        project.setScm((SCM)scm);
        this.commit("commitFileBase", this.johnDoe, "Initial Commit");
        this.testRepo.git.branch("integration");
        this.build(project, Result.SUCCESS, "commitFileBase");
        this.testRepo.git.checkout(null, "topic1");
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        FreeStyleBuild build1 = this.build(project, Result.SUCCESS, "commitFile1");
        Assert.assertTrue((boolean)build1.getWorkspace().child("commitFile1").exists());
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
        this.testRepo.git.deleteBranch("integration");
        this.testRepo.git.checkout("topic1", "integration");
        this.testRepo.git.checkout("master", "topic2");
        this.commit("commitFile1", "other content", this.johnDoe, "Commit number 2");
        Assert.assertTrue((String)"scm polling did not detect commit2 change", (boolean)project.poll(this.listener).hasChanges());
        this.r.buildAndAssertStatus(Result.FAILURE, (Job)project);
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
    }

    @Test
    public void testMergeWithAgent() throws Exception {
        Assume.assumeTrue((String)"Test class max time 180 exceeded", (boolean)this.isTimeAvailable());
        FreeStyleProject project = this.setupSimpleProject("master");
        project.setAssignedLabel((Label)this.r.createSlave().getSelfLabel());
        GitSCM scm = new GitSCM(this.createRemoteRepositories(), Collections.singletonList(new BranchSpec("*")), null, null, Collections.emptyList());
        scm.getExtensions().add((Object)new TestPreBuildMerge(new UserMergeOptions("origin", "integration", null, null)));
        this.addChangelogToBranchExtension(scm);
        project.setScm((SCM)scm);
        this.commit("commitFileBase", this.johnDoe, "Initial Commit");
        this.testRepo.git.branch("integration");
        this.build(project, Result.SUCCESS, "commitFileBase");
        this.testRepo.git.checkout(null, "topic1");
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        FreeStyleBuild build1 = this.build(project, Result.SUCCESS, "commitFile1");
        Assert.assertTrue((boolean)build1.getWorkspace().child("commitFile1").exists());
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
        this.testRepo.git.deleteBranch("integration");
        this.testRepo.git.checkout("topic1", "integration");
        this.testRepo.git.checkout("master", "topic2");
        String commitFile2 = "commitFile2";
        this.commit("commitFile2", this.johnDoe, "Commit number 2");
        Assert.assertTrue((String)"scm polling did not detect commit2 change", (boolean)project.poll(this.listener).hasChanges());
        FreeStyleBuild build2 = this.build(project, Result.SUCCESS, "commitFile2");
        Assert.assertTrue((boolean)build2.getWorkspace().child("commitFile2").exists());
        this.r.assertBuildStatusSuccess((Run)build2);
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
    }

    @Test
    public void testMergeWithMatrixBuild() throws Exception {
        Assume.assumeTrue((String)"Test class max time 180 exceeded", (boolean)this.isTimeAvailable());
        Assume.assumeFalse((String)"gpgsign enabled", (boolean)gpgsignEnabled);
        MatrixProject project = (MatrixProject)this.r.jenkins.createProject(MatrixProject.class, "xyz");
        project.setAxes(new AxisList(new Axis[]{new Axis("VAR", new String[]{"a", "b"})}));
        GitSCM scm = new GitSCM(this.createRemoteRepositories(), Collections.singletonList(new BranchSpec("*")), null, null, Collections.emptyList());
        scm.getExtensions().add((Object)new PreBuildMerge(new UserMergeOptions("origin", "integration", null, null)));
        this.addChangelogToBranchExtension(scm);
        project.setScm((SCM)scm);
        this.commit("commitFileBase", this.johnDoe, "Initial Commit");
        this.testRepo.git.branch("integration");
        this.build(project, Result.SUCCESS, "commitFileBase");
        this.testRepo.git.checkout(null, "topic1");
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        MatrixBuild build1 = this.build(project, Result.SUCCESS, "commitFile1");
        Assert.assertTrue((boolean)build1.getWorkspace().child("commitFile1").exists());
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
        this.testRepo.git.deleteBranch("integration");
        this.testRepo.git.checkout("topic1", "integration");
        this.testRepo.git.checkout("master", "topic2");
        String commitFile2 = "commitFile2";
        this.commit("commitFile2", this.johnDoe, "Commit number 2");
        Assert.assertTrue((String)"scm polling did not detect commit2 change", (boolean)project.poll(this.listener).hasChanges());
        MatrixBuild build2 = this.build(project, Result.SUCCESS, "commitFile2");
        Assert.assertTrue((boolean)build2.getWorkspace().child("commitFile2").exists());
        this.r.assertBuildStatusSuccess((Run)build2);
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
    }

    @Test
    public void testInitSparseCheckout() throws Exception {
        Assume.assumeTrue((String)"Test class max time 180 exceeded", (boolean)this.isTimeAvailable());
        FreeStyleProject project = this.setupProject("master", Collections.singletonList(new SparseCheckoutPath("toto")));
        String commitFile1 = "toto/commitFile1";
        this.commit("toto/commitFile1", this.johnDoe, "Commit number 1");
        String commitFile2 = "titi/commitFile2";
        this.commit("titi/commitFile2", this.johnDoe, "Commit number 2");
        FreeStyleBuild build1 = this.build(project, Result.SUCCESS, new String[0]);
        Assert.assertTrue((boolean)build1.getWorkspace().child("toto").exists());
        Assert.assertTrue((boolean)build1.getWorkspace().child("toto/commitFile1").exists());
        Assert.assertFalse((boolean)build1.getWorkspace().child("titi").exists());
        Assert.assertFalse((boolean)build1.getWorkspace().child("titi/commitFile2").exists());
    }

    @Test
    public void testInitSparseCheckoutBis() throws Exception {
        Assume.assumeTrue((String)"Test class max time 180 exceeded", (boolean)this.isTimeAvailable());
        FreeStyleProject project = this.setupProject("master", Collections.singletonList(new SparseCheckoutPath("titi")));
        String commitFile1 = "toto/commitFile1";
        this.commit("toto/commitFile1", this.johnDoe, "Commit number 1");
        String commitFile2 = "titi/commitFile2";
        this.commit("titi/commitFile2", this.johnDoe, "Commit number 2");
        FreeStyleBuild build1 = this.build(project, Result.SUCCESS, new String[0]);
        Assert.assertTrue((boolean)build1.getWorkspace().child("titi").exists());
        Assert.assertTrue((boolean)build1.getWorkspace().child("titi/commitFile2").exists());
        Assert.assertFalse((boolean)build1.getWorkspace().child("toto").exists());
        Assert.assertFalse((boolean)build1.getWorkspace().child("toto/commitFile1").exists());
    }

    @Test
    public void testInitSparseCheckoutOverAgent() throws Exception {
        Assume.assumeTrue((String)"Test class max time 180 exceeded", (boolean)this.isTimeAvailable());
        FreeStyleProject project = this.setupProject("master", Collections.singletonList(new SparseCheckoutPath("titi")));
        project.setAssignedLabel((Label)this.r.createSlave().getSelfLabel());
        String commitFile1 = "toto/commitFile1";
        this.commit("toto/commitFile1", this.johnDoe, "Commit number 1");
        String commitFile2 = "titi/commitFile2";
        this.commit("titi/commitFile2", this.johnDoe, "Commit number 2");
        FreeStyleBuild build1 = this.build(project, Result.SUCCESS, new String[0]);
        Assert.assertTrue((boolean)build1.getWorkspace().child("titi").exists());
        Assert.assertTrue((boolean)build1.getWorkspace().child("titi/commitFile2").exists());
        Assert.assertFalse((boolean)build1.getWorkspace().child("toto").exists());
        Assert.assertFalse((boolean)build1.getWorkspace().child("toto/commitFile1").exists());
    }

    @Test
    public void testNodeEnvVarsAvailable() throws Exception {
        Assume.assumeTrue((String)"Test class max time 180 exceeded", (boolean)this.isTimeAvailable());
        FreeStyleProject project = this.setupSimpleProject("master");
        DumbSlave agent = this.r.createSlave();
        this.setVariables((Node)agent, new EnvironmentVariablesNodeProperty.Entry("TESTKEY", "agent value"));
        project.setAssignedLabel((Label)agent.getSelfLabel());
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        this.build(project, Result.SUCCESS, "commitFile1");
        Assert.assertEquals((Object)"agent value", (Object)this.getEnvVars(project).get((Object)"TESTKEY"));
    }

    @Test
    public void testBasicWithAgent() throws Exception {
        Assume.assumeTrue((String)"Test class max time 180 exceeded", (boolean)this.isTimeAvailable());
        FreeStyleProject project = this.setupSimpleProject("master");
        project.setAssignedLabel((Label)this.r.createSlave().getSelfLabel());
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        this.build(project, Result.SUCCESS, "commitFile1");
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
        String commitFile2 = "commitFile2";
        this.commit("commitFile2", this.janeDoe, "Commit number 2");
        Assert.assertTrue((String)"scm polling did not detect commit2 change", (boolean)project.poll(this.listener).hasChanges());
        FreeStyleBuild build2 = this.build(project, Result.SUCCESS, "commitFile2");
        Set culprits = build2.getCulprits();
        Assert.assertEquals((String)"The build should have only one culprit", (long)1L, (long)culprits.size());
        Assert.assertEquals((String)"", (Object)this.janeDoe.getName(), (Object)((User)culprits.iterator().next()).getFullName());
        Assert.assertTrue((boolean)build2.getWorkspace().child("commitFile2").exists());
        this.r.assertBuildStatusSuccess((Run)build2);
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
    }

    private boolean isWindows() {
        return File.pathSeparatorChar == ';';
    }

    private static class BuildChooserContextTestCallable
    extends MasterToSlaveCallable<String, IOException> {
        private final BuildChooserContext c;

        public BuildChooserContextTestCallable(BuildChooserContext c) {
            this.c = c;
        }

        public String call() throws IOException {
            try {
                return (String)this.c.actOnProject(new BuildChooserContext.ContextCallable<Job<?, ?>, String>(){

                    public String invoke(Job<?, ?> param, VirtualChannel channel) throws IOException, InterruptedException {
                        Assert.assertTrue((boolean)(channel instanceof Channel));
                        Assert.assertNotNull((Object)Jenkins.getInstanceOrNull());
                        return param.toString();
                    }
                });
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }
    }

    public static class TestPreBuildMerge
    extends PreBuildMerge {
        public TestPreBuildMerge(UserMergeOptions options) {
            super(options);
        }

        public GitClient decorate(GitSCM scm, GitClient git) throws IOException, InterruptedException, GitException {
            GitClient gitClient = super.decorate(scm, git);
            gitClient.config(GitClient.ConfigLevel.LOCAL, "commit.gpgsign", "false");
            gitClient.config(GitClient.ConfigLevel.LOCAL, "tag.gpgSign", "false");
            return gitClient;
        }
    }
}

