/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.FilePath;
import hudson.model.Job;
import hudson.model.Label;
import hudson.model.Run;
import hudson.model.TopLevelItem;
import hudson.plugins.git.AbstractGitTestCase;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.GitTool;
import hudson.scm.SCM;
import hudson.slaves.DumbSlave;
import hudson.tools.ToolInstallation;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import jenkins.plugins.git.CliGitCommand;
import jenkins.plugins.git.GitHooksConfiguration;
import org.eclipse.jgit.util.SystemReader;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsIterableContaining;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.StringStartsWith;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.cps.CpsScmFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.jvnet.hudson.test.BuildWatcher;
import org.jvnet.hudson.test.LoggerRule;

public class GitHooksTest
extends AbstractGitTestCase {
    @Rule
    public LoggerRule lr = new LoggerRule();
    @ClassRule
    public static BuildWatcher watcher = new BuildWatcher();
    private static final String JENKINS_URL = System.getenv("JENKINS_URL") != null ? System.getenv("JENKINS_URL") : "http://localhost:8080/";

    @BeforeClass
    public static void setGitDefaults() throws Exception {
        SystemReader.getInstance().getUserConfig().clear();
        CliGitCommand gitCmd = new CliGitCommand(null, new String[0]);
        gitCmd.setDefaults();
    }

    @Before
    public void setGitTool() throws IOException {
        this.lr.record(GitHooksConfiguration.class.getName(), Level.ALL).capture(1024);
        GitTool tool = new GitTool("my-git", "git", Collections.emptyList());
        ((GitTool.DescriptorImpl)this.r.jenkins.getDescriptorByType(GitTool.DescriptorImpl.class)).setInstallations((ToolInstallation[])new GitTool[]{tool});
        this.r.jenkins.setLabelString("master");
        this.r.jenkins.setNumExecutors(3);
    }

    @After
    public void tearDown() {
        GitHooksConfiguration.get().setAllowedOnController(false);
        GitHooksConfiguration.get().setAllowedOnAgents(false);
        MatcherAssert.assertThat((Object)this.lr.getMessages(), (Matcher)IsNot.not((Matcher)IsIterableContaining.hasItem((Matcher)StringStartsWith.startsWith((String)"core.hooksPath explicitly set to "))));
    }

    @Test
    public void testPipelineFromScm() throws Exception {
        if (this.isWindows() && JENKINS_URL.contains("ci.jenkins.io")) {
            return;
        }
        GitHooksConfiguration.get().setAllowedOnController(true);
        GitHooksConfiguration.get().setAllowedOnAgents(true);
        DumbSlave agent = this.r.createOnlineSlave(Label.get((String)"somewhere"));
        this.commit("test.txt", "Test", this.johnDoe, "First");
        String jenkinsfile = GitHooksTest.lines("node('somewhere') {", "  checkout scm", "  echo 'Hello Pipeline'", "}");
        this.commit("Jenkinsfile", jenkinsfile, this.johnDoe, "Jenkinsfile");
        WorkflowJob job = (WorkflowJob)this.r.createProject(WorkflowJob.class);
        GitSCM scm = new GitSCM(this.createRemoteRepositories(), Collections.singletonList(new BranchSpec("master")), null, "my-git", Collections.emptyList());
        CpsScmFlowDefinition definition = new CpsScmFlowDefinition((SCM)scm, "Jenkinsfile");
        definition.setLightweight(false);
        job.setDefinition((FlowDefinition)definition);
        job.save();
        WorkflowRun run = (WorkflowRun)this.r.buildAndAssertSuccess((Job)job);
        this.r.assertLogContains("Hello Pipeline", (Run)run);
        FilePath jobWorkspace = agent.getWorkspaceFor((TopLevelItem)job);
        Assert.assertNotNull((Object)jobWorkspace);
        TemporaryFolder tf = new TemporaryFolder();
        tf.create();
        File postCheckoutOutput1 = new File(tf.newFolder(), "svn-git-fun-post-checkout-1");
        File postCheckoutOutput2 = new File(tf.newFolder(), "svn-git-fun-post-checkout-2");
        FilePath hook = jobWorkspace.child(".git/hooks/post-checkout");
        this.createHookScriptAt(postCheckoutOutput1, hook);
        FilePath scriptWorkspace = this.r.jenkins.getWorkspaceFor((TopLevelItem)job).withSuffix("@script");
        scriptWorkspace = (FilePath)scriptWorkspace.listDirectories().stream().findFirst().get();
        this.createHookScriptAt(postCheckoutOutput2, scriptWorkspace.child(".git/hooks/post-checkout"));
        this.commit("test.txt", "Second", this.johnDoe, "Second");
        this.commit("Jenkinsfile", "/*2*/\n" + jenkinsfile, this.johnDoe, "Jenkinsfile");
        Thread.sleep(TimeUnit.SECONDS.toMillis(2L));
        Instant before = Instant.now().minus(2L, ChronoUnit.SECONDS);
        run = (WorkflowRun)this.r.buildAndAssertSuccess((Job)job);
        Assert.assertTrue((boolean)postCheckoutOutput1.exists());
        Assert.assertTrue((boolean)postCheckoutOutput2.exists());
        this.r.assertLogContains("Hello Pipeline", (Run)run);
        Instant after = Instant.now().plus(2L, ChronoUnit.SECONDS);
        this.checkFileOutput(postCheckoutOutput1, before, after);
        Assert.assertFalse((boolean)postCheckoutOutput1.exists());
        this.checkFileOutput(postCheckoutOutput2, before, after);
        Assert.assertFalse((boolean)postCheckoutOutput2.exists());
        this.commit("test.txt", "Third", this.johnDoe, "Third");
        this.commit("Jenkinsfile", "/*3*/\n" + jenkinsfile, this.johnDoe, "Jenkinsfile");
        GitHooksConfiguration.get().setAllowedOnController(false);
        GitHooksConfiguration.get().setAllowedOnAgents(false);
        run = (WorkflowRun)this.r.buildAndAssertSuccess((Job)job);
        this.r.assertLogContains("Hello Pipeline", (Run)run);
        Assert.assertFalse((boolean)postCheckoutOutput1.exists());
        Assert.assertFalse((boolean)postCheckoutOutput2.exists());
        this.commit("test.txt", "Four", this.johnDoe, "Four");
        this.commit("Jenkinsfile", "/*4*/\n" + jenkinsfile, this.johnDoe, "Jenkinsfile");
        GitHooksConfiguration.get().setAllowedOnController(false);
        GitHooksConfiguration.get().setAllowedOnAgents(true);
        Thread.sleep(TimeUnit.SECONDS.toMillis(2L));
        before = Instant.now().minus(2L, ChronoUnit.SECONDS);
        run = (WorkflowRun)this.r.buildAndAssertSuccess((Job)job);
        Assert.assertFalse((boolean)postCheckoutOutput2.exists());
        Assert.assertTrue((boolean)postCheckoutOutput1.exists());
        this.r.assertLogContains("Hello Pipeline", (Run)run);
        after = Instant.now().plus(2L, ChronoUnit.SECONDS);
        this.checkFileOutput(postCheckoutOutput1, before, after);
        Assert.assertFalse((boolean)postCheckoutOutput1.exists());
        this.commit("test.txt", "Five", this.johnDoe, "Five");
        this.commit("Jenkinsfile", "/*5*/\n" + jenkinsfile, this.johnDoe, "Jenkinsfile");
        GitHooksConfiguration.get().setAllowedOnController(false);
        GitHooksConfiguration.get().setAllowedOnAgents(false);
        run = (WorkflowRun)this.r.buildAndAssertSuccess((Job)job);
        this.r.assertLogContains("Hello Pipeline", (Run)run);
        Assert.assertFalse((boolean)postCheckoutOutput1.exists());
        Assert.assertFalse((boolean)postCheckoutOutput2.exists());
    }

    private void createHookScriptAt(File postCheckoutOutput, FilePath hook) throws IOException, InterruptedException {
        String nl = System.lineSeparator();
        StringBuilder scriptContent = new StringBuilder("#!/bin/sh -v").append(nl);
        scriptContent.append("date +%s > \"").append(postCheckoutOutput.getAbsolutePath().replace("\\", "\\\\")).append('\"').append(nl);
        hook.write(scriptContent.toString(), Charset.defaultCharset().name());
        hook.chmod(511);
    }

    private void checkFileOutput(File postCheckoutOutput, Instant before, Instant after) throws IOException {
        Assert.assertTrue((String)"Output file should exist", (boolean)postCheckoutOutput.exists());
        String s = Files.readString(postCheckoutOutput.toPath(), Charset.defaultCharset()).trim();
        Instant when = Instant.ofEpochSecond(Integer.parseInt(s));
        Assert.assertTrue((String)"Sometime else", (when.isAfter(before) && when.isBefore(after) ? 1 : 0) != 0);
        Files.delete(postCheckoutOutput.toPath());
    }

    @Test
    public void testPipelineCheckoutController() throws Exception {
        if (this.isWindows() && JENKINS_URL.contains("ci.jenkins.io")) {
            return;
        }
        WorkflowJob job = this.setupAndRunPipelineCheckout("master");
        this.commit("Commit3", this.janeDoe, "Commit number 3");
        GitHooksConfiguration.get().setAllowedOnController(true);
        WorkflowRun run = (WorkflowRun)this.r.buildAndAssertSuccess((Job)job);
        this.r.assertLogContains("h4xor3d", (Run)run);
        GitHooksConfiguration.get().setAllowedOnController(false);
        GitHooksConfiguration.get().setAllowedOnAgents(true);
        this.commit("Commit4", this.janeDoe, "Commit number 4");
        run = (WorkflowRun)this.r.buildAndAssertSuccess((Job)job);
        this.r.assertLogNotContains("h4xor3d", (Run)run);
    }

    @Test
    public void testPipelineCheckoutAgent() throws Exception {
        if (this.isWindows() && JENKINS_URL.contains("ci.jenkins.io")) {
            return;
        }
        this.r.createOnlineSlave(Label.get((String)"belsebob"));
        WorkflowJob job = this.setupAndRunPipelineCheckout("belsebob");
        this.commit("Commit3", this.janeDoe, "Commit number 3");
        GitHooksConfiguration.get().setAllowedOnAgents(true);
        WorkflowRun run = (WorkflowRun)this.r.buildAndAssertSuccess((Job)job);
        this.r.assertLogContains("h4xor3d", (Run)run);
        GitHooksConfiguration.get().setAllowedOnAgents(false);
        GitHooksConfiguration.get().setAllowedOnController(true);
        this.commit("Commit4", this.janeDoe, "Commit number 4");
        run = (WorkflowRun)this.r.buildAndAssertSuccess((Job)job);
        this.r.assertLogNotContains("h4xor3d", (Run)run);
    }

    private WorkflowJob setupAndRunPipelineCheckout(String node) throws Exception {
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        WorkflowJob job = (WorkflowJob)this.r.createProject(WorkflowJob.class);
        String uri = this.testRepo.gitDir.getAbsolutePath().replace("\\", "/");
        job.setDefinition((FlowDefinition)new CpsFlowDefinition(GitHooksTest.lines("node('" + node + "') {", "  checkout([$class: 'GitSCM', branches: [[name: '*/master']], userRemoteConfigs: [[url: '" + uri + "']]])", "  if (!fileExists('.git/hooks/post-checkout')) {", "    writeFile file: '.git/hooks/post-checkout', text: \"#!/bin/sh\\necho h4xor3d\"", "    if (isUnix()) {", "      sh 'chmod +x .git/hooks/post-checkout'", "    }", "  } else {", "    if (isUnix()) {", "      sh 'git checkout -B test origin/master'", "    } else {", "      bat 'git.exe checkout -B test origin/master'", "    }", "  }", "}"), true));
        WorkflowRun run = (WorkflowRun)this.r.buildAndAssertSuccess((Job)job);
        this.r.assertLogNotContains("h4xor3d", (Run)run);
        String commitFile2 = "commitFile2";
        this.commit("commitFile2", this.janeDoe, "Commit number 2");
        run = (WorkflowRun)this.r.buildAndAssertSuccess((Job)job);
        this.r.assertLogNotContains("h4xor3d", (Run)run);
        return job;
    }

    private static String lines(String ... lines) {
        return String.join((CharSequence)"\n", lines);
    }

    private boolean isWindows() {
        return File.pathSeparatorChar == ';';
    }
}

