/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.EnvVars;
import hudson.model.TaskListener;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.GitException;
import hudson.plugins.git.util.GitUtilsTest;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import jenkins.plugins.git.CliGitCommand;
import jenkins.plugins.git.GitSampleRepoRule;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.util.SystemReader;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class GitChangeSetTruncateTest {
    @ClassRule
    public static TemporaryFolder tempFolder = new TemporaryFolder();
    @ClassRule
    public static GitSampleRepoRule versionCheckRepo = new GitSampleRepoRule();
    private static File repoRoot = null;
    private static final Random random = new Random();
    private final String gitImpl;
    private final String commitSummary;
    private final String truncatedSummary;
    private final GitChangeSet changeSet;
    private final GitChangeSet changeSetFullSummary;
    private final GitChangeSet changeSetTruncatedSummary;
    private static final String SEVENTY_CHARS = "[JENKINS-012345] 8901 34567 90 23456 8901 34567 9012 4567890 2345678 0";
    private static final String EIGHTY_CHARS = "12345678901234567890123456789012345678901234567890123456789012345678901234567890";
    private static final TestData[] TEST_DATA = new TestData[]{new TestData("12345678901234567890123456789012345678901234567890123456789012345678901234567890", "12345678901234567890123456789012345678901234567890123456789012345678901234567890"), new TestData("12345678901234567890123456789012345678901234567890123456789012345678901234567890 A B C", "12345678901234567890123456789012345678901234567890123456789012345678901234567890"), new TestData("[JENKINS-012345] 8901 34567 90 23456 8901 34567 9012 4567890 2345678 0", "[JENKINS-012345] 8901 34567 90 23456 8901 34567 9012 4567890 2345678 0"), new TestData("[JENKINS-012345] 8901 34567 90 23456 8901 34567 9012 4567890 2345678 0 2", "[JENKINS-012345] 8901 34567 90 23456 8901 34567 9012 4567890 2345678 0 2"), new TestData("[JENKINS-012345] 8901 34567 90 23456 8901 34567 9012 4567890 2345678 0 2 4", "[JENKINS-012345] 8901 34567 90 23456 8901 34567 9012 4567890 2345678 0 2"), new TestData("[JENKINS-012345] 8901 34567 90 23456 8901 34567 9012 4567890 2345678 0 23", "[JENKINS-012345] 8901 34567 90 23456 8901 34567 9012 4567890 2345678 0"), new TestData("[JENKINS-012345] 8901 34567 90 23456 8901 34567 9012 4567890 2345678 0 2&4", "[JENKINS-012345] 8901 34567 90 23456 8901 34567 9012 4567890 2345678 0"), new TestData("[JENKINS-012345] 8901 34567 90 23456 8901 34567 9012 4567890 2345678 01", "[JENKINS-012345] 8901 34567 90 23456 8901 34567 9012 4567890 2345678 01"), new TestData("[JENKINS-012345] 8901 34567 90 23456 8901 34567 9012 4567890 2345678 01 3", "[JENKINS-012345] 8901 34567 90 23456 8901 34567 9012 4567890 2345678 01"), new TestData("[JENKINS-012345] 8901 34567 90 23456 8901 34567 9012 4567890 2345678 01 <4", "[JENKINS-012345] 8901 34567 90 23456 8901 34567 9012 4567890 2345678 01"), new TestData("[JENKINS-012345] 8901 34567 90 23456 8901 34567 9012 4567890 2345678 01 3 5", "[JENKINS-012345] 8901 34567 90 23456 8901 34567 9012 4567890 2345678 01"), new TestData("[JENKINS-012345] 8901 34567 90 23456 8901 34567 9012 4567890 2345678 01;", "[JENKINS-012345] 8901 34567 90 23456 8901 34567 9012 4567890 2345678 01;"), new TestData("[JENKINS-012345] 8901 34567 90 23456 8901 34567 9012 4567890 2345678 01; 4", "[JENKINS-012345] 8901 34567 90 23456 8901 34567 9012 4567890 2345678 01;"), new TestData("[JENKINS-012345] 8901 34567 90 23456 8901 34567 9012 4567890 2345678 0 [JENKINS-012345] 8901 34567 90 23456 8901 34567 9012 4567890 2345678 0", "[JENKINS-012345] 8901 34567 90 23456 8901 34567 9012 4567890 2345678 0"), new TestData("[JENKINS-012345] 8901 34567 90 23456 8901 34567 9012 4567890 2345678 0  [JENKINS-012345] 8901 34567 90 23456 8901 34567 9012 4567890 2345678 0", "[JENKINS-012345] 8901 34567 90 23456 8901 34567 9012 4567890 2345678 0 ")};

    public GitChangeSetTruncateTest(String gitImpl, String commitSummary, String truncatedSummary) throws Exception {
        this.gitImpl = gitImpl;
        this.commitSummary = commitSummary;
        this.truncatedSummary = truncatedSummary;
        GitClient gitClient = Git.with((TaskListener)TaskListener.NULL, (EnvVars)GitUtilsTest.getConfigNoSystemEnvsVars()).in(repoRoot).using(gitImpl).getClient();
        ObjectId head = this.commitOneFile(gitClient, commitSummary);
        StringWriter changelogStringWriter = new StringWriter();
        gitClient.changelog().includes(head).to((Writer)changelogStringWriter).execute();
        List<String> changeLogList = Arrays.asList(changelogStringWriter.toString().split("\n"));
        this.changeSet = new GitChangeSet(changeLogList, random.nextBoolean());
        this.changeSetFullSummary = new GitChangeSet(changeLogList, random.nextBoolean(), true);
        this.changeSetTruncatedSummary = new GitChangeSet(changeLogList, random.nextBoolean(), false);
    }

    @Parameterized.Parameters(name="{0} \"{1}\" --->>> \"{2}\"")
    public static Collection gitObjects() {
        String[] bothGitImplementations = new String[]{"git", "jgit"};
        ArrayList<Object[]> arguments = new ArrayList<Object[]>();
        for (String implementation : bothGitImplementations) {
            for (TestData sample : TEST_DATA) {
                Object[] item = new Object[]{implementation, sample.testDataCommitSummary, sample.testDataTruncatedSummary};
                arguments.add(item);
            }
        }
        Collections.shuffle(arguments);
        return arguments;
    }

    @BeforeClass
    public static void createRepo() throws Exception {
        SystemReader.getInstance().getUserConfig().clear();
        repoRoot = tempFolder.newFolder();
        String initialImpl = random.nextBoolean() ? "git" : "jgit";
        GitClient gitClient = Git.with((TaskListener)TaskListener.NULL, (EnvVars)GitUtilsTest.getConfigNoSystemEnvsVars()).in(repoRoot).using(initialImpl).getClient();
        gitClient.init_().workspace(repoRoot.getAbsolutePath()).execute();
        String[] expectedResult = new String[]{""};
        CliGitCommand gitCmd = new CliGitCommand(gitClient, "config", "user.name", "ChangeSet Truncation Test");
        MatcherAssert.assertThat((Object)gitCmd.run(), (Matcher)Matchers.is((Object)expectedResult));
        gitCmd = new CliGitCommand(gitClient, "config", "user.email", "ChangeSetTruncation@mail.example.com");
        MatcherAssert.assertThat((Object)gitCmd.run(), (Matcher)Matchers.is((Object)expectedResult));
        gitCmd = new CliGitCommand(gitClient, "config", "commit.gpgsign", "false");
        gitCmd = new CliGitCommand(gitClient, "config", "tag.gpgSign", "false");
        MatcherAssert.assertThat((Object)gitCmd.run(), (Matcher)Matchers.is((Object)expectedResult));
    }

    private ObjectId commitOneFile(GitClient gitClient, String commitSummary) throws Exception {
        String path = "One-File.txt";
        String content = "A random UUID: %s\n".formatted(UUID.randomUUID());
        String commitMessageBody = random.nextBoolean() ? "\n\ncommitting " + path + " with content:\n\n" + content : "";
        String commitMessage = commitSummary + commitMessageBody;
        gitClient.config(GitClient.ConfigLevel.LOCAL, "commit.gpgsign", "false");
        gitClient.config(GitClient.ConfigLevel.LOCAL, "tag.gpgSign", "false");
        this.createFile(path, content);
        gitClient.add(path);
        gitClient.commit(commitMessage);
        List headList = gitClient.revList("HEAD");
        MatcherAssert.assertThat((Object)headList.size(), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        return (ObjectId)headList.get(0);
    }

    private void createFile(String path, String content) throws Exception {
        File aFile = new File(repoRoot, path);
        File parentDir = aFile.getParentFile();
        if (parentDir != null) {
            parentDir.mkdirs();
        }
        try (PrintWriter writer = new PrintWriter(aFile, StandardCharsets.UTF_8);){
            writer.printf(content, new Object[0]);
        }
        catch (FileNotFoundException ex) {
            throw new GitException((Throwable)ex);
        }
    }

    @Test
    public void summaryTruncatedAtLastWord72CharactersOrLess() throws Exception {
        MatcherAssert.assertThat((Object)this.changeSet.getMsg(), (Matcher)Matchers.is((Object)this.truncatedSummary));
    }

    @Test
    public void summaryAlwaysTruncatedAtLastWord72CharactersOrLess() throws Exception {
        MatcherAssert.assertThat((Object)this.changeSetTruncatedSummary.getMsg(), (Matcher)Matchers.is((Object)this.truncatedSummary));
    }

    @Test
    public void summaryNotTruncatedAtLastWord72CharactersOrLess() throws Exception {
        MatcherAssert.assertThat((Object)this.changeSetFullSummary.getMsg(), (Matcher)Matchers.is((Object)this.commitSummary));
    }

    private static class TestData {
        public final String testDataCommitSummary;
        public final String testDataTruncatedSummary;

        TestData(String commitSummary, String truncatedSummary) {
            this.testDataCommitSummary = commitSummary;
            this.testDataTruncatedSummary = truncatedSummary;
        }
    }
}

