/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.model.User;
import hudson.plugins.git.GitChangeSet;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;

public class GitChangeSetBadArgsTest {
    @Rule
    public JenkinsRule r = new JenkinsRule();
    private static final String DEGENERATE_EMAIL_ADDRESS = "@";

    private GitChangeSet createChangeSet(boolean authorOrCommitter, String name, String email) {
        String dataSource = authorOrCommitter ? "Author" : "Committer";
        ArrayList<Object> lines = new ArrayList<Object>();
        lines.add("commit 1567861636cd854f4dd6fa40bf94c0c657681dd5");
        lines.add("tree 66236cf9a1ac0c589172b450ed01f019a5697c49");
        lines.add("parent e74a24e995305bd67a180f0ebc57927e2b8783ce");
        if (authorOrCommitter) {
            lines.add("author " + name + " <" + email + "> 1363879004 +0100");
            lines.add("committer Good Committer <good.committer@example.com> 1364199539 -0400");
        } else {
            lines.add("author Good Author <good.author@example.com> 1363879004 +0100");
            lines.add("committer " + name + " <" + email + "> 1364199539 -0400");
        }
        lines.add("");
        lines.add("    " + dataSource + " has e-mail address '" + email + "' and name '" + name + "'.");
        lines.add("    ");
        lines.add("    Changes in this version:");
        lines.add("    - " + dataSource + " mutated e-mail address and name.");
        lines.add("    ");
        lines.add("");
        return new GitChangeSet(lines, authorOrCommitter);
    }

    private GitChangeSet createAuthorChangeSet(String authorName, String authorEmail) {
        return this.createChangeSet(true, authorName, authorEmail);
    }

    private GitChangeSet createCommitterChangeSet(String committerName, String committerEmail) {
        return this.createChangeSet(false, committerName, committerEmail);
    }

    @Test
    public void testFindOrCreateUserAuthorBadEmail() {
        String authorName = "Bad Author Test 1";
        GitChangeSet changeSet = this.createAuthorChangeSet(authorName, DEGENERATE_EMAIL_ADDRESS);
        Assert.assertEquals((Object)User.getUnknown(), (Object)changeSet.findOrCreateUser(authorName, DEGENERATE_EMAIL_ADDRESS, false, false));
        Assert.assertEquals((Object)User.getUnknown(), (Object)changeSet.findOrCreateUser(null, DEGENERATE_EMAIL_ADDRESS, false, false));
        Assert.assertEquals((Object)User.getUnknown(), (Object)changeSet.findOrCreateUser("", DEGENERATE_EMAIL_ADDRESS, false, false));
    }

    @Test
    public void testFindOrCreateUserCommitterBadEmail() {
        String committerName = "Bad Committer Test 2";
        GitChangeSet changeSet = this.createCommitterChangeSet(committerName, DEGENERATE_EMAIL_ADDRESS);
        Assert.assertEquals((Object)User.getUnknown(), (Object)changeSet.findOrCreateUser(committerName, DEGENERATE_EMAIL_ADDRESS, false, false));
        Assert.assertEquals((Object)User.getUnknown(), (Object)changeSet.findOrCreateUser(null, DEGENERATE_EMAIL_ADDRESS, false, false));
        Assert.assertEquals((Object)User.getUnknown(), (Object)changeSet.findOrCreateUser("", DEGENERATE_EMAIL_ADDRESS, false, false));
    }

    @Test
    public void testFindOrCreateUserEmptyAuthor() {
        String emptyAuthorName = "";
        String incompleteAuthorEmail = "@test3.example.com";
        GitChangeSet changeSet = this.createAuthorChangeSet(emptyAuthorName, incompleteAuthorEmail);
        Assert.assertEquals((Object)User.getUnknown(), (Object)changeSet.findOrCreateUser(emptyAuthorName, incompleteAuthorEmail, false, false));
        Assert.assertEquals((Object)User.getUnknown(), (Object)changeSet.findOrCreateUser(null, incompleteAuthorEmail, false, false));
        Assert.assertEquals((Object)User.getUnknown(), (Object)changeSet.findOrCreateUser("", incompleteAuthorEmail, false, false));
    }

    @Test
    public void testFindOrCreateEmptyCommitter() {
        String emptyCommitterName = "";
        String incompleteCommitterEmail = "@test4.example.com";
        GitChangeSet changeSet = this.createCommitterChangeSet(emptyCommitterName, incompleteCommitterEmail);
        Assert.assertEquals((Object)User.getUnknown(), (Object)changeSet.findOrCreateUser(emptyCommitterName, incompleteCommitterEmail, false, false));
        Assert.assertEquals((Object)User.getUnknown(), (Object)changeSet.findOrCreateUser(null, incompleteCommitterEmail, false, false));
        Assert.assertEquals((Object)User.getUnknown(), (Object)changeSet.findOrCreateUser("", incompleteCommitterEmail, false, false));
    }

    @Test
    public void testFindOrCreateUserEmptyAuthorEmail() {
        String authorName = "Author Test 5";
        String emptyAuthorEmail = "";
        GitChangeSet changeSet = this.createAuthorChangeSet(authorName, emptyAuthorEmail);
        Assert.assertEquals((Object)User.getUnknown(), (Object)changeSet.findOrCreateUser(authorName, emptyAuthorEmail, false, false));
        Assert.assertEquals((Object)User.getUnknown(), (Object)changeSet.findOrCreateUser(authorName, emptyAuthorEmail, true, false));
    }

    @Test
    public void testFindOrCreateUserNullAuthorEmail() {
        String authorName = "Author Test 6";
        String emptyAuthorEmail = "";
        GitChangeSet changeSet = this.createAuthorChangeSet(authorName, emptyAuthorEmail);
        Assert.assertEquals((Object)User.getUnknown(), (Object)changeSet.findOrCreateUser(authorName, null, false, false));
        Assert.assertEquals((Object)User.getUnknown(), (Object)changeSet.findOrCreateUser(authorName, null, true, false));
    }

    @Test
    public void testFindOrCreateUserEmptyCommitterEmail() {
        String committerName = "Committer Test 7";
        String emptyCommitterEmail = "";
        GitChangeSet changeSet = this.createCommitterChangeSet(committerName, emptyCommitterEmail);
        Assert.assertEquals((Object)User.getUnknown(), (Object)changeSet.findOrCreateUser(committerName, emptyCommitterEmail, false, false));
        Assert.assertEquals((Object)User.getUnknown(), (Object)changeSet.findOrCreateUser(committerName, emptyCommitterEmail, true, false));
    }

    @Test
    public void testFindOrCreateUserNullCommitterEmail() {
        String committerName = "Committer Test 8";
        String emptyCommitterEmail = "";
        GitChangeSet changeSet = this.createCommitterChangeSet(committerName, emptyCommitterEmail);
        Assert.assertEquals((Object)User.getUnknown(), (Object)changeSet.findOrCreateUser(committerName, null, false, false));
        Assert.assertEquals((Object)User.getUnknown(), (Object)changeSet.findOrCreateUser(committerName, null, true, false));
    }
}

