/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.EnvVars;
import hudson.model.TaskListener;
import hudson.plugins.git.GitChangeLogParser;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.GitChangeSetList;
import java.io.File;
import java.io.FileWriter;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jenkinsci.plugins.gitclient.CliGitAPIImpl;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.gitclient.JGitAPIImpl;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class GitChangeLogParserTest {
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();
    private final String firstMessageTruncated = "123456789 123456789 123456789 123456789 123456789 123456789 123456789 1";
    private final String firstMessage = "123456789 123456789 123456789 123456789 123456789 123456789 123456789 1 345 789";

    @Test
    public void testDuplicatesFilteredCliGit() throws Exception {
        GitClient gitClient = Git.with((TaskListener)TaskListener.NULL, (EnvVars)new EnvVars()).using("Default").in(new File(".")).getClient();
        MatcherAssert.assertThat((Object)gitClient, (Matcher)Matchers.instanceOf(CliGitAPIImpl.class));
        this.generateDuplicateChanges(gitClient, "123456789 123456789 123456789 123456789 123456789 123456789 123456789 1");
    }

    @Test
    public void testDuplicatesFilteredJGit() throws Exception {
        GitClient gitClient = Git.with((TaskListener)TaskListener.NULL, (EnvVars)new EnvVars()).using("jgit").in(new File(".")).getClient();
        MatcherAssert.assertThat((Object)gitClient, (Matcher)Matchers.instanceOf(JGitAPIImpl.class));
        this.generateDuplicateChanges(gitClient, "123456789 123456789 123456789 123456789 123456789 123456789 123456789 1 345 789");
    }

    private void generateDuplicateChanges(GitClient gitClient, String expectedMessage) throws Exception {
        GitChangeLogParser parser = new GitChangeLogParser(gitClient, true);
        File log = this.tmpFolder.newFile();
        try (FileWriter writer = new FileWriter(log);){
            writer.write("commit 123abc456def\n");
            writer.write("    123456789 123456789 123456789 123456789 123456789 123456789 123456789 1 345 789\n");
            writer.write("commit 123abc456def\n");
            writer.write("    second message");
        }
        GitChangeSetList list = parser.parse(null, null, log);
        Assert.assertNotNull((Object)list);
        Assert.assertNotNull((Object)list.getLogs());
        Assert.assertEquals((long)1L, (long)list.getLogs().size());
        GitChangeSet first = (GitChangeSet)list.getLogs().get(0);
        Assert.assertNotNull((Object)first);
        Assert.assertEquals((Object)"123abc456def", (Object)first.getId());
        MatcherAssert.assertThat((Object)first.getMsg(), (Matcher)Matchers.is((Object)expectedMessage));
        Assert.assertTrue((String)("Temp file delete failed for " + String.valueOf(log)), (boolean)log.delete());
    }
}

