/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.SystemCredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.ModelObject;
import hudson.model.Run;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import jenkins.model.Jenkins;
import jenkins.plugins.git.GitSampleRepoRule;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;

public class CredentialsUserRemoteConfigTest {
    @Rule
    public JenkinsRule r = new JenkinsRule();
    @Rule
    public GitSampleRepoRule sampleRepo = new GitSampleRepoRule();
    private CredentialsStore store = null;
    private boolean useSymbolForGitSCM = true;
    private Random random = new Random();
    private String credential = "undefined-credential";
    private static final String SHA_TO_REPLACE = "feedbeefbeadcededeedabed";

    @Before
    public void enableSystemCredentialsProvider() {
        SystemCredentialsProvider.getInstance().setDomainCredentialsMap(Collections.singletonMap(Domain.global(), Collections.emptyList()));
        for (CredentialsStore s : CredentialsProvider.lookupStores((ModelObject)Jenkins.get())) {
            if (!(s.getProvider() instanceof SystemCredentialsProvider.ProviderImpl)) continue;
            this.store = s;
            break;
        }
        MatcherAssert.assertThat((String)"The system credentials provider is enabled", (Object)this.store, (Matcher)Matchers.notNullValue());
    }

    @Before
    public void chooseSymbolForGitSCM() {
        this.useSymbolForGitSCM = this.random.nextBoolean();
    }

    @Before
    public void generateCredentialID() {
        this.credential = "credential-id-" + (100 + this.random.nextInt(900));
    }

    @Before
    public void initSampleRepo() throws Exception {
        this.sampleRepo.init();
        Assert.assertTrue((String)"Failed to create src dir in sample repo", (boolean)this.sampleRepo.mkdirs("src"));
        this.sampleRepo.write("src/sample.txt", "Contents of src/sample.txt");
        this.sampleRepo.git("add", "src/sample.txt");
        this.sampleRepo.git("commit", "-m", "Add src/sample.txt to sample repo");
    }

    private String classPrologue() {
        if (this.useSymbolForGitSCM) {
            return "    scmGit(\n";
        }
        return "    [$class: 'GitSCM', \n";
    }

    private String classEpilogue() {
        if (this.useSymbolForGitSCM) {
            return "    )\n";
        }
        return "    ]\n";
    }

    private WorkflowJob createProjectWithCredential() throws Exception {
        return this.createProject(true);
    }

    private WorkflowJob createProject(boolean useCredential) throws Exception {
        String credentialsPhrase = useCredential ? "credentialsId: '" + this.credential + "', " : "";
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("node {\n  checkout(\n" + this.classPrologue() + "      userRemoteConfigs: [[" + credentialsPhrase + "url: $/" + String.valueOf((Object)this.sampleRepo) + "/$]]\n" + this.randomPipelineCheckoutExtras() + this.classEpilogue() + "  )}", true));
        return p;
    }

    private String randomPipelineExtensions() {
        int extensionCount;
        String[] extensions = new String[]{"[$class: 'BuildChooserSetting', buildChooser: [$class: 'AncestryBuildChooser', ancestorCommitSha1: 'feedbeefbeadcededeedabed', maximumAgeInDays: 23]]", "[$class: 'SparseCheckoutPaths', sparseCheckoutPaths: [[path: 'src'], [path: 'Makefile']]]", "[$class: 'AuthorInChangelog']", "[$class: 'BuildChooserSetting', buildChooser: [$class: 'DefaultBuildChooser']]", "[$class: 'BuildSingleRevisionOnly']", "[$class: 'ChangelogToBranch', options: [compareRemote: 'origin', compareTarget: 'master']]", "[$class: 'CheckoutOption', timeout: 1]", "[$class: 'CleanBeforeCheckout']", "[$class: 'CleanCheckout']", "[$class: 'DisableRemotePoll']", "[$class: 'LocalBranch', localBranch: 'master']", "[$class: 'PreBuildMerge', options: [mergeRemote: 'origin', mergeTarget: 'master']]", "[$class: 'PruneStaleBranch']", "[$class: 'PruneStaleTag']", "[$class: 'SubmoduleOption', disableSubmodules: true]", "[$class: 'SubmoduleOption', depth: 1, shallow: true]", "[$class: 'SubmoduleOption', parentCredentials: true, recursiveSubmodules: true, threads: 13]", "[$class: 'SubmoduleOption', depth: 17, disableSubmodules: false, parentCredentials: true, recursiveSubmodules: true, reference: '/cache/git1.git', shallow: true, threads: 13, timeout: 11, trackingSubmodules: true]", "[$class: 'UserIdentity', email: 'custom.user.email@example.com', name: 'Custom User Name']", "[$class: 'WipeWorkspace']", "authorInChangelog()", "buildSingleRevisionOnly()", "changelogToBranch(changelogBase(compareRemote: 'origin', compareTarget: 'master'))", "checkoutOption(timeout: 17)", "cleanAfterCheckout()", "cleanAfterCheckout(deleteUntrackedNestedRepositories: false)", "cleanAfterCheckout(deleteUntrackedNestedRepositories: true)", "cleanBeforeCheckout()", "cleanBeforeCheckout(deleteUntrackedNestedRepositories: false)", "cleanBeforeCheckout(deleteUntrackedNestedRepositories: true)", "cloneOption(depth: 3, honorRefspec: true, noTags: true, reference: '/cache/git2.git', shallow: true, timeout: 13)", "cloneOption(depth: 3, honorRefspec: true, noTags: true, reference: '/cache/git3.git', shallow: true)", "cloneOption(depth: 3, honorRefspec: true, noTags: true, reference: '/cache/git4.git')", "cloneOption(depth: 3, honorRefspec: true, noTags: true)", "cloneOption(depth: 3, honorRefspec: true)", "cloneOption(depth: 3)", "cloneOption(honorRefspec: true, noTags: true, reference: '/cache/git5.git', shallow: true, timeout: 13)", "cloneOption(honorRefspec: true, noTags: true, reference: '/cache/git6.git', shallow: true)", "cloneOption(honorRefspec: true, noTags: true, reference: '/cache/git7.git')", "cloneOption(honorRefspec: true, noTags: true)", "cloneOption(honorRefspec: true)", "localBranch('master')", "perBuildTag()", "pruneStaleBranch()", "pruneTags()", "pruneTags(false)", "pruneTags(true)", "sparseCheckout(sparseCheckoutPaths: [[path: 'src'], [path: 'Makefile']])", "submodule(disableSubmodules: true)", "submodule(depth: 1, shallow: true)", "submodule(parentCredentials: true, recursiveSubmodules: true, threads: 13)", "submodule(depth: 17, disableSubmodules: false, parentCredentials: true, recursiveSubmodules: true, reference: '/cache/git1.git', shallow: true, threads: 13, timeout: 11, trackingSubmodules: true)"};
        List<String> extensionList = Arrays.asList(extensions);
        if (this.sampleRepo.hasGitLFS()) {
            extensionList = new ArrayList<String>(extensionList);
            extensionList.add("[$class: 'GitLFSPull']");
            extensionList.add("lfs()");
        }
        if ((extensionCount = this.random.nextInt(extensionList.size())) == 0) {
            return "";
        }
        Collections.shuffle(extensionList);
        StringBuilder extensionBuffer = new StringBuilder();
        extensionBuffer.append("      , extensions: [\n");
        int added = 0;
        for (String extension : extensionList) {
            if (added >= extensionCount) break;
            extensionBuffer.append("                    ");
            if (added != 0) {
                extensionBuffer.append(',');
            }
            extensionBuffer.append(extension);
            extensionBuffer.append('\n');
            ++added;
        }
        extensionBuffer.append("      ]\n");
        return extensionBuffer.toString();
    }

    private String randomPipelineCheckoutExtras() throws Exception {
        String[] browsers = new String[]{"", "[$class: 'BitbucketWeb', repoUrl: 'https://markewaite@bitbucket.org/markewaite/git-plugin']", "[$class: 'CGit', repoUrl: 'https://git.zx2c4.com/cgit']", "[$class: 'FisheyeGitRepositoryBrowser', repoUrl: 'https://fisheye.apache.org/browse/ant-git']", "[$class: 'GitBlitRepositoryBrowser', repoUrl: 'https://github.com/MarkEWaite/git-plugin', projectName: 'git-plugin-project-name-value']", "[$class: 'GitLab', repoUrl: 'https://gitlab.com/MarkEWaite/git-client-plugin', version: '12.10.1']", "[$class: 'GitLab', repoUrl: 'https://gitlab.com/MarkEWaite/git-client-plugin']", "[$class: 'GitList', repoUrl: 'http://gitlist.org/']", "[$class: 'GitWeb', repoUrl: 'https://git.ti.com/gitweb']", "[$class: 'GithubWeb', repoUrl: 'https://github.com/jenkinsci/git-plugin']", "[$class: 'Gitiles', repoUrl: 'https://gerrit.googlesource.com/gitiles/']", "[$class: 'GogsGit', repoUrl: 'https://try.gogs.io/MarkEWaite/git-plugin']", "[$class: 'KilnGit', repoUrl: 'https://kiln.example.com/MarkEWaite/git-plugin']", "[$class: 'Phabricator', repo: 'source/tool-spacemedia', repoUrl: 'https://phabricator.wikimedia.org/source/tool-spacemedia/']", "[$class: 'RedmineWeb', repoUrl: 'https://www.redmine.org/projects/redmine/repository']", "[$class: 'RhodeCode', repoUrl: 'https://code.rhodecode.com/rhodecode-enterprise-ce']", "[$class: 'Stash', repoUrl: 'https://markewaite@bitbucket.org/markewaite/git-plugin']", "[$class: 'TFS2013GitRepositoryBrowser', repoUrl: 'https://markwaite.visualstudio.com/DefaultCollection/git-plugin/_git/git-plugin']", "[$class: 'TFS2013GitRepositoryBrowser', repoUrl: 'https://dev.azure.com/MarkEWaite/git-plugin/_git/git-plugin']", "[$class: 'ViewGitWeb', repoUrl: 'https://git.ti.com/gitweb', projectName: 'viewgitweb-project-name-value']", "bitbucket('https://markewaite@bitbucket.org/markewaite/git-plugin')", "cgit('https://git.zx2c4.com/cgit')", "fisheye('https://fisheye.apache.org/browse/ant-git')", "gitblit(repoUrl: 'https://github.com/MarkEWaite/git-client-plugin', projectName: 'git-plugin-project-name-value')", "gitLab(repoUrl: 'https://gitlab.com/MarkEWaite/git-client-plugin', version: '12.10.1')", "gitList('http://gitlist.org/')", "gitWeb('https://git.ti.com/gitweb')", "github('https://github.com/jenkinsci/git-plugin')", "gitiles('https://gerrit.googlesource.com/gitiles/')", "gogs('https://try.gogs.io/MarkEWaite/git-plugin')", "kiln('https://kiln.example.com/MarkEWaite/git-plugin')", "teamFoundation('https://markwaite.visualstudio.com/DefaultCollection/git-plugin/_git/git-plugin')", "teamFoundation('https://dev.azure.com/MarkEWaite/git-plugin/_git/git-plugin')", "phabricator(repo: 'source/tool-spacemedia', repoUrl: 'https://phabricator.wikimedia.org/source/tool-spacemedia/')", "redmine('https://www.redmine.org/projects/redmine/repository')", "rhodeCode('https://code.rhodecode.com/rhodecode-enterprise-ce')", "viewgit(repoUrl: 'https://repo.or.cz/viewgit.git', projectName: 'viewgit-project-name-value')"};
        String browser = browsers[this.random.nextInt(browsers.length)];
        StringBuilder extras = new StringBuilder();
        if (!browser.isEmpty()) {
            extras.append("      , browser: ");
            extras.append(browser);
            extras.append('\n');
        }
        extras.append(this.randomPipelineExtensions().replace(SHA_TO_REPLACE, this.sampleRepo.head()));
        if (this.random.nextBoolean()) {
            extras.append("      , doGenerateSubmoduleConfigurations: false\n");
            extras.append("      , submoduleCfg: []\n");
        }
        return extras.toString();
    }

    @Test
    public void checkoutWithValidCredentials() throws Exception {
        this.store.addCredentials(Domain.global(), (Credentials)this.createCredential(CredentialsScope.GLOBAL, this.credential));
        this.store.save();
        WorkflowJob p = this.createProjectWithCredential();
        WorkflowRun b = (WorkflowRun)this.r.buildAndAssertSuccess((Job)p);
        this.r.waitForMessage("using credential " + this.credential, (Run)b);
    }

    @Test
    public void checkoutWithDifferentCredentials() throws Exception {
        this.store.addCredentials(Domain.global(), (Credentials)this.createCredential(CredentialsScope.GLOBAL, "other"));
        this.store.save();
        String notOtherCredential = "not-other-" + (100 + this.random.nextInt(900));
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("node {\n  checkout(\n" + this.classPrologue() + "      userRemoteConfigs: [[credentialsId: '" + notOtherCredential + "', url: $/" + String.valueOf((Object)this.sampleRepo) + "/$]]\n" + this.classEpilogue() + "  )}", true));
        WorkflowRun b = (WorkflowRun)this.r.buildAndAssertSuccess((Job)p);
        this.r.waitForMessage("Warning: CredentialId \"" + notOtherCredential + "\" could not be found", (Run)b);
    }

    @Test
    public void checkoutWithInvalidCredentials() throws Exception {
        String systemCredential = "system-credential-" + (100 + this.random.nextInt(900));
        this.store.addCredentials(Domain.global(), (Credentials)this.createCredential(CredentialsScope.SYSTEM, systemCredential));
        this.store.save();
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("node {\n  checkout(\n" + this.classPrologue() + "      userRemoteConfigs: [[credentialsId: '" + systemCredential + "', url: $/" + String.valueOf((Object)this.sampleRepo) + "/$]]\n" + this.classEpilogue() + "  )}", true));
        WorkflowRun b = (WorkflowRun)this.r.buildAndAssertSuccess((Job)p);
        this.r.waitForMessage("Warning: CredentialId \"" + systemCredential + "\" could not be found", (Run)b);
    }

    @Test
    public void checkoutWithNoCredentialsStoredButUsed() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("node {\n  checkout(\n" + this.classPrologue() + "      userRemoteConfigs: [[credentialsId: '" + this.credential + "', url: $/" + String.valueOf((Object)this.sampleRepo) + "/$]]\n" + this.classEpilogue() + "  )}", true));
        WorkflowRun b = (WorkflowRun)this.r.buildAndAssertSuccess((Job)p);
        this.r.waitForMessage("Warning: CredentialId \"" + this.credential + "\" could not be found", (Run)b);
    }

    @Test
    public void checkoutWithNoCredentialsSpecified() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("node {\n  checkout(\n" + this.classPrologue() + "      userRemoteConfigs: [[url: $/" + String.valueOf((Object)this.sampleRepo) + "/$]]\n" + this.classEpilogue() + "  )}", true));
        WorkflowRun b = (WorkflowRun)this.r.buildAndAssertSuccess((Job)p);
        this.r.waitForMessage("No credentials specified", (Run)b);
    }

    private StandardCredentials createCredential(CredentialsScope scope, String id) throws Descriptor.FormException {
        return new UsernamePasswordCredentialsImpl(scope, id, "desc: " + id, "username", "password-longer-than-14");
    }
}

