/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.extensions.impl;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.extensions.GitSCMExtension;
import hudson.plugins.git.extensions.GitSCMExtensionDescriptor;
import hudson.plugins.git.extensions.impl.SparseCheckoutPath;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.gitclient.CheckoutCommand;
import org.jenkinsci.plugins.gitclient.CloneCommand;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.gitclient.UnsupportedCommand;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.kohsuke.stapler.DataBoundConstructor;

public class SparseCheckoutPaths
extends GitSCMExtension {
    private final List<SparseCheckoutPath> sparseCheckoutPaths;

    @DataBoundConstructor
    public SparseCheckoutPaths(List<SparseCheckoutPath> sparseCheckoutPaths) {
        this.sparseCheckoutPaths = sparseCheckoutPaths == null ? Collections.emptyList() : sparseCheckoutPaths;
    }

    @Whitelisted
    public List<SparseCheckoutPath> getSparseCheckoutPaths() {
        return this.sparseCheckoutPaths;
    }

    @Override
    public void decorateCloneCommand(GitSCM scm, Run<?, ?> build, GitClient git, TaskListener listener, CloneCommand cmd) throws IOException, InterruptedException, GitException {
        if (!this.sparseCheckoutPaths.isEmpty()) {
            listener.getLogger().println("Using no checkout clone with sparse checkout.");
        }
    }

    @Override
    public void decorateCheckoutCommand(GitSCM scm, Run<?, ?> build, GitClient git, TaskListener listener, CheckoutCommand cmd) throws IOException, InterruptedException, GitException {
        cmd.sparseCheckoutPaths(Lists.transform(this.sparseCheckoutPaths, (Function)SparseCheckoutPath.SPARSE_CHECKOUT_PATH_TO_PATH));
    }

    @Override
    public void determineSupportForJGit(GitSCM scm, @NonNull UnsupportedCommand cmd) {
        cmd.sparseCheckoutPaths(Lists.transform(this.sparseCheckoutPaths, (Function)SparseCheckoutPath.SPARSE_CHECKOUT_PATH_TO_PATH));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        SparseCheckoutPaths that = (SparseCheckoutPaths)((Object)o);
        return Objects.equals(this.getSparseCheckoutPaths(), that.getSparseCheckoutPaths());
    }

    public int hashCode() {
        return Objects.hash(this.getSparseCheckoutPaths());
    }

    public String toString() {
        return "SparseCheckoutPaths{sparseCheckoutPaths=" + this.sparseCheckoutPaths + "}";
    }

    @Extension
    @Symbol(value={"sparseCheckout"})
    public static class DescriptorImpl
    extends GitSCMExtensionDescriptor {
        public String getDisplayName() {
            return "Sparse checkout paths";
        }
    }
}

