/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.util;

import com.google.common.base.Throwables;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.TaskListener;
import hudson.plugins.git.GitException;
import hudson.plugins.git.Messages;
import hudson.plugins.git.Revision;
import hudson.plugins.git.util.BuildChooserContext;
import hudson.plugins.git.util.BuildChooserDescriptor;
import hudson.plugins.git.util.BuildData;
import hudson.plugins.git.util.DefaultBuildChooser;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Predicate;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.gitclient.RepositoryCallback;
import org.kohsuke.stapler.DataBoundConstructor;

public class AncestryBuildChooser
extends DefaultBuildChooser {
    private final Integer maximumAgeInDays;
    private final String ancestorCommitSha1;
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public AncestryBuildChooser(Integer maximumAgeInDays, String ancestorCommitSha1) {
        this.maximumAgeInDays = maximumAgeInDays;
        this.ancestorCommitSha1 = ancestorCommitSha1;
    }

    public Integer getMaximumAgeInDays() {
        return this.maximumAgeInDays;
    }

    public String getAncestorCommitSha1() {
        return this.ancestorCommitSha1;
    }

    @Override
    public Collection<Revision> getCandidateRevisions(boolean isPollCall, String branchSpec, GitClient git, TaskListener listener, BuildData data, BuildChooserContext context) throws GitException, IOException, InterruptedException {
        Collection<Revision> candidates = super.getCandidateRevisions(isPollCall, branchSpec, git, listener, data, context);
        return (Collection)git.withRepository((RepositoryCallback & Serializable)(repository, channel) -> {
            try (RevWalk walk = new RevWalk(repository);){
                RevCommit ancestor = null;
                if (this.ancestorCommitSha1 != null && !this.ancestorCommitSha1.isEmpty()) {
                    try {
                        ancestor = walk.parseCommit((AnyObjectId)ObjectId.fromString((String)this.ancestorCommitSha1));
                    }
                    catch (IllegalArgumentException e) {
                        throw new GitException((Throwable)e);
                    }
                }
                CommitAgeFilter ageFilter = new CommitAgeFilter(this.maximumAgeInDays);
                AncestryFilter ancestryFilter = new AncestryFilter(walk, ancestor);
                ArrayList<Revision> filteredCandidates = new ArrayList<Revision>();
                try {
                    for (Revision currentRevision : candidates) {
                        RevCommit currentRev = walk.parseCommit((AnyObjectId)ObjectId.fromString((String)currentRevision.getSha1String()));
                        if (ageFilter.isEnabled() && !ageFilter.test(currentRev) || ancestryFilter.isEnabled() && !ancestryFilter.test(currentRev)) continue;
                        filteredCandidates.add(currentRevision);
                    }
                }
                catch (Throwable e) {
                    Iterator ioeIter = Throwables.getCausalChain((Throwable)e).stream().filter(IOException.class::isInstance).map(IOException.class::cast).iterator();
                    if (ioeIter.hasNext()) {
                        throw (IOException)ioeIter.next();
                    }
                    throw Throwables.propagate((Throwable)e);
                }
                ArrayList<Revision> arrayList = filteredCandidates;
                return arrayList;
            }
        });
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildChooserDescriptor {
        public String getDisplayName() {
            return Messages.BuildChooser_Ancestry();
        }
    }

    private static class AncestryFilter
    implements Predicate<RevCommit> {
        RevWalk revwalk;
        RevCommit ancestor;

        public AncestryFilter(RevWalk revwalk, RevCommit ancestor) {
            this.revwalk = revwalk;
            this.ancestor = ancestor;
        }

        @Override
        public boolean test(RevCommit rev) {
            try {
                return this.revwalk.isMergedInto(this.ancestor, rev);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public boolean isEnabled() {
            return this.revwalk != null && this.ancestor != null;
        }
    }

    private static class CommitAgeFilter
    implements Predicate<RevCommit> {
        private LocalDateTime oldestAllowableCommitDate = null;

        public CommitAgeFilter(Integer oldestAllowableAgeInDays) {
            if (oldestAllowableAgeInDays != null && oldestAllowableAgeInDays >= 0) {
                this.oldestAllowableCommitDate = LocalDate.now().atStartOfDay().minusDays(oldestAllowableAgeInDays.intValue());
            }
        }

        @Override
        public boolean test(@NonNull RevCommit rev) {
            return LocalDateTime.ofInstant(rev.getCommitterIdent().getWhen().toInstant(), ZoneId.systemDefault()).isAfter(this.oldestAllowableCommitDate);
        }

        public boolean isEnabled() {
            return this.oldestAllowableCommitDate != null;
        }
    }
}

