/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import hudson.plugins.git.GitTool;
import hudson.tools.BatchCommandInstaller;
import hudson.tools.CommandInstaller;
import hudson.tools.InstallSourceProperty;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolProperty;
import hudson.tools.ZipExtractionInstaller;
import hudson.util.DescribableList;
import io.jenkins.plugins.casc.misc.RoundTripAbstractTest;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.beans.HasPropertyWithValue;
import org.hamcrest.collection.IsArrayWithSize;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.core.AllOf;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.jvnet.hudson.test.RestartableJenkinsRule;

public class GitToolJCasCCompatibilityTest
extends RoundTripAbstractTest {
    protected void assertConfiguredAsExpected(RestartableJenkinsRule restartableJenkinsRule, String s) {
        ToolDescriptor descriptor = (ToolDescriptor)restartableJenkinsRule.j.jenkins.getDescriptor(GitTool.class);
        ToolInstallation[] installations = descriptor.getInstallations();
        MatcherAssert.assertThat((Object)installations, (Matcher)IsArrayWithSize.arrayWithSize((int)1));
        Assert.assertEquals((Object)"Default", (Object)installations[0].getName());
        Assert.assertEquals((Object)"git", (Object)installations[0].getHome());
        DescribableList properties = installations[0].getProperties();
        MatcherAssert.assertThat((Object)properties, (Matcher)IsCollectionWithSize.hasSize((int)1));
        ToolProperty property = (ToolProperty)properties.get(0);
        MatcherAssert.assertThat((Object)((InstallSourceProperty)property).installers, (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(CommandInstaller.class), HasPropertyWithValue.hasProperty((String)"command", (Matcher)IsEqual.equalTo((Object)"install git")), HasPropertyWithValue.hasProperty((String)"toolHome", (Matcher)IsEqual.equalTo((Object)"/my/path/1")), HasPropertyWithValue.hasProperty((String)"label", (Matcher)IsEqual.equalTo((Object)"git command"))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(ZipExtractionInstaller.class), HasPropertyWithValue.hasProperty((String)"url", (Matcher)IsEqual.equalTo((Object)"http://fake.com")), HasPropertyWithValue.hasProperty((String)"subdir", (Matcher)IsEqual.equalTo((Object)"/my/path/2")), HasPropertyWithValue.hasProperty((String)"label", (Matcher)IsEqual.equalTo((Object)"git zip"))}), AllOf.allOf((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(BatchCommandInstaller.class), HasPropertyWithValue.hasProperty((String)"command", (Matcher)IsEqual.equalTo((Object)"run batch command")), HasPropertyWithValue.hasProperty((String)"toolHome", (Matcher)IsEqual.equalTo((Object)"/my/path/3")), HasPropertyWithValue.hasProperty((String)"label", (Matcher)IsEqual.equalTo((Object)"git batch"))})}));
    }

    protected String stringInLogExpected() {
        return ".installations = [GitTool[Default]]";
    }

    protected String configResource() {
        return "tool-casc.yaml";
    }
}

