/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import com.cloudbees.plugins.credentials.common.StandardCredentials;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.TaskListener;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.plugins.git.GitException;
import hudson.plugins.git.UserRemoteConfig;
import hudson.plugins.git.util.GitUtilsTest;
import hudson.tasks.Mailer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.lib.PersonIdent;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;

public class TestGitRepo {
    protected String name;
    protected TaskListener listener;
    public File gitDir;
    public FilePath gitDirPath;
    public GitClient git;
    public final PersonIdent johnDoe = new PersonIdent("John Doe", "john@doe.com");
    public final PersonIdent janeDoe = new PersonIdent("Jane Doe", "jane@doe.com");

    public TestGitRepo(String name, File tmpDir, TaskListener listener) throws IOException, InterruptedException {
        this.name = name;
        this.listener = listener;
        EnvVars envVars = GitUtilsTest.getConfigNoSystemEnvsVars();
        this.gitDir = tmpDir;
        User john = User.getOrCreateByIdOrFullName((String)this.johnDoe.getName());
        Mailer.UserProperty johnsMailerProperty = new Mailer.UserProperty(this.johnDoe.getEmailAddress());
        john.addProperty((UserProperty)johnsMailerProperty);
        User jane = User.getOrCreateByIdOrFullName((String)this.janeDoe.getName());
        Mailer.UserProperty janesMailerProperty = new Mailer.UserProperty(this.janeDoe.getEmailAddress());
        jane.addProperty((UserProperty)janesMailerProperty);
        this.gitDirPath = new FilePath(this.gitDir);
        this.git = Git.with((TaskListener)listener, (EnvVars)envVars).in(this.gitDir).getClient();
        this.git.init();
        this.git.config(GitClient.ConfigLevel.LOCAL, "commit.gpgsign", "false");
        this.git.config(GitClient.ConfigLevel.LOCAL, "tag.gpgSign", "false");
    }

    public String commit(String fileName, PersonIdent committer, String message) throws GitException, InterruptedException {
        return this.commit(fileName, fileName, committer, committer, message);
    }

    public String commit(String fileName, PersonIdent author, PersonIdent committer, String message) throws GitException, InterruptedException {
        return this.commit(fileName, fileName, author, committer, message);
    }

    public String commit(String fileName, String fileContent, PersonIdent committer, String message) throws GitException, InterruptedException {
        return this.commit(fileName, fileContent, committer, committer, message);
    }

    public String commit(String fileName, String fileContent, PersonIdent author, PersonIdent committer, String message) throws GitException, InterruptedException {
        FilePath file = this.gitDirPath.child(fileName);
        try {
            file.write(fileContent, null);
        }
        catch (Exception e) {
            throw new GitException("unable to write file", (Throwable)e);
        }
        this.git.add(fileName);
        this.git.setAuthor(author);
        this.git.setCommitter(committer);
        this.git.commit(message);
        return this.git.revParse("HEAD").getName();
    }

    public void tag(String tagName, String comment) throws GitException, InterruptedException {
        this.git.tag(tagName, comment);
    }

    public List<UserRemoteConfig> remoteConfigs() throws IOException {
        return this.remoteConfigs(null);
    }

    List<UserRemoteConfig> remoteConfigs(StandardCredentials credentials) {
        String credentialsId = credentials == null ? null : credentials.getId();
        ArrayList<UserRemoteConfig> list = new ArrayList<UserRemoteConfig>();
        list.add(new UserRemoteConfig(this.gitDir.getAbsolutePath(), "origin", "", credentialsId));
        return list;
    }
}

