/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.SystemCredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Functions;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Build;
import hudson.model.Cause;
import hudson.model.Descriptor;
import hudson.model.EnvironmentContributingAction;
import hudson.model.EnvironmentContributor;
import hudson.model.Fingerprint;
import hudson.model.FreeStyleBuild;
import hudson.model.FreeStyleProject;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.Label;
import hudson.model.ModelObject;
import hudson.model.Node;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.StringParameterDefinition;
import hudson.model.StringParameterValue;
import hudson.model.TaskListener;
import hudson.model.User;
import hudson.plugins.git.AbstractGitTestCase;
import hudson.plugins.git.Branch;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.ChangelogToBranchOptions;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.GitRevisionBuildParameters;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.GitSCMSlowTest;
import hudson.plugins.git.GitTool;
import hudson.plugins.git.Revision;
import hudson.plugins.git.TestGitRepo;
import hudson.plugins.git.UserMergeOptions;
import hudson.plugins.git.UserRemoteConfig;
import hudson.plugins.git.browser.GithubWeb;
import hudson.plugins.git.extensions.GitSCMExtension;
import hudson.plugins.git.extensions.impl.AuthorInChangelog;
import hudson.plugins.git.extensions.impl.ChangelogToBranch;
import hudson.plugins.git.extensions.impl.CleanBeforeCheckout;
import hudson.plugins.git.extensions.impl.CloneOption;
import hudson.plugins.git.extensions.impl.DisableRemotePoll;
import hudson.plugins.git.extensions.impl.LocalBranch;
import hudson.plugins.git.extensions.impl.PreBuildMerge;
import hudson.plugins.git.extensions.impl.RelativeTargetDirectory;
import hudson.plugins.git.extensions.impl.SparseCheckoutPath;
import hudson.plugins.git.extensions.impl.SparseCheckoutPaths;
import hudson.plugins.git.util.BuildChooser;
import hudson.plugins.git.util.BuildData;
import hudson.plugins.git.util.GitUtils;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameters;
import hudson.plugins.parameterizedtrigger.BuildTrigger;
import hudson.plugins.parameterizedtrigger.BuildTriggerConfig;
import hudson.plugins.parameterizedtrigger.ResultCondition;
import hudson.scm.ChangeLogSet;
import hudson.scm.PollingResult;
import hudson.scm.SCM;
import hudson.scm.SCMRevisionState;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.security.AuthorizationStrategy;
import hudson.security.Permission;
import hudson.security.SecurityRealm;
import hudson.slaves.DumbSlave;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolLocationNodeProperty;
import hudson.util.LogTaskListener;
import hudson.util.RingBufferLogHandler;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import jenkins.plugins.git.CliGitCommand;
import jenkins.plugins.git.GitSampleRepoRule;
import jenkins.plugins.git.RandomOrder;
import org.apache.commons.io.FileUtils;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.SystemReader;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.htmlunit.html.HtmlPage;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.gitclient.JGitTool;
import org.jenkinsci.plugins.gitclient.MergeCommand;
import org.jenkinsci.plugins.gitclient.RepositoryCallback;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Stopwatch;
import org.junit.rules.TestName;
import org.junit.runner.OrderWith;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.LoggerRule;
import org.jvnet.hudson.test.MockAuthorizationStrategy;
import org.jvnet.hudson.test.TestExtension;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@OrderWith(value=RandomOrder.class)
public class GitSCMTest
extends AbstractGitTestCase {
    @Rule
    public GitSampleRepoRule secondRepo = new GitSampleRepoRule();
    @Rule
    public LoggerRule logRule = new LoggerRule();
    private CredentialsStore store = null;
    @ClassRule
    public static Stopwatch stopwatch = new Stopwatch();
    @Rule
    public TestName testName = new TestName();
    private static final int MAX_SECONDS_FOR_THESE_TESTS = 570;
    private final Random random = new Random();
    private boolean useChangelogToBranch = this.random.nextBoolean();

    private boolean isTimeAvailable() {
        String env = System.getenv("CI");
        if (env == null || !Boolean.parseBoolean(env)) {
            return true;
        }
        return stopwatch.runtime(TimeUnit.SECONDS) <= 570L;
    }

    @BeforeClass
    public static void setGitDefaults() throws Exception {
        SystemReader.getInstance().getUserConfig().clear();
        CliGitCommand gitCmd = new CliGitCommand(null, new String[0]);
        gitCmd.setDefaults();
    }

    @Before
    public void enableSystemCredentialsProvider() throws Exception {
        SystemCredentialsProvider.getInstance().setDomainCredentialsMap(Collections.singletonMap(Domain.global(), Collections.emptyList()));
        for (CredentialsStore s : CredentialsProvider.lookupStores((ModelObject)Jenkins.get())) {
            if (!(s.getProvider() instanceof SystemCredentialsProvider.ProviderImpl)) continue;
            this.store = s;
            break;
        }
        MatcherAssert.assertThat((String)"The system credentials provider is enabled", (Object)this.store, (Matcher)Matchers.notNullValue());
    }

    @After
    public void waitForJenkinsIdle() throws Exception {
        if (this.cleanupIsUnreliable()) {
            this.r.waitUntilNoActivityUpTo(5001);
        }
    }

    private StandardCredentials getInvalidCredential() {
        String username = "bad-user";
        String password = "bad-password";
        CredentialsScope scope = CredentialsScope.GLOBAL;
        String id = "username-" + username + "-password-" + password;
        return new UsernamePasswordCredentialsImpl(scope, id, "desc: " + id, username, password);
    }

    @Test
    public void testAddGitTagAction() throws Exception {
        if (this.isWindows() || this.random.nextBoolean()) {
            return;
        }
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        FreeStyleProject project = this.setupSimpleProject("master");
        List remoteConfigs = GitSCM.createRepoList((String)"https://github.com/jenkinsci/git-plugin", (String)"github");
        project.setScm((SCM)new GitSCM(remoteConfigs, Collections.singletonList(new BranchSpec("master")), Boolean.valueOf(false), null, null, null, null));
        GitSCM scm = (GitSCM)project.getScm();
        GitSCM.DescriptorImpl descriptor = scm.getDescriptor();
        boolean originalValue = scm.isAddGitTagAction();
        Assert.assertFalse((String)"Wrong initial value for hide tag action", (boolean)originalValue);
        descriptor.setAddGitTagAction(true);
        Assert.assertTrue((String)"Hide tag action not set", (boolean)scm.isAddGitTagAction());
        descriptor.setAddGitTagAction(false);
        Assert.assertFalse((String)"Wrong final value for hide tag action", (boolean)scm.isAddGitTagAction());
        descriptor.setAddGitTagAction(originalValue);
        String currentDirectoryPath = new File(".").getCanonicalPath();
        if (this.isWindows() && currentDirectoryPath.length() > 95) {
            return;
        }
        this.logRule.record(GitSCM.class, Level.FINE).capture(20);
        this.commit("commitFileWithoutGitTagAction", this.johnDoe, "Commit 1 without git tag action");
        this.build(project, Result.SUCCESS, new String[0]);
        MatcherAssert.assertThat((Object)this.logRule, (Matcher)LoggerRule.recorded((Matcher)Matchers.containsString((String)"Not adding GitTagAction to build 1")));
        descriptor.setAddGitTagAction(true);
        this.build(project, Result.SUCCESS, new String[0]);
        MatcherAssert.assertThat((Object)this.logRule, (Matcher)LoggerRule.recorded((Matcher)Matchers.containsString((String)"Adding GitTagAction to build 2")));
        descriptor.setAddGitTagAction(false);
        this.build(project, Result.SUCCESS, new String[0]);
        MatcherAssert.assertThat((Object)this.logRule, (Matcher)LoggerRule.recorded((Matcher)Matchers.containsString((String)"Not adding GitTagAction to build 3")));
    }

    @Test
    public void manageShouldAccessGlobalConfig() throws Exception {
        Collection descriptors;
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        String USER = "user";
        String MANAGER = "manager";
        this.r.jenkins.setSecurityRealm((SecurityRealm)this.r.createDummySecurityRealm());
        this.r.jenkins.setAuthorizationStrategy((AuthorizationStrategy)new MockAuthorizationStrategy().grant(new Permission[]{Jenkins.READ}).everywhere().to(new String[]{"user"}).grant(new Permission[]{Jenkins.READ}).everywhere().to(new String[]{"manager"}).grant(new Permission[]{Jenkins.MANAGE}).everywhere().to(new String[]{"manager"}));
        try (ACLContext c = ACL.as((User)User.getById((String)"user", (boolean)true));){
            descriptors = Functions.getSortedDescriptorsForGlobalConfigUnclassified();
            MatcherAssert.assertThat((String)"Global configuration should not be accessible to READ users", (Object)descriptors, (Matcher)Matchers.is((Matcher)Matchers.empty()));
        }
        c = ACL.as((User)User.getById((String)"manager", (boolean)true));
        try {
            descriptors = Functions.getSortedDescriptorsForGlobalConfigUnclassified();
            Optional<Descriptor> found = descriptors.stream().filter(descriptor -> descriptor instanceof GitSCM.DescriptorImpl).findFirst();
            Assert.assertTrue((String)"Global configuration should be accessible to MANAGE users", (boolean)found.isPresent());
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
    }

    @Test
    public void trackCredentials() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        StandardCredentials credential = this.getInvalidCredential();
        this.store.addCredentials(Domain.global(), (Credentials)credential);
        Fingerprint fingerprint = CredentialsProvider.getFingerprintOf((Credentials)credential);
        MatcherAssert.assertThat((String)"Fingerprint should not be set before job definition", (Object)fingerprint, (Matcher)Matchers.nullValue());
        JenkinsRule.WebClient wc = this.r.createWebClient();
        HtmlPage page = wc.goTo("credentials/store/system/domain/_/credentials/" + credential.getId());
        MatcherAssert.assertThat((String)"Have usage tracking reported", (Object)page.getElementById("usage"), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((String)"No fingerprint created until first use", (Object)page.getElementById("usage-missing"), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((String)"No fingerprint created until first use", (Object)page.getElementById("usage-present"), (Matcher)Matchers.nullValue());
        FreeStyleProject project = this.setupProject("master", credential);
        fingerprint = CredentialsProvider.getFingerprintOf((Credentials)credential);
        MatcherAssert.assertThat((String)"Fingerprint should not be set before first build", (Object)fingerprint, (Matcher)Matchers.nullValue());
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        this.build(project, Result.SUCCESS, "commitFile1");
        fingerprint = CredentialsProvider.getFingerprintOf((Credentials)credential);
        MatcherAssert.assertThat((String)"Fingerprint should be set after first build", (Object)fingerprint, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)fingerprint.getJobs(), (Matcher)Matchers.hasItem((Matcher)Matchers.is((Object)project.getFullName())));
        Fingerprint.RangeSet rangeSet = fingerprint.getRangeSet((Job)project);
        MatcherAssert.assertThat((Object)rangeSet, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)rangeSet.includes(((FreeStyleBuild)project.getLastBuild()).getNumber()), (Matcher)Matchers.is((Object)true));
        page = wc.goTo("credentials/store/system/domain/_/credentials/" + credential.getId());
        MatcherAssert.assertThat((Object)page.getElementById("usage-missing"), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)page.getElementById("usage-present"), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)page.getAnchorByText(project.getFullDisplayName()), (Matcher)Matchers.notNullValue());
    }

    @Test
    public void testBasic() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        FreeStyleProject project = this.setupSimpleProject("master");
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        this.build(project, Result.SUCCESS, "commitFile1");
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
        String commitFile2 = "commitFile2";
        this.commit("commitFile2", this.janeDoe, "Commit number 2");
        Assert.assertTrue((String)"scm polling did not detect commit2 change", (boolean)project.poll(this.listener).hasChanges());
        FreeStyleBuild build2 = this.build(project, Result.SUCCESS, "commitFile2");
        Set culprits = build2.getCulprits();
        Assert.assertEquals((String)"The build should have only one culprit", (long)1L, (long)culprits.size());
        Assert.assertEquals((String)"", (Object)this.janeDoe.getName(), (Object)((User)culprits.iterator().next()).getFullName());
        Assert.assertTrue((boolean)build2.getWorkspace().child("commitFile2").exists());
        this.r.assertBuildStatusSuccess((Run)build2);
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
    }

    @Test
    public void testBasicRemotePoll() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        FreeStyleProject project = this.setupProject("master", false, null, null, null, true, null);
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        this.build(project, Result.SUCCESS, "commitFile1");
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
        String commitFile2 = "commitFile2";
        String sha1String = this.commit("commitFile2", this.janeDoe, "Commit number 2");
        Assert.assertTrue((String)"scm polling did not detect commit2 change", (boolean)project.poll(this.listener).hasChanges());
        FreeStyleBuild build2 = this.build(project, Result.SUCCESS, "commitFile2");
        Set culprits = build2.getCulprits();
        Assert.assertEquals((String)"The build should have only one culprit", (long)1L, (long)culprits.size());
        Assert.assertEquals((String)"", (Object)this.janeDoe.getName(), (Object)((User)culprits.iterator().next()).getFullName());
        Assert.assertTrue((boolean)build2.getWorkspace().child("commitFile2").exists());
        this.r.assertBuildStatusSuccess((Run)build2);
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
        MatcherAssert.assertThat((Object)TokenMacro.expandAll((AbstractBuild)build2, (TaskListener)this.listener, (String)"${GIT_REVISION,length=7}"), (Matcher)Matchers.is((Object)sha1String.substring(0, 7)));
        MatcherAssert.assertThat((Object)TokenMacro.expandAll((AbstractBuild)build2, (TaskListener)this.listener, (String)"${GIT_REVISION}"), (Matcher)Matchers.is((Object)sha1String));
        MatcherAssert.assertThat((Object)TokenMacro.expandAll((AbstractBuild)build2, (TaskListener)this.listener, (String)"$GIT_REVISION"), (Matcher)Matchers.is((Object)sha1String));
    }

    @Test
    public void testBranchSpecWithRemotesMaster() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        FreeStyleProject projectMasterBranch = this.setupProject("remotes/origin/master", false, null, null, null, true, null);
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        this.build(projectMasterBranch, Result.SUCCESS, "commitFile1");
    }

    @Test
    public void testSpecificRefspecs() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        ArrayList<UserRemoteConfig> repos = new ArrayList<UserRemoteConfig>();
        repos.add(new UserRemoteConfig(this.testRepo.gitDir.getAbsolutePath(), "origin", "+refs/heads/foo:refs/remotes/foo", null));
        FreeStyleProject projectWithMaster = this.setupProject(repos, Collections.singletonList(new BranchSpec("master")), null, false, null);
        CloneOption cloneOptionMaster = new CloneOption(false, null, null);
        cloneOptionMaster.setHonorRefspec(true);
        ((GitSCM)projectWithMaster.getScm()).getExtensions().add((Object)cloneOptionMaster);
        FreeStyleProject projectWithFoo = this.setupProject(repos, Collections.singletonList(new BranchSpec("foo")), null, false, null);
        CloneOption cloneOptionFoo = new CloneOption(false, null, null);
        cloneOptionFoo.setHonorRefspec(true);
        ((GitSCM)projectWithMaster.getScm()).getExtensions().add((Object)cloneOptionFoo);
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit in master");
        this.git.checkout().ref("master").branch("foo").execute();
        this.commit("commitFile1", this.johnDoe, "Commit in foo");
        this.build(projectWithMaster, Result.FAILURE, new String[0]);
        this.build(projectWithFoo, Result.SUCCESS, "commitFile1");
    }

    @Test
    public void testAvoidRedundantFetch() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        ArrayList<UserRemoteConfig> repos = new ArrayList<UserRemoteConfig>();
        repos.add(new UserRemoteConfig(this.testRepo.gitDir.getAbsolutePath(), "origin", "+refs/heads/*:refs/remotes/*", null));
        FreeStyleProject projectWithMaster = this.setupProject(repos, Collections.singletonList(new BranchSpec("master")), null, false, null);
        if (this.random.nextBoolean()) {
            CloneOption cloneOptionMaster = new CloneOption(false, null, null);
            cloneOptionMaster.setDepth(Integer.valueOf(1));
            ((GitSCM)projectWithMaster.getScm()).getExtensions().add((Object)cloneOptionMaster);
        }
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit in master");
        FreeStyleBuild build = this.build(projectWithMaster, Result.SUCCESS, new String[0]);
        this.assertRedundantFetchIsSkipped(build, "+refs/heads/*:refs/remotes/origin/*");
    }

    @Test
    public void testAvoidRedundantFetchWithoutHonorRefSpec() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        ArrayList<UserRemoteConfig> repos = new ArrayList<UserRemoteConfig>();
        repos.add(new UserRemoteConfig(this.testRepo.gitDir.getAbsolutePath(), "origin", "+refs/heads/foo:refs/remotes/foo", null));
        FreeStyleProject projectWithMaster = this.setupProject(repos, Collections.singletonList(new BranchSpec("master")), null, false, null);
        if (this.random.nextBoolean()) {
            CloneOption cloneOptionMaster = new CloneOption(false, null, null);
            cloneOptionMaster.setDepth(Integer.valueOf(1));
            ((GitSCM)projectWithMaster.getScm()).getExtensions().add((Object)cloneOptionMaster);
        }
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit in master");
        this.git.checkout().ref("master").branch("foo").execute();
        this.commit("commitFile1", this.johnDoe, "Commit in foo");
        FreeStyleBuild build = this.build(projectWithMaster, Result.SUCCESS, new String[0]);
        FilePath childFile = this.returnFile(build);
        if (childFile != null) {
            MatcherAssert.assertThat((String)"master branch was not fetched", (Object)childFile.readToString(), (Matcher)Matchers.containsString((String)"master"));
            MatcherAssert.assertThat((String)"foo branch was not fetched", (Object)childFile.readToString(), (Matcher)Matchers.containsString((String)"foo"));
        }
        String wideRefSpec = "+refs/heads/*:refs/remotes/origin/*";
        this.assertRedundantFetchIsSkipped(build, wideRefSpec);
        MatcherAssert.assertThat((Object)build.getResult(), (Matcher)Matchers.is((Object)Result.SUCCESS));
    }

    @Test
    public void testAvoidRedundantFetchWithHonorRefSpec() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        ArrayList<UserRemoteConfig> repos = new ArrayList<UserRemoteConfig>();
        String refSpec = "+refs/heads/foo:refs/remotes/foo";
        repos.add(new UserRemoteConfig(this.testRepo.gitDir.getAbsolutePath(), "origin", refSpec, null));
        FreeStyleProject projectWithMaster = this.setupProject(repos, Collections.singletonList(new BranchSpec("master")), null, false, null);
        CloneOption cloneOptionMaster = new CloneOption(false, null, null);
        cloneOptionMaster.setHonorRefspec(true);
        ((GitSCM)projectWithMaster.getScm()).getExtensions().add((Object)cloneOptionMaster);
        String commitFile1 = "commitFile1";
        String commitFile1SHA1a = this.commit("commitFile1", this.johnDoe, "Commit in master");
        this.git.checkout().ref("master").branch("foo").execute();
        String commitFile1SHA1b = this.commit("commitFile1", this.johnDoe, "Commit in foo");
        FreeStyleBuild build = this.build(projectWithMaster, Result.FAILURE, new String[0]);
        FilePath childFile = this.returnFile(build);
        Assert.assertNotNull((Object)childFile);
        String fetchHeadContents = childFile.readToString();
        List buildLog = build.getLog(50);
        MatcherAssert.assertThat((String)("master branch was fetched: " + buildLog), (Object)fetchHeadContents, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"branch 'master'")));
        MatcherAssert.assertThat((String)("foo branch was not fetched: " + buildLog), (Object)fetchHeadContents, (Matcher)Matchers.containsString((String)"branch 'foo'"));
        MatcherAssert.assertThat((String)("master branch SHA1 '" + commitFile1SHA1a + "' fetched " + buildLog), (Object)fetchHeadContents, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)commitFile1SHA1a)));
        MatcherAssert.assertThat((String)("foo branch SHA1 '" + commitFile1SHA1b + "' was not fetched " + buildLog), (Object)fetchHeadContents, (Matcher)Matchers.containsString((String)commitFile1SHA1b));
        this.assertRedundantFetchIsSkipped(build, refSpec);
        MatcherAssert.assertThat((Object)build.getResult(), (Matcher)Matchers.is((Object)Result.FAILURE));
    }

    @Test
    public void testAvoidRedundantFetchWithNullRefspec() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        String nullRefspec = null;
        ArrayList<UserRemoteConfig> repos = new ArrayList<UserRemoteConfig>();
        repos.add(new UserRemoteConfig(this.testRepo.gitDir.getAbsolutePath(), "origin", nullRefspec, null));
        FreeStyleProject projectWithMaster = this.setupProject(repos, Collections.singletonList(new BranchSpec("master")), null, false, null);
        if (this.random.nextBoolean()) {
            CloneOption cloneOptionMaster = new CloneOption(false, null, null);
            cloneOptionMaster.setDepth(Integer.valueOf(1));
            ((GitSCM)projectWithMaster.getScm()).getExtensions().add((Object)cloneOptionMaster);
        }
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit in master");
        FreeStyleBuild build = this.build(projectWithMaster, Result.SUCCESS, new String[0]);
        this.assertRedundantFetchIsSkipped(build, "+refs/heads/*:refs/remotes/origin/*");
    }

    @Test
    public void testRetainRedundantFetch() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        String refspec = "+refs/heads/*:refs/remotes/origin/* +refs/pull/553/head:refs/remotes/origin/pull/553";
        ArrayList<UserRemoteConfig> repos = new ArrayList<UserRemoteConfig>();
        repos.add(new UserRemoteConfig(this.testRepo.gitDir.getAbsolutePath(), "origin", refspec, null));
        FreeStyleProject projectWithMaster = this.setupProject(repos, Collections.singletonList(new BranchSpec("master")), null, false, null);
        if (this.random.nextBoolean()) {
            CloneOption cloneOptionMaster = new CloneOption(false, null, null);
            cloneOptionMaster.setDepth(Integer.valueOf(1));
            ((GitSCM)projectWithMaster.getScm()).getExtensions().add((Object)cloneOptionMaster);
        }
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit in master");
        String[] expectedResult = new String[]{""};
        CliGitCommand gitCmd = new CliGitCommand(this.testRepo.git, "update-ref", "refs/pull/553/head", "HEAD");
        MatcherAssert.assertThat((Object)gitCmd.run(), (Matcher)Matchers.is((Object)expectedResult));
        FreeStyleBuild build = this.build(projectWithMaster, Result.SUCCESS, new String[0]);
        this.assertRedundantFetchIsUsed(build, refspec);
    }

    @Test
    public void testRetainRedundantFetchIfSecondFetchIsAllowed() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        String refspec = "+refs/heads/*:refs/remotes/*";
        ArrayList<UserRemoteConfig> repos = new ArrayList<UserRemoteConfig>();
        repos.add(new UserRemoteConfig(this.testRepo.gitDir.getAbsolutePath(), "origin", refspec, null));
        FreeStyleProject projectWithMaster = this.setupProject(repos, Collections.singletonList(new BranchSpec("master")), null, false, null);
        GitSCM scm = (GitSCM)projectWithMaster.getScm();
        GitSCM.DescriptorImpl descriptor = scm.getDescriptor();
        MatcherAssert.assertThat((String)"Redundant fetch is skipped by default", (Object)scm.isAllowSecondFetch(), (Matcher)Matchers.is((Object)false));
        descriptor.setAllowSecondFetch(true);
        MatcherAssert.assertThat((String)"Redundant fetch should be allowed", (Object)scm.isAllowSecondFetch(), (Matcher)Matchers.is((Object)true));
        if (this.random.nextBoolean()) {
            CloneOption cloneOptionMaster = new CloneOption(false, null, null);
            cloneOptionMaster.setDepth(Integer.valueOf(1));
            ((GitSCM)projectWithMaster.getScm()).getExtensions().add((Object)cloneOptionMaster);
        }
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit in master");
        FreeStyleBuild build = this.build(projectWithMaster, Result.SUCCESS, new String[0]);
        this.assertRedundantFetchIsUsed(build, refspec);
    }

    private void assertRedundantFetchIsSkipped(FreeStyleBuild build, String refSpec) throws IOException {
        this.assertRedundantFetchCount(build, refSpec, 1);
    }

    private void assertRedundantFetchIsUsed(FreeStyleBuild build, String refSpec) throws IOException {
        this.assertRedundantFetchCount(build, refSpec, 2);
    }

    private void assertRedundantFetchCount(FreeStyleBuild build, String refSpec, int expectedFetchCount) throws IOException {
        List values = build.getLog(Integer.MAX_VALUE);
        Pattern fetchPattern = Pattern.compile(".* git.* fetch .*");
        List fetchCommands = values.stream().filter(fetchPattern.asPredicate()).collect(Collectors.toList());
        MatcherAssert.assertThat((String)("Fetch commands were: " + fetchCommands), fetchCommands, (Matcher)Matchers.hasSize((int)expectedFetchCount));
    }

    private FilePath returnFile(FreeStyleBuild build) throws IOException, InterruptedException {
        List files = ((FreeStyleProject)build.getProject()).getWorkspace().list();
        FilePath resultFile = null;
        for (FilePath s : files) {
            if (!s.getName().equals(".git")) continue;
            resultFile = s.child("FETCH_HEAD");
        }
        return resultFile;
    }

    @Test
    public void testSpecificRefspecsWithoutCloneOption() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        ArrayList<UserRemoteConfig> repos = new ArrayList<UserRemoteConfig>();
        repos.add(new UserRemoteConfig(this.testRepo.gitDir.getAbsolutePath(), "origin", "+refs/heads/foo:refs/remotes/foo", null));
        FreeStyleProject projectWithMaster = this.setupProject(repos, Collections.singletonList(new BranchSpec("master")), null, false, null);
        FreeStyleProject projectWithFoo = this.setupProject(repos, Collections.singletonList(new BranchSpec("foo")), null, false, null);
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit in master");
        this.git.checkout().ref("master").branch("foo").execute();
        this.commit("commitFile1", this.johnDoe, "Commit in foo");
        this.build(projectWithMaster, Result.SUCCESS, new String[0]);
        this.build(projectWithFoo, Result.SUCCESS, "commitFile1");
    }

    @Test
    public void testAddFirstRepositoryWithNullRepoURL() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        ArrayList<UserRemoteConfig> repos = new ArrayList<UserRemoteConfig>();
        repos.add(new UserRemoteConfig(null, null, null, null));
        FreeStyleProject project = this.setupProject(repos, Collections.singletonList(new BranchSpec("master")), null, false, null);
        FreeStyleBuild build = this.build(project, Result.FAILURE, new String[0]);
        MatcherAssert.assertThat((String)"Build log reports 'Null value not allowed'", (Object)build.getLog(175), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)"Null value not allowed as an environment variable: GIT_URL")));
        MatcherAssert.assertThat((String)"Build log did not report empty string in job definition", (Object)build.getLog(175), (Matcher)Matchers.hasItem((Object)"FATAL: Git repository URL 1 is an empty string in job definition. Checkout requires a valid repository URL"));
    }

    @Test
    public void testAddSecondRepositoryWithNullRepoURL() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        String repoURL = "https://example.com/non-empty/repo/url";
        ArrayList<UserRemoteConfig> repos = new ArrayList<UserRemoteConfig>();
        repos.add(new UserRemoteConfig(repoURL, null, null, null));
        repos.add(new UserRemoteConfig(null, null, null, null));
        FreeStyleProject project = this.setupProject(repos, Collections.singletonList(new BranchSpec("master")), null, false, null);
        FreeStyleBuild build = this.build(project, Result.FAILURE, new String[0]);
        MatcherAssert.assertThat((String)"Build log reports 'Null value not allowed'", (Object)build.getLog(175), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)"Null value not allowed as an environment variable: GIT_URL_2")));
        MatcherAssert.assertThat((String)"Build log did not report empty string in job definition for URL 2", (Object)build.getLog(175), (Matcher)Matchers.hasItem((Object)"FATAL: Git repository URL 2 is an empty string in job definition. Checkout requires a valid repository URL"));
    }

    @Test
    public void testBranchSpecWithRemotesHierarchical() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        FreeStyleProject projectMasterBranch = this.setupProject("master", false, null, null, null, true, null);
        FreeStyleProject projectHierarchicalBranch = this.setupProject("remotes/origin/rel-1/xy", false, null, null, null, true, null);
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        this.git.branch("rel-1/xy");
        this.git.checkout("rel-1/xy");
        this.git.deleteBranch("master");
        this.build(projectMasterBranch, Result.FAILURE, new String[0]);
        this.build(projectHierarchicalBranch, Result.SUCCESS, "commitFile1");
    }

    @Test
    public void testBranchSpecUsingTagWithSlash() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        FreeStyleProject projectMasterBranch = this.setupProject("path/tag", false, null, null, null, true, null);
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1 will be tagged with path/tag");
        this.testRepo.git.tag("path/tag", "tag with a slash in the tag name");
        this.build(projectMasterBranch, Result.SUCCESS, "commitFile1");
    }

    @Test
    public void testBasicIncludedRegion() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        FreeStyleProject project = this.setupProject("master", false, null, null, null, ".*3");
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        this.build(project, Result.SUCCESS, "commitFile1");
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
        String commitFile2 = "commitFile2";
        this.commit("commitFile2", this.janeDoe, "Commit number 2");
        Assert.assertFalse((String)"scm polling detected commit2 change, which should not have been included", (boolean)project.poll(this.listener).hasChanges());
        String commitFile3 = "commitFile3";
        this.commit("commitFile3", this.johnDoe, "Commit number 3");
        Assert.assertTrue((String)"scm polling did not detect commit3 change", (boolean)project.poll(this.listener).hasChanges());
        FreeStyleBuild build2 = this.build(project, Result.SUCCESS, "commitFile2", "commitFile3");
        Set culprits = build2.getCulprits();
        Assert.assertEquals((String)"The build should have two culprit", (long)2L, (long)culprits.size());
        PersonIdent[] expected = new PersonIdent[]{this.johnDoe, this.janeDoe};
        GitSCMTest.assertCulprits("jane doe and john doe should be the culprits", culprits, expected);
        Assert.assertTrue((boolean)build2.getWorkspace().child("commitFile2").exists());
        Assert.assertTrue((boolean)build2.getWorkspace().child("commitFile3").exists());
        this.r.assertBuildStatusSuccess((Run)build2);
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
    }

    @Test
    public void testMergeCommitInExcludedRegionIsIgnored() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        String branchToMerge = "new-branch-we-merge-to-master";
        FreeStyleProject project = this.setupProject("master", false, null, ".*\\.excluded", null, ".*\\.included");
        String initialCommit = "initialCommit";
        this.commit("initialCommit", this.johnDoe, "Commit initialCommit to master");
        this.build(project, Result.SUCCESS, "initialCommit");
        String secondCommit = "secondCommit";
        this.commit("secondCommit", this.johnDoe, "Commit secondCommit to master");
        this.testRepo.git.checkoutBranch("new-branch-we-merge-to-master", "HEAD~");
        String fileToMerge = "fileToMerge.excluded";
        this.commit("fileToMerge.excluded", this.johnDoe, "Commit should be ignored: fileToMerge.excluded to new-branch-we-merge-to-master");
        ObjectId branchSHA = this.git.revParse("HEAD");
        this.testRepo.git.checkoutBranch("master", "refs/heads/master");
        MergeCommand mergeCommand = this.testRepo.git.merge();
        mergeCommand.setRevisionToMerge(branchSHA);
        mergeCommand.execute();
        Assert.assertFalse((String)"Polling should report no changes, because they are in the excluded region.", (boolean)project.poll(this.listener).hasChanges());
    }

    @Test
    public void testMergeCommitInExcludedDirectoryIsIgnored() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        String branchToMerge = "new-branch-we-merge-to-master";
        FreeStyleProject project = this.setupProject("master", false, null, "excluded/.*", null, "included/.*");
        String initialCommit = "initialCommit";
        this.commit("initialCommit", this.johnDoe, "Commit initialCommit to master");
        this.build(project, Result.SUCCESS, "initialCommit");
        String secondCommit = "secondCommit";
        this.commit("secondCommit", this.johnDoe, "Commit secondCommit to master");
        this.testRepo.git.checkoutBranch("new-branch-we-merge-to-master", "HEAD~");
        String fileToMerge = "excluded/should-be-ignored";
        this.commit("excluded/should-be-ignored", this.johnDoe, "Commit should be ignored: excluded/should-be-ignored to new-branch-we-merge-to-master");
        ObjectId branchSHA = this.git.revParse("HEAD");
        this.testRepo.git.checkoutBranch("master", "refs/heads/master");
        MergeCommand mergeCommand = this.testRepo.git.merge();
        mergeCommand.setRevisionToMerge(branchSHA);
        mergeCommand.execute();
        Assert.assertFalse((String)"Polling should see no changes, because they are in the excluded directory.", (boolean)project.poll(this.listener).hasChanges());
    }

    @Test
    public void testMergeCommitInIncludedRegionIsProcessed() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        String branchToMerge = "new-branch-we-merge-to-master";
        FreeStyleProject project = this.setupProject("master", false, null, ".*\\.excluded", null, ".*\\.included");
        String initialCommit = "initialCommit";
        this.commit("initialCommit", this.johnDoe, "Commit initialCommit to master");
        this.build(project, Result.SUCCESS, "initialCommit");
        String secondCommit = "secondCommit";
        this.commit("secondCommit", this.johnDoe, "Commit secondCommit to master");
        this.testRepo.git.checkoutBranch("new-branch-we-merge-to-master", "HEAD~");
        String fileToMerge = "fileToMerge.included";
        this.commit("fileToMerge.included", this.johnDoe, "Commit should be noticed and processed as a change: fileToMerge.included to new-branch-we-merge-to-master");
        ObjectId branchSHA = this.git.revParse("HEAD");
        this.testRepo.git.checkoutBranch("master", "refs/heads/master");
        MergeCommand mergeCommand = this.testRepo.git.merge();
        mergeCommand.setRevisionToMerge(branchSHA);
        mergeCommand.execute();
        Assert.assertTrue((String)"Polling should report changes, because they fall within the included region.", (boolean)project.poll(this.listener).hasChanges());
    }

    @Test
    public void testMergeCommitInIncludedDirectoryIsProcessed() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        String branchToMerge = "new-branch-we-merge-to-master";
        FreeStyleProject project = this.setupProject("master", false, null, "excluded/.*", null, "included/.*");
        String initialCommit = "initialCommit";
        this.commit("initialCommit", this.johnDoe, "Commit initialCommit to master");
        this.build(project, Result.SUCCESS, "initialCommit");
        String secondCommit = "secondCommit";
        this.commit("secondCommit", this.johnDoe, "Commit secondCommit to master");
        this.testRepo.git.checkoutBranch("new-branch-we-merge-to-master", "HEAD~");
        String fileToMerge = "included/should-be-processed";
        this.commit("included/should-be-processed", this.johnDoe, "Commit should be noticed and processed as a change: included/should-be-processed to new-branch-we-merge-to-master");
        ObjectId branchSHA = this.git.revParse("HEAD");
        this.testRepo.git.checkoutBranch("master", "refs/heads/master");
        MergeCommand mergeCommand = this.testRepo.git.merge();
        mergeCommand.setRevisionToMerge(branchSHA);
        mergeCommand.execute();
        Assert.assertTrue((String)"Polling should report changes, because they are in the included directory.", (boolean)project.poll(this.listener).hasChanges());
    }

    @Test
    public void testMergeCommitOutsideIncludedRegionIsIgnored() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        String branchToMerge = "new-branch-we-merge-to-master";
        FreeStyleProject project = this.setupProject("master", false, null, null, null, ".*\\.included");
        String initialCommit = "initialCommit";
        this.commit("initialCommit", this.johnDoe, "Commit initialCommit to master");
        this.build(project, Result.SUCCESS, "initialCommit");
        String secondCommit = "secondCommit";
        this.commit("secondCommit", this.johnDoe, "Commit secondCommit to master");
        this.testRepo.git.checkoutBranch("new-branch-we-merge-to-master", "HEAD~");
        String fileToMerge = "fileToMerge.should-be-ignored";
        this.commit("fileToMerge.should-be-ignored", this.johnDoe, "Commit should be ignored: fileToMerge.should-be-ignored to new-branch-we-merge-to-master");
        ObjectId branchSHA = this.git.revParse("HEAD");
        this.testRepo.git.checkoutBranch("master", "refs/heads/master");
        MergeCommand mergeCommand = this.testRepo.git.merge();
        mergeCommand.setRevisionToMerge(branchSHA);
        mergeCommand.execute();
        Assert.assertFalse((String)"Polling should ignore the change, because it falls outside the included region.", (boolean)project.poll(this.listener).hasChanges());
    }

    @Test
    public void testMergeCommitOutsideIncludedDirectoryIsIgnored() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        String branchToMerge = "new-branch-we-merge-to-master";
        FreeStyleProject project = this.setupProject("master", false, null, null, null, "included/.*");
        String initialCommit = "initialCommit";
        this.commit("initialCommit", this.johnDoe, "Commit initialCommit to master");
        this.build(project, Result.SUCCESS, "initialCommit");
        String secondCommit = "secondCommit";
        this.commit("secondCommit", this.johnDoe, "Commit secondCommit to master");
        this.testRepo.git.checkoutBranch("new-branch-we-merge-to-master", "HEAD~");
        String fileToMerge = "directory-to-ignore/file-should-be-ignored";
        this.commit("directory-to-ignore/file-should-be-ignored", this.johnDoe, "Commit should be ignored: directory-to-ignore/file-should-be-ignored to new-branch-we-merge-to-master");
        ObjectId branchSHA = this.git.revParse("HEAD");
        this.testRepo.git.checkoutBranch("master", "refs/heads/master");
        MergeCommand mergeCommand = this.testRepo.git.merge();
        mergeCommand.setRevisionToMerge(branchSHA);
        mergeCommand.execute();
        Assert.assertFalse((String)"Polling should ignore the change, because it falls outside the included directory.", (boolean)project.poll(this.listener).hasChanges());
    }

    @Test
    public void testMergeCommitOutsideExcludedRegionIsProcessed() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        String branchToMerge = "new-branch-we-merge-to-master";
        FreeStyleProject project = this.setupProject("master", false, null, ".*\\.excluded", null, null);
        String initialCommit = "initialCommit";
        this.commit("initialCommit", this.johnDoe, "Commit initialCommit to master");
        this.build(project, Result.SUCCESS, "initialCommit");
        String secondCommit = "secondCommit";
        this.commit("secondCommit", this.johnDoe, "Commit secondCommit to master");
        this.testRepo.git.checkoutBranch("new-branch-we-merge-to-master", "HEAD~");
        String fileToMerge = "fileToMerge.should-be-processed";
        this.commit("fileToMerge.should-be-processed", this.johnDoe, "Commit should be noticed and processed as a change: fileToMerge.should-be-processed to new-branch-we-merge-to-master");
        ObjectId branchSHA = this.git.revParse("HEAD");
        this.testRepo.git.checkoutBranch("master", "refs/heads/master");
        MergeCommand mergeCommand = this.testRepo.git.merge();
        mergeCommand.setRevisionToMerge(branchSHA);
        mergeCommand.execute();
        Assert.assertTrue((String)"Polling should process the change, because it falls outside the excluded region.", (boolean)project.poll(this.listener).hasChanges());
    }

    @Test
    public void testMergeCommitOutsideExcludedDirectoryIsProcessed() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        String branchToMerge = "new-branch-we-merge-to-master";
        FreeStyleProject project = this.setupProject("master", false, null, "excluded/.*", null, null);
        String initialCommit = "initialCommit";
        this.commit("initialCommit", this.johnDoe, "Commit initialCommit to master");
        this.build(project, Result.SUCCESS, "initialCommit");
        String secondCommit = "secondCommit";
        this.commit("secondCommit", this.johnDoe, "Commit secondCommit to master");
        this.testRepo.git.checkoutBranch("new-branch-we-merge-to-master", "HEAD~");
        String fileToMerge = "directory-to-include/file-should-be-processed";
        this.commit("directory-to-include/file-should-be-processed", this.johnDoe, "Commit should be noticed and processed as a change: directory-to-include/file-should-be-processed to new-branch-we-merge-to-master");
        ObjectId branchSHA = this.git.revParse("HEAD");
        this.testRepo.git.checkoutBranch("master", "refs/heads/master");
        MergeCommand mergeCommand = this.testRepo.git.merge();
        mergeCommand.setRevisionToMerge(branchSHA);
        mergeCommand.execute();
        Assert.assertTrue((String)"SCM polling should process the change, because it falls outside the excluded directory.", (boolean)project.poll(this.listener).hasChanges());
    }

    @Test
    public void testIncludedRegionWithDeeperCommits() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        FreeStyleProject project = this.setupProject("master", false, null, null, null, ".*3");
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        this.build(project, Result.SUCCESS, "commitFile1");
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
        String commitFile2 = "commitFile2";
        this.commit("commitFile2", this.janeDoe, "Commit number 2");
        Assert.assertFalse((String)"scm polling detected commit2 change, which should not have been included", (boolean)project.poll(this.listener).hasChanges());
        String commitFile3 = "commitFile3";
        this.commit("commitFile3", this.johnDoe, "Commit number 3");
        String commitFile4 = "commitFile4";
        this.commit("commitFile4", this.janeDoe, "Commit number 4");
        Assert.assertTrue((String)"scm polling did not detect commit3 change", (boolean)project.poll(this.listener).hasChanges());
        FreeStyleBuild build2 = this.build(project, Result.SUCCESS, "commitFile2", "commitFile3");
        Set culprits = build2.getCulprits();
        Assert.assertEquals((String)"The build should have two culprit", (long)2L, (long)culprits.size());
        PersonIdent[] expected = new PersonIdent[]{this.johnDoe, this.janeDoe};
        GitSCMTest.assertCulprits("jane doe and john doe should be the culprits", culprits, expected);
        Assert.assertTrue((boolean)build2.getWorkspace().child("commitFile2").exists());
        Assert.assertTrue((boolean)build2.getWorkspace().child("commitFile3").exists());
        this.r.assertBuildStatusSuccess((Run)build2);
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
    }

    @Test
    public void testBasicExcludedRegion() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        FreeStyleProject project = this.setupProject("master", false, null, ".*2", null, null);
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        this.build(project, Result.SUCCESS, "commitFile1");
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
        String commitFile2 = "commitFile2";
        this.commit("commitFile2", this.janeDoe, "Commit number 2");
        Assert.assertFalse((String)"scm polling detected commit2 change, which should have been excluded", (boolean)project.poll(this.listener).hasChanges());
        String commitFile3 = "commitFile3";
        this.commit("commitFile3", this.johnDoe, "Commit number 3");
        Assert.assertTrue((String)"scm polling did not detect commit3 change", (boolean)project.poll(this.listener).hasChanges());
        FreeStyleBuild build2 = this.build(project, Result.SUCCESS, "commitFile2", "commitFile3");
        Set culprits = build2.getCulprits();
        Assert.assertEquals((String)"The build should have two culprit", (long)2L, (long)culprits.size());
        PersonIdent[] expected = new PersonIdent[]{this.johnDoe, this.janeDoe};
        GitSCMTest.assertCulprits("jane doe and john doe should be the culprits", culprits, expected);
        Assert.assertTrue((boolean)build2.getWorkspace().child("commitFile2").exists());
        Assert.assertTrue((boolean)build2.getWorkspace().child("commitFile3").exists());
        this.r.assertBuildStatusSuccess((Run)build2);
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
    }

    private int findLogLineStartsWith(List<String> buildLog, String initialString) {
        int logLine = 0;
        for (String logString : buildLog) {
            if (logString.startsWith(initialString)) {
                return logLine;
            }
            ++logLine;
        }
        return -1;
    }

    @Test
    public void testCleanBeforeCheckout() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        FreeStyleProject p = this.setupProject("master", false, null, null, "Jane Doe", null);
        ((GitSCM)p.getScm()).getExtensions().add((Object)new CleanBeforeCheckout());
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, this.janeDoe, "Commit number 1");
        FreeStyleBuild firstBuild = this.build(p, Result.SUCCESS, "commitFile1");
        MatcherAssert.assertThat((Object)firstBuild.getLog(50), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)"Cleaning workspace")));
        String commitFile2 = "commitFile2";
        this.commit("commitFile2", this.johnDoe, this.janeDoe, "Commit number 2");
        FreeStyleBuild secondBuild = this.build(p, Result.SUCCESS, "commitFile2");
        List secondLog = secondBuild.getLog(50);
        MatcherAssert.assertThat((Object)secondLog, (Matcher)Matchers.hasItem((Object)"Cleaning workspace"));
        int cleaningLogLine = this.findLogLineStartsWith(secondLog, "Cleaning workspace");
        int fetchingLogLine = this.findLogLineStartsWith(secondLog, "Fetching upstream changes from ");
        MatcherAssert.assertThat((String)"Cleaning should happen before fetch", (Object)cleaningLogLine, (Matcher)Matchers.is((Matcher)Matchers.lessThan((Comparable)Integer.valueOf(fetchingLogLine))));
    }

    @Test
    public void testExcludedRegionMultiCommit() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        FreeStyleProject clientProject = this.setupProject("master", false, null, ".*serverFile", null, null);
        FreeStyleProject serverProject = this.setupProject("master", false, null, ".*clientFile", null, null);
        String initialCommitFile = "initialFile";
        this.commit(initialCommitFile, this.johnDoe, "initial commit");
        this.build(clientProject, Result.SUCCESS, initialCommitFile);
        this.build(serverProject, Result.SUCCESS, initialCommitFile);
        Assert.assertFalse((String)"scm polling should not detect any more changes after initial build", (boolean)clientProject.poll(this.listener).hasChanges());
        Assert.assertFalse((String)"scm polling should not detect any more changes after initial build", (boolean)serverProject.poll(this.listener).hasChanges());
        this.commit("myserverFile", this.johnDoe, "commit first server file");
        Assert.assertFalse((String)"scm polling should not detect any changes in client project", (boolean)clientProject.poll(this.listener).hasChanges());
        Assert.assertTrue((String)"scm polling did not detect changes in server project", (boolean)serverProject.poll(this.listener).hasChanges());
        this.commit("myNewserverFile", this.johnDoe, "commit new server file");
        this.commit("myclientFile", this.johnDoe, "commit first clientfile");
        Assert.assertTrue((String)"scm polling did not detect changes in client project", (boolean)clientProject.poll(this.listener).hasChanges());
        Assert.assertTrue((String)"scm polling did not detect changes in server project", (boolean)serverProject.poll(this.listener).hasChanges());
    }

    @Test
    public void testBasicExcludedUser() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        FreeStyleProject project = this.setupProject("master", false, null, null, "Jane Doe", null);
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        this.build(project, Result.SUCCESS, "commitFile1");
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
        String commitFile2 = "commitFile2";
        this.commit("commitFile2", this.janeDoe, "Commit number 2");
        Assert.assertFalse((String)"scm polling detected commit2 change, which should have been excluded", (boolean)project.poll(this.listener).hasChanges());
        String commitFile3 = "commitFile3";
        this.commit("commitFile3", this.johnDoe, "Commit number 3");
        Assert.assertTrue((String)"scm polling did not detect commit3 change", (boolean)project.poll(this.listener).hasChanges());
        FreeStyleBuild build2 = this.build(project, Result.SUCCESS, "commitFile2", "commitFile3");
        Set culprits = build2.getCulprits();
        Assert.assertEquals((String)"The build should have two culprit", (long)2L, (long)culprits.size());
        PersonIdent[] expected = new PersonIdent[]{this.johnDoe, this.janeDoe};
        GitSCMTest.assertCulprits("jane doe and john doe should be the culprits", culprits, expected);
        Assert.assertTrue((boolean)build2.getWorkspace().child("commitFile2").exists());
        Assert.assertTrue((boolean)build2.getWorkspace().child("commitFile3").exists());
        this.r.assertBuildStatusSuccess((Run)build2);
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
    }

    @Test
    public void testBasicInSubdir() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        FreeStyleProject project = this.setupSimpleProject("master");
        ((GitSCM)project.getScm()).getExtensions().add((Object)new RelativeTargetDirectory("subdir"));
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        this.build(project, "subdir", Result.SUCCESS, "commitFile1");
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
        String commitFile2 = "commitFile2";
        this.commit("commitFile2", this.janeDoe, "Commit number 2");
        Assert.assertTrue((String)"scm polling did not detect commit2 change", (boolean)project.poll(this.listener).hasChanges());
        FreeStyleBuild build2 = this.build(project, "subdir", Result.SUCCESS, "commitFile2");
        Set culprits = build2.getCulprits();
        Assert.assertEquals((String)"The build should have only one culprit", (long)1L, (long)culprits.size());
        Assert.assertEquals((String)"", (Object)this.janeDoe.getName(), (Object)((User)culprits.iterator().next()).getFullName());
        Assert.assertTrue((String)"The workspace should have a 'subdir' subdirectory, but does not.", (boolean)build2.getWorkspace().child("subdir").exists());
        Assert.assertTrue((String)"The 'subdir' subdirectory should contain commitFile2, but does not.", (boolean)build2.getWorkspace().child("subdir").child("commitFile2").exists());
        this.r.assertBuildStatusSuccess((Run)build2);
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
    }

    @Test
    public void testBasicWithAgentNoExecutorsOnMaster() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        FreeStyleProject project = this.setupSimpleProject("master");
        this.r.jenkins.setNumExecutors(0);
        project.setAssignedLabel((Label)this.r.createSlave().getSelfLabel());
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        this.build(project, Result.SUCCESS, "commitFile1");
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
        String commitFile2 = "commitFile2";
        this.commit("commitFile2", this.janeDoe, "Commit number 2");
        Assert.assertTrue((String)"scm polling did not detect commit2 change", (boolean)project.poll(this.listener).hasChanges());
        FreeStyleBuild build2 = this.build(project, Result.SUCCESS, "commitFile2");
        Set culprits = build2.getCulprits();
        Assert.assertEquals((String)"The build should have only one culprit", (long)1L, (long)culprits.size());
        Assert.assertEquals((String)"", (Object)this.janeDoe.getName(), (Object)((User)culprits.iterator().next()).getFullName());
        Assert.assertTrue((boolean)build2.getWorkspace().child("commitFile2").exists());
        this.r.assertBuildStatusSuccess((Run)build2);
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
    }

    @Test
    public void testAuthorOrCommitterFalse() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        FreeStyleProject project = this.setupSimpleProject("master");
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, this.janeDoe, "Commit number 1");
        FreeStyleBuild firstBuild = this.build(project, Result.SUCCESS, "commitFile1");
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
        String commitFile2 = "commitFile2";
        this.commit("commitFile2", this.johnDoe, this.janeDoe, "Commit number 2");
        Assert.assertTrue((String)"scm polling did not detect commit2 change", (boolean)project.poll(this.listener).hasChanges());
        FreeStyleBuild secondBuild = this.build(project, Result.SUCCESS, "commitFile2");
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
        Set secondCulprits = secondBuild.getCulprits();
        Assert.assertEquals((String)"The build should have only one culprit", (long)1L, (long)secondCulprits.size());
        Assert.assertEquals((String)"Did not get the committer as the change author with authorOrCommitter==false", (Object)this.janeDoe.getName(), (Object)((User)secondCulprits.iterator().next()).getFullName());
    }

    @Test
    public void testAuthorOrCommitterTrue() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        FreeStyleProject project = this.setupSimpleProject("master");
        ((GitSCM)project.getScm()).getExtensions().add((Object)new AuthorInChangelog());
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, this.janeDoe, "Commit number 1");
        FreeStyleBuild firstBuild = this.build(project, Result.SUCCESS, "commitFile1");
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
        String commitFile2 = "commitFile2";
        this.commit("commitFile2", this.johnDoe, this.janeDoe, "Commit number 2");
        Assert.assertTrue((String)"scm polling did not detect commit2 change", (boolean)project.poll(this.listener).hasChanges());
        FreeStyleBuild secondBuild = this.build(project, Result.SUCCESS, "commitFile2");
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
        Set secondCulprits = secondBuild.getCulprits();
        Assert.assertEquals((String)"The build should have only one culprit", (long)1L, (long)secondCulprits.size());
        Assert.assertEquals((String)"Did not get the author as the change author with authorOrCommitter==true", (Object)this.johnDoe.getName(), (Object)((User)secondCulprits.iterator().next()).getFullName());
    }

    @Test
    public void testNewCommitToUntrackedBranchDoesNotTriggerBuild() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        FreeStyleProject project = this.setupSimpleProject("master");
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        this.build(project, Result.SUCCESS, "commitFile1");
        this.git.checkout("HEAD", "untracked");
        String commitFile2 = "commitFile2";
        this.commit("commitFile2", this.johnDoe, "Commit number 2");
        Assert.assertFalse((String)"scm polling should not detect commit2 change because it is not in the branch we are tracking.", (boolean)project.poll(this.listener).hasChanges());
    }

    private String checkoutString(FreeStyleProject project, String envVar) {
        return "checkout -f " + (String)this.getEnvVars(project).get((Object)envVar);
    }

    @Test
    public void testEnvVarsAvailable() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        FreeStyleProject project = this.setupSimpleProject("master");
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        FreeStyleBuild build1 = this.build(project, Result.SUCCESS, "commitFile1");
        Assert.assertEquals((Object)"origin/master", (Object)this.getEnvVars(project).get((Object)"GIT_BRANCH"));
        this.r.waitForMessage((String)this.getEnvVars(project).get((Object)"GIT_BRANCH"), (Run)build1);
        this.r.waitForMessage(this.checkoutString(project, "GIT_COMMIT"), (Run)build1);
        String commitFile2 = "commitFile2";
        this.commit("commitFile2", this.johnDoe, "Commit number 2");
        FreeStyleBuild build2 = this.build(project, Result.SUCCESS, "commitFile2");
        this.r.assertLogNotContains(this.checkoutString(project, "GIT_PREVIOUS_COMMIT"), (Run)build2);
        this.r.waitForMessage(this.checkoutString(project, "GIT_PREVIOUS_COMMIT"), (Run)build1);
        this.r.assertLogNotContains(this.checkoutString(project, "GIT_PREVIOUS_SUCCESSFUL_COMMIT"), (Run)build2);
        this.r.waitForMessage(this.checkoutString(project, "GIT_PREVIOUS_SUCCESSFUL_COMMIT"), (Run)build1);
    }

    @Test
    public void testNodeOverrideGit() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        GitSCM scm = new GitSCM(null);
        DumbSlave agent = this.r.createSlave();
        GitTool.DescriptorImpl gitToolDescriptor = (GitTool.DescriptorImpl)this.r.jenkins.getDescriptorByType(GitTool.DescriptorImpl.class);
        GitTool installation = new GitTool("Default", "/usr/bin/git", null);
        gitToolDescriptor.setInstallations((ToolInstallation[])new GitTool[]{installation});
        String gitExe = scm.getGitExe((Node)agent, TaskListener.NULL);
        Assert.assertEquals((Object)"/usr/bin/git", (Object)gitExe);
        ToolLocationNodeProperty nodeGitLocation = new ToolLocationNodeProperty(new ToolLocationNodeProperty.ToolLocation[]{new ToolLocationNodeProperty.ToolLocation((ToolDescriptor)gitToolDescriptor, "Default", "C:\\Program Files\\Git\\bin\\git.exe")});
        agent.setNodeProperties(Collections.singletonList(nodeGitLocation));
        gitExe = scm.getGitExe((Node)agent, TaskListener.NULL);
        Assert.assertEquals((Object)"C:\\Program Files\\Git\\bin\\git.exe", (Object)gitExe);
    }

    @Test
    public void testGitSCMCanBuildAgainstTags() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        String mytag = "mytag";
        FreeStyleProject project = this.setupSimpleProject("mytag");
        this.build(project, Result.FAILURE, new String[0]);
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        this.build(project, Result.FAILURE, new String[0]);
        String tmpBranch = "tmp";
        this.git.branch("tmp");
        this.git.checkout("tmp");
        String commitFile2 = "commitFile2";
        this.commit("commitFile2", this.johnDoe, "Commit number 2");
        Assert.assertFalse((String)"scm polling should not detect any more changes since mytag is untouched right now", (boolean)project.poll(this.listener).hasChanges());
        this.build(project, Result.FAILURE, new String[0]);
        this.git.tag("mytag", "mytag initial");
        this.git.checkout("master");
        this.git.deleteBranch("tmp");
        Assert.assertTrue((String)"scm polling should detect commit2 change in 'mytag'", (boolean)project.poll(this.listener).hasChanges());
        this.build(project, Result.SUCCESS, "commitFile2");
        Assert.assertFalse((String)"scm polling should not detect any more changes after last build", (boolean)project.poll(this.listener).hasChanges());
        this.git.checkout("mytag");
        this.git.branch("tmp");
        String commitFile3 = "commitFile3";
        this.commit("commitFile3", this.johnDoe, "Commit number 3");
        Assert.assertFalse((String)"scm polling should not detect any more changes since mytag is untouched right now", (boolean)project.poll(this.listener).hasChanges());
        this.git.tag("mytag", "mytag moved");
        this.git.checkout("master");
        this.git.deleteBranch("tmp");
        Assert.assertTrue((String)"scm polling should detect commit3 change in 'mytag'", (boolean)project.poll(this.listener).hasChanges());
        this.build(project, Result.SUCCESS, "commitFile3");
        Assert.assertFalse((String)"scm polling should not detect any more changes after last build", (boolean)project.poll(this.listener).hasChanges());
    }

    @Test
    public void testMultipleBranchBuild() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        FreeStyleProject project = this.setupSimpleProject("");
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        this.build(project, Result.SUCCESS, "commitFile1");
        String fork = "fork";
        this.git.branch("fork");
        String commitFile2 = "commitFile2";
        this.commit("commitFile2", this.johnDoe, "Commit number 2");
        String commitFile3 = "commitFile3";
        this.commit("commitFile3", this.johnDoe, "Commit number 3");
        Assert.assertTrue((String)"scm polling should detect changes in 'master' branch", (boolean)project.poll(this.listener).hasChanges());
        this.build(project, Result.SUCCESS, "commitFile1", "commitFile2");
        Assert.assertFalse((String)"scm polling should not detect any more changes after last build", (boolean)project.poll(this.listener).hasChanges());
        this.git.checkout("fork");
        String forkFile1 = "forkFile1";
        this.commit("forkFile1", this.johnDoe, "Fork commit number 1");
        String forkFile2 = "forkFile2";
        this.commit("forkFile2", this.johnDoe, "Fork commit number 2");
        Assert.assertTrue((String)"scm polling should detect changes in 'fork' branch", (boolean)project.poll(this.listener).hasChanges());
        this.build(project, Result.SUCCESS, "forkFile1", "forkFile2");
        Assert.assertFalse((String)"scm polling should not detect any more changes after last build", (boolean)project.poll(this.listener).hasChanges());
    }

    @Test
    public void testMultipleBranchesWithTags() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        List<BranchSpec> branchSpecs = Arrays.asList(new BranchSpec("refs/tags/v*"), new BranchSpec("refs/remotes/origin/non-existent"));
        FreeStyleProject project = this.setupProject(branchSpecs, false, null, null, this.janeDoe.getName(), null, false, null);
        this.commit("commitFileBase", this.johnDoe, "Initial Commit");
        FreeStyleBuild freeStyleBuild = this.build(project, Result.FAILURE, new String[0]);
        String v1 = "v1";
        this.git.tag("v1", "version 1");
        Assert.assertTrue((String)"v1 tag exists", (boolean)this.git.tagExists("v1"));
        freeStyleBuild = this.build(project, Result.SUCCESS, new String[0]);
        Assert.assertTrue((String)"change set is empty", (boolean)freeStyleBuild.getChangeSet().isEmptySet());
        this.commit("file1", this.johnDoe, "change to file1");
        this.git.tag("none", "latest");
        freeStyleBuild = this.build(project, Result.SUCCESS, new String[0]);
        ObjectId tag = this.git.revParse("refs/tags/v1");
        GitSCM scm = (GitSCM)project.getScm();
        BuildData buildData = scm.getBuildData((Run)freeStyleBuild);
        Assert.assertEquals((String)"last build matches the v1 tag revision", (Object)tag, (Object)buildData.lastBuild.getSHA1());
    }

    @Test
    public void testBlankRepositoryName() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        new GitSCM(null);
    }

    @Test
    public void testSubmoduleFixup() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        File repo = this.secondRepo.getRoot();
        FilePath moduleWs = new FilePath(repo);
        GitClient moduleRepo = Git.with((TaskListener)this.listener, (EnvVars)new EnvVars()).in(repo).getClient();
        moduleRepo.init();
        moduleWs.child("a").touch(0L);
        moduleRepo.add("a");
        moduleRepo.commit("creating a module");
        this.git.addSubmodule(repo.getAbsolutePath(), "module1");
        this.git.commit("creating a super project");
        FreeStyleProject u = this.createFreeStyleProject();
        FreeStyleProject d = this.createFreeStyleProject();
        u.setScm((SCM)new GitSCM(this.workDir.getPath()));
        u.getPublishersList().add((Object)new BuildTrigger(new BuildTriggerConfig[]{new BuildTriggerConfig(d.getName(), ResultCondition.SUCCESS, new AbstractBuildParameters[]{new GitRevisionBuildParameters()})}));
        d.setScm((SCM)new GitSCM(this.workDir.getPath()));
        this.r.jenkins.rebuildDependencyGraph();
        FreeStyleBuild ub = this.r.buildAndAssertSuccess(u);
        for (int i = 0; (d.getLastBuild() == null || ((FreeStyleBuild)d.getLastBuild()).isBuilding()) && i < 100; ++i) {
            Thread.sleep(100L);
        }
        FreeStyleBuild db = (FreeStyleBuild)d.getLastBuild();
        Assert.assertNotNull((String)"downstream build didn't happen", (Object)db);
        db = (FreeStyleBuild)this.r.waitForCompletion((Run)db);
        this.r.assertBuildStatusSuccess((Run)db);
    }

    public static void assertCulprits(String assertMsg, Set<User> actual, PersonIdent[] expected) {
        List fullNames = actual.stream().map(User::getFullName).collect(Collectors.toList());
        for (PersonIdent p : expected) {
            Assert.assertTrue((String)assertMsg, (boolean)fullNames.contains(p.getName()));
        }
    }

    @Test
    public void testHideCredentials() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        FreeStyleProject project = this.setupSimpleProject("master");
        this.store.addCredentials(Domain.global(), (Credentials)this.createCredential(CredentialsScope.GLOBAL, "github"));
        List remoteConfigs = GitSCM.createRepoList((String)"https://github.com/jenkinsci/git-plugin", (String)"github");
        project.setScm((SCM)new GitSCM(remoteConfigs, Collections.singletonList(new BranchSpec("master")), Boolean.valueOf(false), null, null, null, null));
        GitSCM scm = (GitSCM)project.getScm();
        GitSCM.DescriptorImpl descriptor = scm.getDescriptor();
        Assert.assertFalse((String)"Wrong initial value for hide credentials", (boolean)scm.isHideCredentials());
        descriptor.setHideCredentials(true);
        Assert.assertTrue((String)"Hide credentials not set", (boolean)scm.isHideCredentials());
        String currentDirectoryPath = new File(".").getCanonicalPath();
        if (this.isWindows() && currentDirectoryPath.length() > 95) {
            return;
        }
        descriptor.setHideCredentials(false);
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        this.build(project, Result.SUCCESS, new String[0]);
        List logLines = ((FreeStyleBuild)project.getLastBuild()).getLog(100);
        MatcherAssert.assertThat((Object)logLines, (Matcher)Matchers.hasItem((Object)"using credential github"));
        descriptor.setHideCredentials(true);
        this.build(project, Result.SUCCESS, new String[0]);
        logLines = ((FreeStyleBuild)project.getLastBuild()).getLog(100);
        MatcherAssert.assertThat((Object)logLines, (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)"using credential github")));
    }

    @Test
    public void testEmailCommitter() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        FreeStyleProject project = this.setupSimpleProject("master");
        GitSCM scm = (GitSCM)project.getScm();
        GitSCM.DescriptorImpl descriptor = scm.getDescriptor();
        Assert.assertFalse((String)"Wrong initial value for create account based on e-mail", (boolean)scm.isCreateAccountBasedOnEmail());
        descriptor.setCreateAccountBasedOnEmail(true);
        Assert.assertTrue((String)"Create account based on e-mail not set", (boolean)scm.isCreateAccountBasedOnEmail());
        Assert.assertFalse((String)"Wrong initial value for use existing user if same e-mail already found", (boolean)scm.isUseExistingAccountWithSameEmail());
        descriptor.setUseExistingAccountWithSameEmail(true);
        Assert.assertTrue((String)"Use existing user if same e-mail already found is not set", (boolean)scm.isUseExistingAccountWithSameEmail());
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        FreeStyleBuild build = this.build(project, Result.SUCCESS, "commitFile1");
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
        String commitFile2 = "commitFile2";
        PersonIdent jeffDoe = new PersonIdent("Jeff Doe", "jeff@doe.com");
        this.commit("commitFile2", jeffDoe, "Commit number 2");
        Assert.assertTrue((String)"scm polling did not detect commit2 change", (boolean)project.poll(this.listener).hasChanges());
        FreeStyleBuild build2 = this.build(project, Result.SUCCESS, "commitFile2");
        Set culprits = build2.getCulprits();
        Assert.assertEquals((String)"The build should have only one culprit", (long)1L, (long)culprits.size());
        User culprit = (User)culprits.iterator().next();
        Assert.assertEquals((String)"", (Object)jeffDoe.getEmailAddress(), (Object)culprit.getId());
        Assert.assertEquals((String)"", (Object)jeffDoe.getName(), (Object)culprit.getFullName());
        this.r.assertBuildStatusSuccess((Run)build);
    }

    @Test
    public void testNonExistentWorkingDirectoryPoll() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        FreeStyleProject project = this.setupSimpleProject("master");
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        project.setScm((SCM)new GitSCM(((GitSCM)project.getScm()).getUserRemoteConfigs(), Collections.singletonList(new BranchSpec("master")), null, null, Collections.singletonList(new DisableRemotePoll())));
        FreeStyleBuild build1 = this.build(project, Result.SUCCESS, "commitFile1");
        build1.getWorkspace().deleteRecursive();
        RingBufferLogHandler pollLogHandler = new RingBufferLogHandler(10);
        Logger pollLogger = Logger.getLogger(GitSCMTest.class.getName());
        pollLogger.addHandler((Handler)pollLogHandler);
        LogTaskListener taskListener = new LogTaskListener(pollLogger, Level.INFO);
        FilePath filePath = build1.getWorkspace();
        MatcherAssert.assertThat((Object)project.getScm().compareRemoteRevisionWith((Job)project, (Launcher)new Launcher.LocalLauncher((TaskListener)taskListener), filePath, (TaskListener)taskListener, null), (Matcher)Matchers.is((Object)PollingResult.BUILD_NOW));
        Assert.assertTrue((boolean)pollLogHandler.getView().stream().anyMatch(m -> m.getMessage().contains("[poll] Working Directory does not exist")));
    }

    public void testFetchFromMultipleRepositories() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        FreeStyleProject project = this.setupSimpleProject("master");
        TestGitRepo secondTestRepo = new TestGitRepo("second", this.secondRepo.getRoot(), this.listener);
        ArrayList<UserRemoteConfig> remotes = new ArrayList<UserRemoteConfig>();
        remotes.addAll(this.testRepo.remoteConfigs());
        remotes.addAll(secondTestRepo.remoteConfigs());
        project.setScm((SCM)new GitSCM(remotes, Collections.singletonList(new BranchSpec("master")), null, null, Collections.emptyList()));
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        this.build(project, Result.SUCCESS, "commitFile1");
        SCMRevisionState baseline = project.poll((TaskListener)this.listener).baseline;
        PollingResult.Change change = project.poll((TaskListener)this.listener).change;
        SCMRevisionState remote = project.poll((TaskListener)this.listener).remote;
        String assertionMessage = MessageFormat.format("polling incorrectly detected change after build. Baseline: {0}, Change: {1}, Remote: {2}", baseline, change, remote);
        Assert.assertFalse((String)assertionMessage, (boolean)project.poll(this.listener).hasChanges());
        String commitFile2 = "commitFile2";
        secondTestRepo.commit("commitFile2", this.janeDoe, "Commit number 2");
        Assert.assertTrue((String)"scm polling did not detect commit2 change", (boolean)project.poll(this.listener).hasChanges());
        FreeStyleBuild build2 = this.build(project, Result.SUCCESS, "commitFile2");
        Assert.assertTrue((boolean)build2.getWorkspace().child("commitFile2").exists());
        this.r.assertBuildStatusSuccess((Run)build2);
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
    }

    private void branchSpecWithMultipleRepositories(String branchName) throws Exception {
        FreeStyleProject project = this.setupSimpleProject("master");
        TestGitRepo secondTestRepo = new TestGitRepo("second", this.secondRepo.getRoot(), this.listener);
        ArrayList<UserRemoteConfig> remotes = new ArrayList<UserRemoteConfig>();
        remotes.addAll(this.testRepo.remoteConfigs());
        remotes.addAll(secondTestRepo.remoteConfigs());
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        project.setScm((SCM)new GitSCM(remotes, Collections.singletonList(new BranchSpec(branchName)), null, null, Collections.emptyList()));
        FreeStyleBuild build = this.build(project, Result.SUCCESS, "commitFile1");
        this.r.assertBuildStatusSuccess((Run)build);
    }

    @Test
    public void testBranchSpecAsSHA1WithMultipleRepositories() throws Exception {
        String commitFile1 = "commitFile1";
        this.commit(commitFile1, this.johnDoe, "Commit 1 from testBranchSpecAsSHA1WithMultipleRepositories");
        this.branchSpecWithMultipleRepositories(this.testRepo.git.revParse("HEAD").getName());
    }

    @Test
    public void testBranchSpecAsRemotesOriginMasterWithMultipleRepositories() throws Exception {
        String commitFile1 = "commitFile1";
        this.commit(commitFile1, this.johnDoe, "Commit 1 from testBranchSpecAsSHA1WithMultipleRepositories");
        this.branchSpecWithMultipleRepositories("remotes/origin/master");
    }

    @Test
    public void testCommitDetectedOnlyOnceInMultipleRepositories() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        FreeStyleProject project = this.setupSimpleProject("master");
        TestGitRepo secondTestRepo = new TestGitRepo("secondRepo", this.secondRepo.getRoot(), this.listener);
        ArrayList<UserRemoteConfig> remotes = new ArrayList<UserRemoteConfig>();
        remotes.addAll(this.testRepo.remoteConfigs());
        remotes.addAll(secondTestRepo.remoteConfigs());
        GitSCM gitSCM = new GitSCM(remotes, Collections.singletonList(new BranchSpec("origin/master")), null, null, Collections.emptyList());
        project.setScm((SCM)gitSCM);
        FilePath filePath = new FilePath(new File("."));
        MatcherAssert.assertThat((Object)gitSCM.compareRemoteRevisionWith((Job)project, (Launcher)new Launcher.LocalLauncher(this.listener), filePath, this.listener, null), (Matcher)Matchers.is((Object)PollingResult.BUILD_NOW));
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        FreeStyleBuild build = this.build(project, Result.SUCCESS, "commitFile1");
        this.commit("commitFile2", this.johnDoe, "Commit number 2");
        this.git = Git.with((TaskListener)this.listener, (EnvVars)new EnvVars()).in(build.getWorkspace()).getClient();
        for (RemoteConfig remoteConfig : gitSCM.getRepositories()) {
            this.git.fetch_().from((URIish)remoteConfig.getURIs().get(0), remoteConfig.getFetchRefSpecs());
        }
        BuildChooser buildChooser = gitSCM.getBuildChooser();
        Collection candidateRevisions = buildChooser.getCandidateRevisions(false, "origin/master", this.git, this.listener, (BuildData)((FreeStyleBuild)project.getLastBuild()).getAction(BuildData.class), null);
        Assert.assertEquals((long)1L, (long)candidateRevisions.size());
        gitSCM.setBuildChooser(buildChooser);
        Collection candidateRevisions2 = buildChooser.getCandidateRevisions(false, "origin/master", this.git, this.listener, (BuildData)((FreeStyleBuild)project.getLastBuild()).getAction(BuildData.class), null);
        MatcherAssert.assertThat((Object)candidateRevisions2, (Matcher)Matchers.is((Object)candidateRevisions));
    }

    private void addChangelogToBranchExtension(GitSCM scm) {
        if (this.useChangelogToBranch) {
            ChangelogToBranchOptions changelogOptions = new ChangelogToBranchOptions("origin", "master");
            scm.getExtensions().add((Object)new ChangelogToBranch(changelogOptions));
        }
        this.useChangelogToBranch = !this.useChangelogToBranch;
    }

    @Test
    public void testMerge() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        FreeStyleProject project = this.setupSimpleProject("master");
        GitSCM scm = new GitSCM(this.createRemoteRepositories(), Collections.singletonList(new BranchSpec("*")), null, null, Collections.emptyList());
        scm.getExtensions().add((Object)new GitSCMSlowTest.TestPreBuildMerge(new UserMergeOptions("origin", "integration", "default", MergeCommand.GitPluginFastForwardMode.FF)));
        this.addChangelogToBranchExtension(scm);
        project.setScm((SCM)scm);
        this.commit("commitFileBase", this.johnDoe, "Initial Commit");
        this.testRepo.git.branch("integration");
        this.build(project, Result.SUCCESS, "commitFileBase");
        this.testRepo.git.checkout(null, "topic1");
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        FreeStyleBuild build1 = this.build(project, Result.SUCCESS, "commitFile1");
        Assert.assertTrue((boolean)build1.getWorkspace().child("commitFile1").exists());
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
        this.testRepo.git.deleteBranch("integration");
        this.testRepo.git.checkout("topic1", "integration");
        this.testRepo.git.checkout("master", "topic2");
        String commitFile2 = "commitFile2";
        this.commit("commitFile2", this.johnDoe, "Commit number 2");
        Assert.assertTrue((String)"scm polling did not detect commit2 change", (boolean)project.poll(this.listener).hasChanges());
        FreeStyleBuild build2 = this.build(project, Result.SUCCESS, "commitFile2");
        Assert.assertTrue((boolean)build2.getWorkspace().child("commitFile2").exists());
        this.r.assertBuildStatusSuccess((Run)build2);
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
    }

    @Test
    public void testMergeChangelog() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        FreeStyleProject project = this.setupSimpleProject("master");
        GitSCM scm = new GitSCM(this.createRemoteRepositories(), Collections.singletonList(new BranchSpec("*")), null, null, Collections.emptyList());
        scm.getExtensions().add((Object)new PreBuildMerge(new UserMergeOptions("origin", "integration", "default", MergeCommand.GitPluginFastForwardMode.FF)));
        this.addChangelogToBranchExtension(scm);
        project.setScm((SCM)scm);
        this.commit("commitFileBase", this.johnDoe, "Initial Commit");
        this.testRepo.git.branch("integration");
        this.build(project, Result.SUCCESS, "commitFileBase");
        this.testRepo.git.checkout("master", "topic2");
        String commitFile2 = "commitFile2";
        String commitMessage = "Commit number 2";
        this.commit("commitFile2", this.johnDoe, commitMessage);
        FreeStyleBuild build2 = this.build(project, Result.SUCCESS, "commitFile2");
        ChangeLogSet changeLog = build2.getChangeSet();
        Assert.assertEquals((String)"Changelog should contain one item", (long)1L, (long)changeLog.getItems().length);
        GitChangeSet singleChange = (GitChangeSet)changeLog.getItems()[0];
        Assert.assertEquals((String)"Changelog should contain commit number 2", (Object)commitMessage, (Object)singleChange.getComment().trim());
    }

    @Test
    public void testMergeFailed() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        FreeStyleProject project = this.setupSimpleProject("master");
        GitSCM scm = new GitSCM(this.createRemoteRepositories(), Collections.singletonList(new BranchSpec("*")), null, null, Collections.emptyList());
        project.setScm((SCM)scm);
        scm.getExtensions().add((Object)new PreBuildMerge(new UserMergeOptions("origin", "integration", "", MergeCommand.GitPluginFastForwardMode.FF)));
        this.addChangelogToBranchExtension(scm);
        this.commit("commitFileBase", this.johnDoe, "Initial Commit");
        this.testRepo.git.branch("integration");
        this.build(project, Result.SUCCESS, "commitFileBase");
        this.testRepo.git.checkout(null, "topic1");
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        FreeStyleBuild build1 = this.build(project, Result.SUCCESS, "commitFile1");
        Assert.assertTrue((boolean)build1.getWorkspace().child("commitFile1").exists());
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
        this.testRepo.git.deleteBranch("integration");
        this.testRepo.git.checkout("topic1", "integration");
        this.testRepo.git.checkout("master", "topic2");
        this.commit("commitFile1", "other content", this.johnDoe, "Commit number 2");
        Assert.assertTrue((String)"scm polling did not detect commit2 change", (boolean)project.poll(this.listener).hasChanges());
        this.r.buildAndAssertStatus(Result.FAILURE, (Job)project);
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
    }

    @Test
    public void testMultipleMergeFailed() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        FreeStyleProject project = this.setupSimpleProject("master");
        GitSCM scm = new GitSCM(this.createRemoteRepositories(), Collections.singletonList(new BranchSpec("master")), null, null, Collections.emptyList());
        project.setScm((SCM)scm);
        scm.getExtensions().add((Object)new PreBuildMerge(new UserMergeOptions("origin", "integration1", "", MergeCommand.GitPluginFastForwardMode.FF)));
        scm.getExtensions().add((Object)new PreBuildMerge(new UserMergeOptions("origin", "integration2", "", MergeCommand.GitPluginFastForwardMode.FF)));
        this.addChangelogToBranchExtension(scm);
        this.commit("dummyFile", this.johnDoe, "Initial Commit");
        this.testRepo.git.branch("integration1");
        this.testRepo.git.branch("integration2");
        this.build(project, Result.SUCCESS, new String[0]);
        String commitFile = "commitFile";
        this.testRepo.git.checkoutBranch("integration1", "master");
        this.commit("commitFile", "abc", this.johnDoe, "merge conflict with integration2");
        this.testRepo.git.checkoutBranch("integration2", "master");
        this.commit("commitFile", "cde", this.johnDoe, "merge conflict with integration1");
        FreeStyleBuild build = this.build(project, Result.FAILURE, new String[0]);
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)project.poll(this.listener).hasChanges());
    }

    @Test
    public void testEnvironmentVariableExpansion() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        FreeStyleProject project = this.createFreeStyleProject();
        project.setScm((SCM)new GitSCM("${CAT}" + this.testRepo.gitDir.getPath()));
        this.commit("a.txt", this.johnDoe, "Initial Commit");
        this.build(project, Result.SUCCESS, "a.txt");
        PollingResult r = project.poll((TaskListener)StreamTaskListener.fromStdout());
        Assert.assertFalse((boolean)r.hasChanges());
        this.commit("b.txt", this.johnDoe, "Another commit");
        r = project.poll((TaskListener)StreamTaskListener.fromStdout());
        Assert.assertTrue((boolean)r.hasChanges());
        this.build(project, Result.SUCCESS, "b.txt");
    }

    @Test
    public void testDataCompatibility1() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        FreeStyleProject p = (FreeStyleProject)this.r.jenkins.createProjectFromXML("foo", this.getClass().getResourceAsStream("GitSCMTest/old1.xml"));
        GitSCM oldGit = (GitSCM)p.getScm();
        Assert.assertEquals(Collections.emptyList(), (Object)oldGit.getExtensions().toList());
        Assert.assertEquals((long)0L, (long)oldGit.getSubmoduleCfg().size());
        Assert.assertEquals((Object)"git https://github.com/jenkinsci/model-ant-project.git", (Object)oldGit.getKey());
        MatcherAssert.assertThat((Object)oldGit.getEffectiveBrowser(), (Matcher)Matchers.instanceOf(GithubWeb.class));
        GithubWeb browser = (GithubWeb)oldGit.getEffectiveBrowser();
        Assert.assertEquals((Object)browser.getRepoUrl(), (Object)"https://github.com/jenkinsci/model-ant-project.git/");
    }

    @Test
    public void testCheckoutReturnsLatestValues() throws Exception {
        String currentDirectoryPath = new File(".").getCanonicalPath();
        if (this.isWindows() && currentDirectoryPath.length() > 95) {
            return;
        }
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        WorkflowJob p = (WorkflowJob)this.r.jenkins.createProject(WorkflowJob.class, "pipeline-checkout-3-tags");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("node {\n    def tokenBranch = ''\n    def tokenRevision = ''\n    def checkout1 = checkout([$class: 'GitSCM', branches: [[name: 'git-1.1']], extensions: [], userRemoteConfigs: [[url: 'https://github.com/jenkinsci/git-plugin.git']]])\n    echo \"checkout1: ${checkout1}\"\n    tokenBranch = tm '${GIT_BRANCH}'\n    tokenRevision = tm '${GIT_REVISION}'\n    echo \"token1: ${tokenBranch}\"\n    echo \"revision1: ${tokenRevision}\"\n    def checkout2 = checkout([$class: 'GitSCM', branches: [[name: 'git-2.0.2']], extensions: [], userRemoteConfigs: [[url: 'https://github.com/jenkinsci/git-plugin.git']]])\n    echo \"checkout2: ${checkout2}\"\n    tokenBranch = tm '${GIT_BRANCH,all=true}'\n    tokenRevision = tm '${GIT_REVISION,length=8}'\n    echo \"token2: ${tokenBranch}\"\n    echo \"revision2: ${tokenRevision}\"\n    def checkout3 = checkout([$class: 'GitSCM', branches: [[name: 'git-3.0.0']], extensions: [], userRemoteConfigs: [[url: 'https://github.com/jenkinsci/git-plugin.git']]])\n    echo \"checkout3: ${checkout3}\"\n    tokenBranch = tm '${GIT_BRANCH,fullName=true}'\n    tokenRevision = tm '${GIT_REVISION,length=6}'\n    echo \"token3: ${tokenBranch}\"\n    echo \"revision3: ${tokenRevision}\"\n}", true));
        WorkflowRun b = (WorkflowRun)this.r.buildAndAssertSuccess((Job)p);
        String log = b.getLog();
        MatcherAssert.assertThat((Object)this.getLineStartsWith(log, "checkout1:"), (Matcher)Matchers.containsString((String)"checkout1: [GIT_BRANCH:git-1.1, GIT_COMMIT:82db9509c068f60c41d7a4572c0114cc6d23cd0d, GIT_URL:https://github.com/jenkinsci/git-plugin.git]"));
        MatcherAssert.assertThat((Object)this.getLineStartsWith(log, "checkout2:"), (Matcher)Matchers.containsString((String)"checkout2: [GIT_BRANCH:git-2.0.2, GIT_COMMIT:377a0fdbfbf07f70a3e9a566d749b2a185909c33, GIT_URL:https://github.com/jenkinsci/git-plugin.git]"));
        MatcherAssert.assertThat((Object)this.getLineStartsWith(log, "checkout3:"), (Matcher)Matchers.containsString((String)"checkout3: [GIT_BRANCH:git-3.0.0, GIT_COMMIT:858dee578b79ac6683419faa57a281ccb9d347aa, GIT_URL:https://github.com/jenkinsci/git-plugin.git]"));
        MatcherAssert.assertThat((Object)this.getLineStartsWith(log, "token1:"), (Matcher)Matchers.containsString((String)"token1: git-1.1"));
        MatcherAssert.assertThat((Object)this.getLineStartsWith(log, "token2:"), (Matcher)Matchers.containsString((String)"token2: git-1.1"));
        MatcherAssert.assertThat((Object)this.getLineStartsWith(log, "token3:"), (Matcher)Matchers.containsString((String)"token3: git-1.1"));
        MatcherAssert.assertThat((Object)this.getLineStartsWith(log, "revision1:"), (Matcher)Matchers.containsString((String)"revision1: 82db9509c068f60c41d7a4572c0114cc6d23cd0d"));
        MatcherAssert.assertThat((Object)this.getLineStartsWith(log, "revision2:"), (Matcher)Matchers.containsString((String)"revision2: 82db9509"));
        MatcherAssert.assertThat((Object)this.getLineStartsWith(log, "revision3:"), (Matcher)Matchers.containsString((String)"revision3: 82db95"));
    }

    private String getLineStartsWith(String text, String startOfLine) {
        try (Scanner scanner = new Scanner(text);){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (!line.startsWith(startOfLine)) continue;
                String string = line;
                return string;
            }
        }
        return "";
    }

    @Test
    public void testPleaseDontContinueAnyway() throws Exception {
        if (this.isWindows() || this.random.nextBoolean()) {
            return;
        }
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        this.testRepo.commit("a", "foo", this.johnDoe, "added");
        FreeStyleProject p = this.createFreeStyleProject();
        p.setScm((SCM)new GitSCM(this.testRepo.gitDir.getAbsolutePath()));
        this.r.buildAndAssertSuccess(p);
        p.setScm((SCM)new GitSCM("http://localhost:4321/no/such/repository.git"));
        this.r.buildAndAssertStatus(Result.FAILURE, (Job)p);
    }

    @Test
    public void testCheckoutToSpecificBranch() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        FreeStyleProject p = this.createFreeStyleProject();
        GitSCM oldGit = new GitSCM("https://github.com/jenkinsci/model-ant-project.git/");
        this.setupJGit(oldGit);
        oldGit.getExtensions().add((Object)new LocalBranch("master"));
        p.setScm((SCM)oldGit);
        FreeStyleBuild b = this.r.buildAndAssertSuccess(p);
        GitClient gc = Git.with((TaskListener)StreamTaskListener.fromStdout(), null).in(b.getWorkspace()).getClient();
        gc.withRepository((RepositoryCallback & Serializable)(repo, channel) -> {
            Ref head = repo.findRef("HEAD");
            Assert.assertTrue((String)"Detached HEAD", (boolean)head.isSymbolic());
            Ref t = head.getTarget();
            Assert.assertEquals((Object)t.getName(), (Object)"refs/heads/master");
            return null;
        });
    }

    @Test
    public void testCheckoutToDefaultLocalBranch_StarStar() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        FreeStyleProject project = this.setupSimpleProject("master");
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        GitSCM git = (GitSCM)project.getScm();
        git.getExtensions().add((Object)new LocalBranch("**"));
        FreeStyleBuild build1 = this.build(project, Result.SUCCESS, "commitFile1");
        Assert.assertEquals((String)"GIT_BRANCH", (Object)"origin/master", (Object)this.getEnvVars(project).get((Object)"GIT_BRANCH"));
        Assert.assertEquals((String)"GIT_LOCAL_BRANCH", (Object)"master", (Object)this.getEnvVars(project).get((Object)"GIT_LOCAL_BRANCH"));
    }

    @Test
    public void testCheckoutToDefaultLocalBranch_NULL() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        FreeStyleProject project = this.setupSimpleProject("master");
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        GitSCM git = (GitSCM)project.getScm();
        git.getExtensions().add((Object)new LocalBranch(""));
        FreeStyleBuild build1 = this.build(project, Result.SUCCESS, "commitFile1");
        Assert.assertEquals((String)"GIT_BRANCH", (Object)"origin/master", (Object)this.getEnvVars(project).get((Object)"GIT_BRANCH"));
        Assert.assertEquals((String)"GIT_LOCAL_BRANCH", (Object)"master", (Object)this.getEnvVars(project).get((Object)"GIT_LOCAL_BRANCH"));
    }

    @Test
    public void testCheckoutSansLocalBranchExtension() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        FreeStyleProject project = this.setupSimpleProject("master");
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        FreeStyleBuild build1 = this.build(project, Result.SUCCESS, "commitFile1");
        Assert.assertEquals((String)"GIT_BRANCH", (Object)"origin/master", (Object)this.getEnvVars(project).get((Object)"GIT_BRANCH"));
        Assert.assertNull((String)"GIT_LOCAL_BRANCH", (Object)this.getEnvVars(project).get((Object)"GIT_LOCAL_BRANCH"));
    }

    @Test
    public void testCheckoutRelativeTargetDirectoryExtension() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        FreeStyleProject project = this.setupProject("master", false, "checkoutDir");
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        GitSCM git = (GitSCM)project.getScm();
        git.getExtensions().add((Object)new RelativeTargetDirectory("checkoutDir"));
        FreeStyleBuild build1 = this.build(project, "checkoutDir", Result.SUCCESS, "commitFile1");
        Assert.assertEquals((String)"GIT_CHECKOUT_DIR", (Object)"checkoutDir", (Object)this.getEnvVars(project).get((Object)"GIT_CHECKOUT_DIR"));
    }

    @Test
    public void testCheckoutSansRelativeTargetDirectoryExtension() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        FreeStyleProject project = this.setupSimpleProject("master");
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        FreeStyleBuild build1 = this.build(project, Result.SUCCESS, "commitFile1");
        Assert.assertNull((String)"GIT_CHECKOUT_DIR", (Object)this.getEnvVars(project).get((Object)"GIT_CHECKOUT_DIR"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCheckoutFailureIsRetryable() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        FreeStyleProject project = this.setupSimpleProject("master");
        String commitFile1 = "commitFile1";
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        FreeStyleBuild build1 = this.build(project, Result.SUCCESS, "commitFile1");
        String commitFile2 = "commitFile2";
        this.commit("commitFile2", this.janeDoe, "Commit number 2");
        File lock = new File(build1.getWorkspace().getRemote(), ".git/index.lock");
        try {
            FileUtils.touch((File)lock);
            FreeStyleBuild build2 = this.build(project, Result.FAILURE, new String[0]);
            this.r.waitForMessage("java.io.IOException: Could not checkout", (Run)build2);
        }
        finally {
            lock.delete();
        }
    }

    @Test
    public void testSparseCheckoutAfterNormalCheckout() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        FreeStyleProject project = this.setupSimpleProject("master");
        String commitFile1 = "toto/commitFile1";
        this.commit("toto/commitFile1", this.johnDoe, "Commit number 1");
        String commitFile2 = "titi/commitFile2";
        this.commit("titi/commitFile2", this.johnDoe, "Commit number 2");
        FreeStyleBuild build1 = this.build(project, Result.SUCCESS, new String[0]);
        Assert.assertTrue((boolean)build1.getWorkspace().child("titi").exists());
        Assert.assertTrue((boolean)build1.getWorkspace().child("titi/commitFile2").exists());
        Assert.assertTrue((boolean)build1.getWorkspace().child("toto").exists());
        Assert.assertTrue((boolean)build1.getWorkspace().child("toto/commitFile1").exists());
        ((GitSCM)project.getScm()).getExtensions().add((Object)new SparseCheckoutPaths(Collections.singletonList(new SparseCheckoutPath("titi"))));
        FreeStyleBuild build2 = this.build(project, Result.SUCCESS, new String[0]);
        Assert.assertTrue((boolean)build2.getWorkspace().child("titi").exists());
        Assert.assertTrue((boolean)build2.getWorkspace().child("titi/commitFile2").exists());
        Assert.assertFalse((boolean)build2.getWorkspace().child("toto").exists());
        Assert.assertFalse((boolean)build2.getWorkspace().child("toto/commitFile1").exists());
    }

    @Test
    public void testNormalCheckoutAfterSparseCheckout() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        FreeStyleProject project = this.setupProject("master", Collections.singletonList(new SparseCheckoutPath("titi")));
        String commitFile1 = "toto/commitFile1";
        this.commit("toto/commitFile1", this.johnDoe, "Commit number 1");
        String commitFile2 = "titi/commitFile2";
        this.commit("titi/commitFile2", this.johnDoe, "Commit number 2");
        FreeStyleBuild build2 = this.build(project, Result.SUCCESS, new String[0]);
        Assert.assertTrue((boolean)build2.getWorkspace().child("titi").exists());
        Assert.assertTrue((boolean)build2.getWorkspace().child("titi/commitFile2").exists());
        Assert.assertFalse((boolean)build2.getWorkspace().child("toto").exists());
        Assert.assertFalse((boolean)build2.getWorkspace().child("toto/commitFile1").exists());
        ((GitSCM)project.getScm()).getExtensions().remove(SparseCheckoutPaths.class);
        FreeStyleBuild build1 = this.build(project, Result.SUCCESS, new String[0]);
        Assert.assertTrue((boolean)build1.getWorkspace().child("titi").exists());
        Assert.assertTrue((boolean)build1.getWorkspace().child("titi/commitFile2").exists());
        Assert.assertTrue((boolean)build1.getWorkspace().child("toto").exists());
        Assert.assertTrue((boolean)build1.getWorkspace().child("toto/commitFile1").exists());
    }

    @Test
    public void testPolling_environmentValueInBranchSpec() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        FreeStyleProject project = this.createFreeStyleProject();
        GitSCM scm = new GitSCM(this.createRemoteRepositories(), Collections.singletonList(new BranchSpec("${MY_BRANCH}")), null, null, Collections.emptyList());
        project.setScm((SCM)scm);
        project.addProperty((JobProperty)new ParametersDefinitionProperty(new ParameterDefinition[]{new StringParameterDefinition("MY_BRANCH", "master")}));
        this.commit("toto/commitFile1", this.johnDoe, "Commit number 1");
        this.build(project, Result.SUCCESS, new String[0]);
        Assert.assertFalse((String)"No changes to git since last build, thus no new build is expected", (boolean)project.poll(this.listener).hasChanges());
    }

    public void baseTestPolling_parentHead(List<GitSCMExtension> extensions) throws Exception {
        FreeStyleProject project = this.createFreeStyleProject();
        GitSCM scm = new GitSCM(this.createRemoteRepositories(), Collections.singletonList(new BranchSpec("**")), null, null, extensions);
        project.setScm((SCM)scm);
        this.commit("toto/commitFile1", this.johnDoe, "Commit number 1");
        this.git.branch("someBranch");
        this.commit("toto/commitFile2", this.johnDoe, "Commit number 2");
        Assert.assertTrue((String)"polling should detect changes", (boolean)project.poll(this.listener).hasChanges());
        this.build(project, Result.SUCCESS, new String[0]);
        Assert.assertEquals((String)"Wrong number of builds", (long)1L, (long)project.getBuilds().size());
        Assert.assertFalse((String)"polling should not detect changes", (boolean)project.poll(this.listener).hasChanges());
    }

    @Test
    public void testPolling_parentHead() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        this.baseTestPolling_parentHead(Collections.emptyList());
    }

    @Test
    public void testPolling_parentHead_DisableRemotePoll() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        this.baseTestPolling_parentHead(Collections.singletonList(new DisableRemotePoll()));
    }

    @Test
    public void testPollingAfterManualBuildWithParametrizedBranchSpec() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        FreeStyleProject project = this.createFreeStyleProject();
        GitSCM scm = new GitSCM(this.createRemoteRepositories(), Collections.singletonList(new BranchSpec("${MY_BRANCH}")), null, null, Collections.emptyList());
        project.setScm((SCM)scm);
        project.addProperty((JobProperty)new ParametersDefinitionProperty(new ParameterDefinition[]{new StringParameterDefinition("MY_BRANCH", "trackedbranch")}));
        this.commit("file1", this.johnDoe, "Initial Commit");
        this.git.branch("trackedbranch");
        this.git.branch("manualbranch");
        StringParameterValue branchParam = new StringParameterValue("MY_BRANCH", "manualbranch");
        Action[] actions = new Action[]{new ParametersAction(new ParameterValue[]{branchParam})};
        FreeStyleBuild build = (FreeStyleBuild)project.scheduleBuild2(0, (Cause)new Cause.UserIdCause(), actions).get();
        this.r.assertBuildStatus(Result.SUCCESS, (Run)build);
        Assert.assertFalse((String)"No changes to git since last build", (boolean)project.poll(this.listener).hasChanges());
        this.git.checkout("manualbranch");
        this.commit("file2", this.johnDoe, "Commit to manually build branch");
        Assert.assertFalse((String)"No changes to tracked branch", (boolean)project.poll(this.listener).hasChanges());
        this.git.checkout("trackedbranch");
        this.commit("file3", this.johnDoe, "Commit to tracked branch");
        Assert.assertTrue((String)"A change should be detected in tracked branch", (boolean)project.poll(this.listener).hasChanges());
    }

    @Test
    public void testPolling_CanDoRemotePollingIfOneBranchButMultipleRepositories() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        FreeStyleProject project = this.createFreeStyleProject();
        ArrayList<UserRemoteConfig> remoteConfigs = new ArrayList<UserRemoteConfig>();
        remoteConfigs.add(new UserRemoteConfig(this.testRepo.gitDir.getAbsolutePath(), "origin", "", null));
        remoteConfigs.add(new UserRemoteConfig(this.testRepo.gitDir.getAbsolutePath(), "someOtherRepo", "", null));
        GitSCM scm = new GitSCM(remoteConfigs, Collections.singletonList(new BranchSpec("origin/master")), Boolean.valueOf(false), Collections.emptyList(), null, null, Collections.emptyList());
        project.setScm((SCM)scm);
        this.commit("commitFile1", this.johnDoe, "Commit number 1");
        FreeStyleBuild first_build = (FreeStyleBuild)project.scheduleBuild2(0, (Cause)new Cause.UserIdCause()).get();
        this.r.assertBuildStatus(Result.SUCCESS, (Run)first_build);
        first_build.getWorkspace().deleteContents();
        PollingResult pollingResult = scm.poll((AbstractProject)project, null, first_build.getWorkspace(), this.listener, null);
        Assert.assertFalse((boolean)pollingResult.hasChanges());
    }

    @Test
    public void testPolling_environmentValueAsEnvironmentContributingAction() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        FreeStyleProject project = this.createFreeStyleProject();
        GitSCM scm = new GitSCM(this.createRemoteRepositories(), Collections.singletonList(new BranchSpec("${MY_BRANCH}")), null, null, Collections.emptyList());
        project.setScm((SCM)scm);
        this.commit("toto/commitFile1", this.johnDoe, "Commit number 1");
        String brokenPath = "\\broken/path\\of/doom";
        StringParameterValue real_param = new StringParameterValue("MY_BRANCH", "master");
        StringParameterValue fake_param = new StringParameterValue("PATH", brokenPath);
        Action[] actions = new Action[]{new ParametersAction(new ParameterValue[]{real_param}), new FakeParametersAction(fake_param)};
        project.addProperty((JobProperty)new ParametersDefinitionProperty(new ParameterDefinition[]{new StringParameterDefinition("MY_BRANCH", "master")}));
        FreeStyleBuild first_build = (FreeStyleBuild)project.scheduleBuild2(0, (Cause)new Cause.UserIdCause(), actions).get();
        this.r.assertBuildStatus(Result.SUCCESS, (Run)first_build);
        Launcher launcher = this.workspace.createLauncher(this.listener);
        EnvVars environment = GitUtils.getPollEnvironment((AbstractProject)project, (FilePath)this.workspace, (Launcher)launcher, (TaskListener)this.listener);
        Assert.assertEquals((Object)environment.get((Object)"MY_BRANCH"), (Object)"master");
        Assert.assertNotSame((String)"Environment path should not be broken path", (Object)environment.get((Object)"PATH"), (Object)brokenPath);
    }

    private int notifyAndCheckScmName(FreeStyleProject project, ObjectId commit, String expectedScmName, int ordinal, GitSCM git, ObjectId ... priorCommits) throws Exception {
        StringBuilder priorCommitIDs = new StringBuilder();
        for (ObjectId priorCommit : priorCommits) {
            priorCommitIDs.append(" ").append(priorCommit);
        }
        Assert.assertTrue((String)("scm polling should detect commit " + ordinal), (boolean)this.notifyCommit(project, commit));
        Build build = (Build)project.getLastBuild();
        BuildData buildData = git.getBuildData((Run)build);
        Assert.assertEquals((String)("Expected SHA1 != built SHA1 for commit " + ordinal + " priors:" + priorCommitIDs), (Object)commit, (Object)buildData.getLastBuiltRevision().getSha1());
        Assert.assertEquals((String)("Expected SHA1 != retrieved SHA1 for commit " + ordinal + " priors:" + priorCommitIDs), (Object)commit, (Object)buildData.getLastBuild(commit).getSHA1());
        Assert.assertTrue((String)("Commit " + ordinal + " not marked as built"), (boolean)buildData.hasBeenBuilt(commit));
        Assert.assertEquals((String)("Wrong SCM Name for commit " + ordinal), (Object)expectedScmName, (Object)buildData.getScmName());
        return build.getNumber();
    }

    private void checkNumberedBuildScmName(FreeStyleProject project, int buildNumber, String expectedScmName, GitSCM git) throws Exception {
        BuildData buildData = git.getBuildData((Run)project.getBuildByNumber(buildNumber));
        Assert.assertEquals((String)"Wrong SCM Name", (Object)expectedScmName, (Object)buildData.getScmName());
    }

    @Test
    @Deprecated
    public void testNoNullPointerExceptionWithNullBranch() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        ObjectId sha1 = ObjectId.fromString((String)"2cec153f34767f7638378735dc2b907ed251a67d");
        Branch branch = new Branch(null, sha1);
        ArrayList<Branch> branchList = new ArrayList<Branch>();
        branchList.add(branch);
        Revision revision = new Revision(sha1, branchList);
        BuildData buildData = (BuildData)Mockito.mock(BuildData.class);
        Mockito.when((Object)buildData.getLastBuiltRevision()).thenReturn((Object)revision);
        Mockito.when((Object)buildData.hasBeenReferenced(ArgumentMatchers.anyString())).thenReturn((Object)true);
        ArrayList<BuildData> buildDataList = new ArrayList<BuildData>();
        buildDataList.add(buildData);
        AbstractBuild build = (AbstractBuild)Mockito.mock(AbstractBuild.class);
        Mockito.when((Object)build.getActions(BuildData.class)).thenReturn(buildDataList);
        FreeStyleProject project = this.setupProject("*/*", false);
        GitSCM scm = (GitSCM)project.getScm();
        scm.buildEnvVars(build, (Map)new EnvVars());
        ((BuildData)Mockito.verify((Object)buildData, (VerificationMode)Mockito.times((int)1))).getLastBuiltRevision();
        ((BuildData)Mockito.verify((Object)buildData, (VerificationMode)Mockito.times((int)1))).hasBeenReferenced(ArgumentMatchers.anyString());
        ((AbstractBuild)Mockito.verify((Object)build, (VerificationMode)Mockito.times((int)1))).getActions(BuildData.class);
    }

    @Test
    @Deprecated
    public void testBuildEnvVarsLocalBranchStarStar() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        ObjectId sha1 = ObjectId.fromString((String)"2cec153f34767f7638378735dc2b907ed251a67d");
        Branch branch = new Branch("origin/master", sha1);
        ArrayList<Branch> branchList = new ArrayList<Branch>();
        branchList.add(branch);
        Revision revision = new Revision(sha1, branchList);
        BuildData buildData = (BuildData)Mockito.mock(BuildData.class);
        Mockito.when((Object)buildData.getLastBuiltRevision()).thenReturn((Object)revision);
        Mockito.when((Object)buildData.hasBeenReferenced(ArgumentMatchers.anyString())).thenReturn((Object)true);
        ArrayList<BuildData> buildDataList = new ArrayList<BuildData>();
        buildDataList.add(buildData);
        AbstractBuild build = (AbstractBuild)Mockito.mock(AbstractBuild.class);
        Mockito.when((Object)build.getActions(BuildData.class)).thenReturn(buildDataList);
        FreeStyleProject project = this.setupProject("*/*", false);
        GitSCM scm = (GitSCM)project.getScm();
        scm.getExtensions().add((Object)new LocalBranch("**"));
        EnvVars env = new EnvVars();
        scm.buildEnvVars(build, (Map)env);
        Assert.assertEquals((String)"GIT_BRANCH", (Object)"origin/master", (Object)env.get((Object)"GIT_BRANCH"));
        Assert.assertEquals((String)"GIT_LOCAL_BRANCH", (Object)"master", (Object)env.get((Object)"GIT_LOCAL_BRANCH"));
        ((BuildData)Mockito.verify((Object)buildData, (VerificationMode)Mockito.times((int)1))).getLastBuiltRevision();
        ((BuildData)Mockito.verify((Object)buildData, (VerificationMode)Mockito.times((int)1))).hasBeenReferenced(ArgumentMatchers.anyString());
        ((AbstractBuild)Mockito.verify((Object)build, (VerificationMode)Mockito.times((int)1))).getActions(BuildData.class);
    }

    @Test
    @Deprecated
    public void testBuildEnvVarsLocalBranchNull() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        ObjectId sha1 = ObjectId.fromString((String)"2cec153f34767f7638378735dc2b907ed251a67d");
        Branch branch = new Branch("origin/master", sha1);
        ArrayList<Branch> branchList = new ArrayList<Branch>();
        branchList.add(branch);
        Revision revision = new Revision(sha1, branchList);
        BuildData buildData = (BuildData)Mockito.mock(BuildData.class);
        Mockito.when((Object)buildData.getLastBuiltRevision()).thenReturn((Object)revision);
        Mockito.when((Object)buildData.hasBeenReferenced(ArgumentMatchers.anyString())).thenReturn((Object)true);
        ArrayList<BuildData> buildDataList = new ArrayList<BuildData>();
        buildDataList.add(buildData);
        AbstractBuild build = (AbstractBuild)Mockito.mock(AbstractBuild.class);
        Mockito.when((Object)build.getActions(BuildData.class)).thenReturn(buildDataList);
        FreeStyleProject project = this.setupProject("*/*", false);
        GitSCM scm = (GitSCM)project.getScm();
        scm.getExtensions().add((Object)new LocalBranch(""));
        EnvVars env = new EnvVars();
        scm.buildEnvVars(build, (Map)env);
        Assert.assertEquals((String)"GIT_BRANCH", (Object)"origin/master", (Object)env.get((Object)"GIT_BRANCH"));
        Assert.assertEquals((String)"GIT_LOCAL_BRANCH", (Object)"master", (Object)env.get((Object)"GIT_LOCAL_BRANCH"));
        ((BuildData)Mockito.verify((Object)buildData, (VerificationMode)Mockito.times((int)1))).getLastBuiltRevision();
        ((BuildData)Mockito.verify((Object)buildData, (VerificationMode)Mockito.times((int)1))).hasBeenReferenced(ArgumentMatchers.anyString());
        ((AbstractBuild)Mockito.verify((Object)build, (VerificationMode)Mockito.times((int)1))).getActions(BuildData.class);
    }

    @Test
    @Deprecated
    public void testBuildEnvVarsLocalBranchNotSet() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        ObjectId sha1 = ObjectId.fromString((String)"2cec153f34767f7638378735dc2b907ed251a67d");
        Branch branch = new Branch("origin/master", sha1);
        ArrayList<Branch> branchList = new ArrayList<Branch>();
        branchList.add(branch);
        Revision revision = new Revision(sha1, branchList);
        BuildData buildData = (BuildData)Mockito.mock(BuildData.class);
        Mockito.when((Object)buildData.getLastBuiltRevision()).thenReturn((Object)revision);
        Mockito.when((Object)buildData.hasBeenReferenced(ArgumentMatchers.anyString())).thenReturn((Object)true);
        ArrayList<BuildData> buildDataList = new ArrayList<BuildData>();
        buildDataList.add(buildData);
        AbstractBuild build = (AbstractBuild)Mockito.mock(AbstractBuild.class);
        Mockito.when((Object)build.getActions(BuildData.class)).thenReturn(buildDataList);
        FreeStyleProject project = this.setupProject("*/*", false);
        GitSCM scm = (GitSCM)project.getScm();
        EnvVars env = new EnvVars();
        scm.buildEnvVars(build, (Map)env);
        Assert.assertEquals((String)"GIT_BRANCH", (Object)"origin/master", (Object)env.get((Object)"GIT_BRANCH"));
        Assert.assertNull((String)"GIT_LOCAL_BRANCH", (Object)env.get((Object)"GIT_LOCAL_BRANCH"));
        ((BuildData)Mockito.verify((Object)buildData, (VerificationMode)Mockito.times((int)1))).getLastBuiltRevision();
        ((BuildData)Mockito.verify((Object)buildData, (VerificationMode)Mockito.times((int)1))).hasBeenReferenced(ArgumentMatchers.anyString());
        ((AbstractBuild)Mockito.verify((Object)build, (VerificationMode)Mockito.times((int)1))).getActions(BuildData.class);
    }

    @Test
    public void testBuildEnvironmentVariablesSingleRemote() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        ObjectId sha1 = ObjectId.fromString((String)"2cec153f34767f7638378735dc2b907ed251a67d");
        ArrayList<Branch> branchList = new ArrayList<Branch>();
        Branch branch = new Branch("origin/master", sha1);
        branchList.add(branch);
        Revision revision = new Revision(sha1, branchList);
        BuildData buildData = (BuildData)Mockito.mock(BuildData.class);
        Mockito.when((Object)buildData.getLastBuiltRevision()).thenReturn((Object)revision);
        Mockito.when((Object)buildData.hasBeenReferenced(ArgumentMatchers.anyString())).thenReturn((Object)true);
        ArrayList<BuildData> buildDataList = new ArrayList<BuildData>();
        buildDataList.add(buildData);
        Run build = (Run)Mockito.mock(Run.class);
        Mockito.when((Object)build.getActions(BuildData.class)).thenReturn(buildDataList);
        FreeStyleProject project = this.setupSimpleProject("*/*");
        GitSCM scm = (GitSCM)project.getScm();
        HashMap env = new HashMap();
        scm.buildEnvironment(build, env);
        Assert.assertEquals((String)"GIT_BRANCH is invalid", (Object)"origin/master", env.get("GIT_BRANCH"));
        Assert.assertNull((String)"GIT_LOCAL_BRANCH is invalid", env.get("GIT_LOCAL_BRANCH"));
        Assert.assertEquals((String)"GIT_COMMIT is invalid", (Object)sha1.getName(), env.get("GIT_COMMIT"));
        Assert.assertEquals((String)"GIT_URL is invalid", (Object)this.testRepo.gitDir.getAbsolutePath(), env.get("GIT_URL"));
        Assert.assertNull((String)"GIT_URL_1 should not have been set", env.get("GIT_URL_1"));
    }

    @Test
    public void testBuildEnvironmentVariablesMultipleRemotes() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        ObjectId sha1 = ObjectId.fromString((String)"2cec153f34767f7638378735dc2b907ed251a67d");
        ArrayList<Branch> branchList = new ArrayList<Branch>();
        Branch branch = new Branch("origin/master", sha1);
        branchList.add(branch);
        Revision revision = new Revision(sha1, branchList);
        BuildData buildData = (BuildData)Mockito.mock(BuildData.class);
        Mockito.when((Object)buildData.getLastBuiltRevision()).thenReturn((Object)revision);
        Mockito.when((Object)buildData.hasBeenReferenced(ArgumentMatchers.anyString())).thenReturn((Object)true);
        ArrayList<BuildData> buildDataList = new ArrayList<BuildData>();
        buildDataList.add(buildData);
        Run build = (Run)Mockito.mock(Run.class);
        Mockito.when((Object)build.getActions(BuildData.class)).thenReturn(buildDataList);
        FreeStyleProject project = this.setupSimpleProject("*/*");
        ArrayList<UserRemoteConfig> userRemoteConfigs = new ArrayList<UserRemoteConfig>();
        userRemoteConfigs.add(new UserRemoteConfig(this.testRepo.gitDir.getAbsolutePath(), "origin", "", null));
        String upstreamRepoUrl = "/upstream/url";
        userRemoteConfigs.add(new UserRemoteConfig("/upstream/url", "upstream", "", null));
        GitSCM scm = new GitSCM(userRemoteConfigs, Collections.singletonList(new BranchSpec(branch.getName())), null, null, Collections.emptyList());
        project.setScm((SCM)scm);
        HashMap env = new HashMap();
        scm.buildEnvironment(build, env);
        Assert.assertEquals((String)"GIT_BRANCH is invalid", (Object)"origin/master", env.get("GIT_BRANCH"));
        Assert.assertNull((String)"GIT_LOCAL_BRANCH is invalid", env.get("GIT_LOCAL_BRANCH"));
        Assert.assertEquals((String)"GIT_COMMIT is invalid", (Object)sha1.getName(), env.get("GIT_COMMIT"));
        Assert.assertEquals((String)"GIT_URL is invalid", (Object)this.testRepo.gitDir.getAbsolutePath(), env.get("GIT_URL"));
        Assert.assertEquals((String)"GIT_URL_1 is invalid", (Object)this.testRepo.gitDir.getAbsolutePath(), env.get("GIT_URL_1"));
        Assert.assertEquals((String)"GIT_URL_2 is invalid", (Object)"/upstream/url", env.get("GIT_URL_2"));
        Assert.assertNull((String)"GIT_URL_3 should not have been set", env.get("GIT_URL_3"));
    }

    @Test
    public void testCommitMessageIsPrintedToLogs() throws Exception {
        Assume.assumeTrue((String)"Test class max time 570 exceeded", (boolean)this.isTimeAvailable());
        this.sampleRepo.init();
        this.sampleRepo.write("file", "v1");
        this.sampleRepo.git("commit", "--all", "--message=test commit");
        FreeStyleProject p = this.setupSimpleProject("master");
        FreeStyleBuild run = this.r.buildAndAssertSuccess(p);
        this.r.waitForMessage("Commit message: \"test commit\"", (Run)run);
    }

    private void notifyAndCheckBranch(FreeStyleProject project, ObjectId commit, String expectedBranch, int ordinal, GitSCM git) throws Exception {
        Assert.assertTrue((String)("scm polling should detect commit " + ordinal), (boolean)this.notifyCommit(project, commit));
        BuildData buildData = git.getBuildData((Run)project.getLastBuild());
        Collection builtBranches = buildData.lastBuild.getRevision().getBranches();
        Assert.assertEquals((String)("Commit " + ordinal + " should be built"), (Object)commit, (Object)buildData.getLastBuiltRevision().getSha1());
        String expectedBranchString = "origin/" + expectedBranch;
        Assert.assertFalse((String)"Branches should be detected for the build", (boolean)builtBranches.isEmpty());
        Assert.assertEquals((String)(expectedBranch + " branch should be detected"), (Object)expectedBranchString, (Object)((Branch)builtBranches.iterator().next()).getName());
        Assert.assertEquals((Object)expectedBranchString, (Object)this.getEnvVars(project).get((Object)"GIT_BRANCH"));
    }

    private boolean notifyCommit(FreeStyleProject project, ObjectId commitId) throws Exception {
        String notifyContent;
        int initialBuildNumber = ((FreeStyleBuild)project.getLastBuild()).getNumber();
        String commit1 = ObjectId.toString((ObjectId)commitId);
        String notificationPath = this.r.getURL().toExternalForm() + "git/notifyCommit?url=" + this.testRepo.gitDir.toString() + "&sha1=" + commit1;
        URL notifyUrl = new URL(notificationPath);
        try (InputStream is = notifyUrl.openStream();){
            notifyContent = new String(is.readAllBytes(), StandardCharsets.UTF_8);
        }
        MatcherAssert.assertThat((Object)notifyContent, (Matcher)Matchers.containsString((String)("No Git consumers using SCM API plugin for: " + this.testRepo.gitDir.toString())));
        if (((FreeStyleBuild)project.getLastBuild()).getNumber() == initialBuildNumber && this.r.jenkins.getQueue().isEmpty()) {
            return false;
        }
        while (!this.r.jenkins.getQueue().isEmpty()) {
            Thread.sleep(100L);
        }
        FreeStyleBuild build = (FreeStyleBuild)project.getLastBuild();
        while (build.isBuilding()) {
            Thread.sleep(100L);
        }
        return true;
    }

    private void setupJGit(GitSCM git) {
        git.gitTool = "jgit";
        ((GitTool.DescriptorImpl)this.r.jenkins.getDescriptorByType(GitTool.DescriptorImpl.class)).setInstallations((ToolInstallation[])new GitTool[]{new JGitTool(Collections.emptyList())});
    }

    private boolean cleanupIsUnreliable() {
        String jobUrl = System.getenv("JOB_URL");
        return this.isWindows() && jobUrl != null && jobUrl.contains("ci.jenkins.io");
    }

    private boolean isWindows() {
        return File.pathSeparatorChar == ';';
    }

    private StandardCredentials createCredential(CredentialsScope scope, String id) {
        return new UsernamePasswordCredentialsImpl(scope, id, "desc: " + id, "username", "password");
    }

    @TestExtension
    public static class CleanEnvironment
    extends EnvironmentContributor {
        public void buildEnvironmentFor(Run run, EnvVars envs, TaskListener listener) {
            envs.remove((Object)"GIT_BRANCH");
            envs.remove((Object)"GIT_LOCAL_BRANCH");
            envs.remove((Object)"GIT_COMMIT");
            envs.remove((Object)"GIT_PREVIOUS_COMMIT");
            envs.remove((Object)"GIT_PREVIOUS_SUCCESSFUL_COMMIT");
        }
    }

    private final class FakeParametersAction
    implements EnvironmentContributingAction,
    Serializable {
        final ParametersAction m_forwardingAction;

        public FakeParametersAction(StringParameterValue params) {
            this.m_forwardingAction = new ParametersAction(new ParameterValue[]{params});
        }

        @Deprecated
        public void buildEnvVars(AbstractBuild<?, ?> ab, EnvVars ev) {
            this.m_forwardingAction.buildEnvVars(ab, ev);
        }

        public String getIconFileName() {
            return this.m_forwardingAction.getIconFileName();
        }

        public String getDisplayName() {
            return this.m_forwardingAction.getDisplayName();
        }

        public String getUrlName() {
            return this.m_forwardingAction.getUrlName();
        }

        public List<ParameterValue> getParameters() {
            return this.m_forwardingAction.getParameters();
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        }

        private void readObjectNoData() throws ObjectStreamException {
        }
    }

    @TestExtension(value={"testEnvironmentVariableExpansion"})
    public static class SupplySomeEnvVars
    extends EnvironmentContributor {
        public void buildEnvironmentFor(Run r, EnvVars envs, TaskListener listener) throws IOException, InterruptedException {
            envs.put("CAT", "");
        }
    }
}

