/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractBuild;
import hudson.model.FreeStyleBuild;
import hudson.model.FreeStyleProject;
import hudson.model.Item;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.Run;
import hudson.plugins.git.AbstractGitRepository;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.GitStatus;
import hudson.plugins.git.UserRemoteConfig;
import hudson.plugins.git.extensions.impl.DisableRemotePoll;
import hudson.plugins.git.extensions.impl.EnforceGitClient;
import hudson.plugins.git.extensions.impl.PathRestriction;
import hudson.plugins.git.extensions.impl.RelativeTargetDirectory;
import hudson.plugins.git.extensions.impl.SparseCheckoutPath;
import hudson.plugins.git.extensions.impl.SparseCheckoutPaths;
import hudson.plugins.git.extensions.impl.UserExclusion;
import hudson.remoting.VirtualChannel;
import hudson.scm.SCM;
import hudson.slaves.EnvironmentVariablesNodeProperty;
import hudson.tasks.Builder;
import hudson.triggers.SCMTrigger;
import hudson.triggers.Trigger;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import jenkins.MasterToSlaveFileCallable;
import org.eclipse.jgit.lib.Repository;
import org.jenkinsci.plugins.gitclient.Git;
import org.junit.Assert;
import org.junit.Rule;
import org.jvnet.hudson.test.CaptureEnvironmentBuilder;
import org.jvnet.hudson.test.FlagRule;
import org.jvnet.hudson.test.JenkinsRule;

public class AbstractGitProject
extends AbstractGitRepository {
    @Rule
    public JenkinsRule r = new JenkinsRule();
    @Rule
    public FlagRule<String> notifyCommitAccessControl = new FlagRule(() -> GitStatus.NOTIFY_COMMIT_ACCESS_CONTROL, x -> {
        GitStatus.NOTIFY_COMMIT_ACCESS_CONTROL = x;
    });

    protected FreeStyleProject setupProject(List<BranchSpec> branches, boolean authorOrCommitter) throws Exception {
        FreeStyleProject project = this.r.createFreeStyleProject();
        GitSCM scm = new GitSCM(this.remoteConfigs(), branches, null, null, Collections.singletonList(new DisableRemotePoll()));
        project.setScm((SCM)scm);
        project.getBuildersList().add((Object)new CaptureEnvironmentBuilder());
        return project;
    }

    protected FreeStyleProject setupSimpleProject(String branchString) throws Exception {
        return this.setupProject(Collections.singletonList(new BranchSpec(branchString)), false);
    }

    protected FreeStyleProject setupProject(String branchString, boolean authorOrCommitter) throws Exception {
        return this.setupProject(branchString, authorOrCommitter, null);
    }

    protected FreeStyleProject setupProject(String branchString, boolean authorOrCommitter, String relativeTargetDir) throws Exception {
        return this.setupProject(branchString, authorOrCommitter, relativeTargetDir, null, null, null);
    }

    protected FreeStyleProject setupProject(String branchString, boolean authorOrCommitter, String relativeTargetDir, String excludedRegions, String excludedUsers, String includedRegions) throws Exception {
        return this.setupProject(branchString, authorOrCommitter, relativeTargetDir, excludedRegions, excludedUsers, null, false, includedRegions);
    }

    protected FreeStyleProject setupProject(String branchString, boolean authorOrCommitter, String relativeTargetDir, String excludedRegions, String excludedUsers, boolean fastRemotePoll, String includedRegions) throws Exception {
        return this.setupProject(branchString, authorOrCommitter, relativeTargetDir, excludedRegions, excludedUsers, null, fastRemotePoll, includedRegions);
    }

    protected FreeStyleProject setupProject(String branchString, boolean authorOrCommitter, String relativeTargetDir, String excludedRegions, String excludedUsers, String localBranch, boolean fastRemotePoll, String includedRegions) throws Exception {
        return this.setupProject(Collections.singletonList(new BranchSpec(branchString)), authorOrCommitter, relativeTargetDir, excludedRegions, excludedUsers, localBranch, fastRemotePoll, includedRegions);
    }

    protected FreeStyleProject setupProject(List<BranchSpec> branches, boolean authorOrCommitter, String relativeTargetDir, String excludedRegions, String excludedUsers, String localBranch, boolean fastRemotePoll, String includedRegions) throws Exception {
        return this.setupProject(branches, authorOrCommitter, relativeTargetDir, excludedRegions, excludedUsers, localBranch, fastRemotePoll, includedRegions, null);
    }

    protected FreeStyleProject setupProject(String branchString, List<SparseCheckoutPath> sparseCheckoutPaths) throws Exception {
        return this.setupProject(Collections.singletonList(new BranchSpec(branchString)), false, null, null, null, null, false, null, sparseCheckoutPaths);
    }

    protected FreeStyleProject setupProject(List<BranchSpec> branches, boolean authorOrCommitter, String relativeTargetDir, String excludedRegions, String excludedUsers, String localBranch, boolean fastRemotePoll, String includedRegions, List<SparseCheckoutPath> sparseCheckoutPaths) throws Exception {
        FreeStyleProject project = this.r.createFreeStyleProject();
        GitSCM scm = new GitSCM(this.remoteConfigs(), branches, null, null, Collections.emptyList());
        scm.getExtensions().add((Object)new DisableRemotePoll());
        if (relativeTargetDir != null) {
            scm.getExtensions().add((Object)new RelativeTargetDirectory(relativeTargetDir));
        }
        if (excludedUsers != null) {
            scm.getExtensions().add((Object)new UserExclusion(excludedUsers));
        }
        if (excludedRegions != null || includedRegions != null) {
            scm.getExtensions().add((Object)new PathRestriction(includedRegions, excludedRegions));
        }
        scm.getExtensions().add((Object)new SparseCheckoutPaths(sparseCheckoutPaths));
        project.setScm((SCM)scm);
        project.getBuildersList().add((Object)new CaptureEnvironmentBuilder());
        return project;
    }

    protected FreeStyleProject setupProject(List<UserRemoteConfig> repos, List<BranchSpec> branchSpecs, String scmTriggerSpec, boolean disableRemotePoll, EnforceGitClient enforceGitClient) throws Exception {
        FreeStyleProject project = this.r.createFreeStyleProject();
        GitSCM scm = new GitSCM(repos, branchSpecs, null, "jgit", Collections.emptyList());
        if (disableRemotePoll) {
            scm.getExtensions().add((Object)new DisableRemotePoll());
        }
        if (enforceGitClient != null) {
            scm.getExtensions().add((Object)enforceGitClient);
        }
        project.setScm((SCM)scm);
        if (scmTriggerSpec != null) {
            SCMTrigger trigger = new SCMTrigger(scmTriggerSpec);
            project.addTrigger((Trigger)trigger);
            trigger.start((Item)project, true);
        }
        project.getBuildersList().add((Object)new CaptureEnvironmentBuilder());
        project.save();
        return project;
    }

    protected FreeStyleBuild build(FreeStyleProject project, Result expectedResult, String ... expectedNewlyCommittedFiles) throws Exception {
        FreeStyleBuild build = (FreeStyleBuild)project.scheduleBuild2(0).get();
        for (String expectedNewlyCommittedFile : expectedNewlyCommittedFiles) {
            Assert.assertTrue((String)(expectedNewlyCommittedFile + " file not found in workspace"), (boolean)build.getWorkspace().child(expectedNewlyCommittedFile).exists());
        }
        if (expectedResult != null) {
            this.r.assertBuildStatus(expectedResult, (Run)build);
        }
        return build;
    }

    protected FreeStyleBuild build(FreeStyleProject project, String parentDir, Result expectedResult, String ... expectedNewlyCommittedFiles) throws Exception {
        FreeStyleBuild build = (FreeStyleBuild)project.scheduleBuild2(0).get();
        for (String expectedNewlyCommittedFile : expectedNewlyCommittedFiles) {
            Assert.assertTrue((boolean)build.getWorkspace().child(parentDir).child(expectedNewlyCommittedFile).exists());
        }
        if (expectedResult != null) {
            this.r.assertBuildStatus(expectedResult, (Run)build);
        }
        return build;
    }

    protected MatrixBuild build(MatrixProject project, Result expectedResult, String ... expectedNewlyCommittedFiles) throws Exception {
        MatrixBuild build = (MatrixBuild)project.scheduleBuild2(0).get();
        for (String expectedNewlyCommittedFile : expectedNewlyCommittedFiles) {
            Assert.assertTrue((String)(expectedNewlyCommittedFile + " file not found in workspace"), (boolean)build.getWorkspace().child(expectedNewlyCommittedFile).exists());
        }
        if (expectedResult != null) {
            this.r.assertBuildStatus(expectedResult, (Run)build);
        }
        return build;
    }

    protected String getHeadRevision(AbstractBuild build, final String branch) throws IOException, InterruptedException {
        return (String)build.getWorkspace().act((FilePath.FileCallable)new MasterToSlaveFileCallable<String>(){

            public String invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
                String string;
                block8: {
                    Repository repo = Git.with(null, null).in(f).getClient().getRepository();
                    try {
                        string = repo.resolve("refs/heads/" + branch).name();
                        if (repo == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (repo != null) {
                                try {
                                    repo.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (GitException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    repo.close();
                }
                return string;
            }
        });
    }

    protected EnvVars getEnvVars(FreeStyleProject project) {
        for (Builder b : project.getBuilders()) {
            if (!(b instanceof CaptureEnvironmentBuilder)) continue;
            return ((CaptureEnvironmentBuilder)b).getEnvVars();
        }
        return new EnvVars();
    }

    protected void setVariables(Node node, EnvironmentVariablesNodeProperty.Entry ... entries) throws IOException {
        node.getNodeProperties().replaceBy(Collections.singleton(new EnvironmentVariablesNodeProperty(entries)));
    }
}

