/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git.traits;

import jenkins.plugins.git.traits.DiscoverOtherRefsTrait;
import org.junit.Assert;
import org.junit.Test;

public class DiscoverOtherRefsTraitTest {
    @Test
    public void getFullRefSpec() throws Exception {
        DiscoverOtherRefsTrait t = new DiscoverOtherRefsTrait("refs/custom/*");
        Assert.assertEquals((Object)"+refs/custom/*:refs/remotes/@{remote}/custom/*", (Object)t.getFullRefSpec());
    }

    @Test
    public void getNameMapping() throws Exception {
        DiscoverOtherRefsTrait t = new DiscoverOtherRefsTrait("refs/bobby/*");
        Assert.assertEquals((Object)"bobby-@{1}", (Object)t.getNameMapping());
        t = new DiscoverOtherRefsTrait("refs/bobby/*/merge");
        Assert.assertEquals((Object)"bobby-@{1}", (Object)t.getNameMapping());
        t = new DiscoverOtherRefsTrait("refs/*");
        Assert.assertEquals((Object)"other-@{1}", (Object)t.getNameMapping());
        t = new DiscoverOtherRefsTrait("refs/bobby/all");
        Assert.assertEquals((Object)"other-ref", (Object)t.getNameMapping());
    }
}

