/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.util;

import hudson.plugins.git.AbstractGitRepository;
import hudson.plugins.git.Branch;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.Revision;
import hudson.plugins.git.util.DefaultBuildChooser;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class DefaultBuildChooserTest
extends AbstractGitRepository {
    @Test
    public void testChooseGitRevisionToBuildByShaHash() throws Exception {
        this.testGitClient.commit("Commit 1");
        String shaHashCommit1 = ((Branch)this.testGitClient.getBranches().iterator().next()).getSHA1String();
        this.testGitClient.commit("Commit 2");
        String shaHashCommit2 = ((Branch)this.testGitClient.getBranches().iterator().next()).getSHA1String();
        MatcherAssert.assertThat((Object)shaHashCommit1, (Matcher)Matchers.is((Matcher)Matchers.not((Object)shaHashCommit2)));
        DefaultBuildChooser buildChooser = (DefaultBuildChooser)new GitSCM("foo").getBuildChooser();
        Collection candidateRevisions = buildChooser.getCandidateRevisions(false, shaHashCommit1, this.testGitClient, null, null, null);
        MatcherAssert.assertThat((Object)candidateRevisions, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((Revision)candidateRevisions.iterator().next()).getSha1String(), (Matcher)Matchers.is((Object)shaHashCommit1));
        candidateRevisions = buildChooser.getCandidateRevisions(false, "aaa" + shaHashCommit1.substring(3), this.testGitClient, null, null, null);
        MatcherAssert.assertThat((Object)candidateRevisions, (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void testIsAdvancedSpec() throws Exception {
        DefaultBuildChooser buildChooser = (DefaultBuildChooser)new GitSCM("foo").getBuildChooser();
        Assert.assertFalse((boolean)buildChooser.isAdvancedSpec("origin/master"));
        Assert.assertTrue((boolean)buildChooser.isAdvancedSpec("origin/master-*"));
        Assert.assertTrue((boolean)buildChooser.isAdvancedSpec("origin**"));
        Assert.assertTrue((boolean)buildChooser.isAdvancedSpec(":origin/master"));
        Assert.assertTrue((boolean)buildChooser.isAdvancedSpec(":origin/master-\\d{*}"));
    }

    @Test
    public void testPreferRemoteBranchInCandidateRevisionsWithWrongOrderInHashSet() throws Exception {
        String branchName = "feature/42";
        String localRef = "refs/heads/" + branchName;
        String remoteRef = "refs/remotes/origin/" + branchName;
        this.createRefsWithPredefinedOrderInHashSet(localRef, remoteRef);
        DefaultBuildChooser buildChooser = (DefaultBuildChooser)new GitSCM("foo").getBuildChooser();
        Collection candidateRevisions = buildChooser.getCandidateRevisions(false, branchName, this.testGitClient, null, null, null);
        MatcherAssert.assertThat((Object)candidateRevisions, (Matcher)Matchers.hasSize((int)2));
        Revision firstCandidateRevision = (Revision)candidateRevisions.iterator().next();
        Branch firstCandidateBranch = (Branch)firstCandidateRevision.getBranches().iterator().next();
        MatcherAssert.assertThat((Object)firstCandidateBranch.getName(), (Matcher)Matchers.is((Object)remoteRef));
    }

    @Test
    public void testPreferRemoteBranchInCandidateRevisionsWithCorrectOrderInHashSet() throws Exception {
        String branchName = "feature/42";
        String localRef = "refs/heads/" + branchName;
        String remoteRef = "refs/remotes/origin/" + branchName;
        this.createRefsWithPredefinedOrderInHashSet(remoteRef, localRef);
        DefaultBuildChooser buildChooser = (DefaultBuildChooser)new GitSCM("foo").getBuildChooser();
        Collection candidateRevisions = buildChooser.getCandidateRevisions(false, branchName, this.testGitClient, null, null, null);
        MatcherAssert.assertThat((Object)candidateRevisions, (Matcher)Matchers.hasSize((int)2));
        Revision firstCandidateRevision = (Revision)candidateRevisions.iterator().next();
        Branch firstCandidateBranch = (Branch)firstCandidateRevision.getBranches().iterator().next();
        MatcherAssert.assertThat((Object)firstCandidateBranch.getName(), (Matcher)Matchers.is((Object)remoteRef));
    }

    @Test
    public void testSingleCandidateRevisionWithLocalAndRemoteRefsOnSameCommit() throws Exception {
        String branchName = "feature/42";
        String localRef = "refs/heads/" + branchName;
        String remoteRef = "refs/remotes/origin/" + branchName;
        this.testGitClient.ref(localRef);
        this.testGitClient.ref(remoteRef);
        DefaultBuildChooser buildChooser = (DefaultBuildChooser)new GitSCM("foo").getBuildChooser();
        Collection candidateRevisions = buildChooser.getCandidateRevisions(false, branchName, this.testGitClient, null, null, null);
        MatcherAssert.assertThat((Object)candidateRevisions, (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    public void testSingleCandidateRevisionWithLocalAndRemoteRefsOnSameCommitWithOriginPrefix() throws Exception {
        String baseBranchName = "feature/42";
        String branchName = "origin/" + baseBranchName;
        String localRef = "refs/heads/" + baseBranchName;
        String remoteRef = "refs/remotes/" + branchName;
        this.createRefsWithPredefinedOrderInHashSet(localRef, remoteRef);
        DefaultBuildChooser buildChooser = (DefaultBuildChooser)new GitSCM("foo").getBuildChooser();
        Collection candidateRevisions = buildChooser.getCandidateRevisions(false, branchName, this.testGitClient, null, null, null);
        MatcherAssert.assertThat((Object)candidateRevisions, (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    public void testSingleCandidateRevisionWithLocalAndRemoteRefsOnSameCommitWithRemotesOriginPrefix() throws Exception {
        String baseBranchName = "feature/42";
        String branchName = "remotes/origin/" + baseBranchName;
        String localRef = "refs/heads/" + baseBranchName;
        String remoteRef = "refs/" + branchName;
        this.createRefsWithPredefinedOrderInHashSet(localRef, remoteRef);
        DefaultBuildChooser buildChooser = (DefaultBuildChooser)new GitSCM("foo").getBuildChooser();
        Collection candidateRevisions = buildChooser.getCandidateRevisions(false, branchName, this.testGitClient, null, null, null);
        MatcherAssert.assertThat((Object)candidateRevisions, (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    public void testSingleCandidateRevisionWithLocalAndRemoteRefsOnSameCommitWithRefsHeadsPrefix() throws Exception {
        String baseBranchName = "feature/42";
        String branchName = "refs/heads/" + baseBranchName;
        String localRef = "refs/heads/" + baseBranchName;
        String remoteRef = "refs/remotes/origin/" + baseBranchName;
        this.createRefsWithPredefinedOrderInHashSet(localRef, remoteRef);
        DefaultBuildChooser buildChooser = (DefaultBuildChooser)new GitSCM("foo").getBuildChooser();
        Collection candidateRevisions = buildChooser.getCandidateRevisions(false, branchName, this.testGitClient, null, null, null);
        MatcherAssert.assertThat((Object)candidateRevisions, (Matcher)Matchers.hasSize((int)1));
    }

    private void createRefsWithPredefinedOrderInHashSet(String ref1, String ref2) throws InterruptedException {
        ObjectId commit1 = this.testGitClient.revParse("HEAD");
        this.testGitClient.ref(ref1);
        this.testGitClient.commit("Commit");
        ObjectId commit2 = this.testGitClient.revParse("HEAD");
        HashSet<Revision> set = new HashSet<Revision>();
        set.add(new Revision(commit1));
        set.add(new Revision(commit2));
        if (((Revision)set.iterator().next()).getSha1().equals((AnyObjectId)commit1)) {
            this.testGitClient.ref(ref2);
        } else {
            this.testGitClient.ref(ref1);
            this.testGitClient.checkout().ref(commit1.getName()).execute();
            this.testGitClient.ref(ref2);
        }
    }
}

