/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.browser;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.scm.RepositoryBrowser;
import java.io.IOException;
import java.net.URL;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class Phabricator
extends GitRepositoryBrowser {
    private static final long serialVersionUID = 1L;
    private final String repo;

    @DataBoundConstructor
    public Phabricator(String repoUrl, String repo) {
        super(repoUrl);
        this.repo = repo;
    }

    public String getRepo() {
        return this.repo;
    }

    public URL getChangeSetLink(GitChangeSet changeSet) throws IOException {
        return new URL(this.getUrl(), String.format("/r%s%s", this.getRepo(), changeSet.getId()));
    }

    @Override
    public URL getDiffLink(GitChangeSet.Path path) throws IOException {
        GitChangeSet changeSet = path.getChangeSet();
        String sha = changeSet.getId();
        String spec = String.format("/diffusion/%s/change/master/%s;%s", this.getRepo(), path.getPath(), sha);
        return new URL(this.getUrl(), spec);
    }

    @Override
    public URL getFileLink(GitChangeSet.Path path) throws IOException {
        GitChangeSet changeSet = path.getChangeSet();
        String sha = changeSet.getId();
        String spec = String.format("/diffusion/%s/history/master/%s;%s", this.getRepo(), path.getPath(), sha);
        return Phabricator.encodeURL(new URL(this.getUrl(), spec));
    }

    @Extension
    @Symbol(value={"phabricator"})
    public static class PhabricatorDescriptor
    extends Descriptor<RepositoryBrowser<?>> {
        @NonNull
        public String getDisplayName() {
            return "phabricator";
        }

        public Phabricator newInstance(StaplerRequest req, @NonNull JSONObject jsonObject) throws Descriptor.FormException {
            assert (req != null);
            return (Phabricator)((Object)req.bindJSON(Phabricator.class, jsonObject));
        }
    }
}

